/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter;

import java.util.Collection;
import org.gradle.internal.impldep.org.eclipse.jgit.errors.StopWalkException;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.TreeWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.ByteArraySet;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.PathFilter;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.gradle.internal.impldep.org.eclipse.jgit.util.RawParseUtils;

public class PathFilterGroup {
    public static TreeFilter createFromStrings(Collection<String> paths) {
        if (paths.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        PathFilter[] p = new PathFilter[paths.size()];
        int i = 0;
        for (String s : paths) {
            p[i++] = PathFilter.create(s);
        }
        return PathFilterGroup.create(p);
    }

    public static TreeFilter createFromStrings(String ... paths) {
        if (paths.length == 0) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        int length = paths.length;
        PathFilter[] p = new PathFilter[length];
        int i = 0;
        while (i < length) {
            p[i] = PathFilter.create(paths[i]);
            ++i;
        }
        return PathFilterGroup.create(p);
    }

    public static TreeFilter create(Collection<PathFilter> paths) {
        if (paths.isEmpty()) {
            throw new IllegalArgumentException(JGitText.get().atLeastOnePathIsRequired);
        }
        PathFilter[] p = new PathFilter[paths.size()];
        paths.toArray(p);
        return PathFilterGroup.create(p);
    }

    private static TreeFilter create(PathFilter[] p) {
        if (p.length == 1) {
            return new Single(p[0]);
        }
        return new Group(p);
    }

    static class Group
    extends TreeFilter {
        private ByteArraySet fullpaths;
        private ByteArraySet prefixes;
        private byte[] max;

        private Group(PathFilter[] pathFilters) {
            this.fullpaths = new ByteArraySet(pathFilters.length);
            this.prefixes = new ByteArraySet(pathFilters.length / 5);
            this.max = pathFilters[0].pathRaw;
            ByteArraySet.Hasher hasher = new ByteArraySet.Hasher(null, 0);
            PathFilter[] pathFilterArray = pathFilters;
            int n = pathFilters.length;
            int n2 = 0;
            while (n2 < n) {
                PathFilter pf = pathFilterArray[n2];
                hasher.init(pf.pathRaw, pf.pathRaw.length);
                while (hasher.hasNext()) {
                    int hash = hasher.nextHash();
                    if (!hasher.hasNext()) continue;
                    this.prefixes.addIfAbsent(pf.pathRaw, hasher.length(), hash);
                }
                this.fullpaths.addIfAbsent(pf.pathRaw, pf.pathRaw.length, hasher.getHash());
                if (Group.compare(this.max, pf.pathRaw) < 0) {
                    this.max = pf.pathRaw;
                }
                ++n2;
            }
            byte[] newMax = new byte[this.max.length + 1];
            int i = 0;
            while (i < this.max.length) {
                newMax[i] = (this.max[i] & 0xFF) < 47 ? 47 : this.max[i];
                ++i;
            }
            newMax[newMax.length - 1] = 47;
            this.max = newMax;
        }

        private static int compare(byte[] a, byte[] b) {
            int i = 0;
            while (i < a.length && i < b.length) {
                int ba = a[i] & 0xFF;
                int bb = b[i] & 0xFF;
                int cmp = ba - bb;
                if (cmp != 0) {
                    return cmp;
                }
                ++i;
            }
            return a.length - b.length;
        }

        @Override
        public boolean include(TreeWalk walker) {
            byte[] rp = walker.getRawPath();
            ByteArraySet.Hasher hasher = new ByteArraySet.Hasher(rp, walker.getPathLength());
            while (hasher.hasNext()) {
                int hash = hasher.nextHash();
                if (this.fullpaths.contains(rp, hasher.length(), hash)) {
                    return true;
                }
                if (hasher.hasNext() || !walker.isSubtree() || !this.prefixes.contains(rp, hasher.length(), hash)) continue;
                return true;
            }
            int cmp = walker.isPathPrefix(this.max, this.max.length);
            if (cmp > 0) {
                throw StopWalkException.INSTANCE;
            }
            return false;
        }

        @Override
        public boolean shouldBeRecursive() {
            return !this.prefixes.isEmpty();
        }

        @Override
        public TreeFilter clone() {
            return this;
        }

        @Override
        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("FAST(");
            boolean first = true;
            byte[][] byArray = this.fullpaths.toArray();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte[] p = byArray[n2];
                if (!first) {
                    r.append(" OR ");
                }
                r.append(RawParseUtils.decode(p));
                first = false;
                ++n2;
            }
            r.append(")");
            return r.toString();
        }
    }

    static class Single
    extends TreeFilter {
        private final PathFilter path;
        private final byte[] raw;

        private Single(PathFilter p) {
            this.path = p;
            this.raw = this.path.pathRaw;
        }

        @Override
        public boolean include(TreeWalk walker) {
            int cmp = walker.isPathPrefix(this.raw, this.raw.length);
            if (cmp > 0) {
                throw StopWalkException.INSTANCE;
            }
            return cmp == 0;
        }

        @Override
        public boolean shouldBeRecursive() {
            return this.path.shouldBeRecursive();
        }

        @Override
        public TreeFilter clone() {
            return this;
        }

        @Override
        public String toString() {
            return "FAST_" + this.path.toString();
        }
    }
}

