/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.jcifs.netbios;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import org.gradle.internal.impldep.jcifs.Config;
import org.gradle.internal.impldep.jcifs.netbios.Name;
import org.gradle.internal.impldep.jcifs.netbios.NbtAddress;
import org.gradle.internal.impldep.jcifs.smb.SmbFileInputStream;
import org.gradle.internal.impldep.jcifs.util.LogStream;

public class Lmhosts {
    private static final String FILENAME = Config.getProperty("org/gradle/internal/impldep/jcifs.netbios.lmhosts");
    private static final Hashtable TAB = new Hashtable();
    private static long lastModified = 1L;
    private static int alt;
    private static LogStream log;

    public static synchronized NbtAddress getByName(String host) {
        return Lmhosts.getByName(new Name(host, 32, null));
    }

    static synchronized NbtAddress getByName(Name name) {
        NbtAddress result;
        block6: {
            result = null;
            try {
                if (FILENAME != null) {
                    File f = new File(FILENAME);
                    long lm = f.lastModified();
                    if (lm > lastModified) {
                        lastModified = lm;
                        TAB.clear();
                        alt = 0;
                        Lmhosts.populate(new FileReader(f));
                    }
                    result = (NbtAddress)TAB.get(name);
                }
            }
            catch (FileNotFoundException fnfe) {
                if (LogStream.level > 1) {
                    log.println("lmhosts file: " + FILENAME);
                    fnfe.printStackTrace(log);
                }
            }
            catch (IOException ioe) {
                if (LogStream.level <= 0) break block6;
                ioe.printStackTrace(log);
            }
        }
        return result;
    }

    static void populate(Reader r) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(r);
        while ((line = br.readLine()) != null) {
            int j;
            int i;
            if ((line = line.toUpperCase().trim()).length() == 0) continue;
            if (line.charAt(0) == '#') {
                if (line.startsWith("#INCLUDE ")) {
                    line = line.substring(line.indexOf(92));
                    String url = "smb:" + line.replace('\\', '/');
                    if (alt > 0) {
                        try {
                            Lmhosts.populate(new InputStreamReader(new SmbFileInputStream(url)));
                        }
                        catch (IOException ioe) {
                            log.println("lmhosts URL: " + url);
                            ioe.printStackTrace(log);
                            continue;
                        }
                        --alt;
                        while ((line = br.readLine()) != null && !(line = line.toUpperCase().trim()).startsWith("#END_ALTERNATE")) {
                        }
                        continue;
                    }
                    Lmhosts.populate(new InputStreamReader(new SmbFileInputStream(url)));
                    continue;
                }
                if (line.startsWith("#BEGIN_ALTERNATE")) {
                    ++alt;
                    continue;
                }
                if (!line.startsWith("#END_ALTERNATE") || alt <= 0) continue;
                --alt;
                throw new IOException("no lmhosts alternate includes loaded");
            }
            if (!Character.isDigit(line.charAt(0))) continue;
            char[] data = line.toCharArray();
            int c = 46;
            int ip = 0;
            for (i = 0; i < data.length && c == 46; ++i) {
                int b = 0;
                while (i < data.length && (c = data[i]) >= 48 && c <= 57) {
                    b = b * 10 + c - 48;
                    ++i;
                }
                ip = (ip << 8) + b;
            }
            while (i < data.length && Character.isWhitespace(data[i])) {
                ++i;
            }
            for (j = i; j < data.length && !Character.isWhitespace(data[j]); ++j) {
            }
            Name name = new Name(line.substring(i, j), 32, null);
            NbtAddress addr = new NbtAddress(name, ip, false, 0, false, false, true, true, NbtAddress.UNKNOWN_MAC_ADDRESS);
            TAB.put(name, addr);
        }
    }

    static {
        log = LogStream.getInstance();
    }
}

