/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.remote;

import com.intellij.openapi.util.InvalidDataException;
import com.jetbrains.cidr.cpp.execution.remote.CLionRemoteRunConfigurationKt;
import com.jetbrains.cidr.cpp.execution.remote.DebuggerSourceKind;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUIUtils;
import com.jetbrains.cidr.toolchains.OSType;
import com.jetbrains.cidr.ui.BaseItemPrinter;
import com.jetbrains.cidr.ui.ComponentRenderer;
import com.jetbrains.cidr.ui.CustomEditableComboItem;
import com.jetbrains.cidr.ui.ItemPrinterKt;
import com.jetbrains.cidr.ui.ItemState;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00072\u00020\u0001:\u0004\u0006\u0007\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u0082\u0001\u0003\n\u000b\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind;", "", "()V", "isLLDB", "", "()Z", "Bundle", "Companion", "External", "Toolchain", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Toolchain;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$External;", "intellij.clion.execution"})
public abstract class DebuggerSourceKind {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final boolean isLLDB() {
        boolean bl;
        DebuggerSourceKind debuggerSourceKind = this;
        if (Intrinsics.areEqual((Object)debuggerSourceKind, (Object)Bundle.GDB.INSTANCE)) {
            bl = false;
        } else if (Intrinsics.areEqual((Object)debuggerSourceKind, (Object)Bundle.LLDB.INSTANCE)) {
            bl = true;
        } else if (debuggerSourceKind instanceof Toolchain) {
            bl = ((Toolchain)this).getToolchain().getDebuggerKind().isLLDB();
        } else if (debuggerSourceKind instanceof External) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    private DebuggerSourceKind() {
    }

    public /* synthetic */ DebuggerSourceKind(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eB\u001b\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\u0082\u0001\u0002\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind;", "name", "", "subtitle", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getSubtitle", "title", "getTitle", "toString", "Companion", "GDB", "LLDB", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle$GDB;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle$LLDB;", "intellij.clion.execution"})
    public static abstract class Bundle
    extends DebuggerSourceKind {
        @NotNull
        private final String name;
        @Nullable
        private final String subtitle;
        @NotNull
        private static final BaseItemPrinter<Bundle> printer;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final String getTitle() {
            return "Bundled " + this.name;
        }

        @NotNull
        public String toString() {
            return this.getTitle();
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @Nullable
        public final String getSubtitle() {
            return this.subtitle;
        }

        private Bundle(String name2, String subtitle) {
            super(null);
            this.name = name2;
            this.subtitle = subtitle;
        }

        /* synthetic */ Bundle(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        static {
            Companion = new Companion(null);
            Function3 renderValueFunction$iv = Companion.printer.1.INSTANCE;
            boolean $i$f$printerFor = false;
            printer = ItemPrinterKt.printerFor(Bundle.class, (Function3)renderValueFunction$iv);
        }

        public /* synthetic */ Bundle(String name2, String subtitle, DefaultConstructorMarker $constructor_marker) {
            this(name2, subtitle);
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle$GDB;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle;", "()V", "intellij.clion.execution"})
        public static final class GDB
        extends Bundle {
            @NotNull
            public static final GDB INSTANCE;

            private GDB() {
                super("GDB", "multiarch", null);
            }

            static {
                GDB gDB;
                INSTANCE = gDB = new GDB();
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle$LLDB;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle;", "()V", "intellij.clion.execution"})
        public static final class LLDB
        extends Bundle {
            @NotNull
            public static final LLDB INSTANCE;

            private LLDB() {
                super("LLDB", null, 2, null);
            }

            static {
                LLDB lLDB;
                INSTANCE = lLDB = new LLDB();
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\nR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle$Companion;", "", "()V", "printer", "Lcom/jetbrains/cidr/ui/BaseItemPrinter;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Bundle;", "getPrinter", "()Lcom/jetbrains/cidr/ui/BaseItemPrinter;", "defaultForOS", "osType", "Lcom/jetbrains/cidr/toolchains/OSType;", "intellij.clion.execution"})
        public static final class Companion {
            @NotNull
            public final BaseItemPrinter<Bundle> getPrinter() {
                return printer;
            }

            @NotNull
            public final Bundle defaultForOS(@NotNull OSType osType) {
                Intrinsics.checkNotNullParameter((Object)osType, (String)"osType");
                return CPPToolchainsUIUtils.showLLDBFirst((OSType)osType) ? (Bundle)LLDB.INSTANCE : (Bundle)GDB.INSTANCE;
            }

            public static /* synthetic */ Bundle defaultForOS$default(Companion companion, OSType oSType, int n, Object object) {
                if ((n & 1) != 0) {
                    OSType oSType2 = OSType.getCurrent();
                    Intrinsics.checkNotNullExpressionValue((Object)oSType2, (String)"OSType.getCurrent()");
                    oSType = oSType2;
                }
                return companion.defaultForOS(oSType);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Toolchain;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind;", "toolchain", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;)V", "getToolchain", "()Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "intellij.clion.execution"})
    public static final class Toolchain
    extends DebuggerSourceKind {
        @NotNull
        private final CPPToolchains.Toolchain toolchain;
        @NotNull
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final CPPToolchains.Toolchain getToolchain() {
            return this.toolchain;
        }

        public Toolchain(@NotNull CPPToolchains.Toolchain toolchain) {
            Intrinsics.checkNotNullParameter((Object)toolchain, (String)"toolchain");
            super(null);
            this.toolchain = toolchain;
        }

        @NotNull
        public final CPPToolchains.Toolchain component1() {
            return this.toolchain;
        }

        @NotNull
        public final Toolchain copy(@NotNull CPPToolchains.Toolchain toolchain) {
            Intrinsics.checkNotNullParameter((Object)toolchain, (String)"toolchain");
            return new Toolchain(toolchain);
        }

        public static /* synthetic */ Toolchain copy$default(Toolchain toolchain, CPPToolchains.Toolchain toolchain2, int n, Object object) {
            if ((n & 1) != 0) {
                toolchain2 = toolchain.toolchain;
            }
            return toolchain.copy(toolchain2);
        }

        @NotNull
        public String toString() {
            return "Toolchain(toolchain=" + this.toolchain + ")";
        }

        public int hashCode() {
            CPPToolchains.Toolchain toolchain = this.toolchain;
            return toolchain != null ? toolchain.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Toolchain)) break block3;
                    Toolchain toolchain = (Toolchain)object;
                    if (!Intrinsics.areEqual((Object)this.toolchain, (Object)toolchain.toolchain)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Toolchain$Companion;", "", "()V", "printer", "Lcom/jetbrains/cidr/ui/BaseItemPrinter;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Toolchain;", "isRemote", "", "intellij.clion.execution"})
        public static final class Companion {
            @NotNull
            public final BaseItemPrinter<Toolchain> printer(boolean isRemote) {
                Function3 renderValueFunction$iv = (Function3)new Function3<ComponentRenderer, Toolchain, ItemState, Unit>(isRemote){
                    final /* synthetic */ boolean $isRemote;

                    public final void invoke(@NotNull ComponentRenderer $this$printerFor, @NotNull Toolchain toolchainSource, @NotNull ItemState state) {
                        Intrinsics.checkNotNullParameter((Object)$this$printerFor, (String)"$receiver");
                        Intrinsics.checkNotNullParameter((Object)toolchainSource, (String)"toolchainSource");
                        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                        CPPToolchains.Toolchain toolchain = toolchainSource.getToolchain();
                        if (this.$isRemote) {
                            String string = CLionRemoteRunConfigurationKt.getRemoteRunToolchainProblem(toolchain, true);
                            if (string != null) {
                                String string2 = string;
                                boolean bl = false;
                                boolean bl2 = false;
                                String errorMessage = string2;
                                boolean bl3 = false;
                                String string3 = toolchain.getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toolchain.name");
                                $this$printerFor.append((Object)string3);
                                $this$printerFor.appendError((Object)(" (" + errorMessage + ')'), state);
                                return;
                            }
                        }
                        File gdbExecutable = toolchain.getDebugger().getGdbExecutable();
                        if (CPPToolchainsUIUtils.isToolSetGdb((CPPToolSet)toolchain.getToolSet(), (File)gdbExecutable)) {
                            $this$printerFor.append((Object)CPPToolchainsUIUtils.getToolSetGdbTitle((CPPToolSet)toolchain.getToolSet()));
                        } else if (gdbExecutable != null) {
                            String string = gdbExecutable.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gdbExecutable.name");
                            $this$printerFor.append((Object)string);
                        } else if (toolchain.getDebuggerKind() == CPPDebugger.Kind.BUNDLED_GDB) {
                            $this$printerFor.append((Object)"Bundled GDB");
                        } else if (toolchain.getDebuggerKind() == CPPDebugger.Kind.BUNDLED_LLDB) {
                            $this$printerFor.append((Object)"Bundled LLDB");
                        } else {
                            $this$printerFor.appendError((Object)"INVALID", state);
                        }
                        $this$printerFor.appendGrayed((Object)(" from '" + toolchain.getName() + "' toolchain"), state);
                    }
                    {
                        this.$isRemote = bl;
                        super(3);
                    }
                };
                boolean $i$f$printerFor = false;
                return ItemPrinterKt.printerFor(Toolchain.class, (Function3)renderValueFunction$iv);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$External;", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.clion.execution"})
    public static final class External
    extends DebuggerSourceKind {
        @NotNull
        private final String path;
        @NotNull
        private static final BaseItemPrinter<CustomEditableComboItem> printer;
        @NotNull
        public static final Companion Companion;

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public External(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            super(null);
            this.path = path;
        }

        static {
            Companion = new Companion(null);
            Function3 renderValueFunction$iv = Companion.printer.1.INSTANCE;
            boolean $i$f$printerFor = false;
            printer = ItemPrinterKt.printerFor(CustomEditableComboItem.class, (Function3)renderValueFunction$iv);
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final External copy(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return new External(path);
        }

        public static /* synthetic */ External copy$default(External external, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = external.path;
            }
            return external.copy(string);
        }

        @NotNull
        public String toString() {
            return "External(path=" + this.path + ")";
        }

        public int hashCode() {
            String string = this.path;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof External)) break block3;
                    External external = (External)object;
                    if (!Intrinsics.areEqual((Object)this.path, (Object)external.path)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$External$Companion;", "", "()V", "printer", "Lcom/jetbrains/cidr/ui/BaseItemPrinter;", "Lcom/jetbrains/cidr/ui/CustomEditableComboItem;", "getPrinter", "()Lcom/jetbrains/cidr/ui/BaseItemPrinter;", "intellij.clion.execution"})
        public static final class Companion {
            @NotNull
            public final BaseItemPrinter<CustomEditableComboItem> getPrinter() {
                return printer;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind$Companion;", "", "()V", "fromData", "Lcom/jetbrains/cidr/cpp/execution/remote/DebuggerSourceKind;", "debuggerKind", "", "isBundled", "", "toolchainName", "path", "intellij.clion.execution"})
    public static final class Companion {
        @NotNull
        public final DebuggerSourceKind fromData(@Nullable String debuggerKind, boolean isBundled, @Nullable String toolchainName2, @Nullable String path) {
            CPPToolchains.Toolchain toolchain;
            if (debuggerKind != null) {
                DebuggerSourceKind debuggerSourceKind;
                switch (debuggerKind) {
                    case "GDB": {
                        boolean bl = isBundled;
                        if (bl) {
                            debuggerSourceKind = Bundle.GDB.INSTANCE;
                            break;
                        }
                        if (!bl) {
                            String string = path;
                            boolean bl2 = false;
                            String string2 = string;
                            if (string2 == null) {
                                string2 = "";
                            }
                            debuggerSourceKind = new External(string2);
                            break;
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    case "LLDB": {
                        debuggerSourceKind = Bundle.LLDB.INSTANCE;
                        break;
                    }
                    default: {
                        throw (Throwable)new InvalidDataException("Unknown debugger kind");
                    }
                }
                return debuggerSourceKind;
            }
            if (toolchainName2 != null && (toolchain = CPPToolchains.getInstance().getToolchainByNameOrDefault(toolchainName2)) != null) {
                return new Toolchain(toolchain);
            }
            return Bundle.GDB.INSTANCE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

