/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.ProfilerManagerKt;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.clion.AttachCPPProfilerProviderKt;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.DTraceProfilerConfigurationExtensionKt;
import com.intellij.profiler.clion.NativeTargetProcess;
import com.intellij.profiler.clion.dtrace.CPPDTraceProfilerProcess;
import com.intellij.profiler.dtrace.DTraceProfilerProcessBaseKt;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationExtensionBase;
import com.jetbrains.cidr.execution.ConfigurationExtensionContext;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0016\u0010\u0005\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006H\u0016J2\u0010\u0014\u001a\u00020\u00132\u0016\u0010\u0015\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016JJ\u0010\u0016\u001a\u00020\u00042\u0016\u0010\u0005\u001a\u0012\u0012\u0002\b\u0003\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00070\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/intellij/profiler/clion/DTraceProfilerConfigurationExtension;", "Lcom/jetbrains/cidr/execution/CidrRunConfigurationExtensionBase;", "()V", "attachToProcess", "", "configuration", "Lcom/jetbrains/cidr/execution/CidrRunConfiguration;", "Lcom/jetbrains/cidr/execution/CidrBuildTarget;", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "runnerId", "", "context", "Lcom/jetbrains/cidr/execution/ConfigurationExtensionContext;", "isApplicableFor", "", "isEnabledFor", "applicableConfiguration", "patchCommandLine", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "Companion", "intellij.profiler.clion"})
public final class DTraceProfilerConfigurationExtension
extends CidrRunConfigurationExtensionBase {
    private static final String DYLD_INSERT_LIBRARIES = "DYLD_INSERT_LIBRARIES";
    private static final String BUNDLED_STARTER_PATH = "profiler/mac/libosx-starter.dylib";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isApplicableFor(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> configuration) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEnabledFor(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> applicableConfiguration, @NotNull CidrToolEnvironment environment2, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(applicableConfiguration, (String)"applicableConfiguration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        if (!AttachCPPProfilerProviderKt.isCLionProfilerCompatible((RunProfile)applicableConfiguration)) return false;
        if (!AttachCPPProfilerProviderKt.isDTraceProfilerCanBeUsed()) return false;
        HostMachine hostMachine = environment2.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
        if (hostMachine.isRemote()) return false;
        return true;
    }

    public void patchCommandLine(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment2, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)"ProfilerRunner", (Object)runnerId) ^ true) {
            return;
        }
        HostMachine hostMachine = environment2.getHostMachine();
        Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
        if (hostMachine.isRemote()) {
            throw (Throwable)new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.remote.unsupported", new Object[0]));
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.getProject()");
        ExecutionException executionException = DTraceProfilerConfigurationExtensionKt.validateDTraceSettings(project);
        if (executionException != null) {
            ExecutionException executionException2 = executionException;
            boolean bl = false;
            boolean bl2 = false;
            ExecutionException it = executionException2;
            boolean bl3 = false;
            throw (Throwable)it;
        }
        File starterPath = DTraceProfilerConfigurationExtension.Companion.profilerStarterPath();
        if (!starterPath.exists()) {
            Object[] objectArray = new Object[1];
            String string = starterPath.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"starterPath.absolutePath");
            objectArray[0] = string;
            throw (Throwable)new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.cannot.find.process.starter", objectArray));
        }
        cmdLine.withEnvironment(DYLD_INSERT_LIBRARIES, starterPath.getAbsolutePath());
    }

    public void attachToProcess(@NotNull CidrRunConfiguration<?, ? extends CidrBuildTarget<?>> configuration, @NotNull ProcessHandler handler2, @NotNull CidrToolEnvironment environment2, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        Object object;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
                Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
                Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
                Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                if (Intrinsics.areEqual((Object)"ProfilerRunner", (Object)runnerId) ^ true) break block5;
                HostMachine hostMachine = environment2.getHostMachine();
                Intrinsics.checkNotNullExpressionValue((Object)hostMachine, (String)"environment.hostMachine");
                if (!hostMachine.isRemote()) break block6;
            }
            return;
        }
        ProcessHandler processHandler = handler2;
        if (!(processHandler instanceof BaseProcessHandler)) {
            processHandler = null;
        }
        if ((object = (BaseProcessHandler)processHandler) == null || (object = object.getProcess()) == null) {
            throw (Throwable)new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.cannot.detect.target.process", new Object[0]));
        }
        Object targetProcess = object;
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"configuration.getProject()");
        Project project2 = project;
        String string = DTraceProfilerProcessBaseKt.getLegacyDTraceProfilerConfiguration().getConfigurationTypeId();
        ConfigurationType configurationType = configuration.getType();
        Intrinsics.checkNotNullExpressionValue((Object)configurationType, (String)"configuration.getType()");
        String string2 = configurationType.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"configuration.getType().id");
        ProfilerUsageTriggerCollector.Companion.reportStart(project2, string, string2);
        int n = (int)((Process)targetProcess).pid();
        String string3 = configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"configuration.getName()");
        NativeTargetProcess namedProcess = new NativeTargetProcess(n, string3);
        AttachableTargetProcess attachableTargetProcess = namedProcess;
        PerformInBackgroundOption performInBackgroundOption = PerformInBackgroundOption.ALWAYS_BACKGROUND;
        Intrinsics.checkNotNullExpressionValue((Object)performInBackgroundOption, (String)"PerformInBackgroundOption.ALWAYS_BACKGROUND");
        ProfilerManagerKt.installErrorHandlers(CPPDTraceProfilerProcess.Companion.attach(attachableTargetProcess, performInBackgroundOption, 10000, project2), (Project)project2).onError(new Consumer(handler2){
            final /* synthetic */ ProcessHandler $handler;

            public final void accept(Throwable it) {
                ExecutionManagerImpl.Companion.stopProcess(this.$handler);
            }
            {
                this.$handler = processHandler;
            }
        }).onSuccess(new Consumer((Process)targetProcess, project2){
            final /* synthetic */ Process $targetProcess;
            final /* synthetic */ Project $project;

            public final void accept(CPPDTraceProfilerProcess process) {
                UnixProcessManager.sendSigIntToProcessTree((Process)this.$targetProcess);
                ProfilerToolWindowManager profilerToolWindowManager = ProfilerToolWindowManager.Companion.getInstance(this.$project);
                CPPDTraceProfilerProcess cPPDTraceProfilerProcess = process;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)cPPDTraceProfilerProcess), (String)"process");
                ProfilerToolWindowManager.addProfilerProcessTab$default((ProfilerToolWindowManager)profilerToolWindowManager, (ProfilerProcess)((ProfilerProcess)cPPDTraceProfilerProcess), (boolean)false, (int)2, null);
            }
            {
                this.$targetProcess = process;
                this.$project = project;
            }
        });
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/clion/DTraceProfilerConfigurationExtension$Companion;", "", "()V", "BUNDLED_STARTER_PATH", "", "DYLD_INSERT_LIBRARIES", "profilerStarterPath", "Ljava/io/File;", "intellij.profiler.clion"})
    public static final class Companion {
        private final File profilerStarterPath() {
            if (PluginManagerCore.isRunningFromSources()) {
                return new File(PathManager.getHomePath(), "CIDR/clion/bin/profiler/mac/libosx-starter.dylib");
            }
            return new File(PathManager.getBinPath(), DTraceProfilerConfigurationExtension.BUNDLED_STARTER_PATH);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

