/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000B\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nH\u0002\u001a.\u0010\u000b\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010\u001a(\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001e\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a.\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\rH\u0002\u00a8\u0006\u0018"}, d2={"enableAutoUploadChanges", "", "project", "Lcom/intellij/openapi/project/Project;", "webServerConfig", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "publishConfig", "Lcom/jetbrains/plugins/webDeployment/config/PublishConfig;", "invokeLaterNonModal", "runnable", "Lkotlin/Function0;", "savePathMappingSettings", "pathMappings", "", "Lcom/jetbrains/plugins/webDeployment/config/DeploymentPathMapping;", "uploadChanges", "", "setupPublishOptions", "uploadPublishConfigToServer", "uploadToServer", "server", "Lcom/jetbrains/plugins/webDeployment/config/Deployable;", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.remoteRun"})
public final class WebDeploymentConfigurationUtilKt {
    public static final void savePathMappingSettings(@Nullable Project project, @NotNull WebServerConfig webServerConfig, @NotNull List<? extends DeploymentPathMapping> pathMappings, boolean uploadChanges) {
        Intrinsics.checkNotNullParameter((Object)webServerConfig, (String)"webServerConfig");
        Intrinsics.checkNotNullParameter(pathMappings, (String)"pathMappings");
        String string = webServerConfig.getId();
        if (string == null) {
            throw (Throwable)new IllegalStateException("Deployment server config id must not be null");
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"webServerConfig.id ?: th\u2026fig id must not be null\")");
        String serverId = string;
        Collection collection = pathMappings;
        boolean bl = false;
        if (!collection.isEmpty() && project != null && !project.isDefault()) {
            PublishConfig publishConfig = PublishConfig.getInstance((Project)project);
            publishConfig.setPathMappings(serverId, pathMappings);
            PublishConfig publishConfig2 = publishConfig;
            Intrinsics.checkNotNullExpressionValue((Object)publishConfig2, (String)"publishConfig");
            WebDeploymentConfigurationUtilKt.setupPublishOptions(project, webServerConfig, publishConfig2, uploadChanges);
        }
    }

    private static final void setupPublishOptions(Project project, WebServerConfig webServerConfig, PublishConfig publishConfig, boolean uploadChanges) {
        WebDeploymentConfigurationUtilKt.invokeLaterNonModal((Function0<Unit>)((Function0)new Function0<Unit>(uploadChanges, project, webServerConfig, publishConfig){
            final /* synthetic */ boolean $uploadChanges;
            final /* synthetic */ Project $project;
            final /* synthetic */ WebServerConfig $webServerConfig;
            final /* synthetic */ PublishConfig $publishConfig;

            public final void invoke() {
                if (this.$uploadChanges) {
                    WebDeploymentConfigurationUtilKt.uploadPublishConfigToServer(this.$project, this.$webServerConfig, this.$publishConfig);
                    WebDeploymentConfigurationUtilKt.enableAutoUploadChanges(this.$project, this.$webServerConfig, this.$publishConfig);
                }
            }
            {
                this.$uploadChanges = bl;
                this.$project = project;
                this.$webServerConfig = webServerConfig;
                this.$publishConfig = publishConfig;
                super(0);
            }
        }));
    }

    public static final void enableAutoUploadChanges(@NotNull Project project, @NotNull WebServerConfig webServerConfig, @NotNull PublishConfig publishConfig) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)webServerConfig, (String)"webServerConfig");
        Intrinsics.checkNotNullParameter((Object)publishConfig, (String)"publishConfig");
        publishConfig.setDefaultGroupOrServerName(webServerConfig.getName());
        publishConfig.setAutoUploadState(PublishConfig.AutoUploadState.ALWAYS);
        ((DeploymentConfigChangeListener)project.getMessageBus().syncPublisher(WebDeploymentTopics.DEPLOYMENT_CONFIG)).optionsChanged();
    }

    /*
     * WARNING - void declaration
     */
    public static final void uploadPublishConfigToServer(@NotNull Project project, @NotNull WebServerConfig webServerConfig, @NotNull PublishConfig publishConfig) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)webServerConfig, (String)"webServerConfig");
        Intrinsics.checkNotNullParameter((Object)publishConfig, (String)"publishConfig");
        Deployable server = Deployable.create((WebServerConfig)webServerConfig, (Project)project);
        List list = publishConfig.getPathMappings(webServerConfig.getId());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"publishConfig.getPathMappings(webServerConfig.id)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DeploymentPathMapping it = (DeploymentPathMapping)element$iv$iv;
            boolean bl2 = false;
            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
            DeploymentPathMapping deploymentPathMapping = it;
            Intrinsics.checkNotNullExpressionValue((Object)deploymentPathMapping, (String)"it");
            if (localFileSystem.findFileByPath(deploymentPathMapping.getLocalPath()) == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            VirtualFile it$iv$iv = virtualFile;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List roots = (List)destination$iv$iv;
        Deployable deployable = server;
        Intrinsics.checkNotNullExpressionValue((Object)deployable, (String)"server");
        WebDeploymentConfigurationUtilKt.uploadToServer(project, deployable, publishConfig, roots);
    }

    private static final void uploadToServer(Project project, Deployable server, PublishConfig publishConfig, List<? extends VirtualFile> roots) {
        String string = WDBundle.message((String)"upload.to", (Object[])new Object[]{StringUtil.notNullize((String)server.getName())});
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"WDBundle.message(\"upload\u2026.notNullize(server.name))");
        String title = string;
        TransferTask.ListBased transferTask2 = new TransferTask.ListBased(roots, project, publishConfig, server, title, project, (ConnectionOwner)ConnectionOwnerFactory.createConnectionOwner((Project)project), true, publishConfig, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance((Project)project)){
            final /* synthetic */ List $roots;
            final /* synthetic */ Project $project;
            final /* synthetic */ PublishConfig $publishConfig;
            final /* synthetic */ Deployable $server;
            final /* synthetic */ String $title;

            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(@NotNull ExecutionContext context) throws FileSystemException {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                TransferTask.ListBased.ResultWithErrors resultWithErrors = PublishActionUtil.scanFiles((ExecutionContext)context, (Collection)this.$roots);
                Intrinsics.checkNotNullExpressionValue((Object)resultWithErrors, (String)"PublishActionUtil.scanFiles(context, roots)");
                return resultWithErrors;
            }
            {
                this.$roots = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                this.$publishConfig = $captured_local_variable$2;
                this.$server = $captured_local_variable$3;
                this.$title = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7, $super_call_param$8, $super_call_param$9, $super_call_param$10, $super_call_param$11, $super_call_param$12, $super_call_param$13, $super_call_param$14);
            }
        };
        FileTransferToolWindow.printWithTimestamp((Project)project, (Mappable)((Mappable)server), (String)title, (ConsoleViewContentType)ConsoleViewContentType.SYSTEM_OUTPUT, (PublishConfig.TraceLevel)publishConfig.getTraceLevel());
        ProgressManager.getInstance().run((Task)transferTask2);
    }

    private static final void invokeLaterNonModal(Function0<Unit> runnable) {
        Application application = ApplicationManager.getApplication();
        Object object = runnable;
        if (object != null) {
            Function0<Unit> function0 = object;
            object = new Runnable(function0){
                private final /* synthetic */ Function0 function;
                {
                    this.function = function0;
                }

                public final /* synthetic */ void run() {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(), (String)"invoke(...)");
                }
            };
        }
        application.invokeLater((Runnable)object, ModalityState.NON_MODAL);
    }
}

