/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.VagrantSupport;
import com.intellij.remote.ext.CredentialsEditor;
import com.intellij.remote.ext.FormWithAlignableLabelsColumn;
import com.intellij.remote.ui.RemoteSdkEditorForm;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ui.components.JBLabel;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.ui.CreateRemoteSdkUIUtil;
import com.jetbrains.plugins.remotesdk.ui.VagrantCredentialsEditor;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import java.awt.Component;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VagrantRemoteCredentialsEditor
implements CredentialsEditor<VagrantBasedCredentialsHolder>,
FormWithAlignableLabelsColumn {
    @Nullable
    private final Project myProject;
    @NotNull
    private final VagrantCredentialsEditor myVagrantCredentialsForm;

    public VagrantRemoteCredentialsEditor(@NotNull VagrantSupport support, @NotNull RemoteSdkEditorForm parentForm, @Nullable Project project) {
        if (support == null) {
            VagrantRemoteCredentialsEditor.$$$reportNull$$$0(0);
        }
        if (parentForm == null) {
            VagrantRemoteCredentialsEditor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myVagrantCredentialsForm = new VagrantCredentialsEditor(support, parentForm, project);
    }

    @NotNull
    public String getName() {
        String string = VagrantCredentialsType.getInstance().getName();
        if (string == null) {
            VagrantRemoteCredentialsEditor.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JPanel getMainPanel() {
        return this.myVagrantCredentialsForm.getPanel();
    }

    public void onSelected() {
        this.myVagrantCredentialsForm.onSelected();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myVagrantCredentialsForm.getPreferredFocusedComponent(), true));
    }

    public ValidationInfo validate() {
        Ref configRef = Ref.create();
        ValidationInfo result = this.myVagrantCredentialsForm.validate((Ref<FileTransferConfig>)configRef, true);
        if (configRef.isNull()) {
            return result;
        }
        if (result != null) {
            return result;
        }
        return SshCredentialsVerifier.wrapValidation(() -> ((FileTransferConfig)configRef.get()).validateSlow(500L, false));
    }

    @NlsContexts.DialogMessage
    public String validateFinal(@NotNull Supplier<? extends RemoteSdkAdditionalData<?>> supplier, @NotNull Consumer<String> helpersPathUpdateCallback) {
        if (supplier == null) {
            VagrantRemoteCredentialsEditor.$$$reportNull$$$0(3);
        }
        if (helpersPathUpdateCallback == null) {
            VagrantRemoteCredentialsEditor.$$$reportNull$$$0(4);
        }
        return CreateRemoteSdkUIUtil.validateUsingRemoteSdkCredentials(this.myProject, supplier, helpersPathUpdateCallback);
    }

    public void saveCredentials(VagrantBasedCredentialsHolder credentials) {
        VagrantBasedCredentialsHolder sourceCredentials = this.myVagrantCredentialsForm.getVagrantCredentials();
        if (sourceCredentials != null) {
            credentials.setVagrantFolder(sourceCredentials.getVagrantFolder());
            credentials.setMachineName(sourceCredentials.getMachineName());
        }
    }

    public void init(VagrantBasedCredentialsHolder credentials) {
        this.myVagrantCredentialsForm.initVagrantSettings(credentials);
    }

    @NotNull
    public List<JBLabel> getLabelsColumn() {
        List<JBLabel> list = this.myVagrantCredentialsForm.getLabelsColumn();
        if (list == null) {
            VagrantRemoteCredentialsEditor.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentForm";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/remotesdk/VagrantRemoteCredentialsEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpersPathUpdateCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/remotesdk/VagrantRemoteCredentialsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsColumn";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "validateFinal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

