/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk;

import com.google.common.base.Function;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.RemoteConnectionCredentialsWrapper;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkCredentialsProducer;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.util.Consumer;
import com.jetbrains.plugins.remotesdk.SshConfigCredentialsType;
import com.jetbrains.plugins.remotesdk.SshCredentialsType;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsType;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsUtil;
import com.jetbrains.plugins.remotesdk.WebDeploymentCredentialsType;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.util.concurrent.CountDownLatch;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteSdkCredentialsProducerImpl<T extends RemoteSdkCredentials>
implements RemoteSdkCredentialsProducer<T> {
    @NotNull
    private final Function<? super RemoteCredentials, ? extends T> myTransformer;
    @NotNull
    private final RemoteConnectionCredentialsWrapper myWrapper;

    public RemoteSdkCredentialsProducerImpl(@NotNull Function<? super RemoteCredentials, ? extends T> transformer, @NotNull RemoteConnectionCredentialsWrapper wrapper) {
        if (transformer == null) {
            RemoteSdkCredentialsProducerImpl.$$$reportNull$$$0(0);
        }
        if (wrapper == null) {
            RemoteSdkCredentialsProducerImpl.$$$reportNull$$$0(1);
        }
        this(transformer, wrapper, false);
    }

    public RemoteSdkCredentialsProducerImpl(@NotNull Function<? super RemoteCredentials, ? extends T> transformer, @NotNull RemoteConnectionCredentialsWrapper wrapper, boolean useCache) {
        if (transformer == null) {
            RemoteSdkCredentialsProducerImpl.$$$reportNull$$$0(2);
        }
        if (wrapper == null) {
            RemoteSdkCredentialsProducerImpl.$$$reportNull$$$0(3);
        }
        this.myTransformer = transformer;
        this.myWrapper = wrapper;
    }

    public void produceRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction, Consumer<? super T> remoteSdkCredentialsConsumer) {
        this.myWrapper.switchType(new CredentialsCase[]{CredentialsCase.create((CredentialsType)SshCredentialsType.getInstance(), credentials -> remoteSdkCredentialsConsumer.consume(this.myTransformer.apply(credentials))), CredentialsCase.create((CredentialsType)VagrantCredentialsType.getInstance(), credentials -> {
            RemoteCredentials remoteCredentials = VagrantCredentialsUtil.getAndCheckVagrantRemoteCredentials(credentials, allowSynchronousInteraction);
            remoteSdkCredentialsConsumer.consume(this.myTransformer.apply((Object)remoteCredentials));
        }), CredentialsCase.create((CredentialsType)WebDeploymentCredentialsType.getInstance(), credentials -> {
            RemoteCredentials remoteCredentials = WebDeploymentCredentialsType.createRemoteCredentials(project, credentials);
            remoteSdkCredentialsConsumer.consume(this.myTransformer.apply((Object)remoteCredentials));
        }), CredentialsCase.create((CredentialsType)SshConfigCredentialsType.getInstance(), credentials -> {
            RemoteCredentials remoteCredentials = SshConfigCredentialsType.createRemoteCredentials(project, credentials);
            remoteSdkCredentialsConsumer.consume(this.myTransformer.apply((Object)remoteCredentials));
        })});
    }

    public void produceRemoteSdkCredentials(boolean allowSynchronousInteraction, Consumer<? super T> remoteSdkCredentialsConsumer) {
        this.produceRemoteSdkCredentials(null, allowSynchronousInteraction, remoteSdkCredentialsConsumer);
    }

    public void produceRemoteSdkCredentials(Consumer<? super T> remoteSdkCredentialsConsumer) {
        this.produceRemoteSdkCredentials(null, true, remoteSdkCredentialsConsumer);
    }

    @Deprecated
    public T getRemoteSdkCredentials() throws InterruptedException, ExecutionException {
        return this.getRemoteSdkCredentials(null, true);
    }

    public T getRemoteSdkCredentials(boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        return this.getRemoteSdkCredentials(null, allowSynchronousInteraction);
    }

    public T getRemoteSdkCredentials(@Nullable Project project, boolean allowSynchronousInteraction) throws InterruptedException, ExecutionException {
        MyRemoteCredentialsConsumer c = new MyRemoteCredentialsConsumer();
        try {
            this.produceRemoteSdkCredentials(project, allowSynchronousInteraction, c);
        }
        catch (RuntimeException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        c.await();
        return c.myRemoteSdkCredentials;
    }

    public Object getRemoteSdkDataKey() {
        return this.myWrapper.getConnectionKey();
    }

    @Nullable
    public static RemoteCredentials getCredentialsBySftpServerId(@Nullable Project project, @Nullable String id) {
        WebServerConfig server = GroupedServersConfigManager.getInstance((Project)project).findServer(id, true);
        if (server != null && server.getFileTransferConfig().getAccessType() == AccessType.SFTP) {
            return WebDeploymentCredentialHelper.getRemoteCredentials((WebServerConfig)server, (Project)project);
        }
        return null;
    }

    @Nullable
    public static RemoteCredentials getCredentialsBySshConfigName(@Nullable Project project, @Nullable String name) {
        SshUiData sshUiData = SshConfigManager.getInstance((Project)project).findCurrentDataByName(name);
        if (sshUiData == null) {
            return null;
        }
        return sshUiData.copyToCredentials();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "transformer";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "wrapper";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/remotesdk/RemoteSdkCredentialsProducerImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyRemoteCredentialsConsumer
    implements Consumer<T> {
        private final CountDownLatch myLatch = new CountDownLatch(1);
        private T myRemoteSdkCredentials;

        private MyRemoteCredentialsConsumer() {
        }

        public void consume(T data) {
            this.myRemoteSdkCredentials = data;
            this.myLatch.countDown();
        }

        public void await() throws InterruptedException {
            this.myLatch.await();
        }
    }
}

