/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsFacade;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J \u0010\u0019\u001a\u0004\u0018\u00010\u000e*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0005*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0016J\u001c\u0010 \u001a\u0004\u0018\u00010\u0005*\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0016J\u001c\u0010!\u001a\u0004\u0018\u00010\u0005*\u00020\u001d2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0016R \u0010\u0003\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u0004*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00020\u0007*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u00020\u000e*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\u00060\u0004*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListUtils;", "", "()V", "items", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItemImpl;", "Lkotlin/internal/NoInfer;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListImpl;", "getItems", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListImpl;)Ljava/util/List;", "list", "getList", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItemImpl;)Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListImpl;", "normalizedMarker", "", "getNormalizedMarker", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItemImpl;)Ljava/lang/String;", "sublists", "getSublists", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItemImpl;)Ljava/util/List;", "getLineIndentRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/openapi/editor/Document;", "lineNumber", "", "getLineIndentSpaces", "file", "Lcom/intellij/psi/PsiFile;", "getListItemAt", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "offset", "document", "getListItemAtLine", "getListItemAtLineSafely", "intellij.markdown"})
public final class ListUtils {
    @NotNull
    public static final ListUtils INSTANCE;

    @Nullable
    public final MarkdownListItemImpl getListItemAt(@NotNull MarkdownFile $this$getListItemAt, int offset, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getListItemAt, (String)"$this$getListItemAt");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return this.getListItemAtLine($this$getListItemAt, document.getLineNumber(offset), document);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MarkdownListItemImpl getListItemAtLine(@NotNull MarkdownFile $this$getListItemAtLine, int lineNumber, @NotNull Document document) {
        void $this$parentOfType$iv;
        PsiElement elementAtOffset;
        Intrinsics.checkNotNullParameter((Object)$this$getListItemAtLine, (String)"$this$getListItemAtLine");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        int searchingOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)lineStart, (int)(lineEnd - 1), (String)" \t\n");
        if (searchingOffset < lineStart) {
            return null;
        }
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)((PsiFile)$this$getListItemAtLine), (int)searchingOffset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"PsiUtilCore.getElementAt\u2026et(this, searchingOffset)");
        PsiElement psiElement2 = elementAtOffset = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownListItemImpl)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownListItemImpl.class, (boolean)false);
    }

    @Nullable
    public final MarkdownListItemImpl getListItemAtLineSafely(@NotNull MarkdownFile $this$getListItemAtLineSafely, int lineNumber, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getListItemAtLineSafely, (String)"$this$getListItemAtLineSafely");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int n = lineNumber;
        return 0 <= n && document.getLineCount() > n ? this.getListItemAtLine($this$getListItemAtLineSafely, lineNumber, document) : null;
    }

    @NotNull
    public final TextRange getLineIndentRange(@NotNull Document $this$getLineIndentRange, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineIndentRange, (String)"$this$getLineIndentRange");
        int lineStart = $this$getLineIndentRange.getLineStartOffset(lineNumber);
        int nonWsStart = CharArrayUtil.shiftForward((CharSequence)$this$getLineIndentRange.getCharsSequence(), (int)lineStart, (String)" \t");
        TextRange textRange = TextRange.create((int)lineStart, (int)nonWsStart);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.create(lineStart, nonWsStart)");
        return textRange;
    }

    @Nullable
    public final String getLineIndentSpaces(@NotNull Document $this$getLineIndentSpaces, int lineNumber, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineIndentSpaces, (String)"$this$getLineIndentSpaces");
        PsiFile psiFile = file;
        if (psiFile == null) {
            Document document = $this$getLineIndentSpaces;
            boolean bl = false;
            boolean bl2 = false;
            Document $this$run = document;
            boolean bl3 = false;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile($this$run);
            Project project = ProjectUtil.guessProjectForFile((VirtualFile)virtualFile);
            if (project == null) {
                return null;
            }
            Project project2 = project;
            PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile($this$run);
            if (psiFile2 == null) {
                return null;
            }
            psiFile = psiFile2;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"PsiDocumentManager.getIn\u2026File(this) ?: return null");
        }
        PsiFile psiFile3 = psiFile;
        CodeStyleSettingsFacade codeStyleSettingsFacade = CodeStyle.getFacade((PsiFile)psiFile3);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettingsFacade, (String)"CodeStyle.getFacade(psiFile)");
        int tabSize = codeStyleSettingsFacade.getTabSize();
        String string = $this$getLineIndentSpaces.getText(this.getLineIndentRange($this$getLineIndentSpaces, lineNumber));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(getLineIndentRange(lineNumber))");
        String indentStr = string;
        return StringsKt.replace$default((String)indentStr, (String)"\t", (String)StringsKt.repeat((CharSequence)" ", (int)tabSize), (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String getLineIndentSpaces$default(ListUtils listUtils, Document document, int n, PsiFile psiFile, int n2, Object object) {
        if ((n2 & 2) != 0) {
            psiFile = null;
        }
        return listUtils.getLineIndentSpaces(document, n, psiFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownListItemImpl> getItems(@NotNull MarkdownListImpl $this$items) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$items, (String)"$this$items");
        PsiElement[] psiElementArray = $this$items.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"children");
        PsiElement[] $this$filterIsInstance$iv = psiElementArray;
        boolean $i$f$filterIsInstance = false;
        PsiElement[] psiElementArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MarkdownListItemImpl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownListImpl> getSublists(@NotNull MarkdownListItemImpl $this$sublists) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sublists, (String)"$this$sublists");
        PsiElement[] psiElementArray = $this$sublists.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"children");
        PsiElement[] $this$filterIsInstance$iv = psiElementArray;
        boolean $i$f$filterIsInstance = false;
        PsiElement[] psiElementArray2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MarkdownListImpl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final MarkdownListImpl getList(@NotNull MarkdownListItemImpl $this$list) {
        Intrinsics.checkNotNullParameter((Object)$this$list, (String)"$this$list");
        PsiElement psiElement = $this$list.getParent();
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownListImpl");
        }
        return (MarkdownListImpl)psiElement;
    }

    @NotNull
    public final String getNormalizedMarker(@NotNull MarkdownListItemImpl $this$normalizedMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizedMarker, (String)"$this$normalizedMarker");
        PsiElement psiElement = $this$normalizedMarker.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"this.markerElement!!");
        String string = psiElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.markerElement!!.text");
        String string2 = string;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string2 = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        bl = false;
        boolean bl2 = false;
        String it = string2;
        boolean bl3 = false;
        return it + ' ';
    }

    private ListUtils() {
    }

    static {
        ListUtils listUtils;
        INSTANCE = listUtils = new ListUtils();
    }
}

