/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdba.jdbc.JdbcConnectionProvider;
import com.intellij.database.remote.jdba.jdbc.JdbcIntermediateFacade;
import com.intellij.database.remote.jdba.jdbc.dialects.MongoIntermediateFacade;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.database.remote.jdbc.helpers.JdbcHelper;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.helpers.JdbcSettings;
import com.intellij.database.remote.jdbc.helpers.NestedObjectWrapper;
import com.intellij.database.remote.jdbc.impl.JdbcRemoteObject;
import com.intellij.openapi.util.Comparing;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class MongoJdbcHelper
extends JdbcHelperImpl {
    public static final String DOUBLE_TYPE = "Double";
    public static final String STRING_TYPE = "String";
    public static final String OBJECT_TYPE = "Object";
    public static final String ARRAY_TYPE = "Array";
    public static final String BINARY_DATA_TYPE = "BinData";
    public static final String UUID_TYPE = "UUID";
    public static final String OBJECT_ID_TYPE = "ObjectId";
    public static final String BOOLEAN_TYPE = "Boolean";
    public static final String DATE_TYPE = "ISODate";
    public static final String NULL_TYPE = "null";
    public static final String REGEX_TYPE = "Regexp";
    public static final String DB_POINTER_TYPE = "DBPointer";
    public static final String SYMBOL_TYPE = "Symbol";
    public static final String INT_TYPE = "Int32";
    public static final String TIMESTAMP_TYPE = "Timestamp";
    public static final String LONG_TYPE = "Int64";
    public static final String DECIMAL_TYPE = "Decimal128";
    public static final String MIN_KEY_TYPE = "MinKey";
    public static final String MAX_KEY_TYPE = "MaxKey";
    public static final String UNKNOWN_TYPE = "unknown";
    public static final Map<String, Integer> TYPES_MAP = new HashMap<String, Integer>();

    public MongoJdbcHelper(@Nullable String version, @Nullable Connection connection) {
        super("MONGO", version, connection);
    }

    public MongoJdbcHelper() {
        this(null, null);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return MongoJdbcHelper.extractVersion(version);
    }

    @Override
    public boolean hasLazyConnection() {
        return true;
    }

    @Override
    public boolean supportsEscape() {
        return false;
    }

    @Override
    public char getEscapeChar() {
        return '\\';
    }

    @Override
    public JdbcSettings.SslMode[] supportedSslModes() {
        return new JdbcSettings.SslMode[]{JdbcSettings.SslMode.REQUIRE, JdbcSettings.SslMode.VERIFY_CA, JdbcSettings.SslMode.VERIFY_FULL};
    }

    @Override
    @NotNull
    protected String getCharsToEscape() {
        return "[]\\^$.|?*+(){}";
    }

    @Override
    @Nullable
    public final JdbcHelperImpl detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer) throws Exception {
        if (!JdbcNativeUtil.detectString(product, "Mongo DB")) {
            return null;
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product);
        return MongoJdbcHelper.create(delegate, productVer);
    }

    @Override
    public boolean detect(@NotNull Driver driver, @Nullable String url) {
        if (driver == null) {
            MongoJdbcHelper.$$$reportNull$$$0(0);
        }
        return MongoJdbcHelper.classNameContains(driver, "Mongo");
    }

    @NotNull
    private static JdbcHelperImpl create(@Nullable Connection delegate, @Nullable String productVer) throws Exception {
        String versionStr = delegate == null ? productVer : JdbcNativeUtil.getString(delegate, "db.version()");
        JdbcNativeUtil.logInfo("release_version: " + productVer);
        return new MongoJdbcHelper(MongoJdbcHelper.extractVersion(versionStr), delegate);
    }

    @Nullable
    public static String extractVersion(@Nullable String str) {
        return JdbcNativeUtil.findVersion(str, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    protected void enableSsl(@NotNull Driver driver, @NotNull Properties properties, @NotNull JdbcSettings.SslMode sslMode) {
        if (driver == null) {
            MongoJdbcHelper.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            MongoJdbcHelper.$$$reportNull$$$0(2);
        }
        if (sslMode == null) {
            MongoJdbcHelper.$$$reportNull$$$0(3);
        }
        properties.setProperty("ssl", "true");
        if (sslMode == JdbcSettings.SslMode.REQUIRE) {
            properties.setProperty("tlsAllowInvalidCertificates", "true");
        }
        if (sslMode != JdbcSettings.SslMode.VERIFY_FULL) {
            properties.setProperty("tlsAllowInvalidHostnames", "true");
        }
    }

    @Override
    protected Object createInfoIfNeeded(@NotNull JdbcRemoteObject exporter, @Nullable RemoteResultSet.DataRetrievingOptions options, Object o) throws Exception {
        String className;
        if (exporter == null) {
            MongoJdbcHelper.$$$reportNull$$$0(4);
        }
        if (o == null) {
            return null;
        }
        if (options != null && !options.raw && (className = o.getClass().getName()).equals(MongoBinaryValue.CLASS_NAME)) {
            return MongoBlobInfo.fromObject(o, options.maxLobLength);
        }
        return super.createInfoIfNeeded(exporter, options, o);
    }

    @Override
    public Object wrapIfNeeded(@NotNull JdbcRemoteObject exporter, Object o, @Nullable RemoteResultSet.DataRetrievingOptions options) throws RemoteException, SQLException {
        if (exporter == null) {
            MongoJdbcHelper.$$$reportNull$$$0(5);
        }
        if (o == null) {
            return null;
        }
        String className = o.getClass().getName();
        if (className.equals(MongoObjectIdValue.CLASS_NAME)) {
            return new MongoObjectIdValue(o.toString());
        }
        if (className.equals("org.bson.types.Decimal128")) {
            String num = o.toString();
            String lowerCase = num.toLowerCase(Locale.ENGLISH);
            return "nan".equals(lowerCase) ? (Number)Double.NaN : (Number)("infinity".equals(lowerCase) ? (Number)Double.POSITIVE_INFINITY : (Number)("-infinity".equals(lowerCase) ? Double.valueOf(Double.NEGATIVE_INFINITY) : new BigDecimal(num)));
        }
        if (className.equals(MongoMaxKeyValue.CLASS_NAME)) {
            return MongoMaxKeyValue.INSTANCE;
        }
        if (className.equals(MongoMinKeyValue.CLASS_NAME)) {
            return MongoMinKeyValue.INSTANCE;
        }
        if (className.equals(MongoTimestampValue.CLASS_NAME)) {
            return new MongoTimestampValue(o);
        }
        if (className.equals(MongoRegexpValue.CLASS_NAME)) {
            return new MongoRegexpValue(o);
        }
        if (className.equals(MongoBinaryValue.CLASS_NAME)) {
            return MongoBlobInfo.fromObject(o, -1);
        }
        return super.wrapIfNeeded(exporter, o, options);
    }

    @Override
    protected Map<?, ?> convertMap(@NotNull JdbcRemoteObject exporter, @NotNull Map<?, ?> map, @Nullable RemoteResultSet.DataRetrievingOptions options) {
        if (exporter == null) {
            MongoJdbcHelper.$$$reportNull$$$0(6);
        }
        if (map == null) {
            MongoJdbcHelper.$$$reportNull$$$0(7);
        }
        LinkedHashMap newMap = new LinkedHashMap();
        for (Map.Entry<?, ?> o1 : map.entrySet()) {
            try {
                newMap.put(o1.getKey(), this.createInfoIfNeeded(exporter, options, o1.getValue()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return newMap;
    }

    @Override
    protected void convertCollection(@NotNull JdbcRemoteObject exporter, @NotNull Collection<?> c, @NotNull Collection<Object> newC, @Nullable RemoteResultSet.DataRetrievingOptions options) {
        if (exporter == null) {
            MongoJdbcHelper.$$$reportNull$$$0(8);
        }
        if (c == null) {
            MongoJdbcHelper.$$$reportNull$$$0(9);
        }
        if (newC == null) {
            MongoJdbcHelper.$$$reportNull$$$0(10);
        }
        for (Object value : c) {
            try {
                newC.add(this.createInfoIfNeeded(exporter, options, value));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    public static String getTypeName(@Nullable Object o) {
        if (o instanceof MongoValue) {
            String string = ((MongoValue)o).typeName();
            if (string == null) {
                MongoJdbcHelper.$$$reportNull$$$0(11);
            }
            return string;
        }
        if (o instanceof Date) {
            return DATE_TYPE;
        }
        if (o instanceof String || o instanceof LobInfo.ClobInfo) {
            return STRING_TYPE;
        }
        if (o instanceof List) {
            return ARRAY_TYPE;
        }
        if (o instanceof Map) {
            return OBJECT_TYPE;
        }
        if (o instanceof BigDecimal || o instanceof Double && (Double.isNaN((Double)o) || (Double)o == Double.POSITIVE_INFINITY || (Double)o == Double.NEGATIVE_INFINITY)) {
            return DECIMAL_TYPE;
        }
        if (o instanceof Double) {
            return DOUBLE_TYPE;
        }
        if (o instanceof Integer) {
            return INT_TYPE;
        }
        if (o instanceof Long) {
            return LONG_TYPE;
        }
        if (o instanceof Boolean) {
            return BOOLEAN_TYPE;
        }
        if (o instanceof UUID) {
            return UUID_TYPE;
        }
        if (o instanceof MongoBlobInfo) {
            return BINARY_DATA_TYPE;
        }
        if (o instanceof NestedObjectWrapper) {
            return ((NestedObjectWrapper)o).value.startsWith("{") ? OBJECT_TYPE : ARRAY_TYPE;
        }
        if (o == null || o.getClass().getSimpleName().equals("ReservedCellValue")) {
            return NULL_TYPE;
        }
        return UNKNOWN_TYPE;
    }

    @Override
    @NotNull
    public JdbcIntermediateFacade createFacade(@NotNull JdbcConnectionProvider ds) {
        if (ds == null) {
            MongoJdbcHelper.$$$reportNull$$$0(12);
        }
        return new MongoIntermediateFacade(ds, this);
    }

    @Override
    public void adjustType(@NotNull JdbcHelper.Type e) {
        if (e == null) {
            MongoJdbcHelper.$$$reportNull$$$0(13);
        }
        e.length = -1;
        e.scale = 0;
        if (e.typeName == null) {
            return;
        }
        String tName = e.typeName.toLowerCase(Locale.ENGLISH);
        e.typeName = "integer".equals(tName) ? INT_TYPE : ("long".equals(tName) ? LONG_TYPE : ("array".equals(tName) ? ARRAY_TYPE : ("bsonregularexpression".equals(tName) ? REGEX_TYPE : ("binary".equals(tName) ? BINARY_DATA_TYPE : ("date".equals(tName) ? DATE_TYPE : ("map".equals(tName) ? OBJECT_TYPE : e.typeName))))));
    }

    static {
        TYPES_MAP.put(DOUBLE_TYPE, 8);
        TYPES_MAP.put(STRING_TYPE, 12);
        TYPES_MAP.put(OBJECT_TYPE, 1111);
        TYPES_MAP.put(ARRAY_TYPE, 2003);
        TYPES_MAP.put(OBJECT_ID_TYPE, 1111);
        TYPES_MAP.put(DECIMAL_TYPE, 3);
        TYPES_MAP.put(BOOLEAN_TYPE, 16);
        TYPES_MAP.put(DATE_TYPE, 93);
        TYPES_MAP.put(NULL_TYPE, 0);
        TYPES_MAP.put(INT_TYPE, 4);
        TYPES_MAP.put(LONG_TYPE, -5);
        TYPES_MAP.put(BINARY_DATA_TYPE, -2);
        TYPES_MAP.put(UUID_TYPE, 1111);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sslMode";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newC";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "detect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "enableSsl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createInfoIfNeeded";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrapIfNeeded";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "convertMap";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "convertCollection";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFacade";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MongoBlobInfo
    extends LobInfo.BlobInfo {
        private static Method myGetType;
        private static Method myGetData;
        public final byte type;

        public MongoBlobInfo(int length, byte[] data, byte type) {
            super(length, data);
            this.type = type;
        }

        public static Object fromData(byte[] data, byte type, int maxLobLength) {
            int subLength;
            int length = data.length;
            int n = subLength = maxLobLength == -1 ? length : Math.min(maxLobLength, length);
            return subLength == length ? new MongoBinaryValue(data, type) : new MongoBlobInfo(length, subLength <= 0 ? new byte[]{} : Arrays.copyOf(data, subLength), type);
        }

        static Object fromObject(@NotNull Object o, int maxLobLength) {
            if (o == null) {
                MongoBlobInfo.$$$reportNull$$$0(0);
            }
            String message = "Cannot read BinData value ";
            if (myGetType == null) {
                try {
                    Class<?> aClass = Class.forName(MongoBinaryValue.CLASS_NAME);
                    myGetType = aClass.getMethod("getType", new Class[0]);
                    myGetData = aClass.getMethod("getData", new Class[0]);
                }
                catch (ClassNotFoundException e) {
                    message = message + " " + e.getMessage();
                }
                catch (NoSuchMethodException e) {
                    message = message + " " + e.getMessage();
                }
            }
            if (myGetType != null && myGetData != null) {
                try {
                    Object dataObject = myGetData.invoke(o, new Object[0]);
                    if (!(dataObject instanceof byte[])) {
                        return "Cannot read BinData value. Data is " + (dataObject == null ? null : dataObject.getClass());
                    }
                    byte[] data = (byte[])dataObject;
                    Object typeObject = myGetType.invoke(o, new Object[0]);
                    if (!(typeObject instanceof Byte)) {
                        return "Cannot read BinData value. Type is " + (typeObject == null ? null : dataObject.getClass());
                    }
                    byte type = (Byte)typeObject;
                    return MongoBlobInfo.fromData(data, type, maxLobLength);
                }
                catch (IllegalAccessException e) {
                    message = message + " " + e.getMessage();
                }
                catch (InvocationTargetException e) {
                    message = message + " " + e.getMessage();
                }
            }
            return message;
        }

        @Override
        public int compareTo(LobInfo.BlobInfo o) {
            int superVal = super.compareTo(o);
            if (superVal != 0 || this.length == 0L || !(o instanceof MongoBlobInfo)) {
                return superVal;
            }
            return Comparing.compare((byte)this.type, (byte)((MongoBlobInfo)o).type);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MongoBlobInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MongoBlobInfo info = (MongoBlobInfo)o;
            if (!Arrays.equals(this.data, info.data)) {
                return false;
            }
            return this.type == info.type;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.type;
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoBlobInfo", "fromObject"));
        }
    }

    public static class MongoBinaryValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.types.Binary";
        public final byte[] data;
        public final byte type;

        public MongoBinaryValue(byte[] data, byte type) {
            this.data = data;
            this.type = type;
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.BINARY_DATA_TYPE;
        }

        @Override
        public String jsonTypeName() {
            return "binary";
        }

        @Override
        @Nullable
        public Object unwrap() {
            return this;
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoBinaryValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoBinaryValue", "className"));
        }
    }

    public static class MongoRegexpValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.BsonRegularExpression";
        private static Method myGetPattern;
        private static Method myGetOptions;
        public final String pattern;
        public final String options;
        private final Map<String, String> map;

        @TestOnly
        public MongoRegexpValue(String pattern, String options) {
            this.map = new HashMap<String, String>();
            this.pattern = pattern;
            this.options = options;
            this.map.put("pattern", this.pattern);
            this.map.put("options", this.options);
        }

        MongoRegexpValue(@NotNull Object o) {
            if (o == null) {
                MongoRegexpValue.$$$reportNull$$$0(0);
            }
            this.map = new HashMap<String, String>();
            if (myGetPattern == null) {
                try {
                    Class<?> aClass = Class.forName(CLASS_NAME);
                    myGetPattern = aClass.getMethod("getPattern", new Class[0]);
                    myGetOptions = aClass.getMethod("getOptions", new Class[0]);
                }
                catch (ClassNotFoundException aClass) {
                }
                catch (NoSuchMethodException aClass) {
                    // empty catch block
                }
            }
            String pattern = "";
            String options = "";
            if (myGetPattern != null && myGetOptions != null) {
                try {
                    Object optionsObject;
                    Object patternObject = myGetPattern.invoke(o, new Object[0]);
                    if (patternObject instanceof String) {
                        pattern = (String)patternObject;
                    }
                    if ((optionsObject = myGetOptions.invoke(o, new Object[0])) instanceof String) {
                        options = (String)optionsObject;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            this.pattern = pattern;
            this.options = options;
            this.map.put("pattern", this.pattern);
            this.map.put("options", this.options);
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.REGEX_TYPE;
        }

        @Override
        @Nullable
        public Object unwrap() {
            return this.map;
        }

        @Override
        public String jsonTypeName() {
            return "regularExpression";
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoRegexpValue.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return "{\"pattern\": \"" + this.pattern + "\", \"options\": \"" + this.options + "\"}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoRegexpValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoRegexpValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MongoTimestampValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.BsonTimestamp";
        private static Method myGetTime;
        private static Method myGetInc;
        public final int time;
        public final int inc;
        private final Map<String, Integer> map;

        public MongoTimestampValue(int inc, int time) {
            this.map = new HashMap<String, Integer>();
            this.time = time;
            this.inc = inc;
            this.map.put("t", this.time);
            this.map.put("i", this.inc);
        }

        MongoTimestampValue(@NotNull Object o) {
            if (o == null) {
                MongoTimestampValue.$$$reportNull$$$0(0);
            }
            this.map = new HashMap<String, Integer>();
            if (myGetTime == null) {
                try {
                    Class<?> aClass = Class.forName(CLASS_NAME);
                    myGetTime = aClass.getMethod("getTime", new Class[0]);
                    myGetInc = aClass.getMethod("getInc", new Class[0]);
                }
                catch (ClassNotFoundException aClass) {
                }
                catch (NoSuchMethodException aClass) {
                    // empty catch block
                }
            }
            int time = 0;
            int inc = 0;
            if (myGetTime != null && myGetInc != null) {
                try {
                    Object incObject;
                    Object timeObject = myGetTime.invoke(o, new Object[0]);
                    if (timeObject instanceof Integer) {
                        time = (Integer)timeObject;
                    }
                    if ((incObject = myGetInc.invoke(o, new Object[0])) instanceof Integer) {
                        inc = (Integer)incObject;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            this.time = time;
            this.inc = inc;
            this.map.put("t", this.time);
            this.map.put("i", this.inc);
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.TIMESTAMP_TYPE;
        }

        @Override
        @Nullable
        public Object unwrap() {
            return this.map;
        }

        @Override
        public String jsonTypeName() {
            return "timestamp";
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoTimestampValue.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return "{\"t\": " + this.time + ", \"inc\": " + this.inc + "}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoTimestampValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoTimestampValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class MongoMinKeyValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.types.MinKey";
        public static final MongoMinKeyValue INSTANCE = new MongoMinKeyValue();

        private MongoMinKeyValue() {
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.MIN_KEY_TYPE;
        }

        @Override
        @Nullable
        public Integer unwrap() {
            return 1;
        }

        @Override
        public String jsonTypeName() {
            return "minKey";
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoMinKeyValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return "minKey";
        }

        public boolean equals(Object obj) {
            return obj instanceof MongoMinKeyValue;
        }

        public int hashCode() {
            return MongoMinKeyValue.class.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoMinKeyValue", "className"));
        }
    }

    public static class MongoMaxKeyValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.types.MaxKey";
        public static final MongoMaxKeyValue INSTANCE = new MongoMaxKeyValue();

        private MongoMaxKeyValue() {
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.MAX_KEY_TYPE;
        }

        @Override
        @Nullable
        public Integer unwrap() {
            return 1;
        }

        @Override
        public String jsonTypeName() {
            return "maxKey";
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoMaxKeyValue.$$$reportNull$$$0(0);
            }
            return string;
        }

        public String toString() {
            return "maxKey";
        }

        public boolean equals(Object obj) {
            return obj instanceof MongoMaxKeyValue;
        }

        public int hashCode() {
            return MongoMaxKeyValue.class.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoMaxKeyValue", "className"));
        }
    }

    public static class MongoObjectIdValue
    implements MongoValue {
        static String CLASS_NAME = "org.bson.types.ObjectId";
        final String myValue;

        public MongoObjectIdValue(@NotNull String value) {
            if (value == null) {
                MongoObjectIdValue.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        public String typeName() {
            return MongoJdbcHelper.OBJECT_ID_TYPE;
        }

        @Override
        public String jsonTypeName() {
            return "oid";
        }

        @Override
        @NotNull
        public String unwrap() {
            String string = this.myValue;
            if (string == null) {
                MongoObjectIdValue.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String className() {
            String string = CLASS_NAME;
            if (string == null) {
                MongoObjectIdValue.$$$reportNull$$$0(2);
            }
            return string;
        }

        public String toString() {
            return this.myValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myValue.equals(((MongoObjectIdValue)o).myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoObjectIdValue";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/remote/jdbc/helpers/MongoJdbcHelper$MongoObjectIdValue";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "unwrap";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "className";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface MongoValue
    extends Serializable {
        public String typeName();

        public String jsonTypeName();

        @Nullable
        public Object unwrap();

        @NotNull
        public String className();
    }
}

