/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.core;

import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.core.RowLayout;
import com.intellij.database.remote.jdba.util.Classes;
import com.intellij.database.remote.jdba.util.NameAndClass;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.jetbrains.annotations.NotNull;

public abstract class Layouts {
    private static final ResultLayout<Boolean> EXISTENCE = new ResultLayout(ResultLayout.Kind.EXISTENCE, false, new RowLayout<Void>(RowLayout.Kind.EXISTENCE, Void.class, Void.class, new Class[0]));

    @NotNull
    public static <V> RowLayout<V> oneOf(@NotNull Class<V> valueClass) {
        if (valueClass == null) {
            Layouts.$$$reportNull$$$0(0);
        }
        return new RowLayout<V>(RowLayout.Kind.ONE_VALUE, valueClass, valueClass, valueClass);
    }

    @NotNull
    public static <V> RowLayout<V[]> arrayOf(int n, @NotNull Class<V> componentClass) {
        if (componentClass == null) {
            Layouts.$$$reportNull$$$0(1);
        }
        Object[] example = (Object[])Array.newInstance(componentClass, 0);
        Class<?> resultClass = example.getClass();
        Class[] componentClasses = new Class[n];
        for (int i = 0; i < n; ++i) {
            componentClasses[i] = componentClass;
        }
        return new RowLayout<V[]>(RowLayout.Kind.ARRAY, resultClass, componentClass, componentClasses);
    }

    @NotNull
    public static RowLayout<Object[]> arrayOf(Class ... componentClasses) {
        if (componentClasses == null) {
            Layouts.$$$reportNull$$$0(2);
        }
        return new RowLayout<Object[]>(RowLayout.Kind.ARRAY, Object[].class, Object.class, componentClasses);
    }

    @NotNull
    public static RowLayout<Object[]> rawArray() {
        return new RowLayout<Object[]>(RowLayout.Kind.ARRAY, Object[].class, Object.class, new Class[0]);
    }

    @NotNull
    public static RowLayout<int[]> arrayOfInts() {
        return new RowLayout<int[]>(RowLayout.Kind.ARRAY, int[].class, Integer.TYPE, new Class[0]);
    }

    @NotNull
    public static RowLayout<long[]> arrayOfLongs() {
        return new RowLayout<long[]>(RowLayout.Kind.ARRAY, long[].class, Long.TYPE, new Class[0]);
    }

    @NotNull
    public static <C> RowLayout<C> structOf(@NotNull Class<C> structClass) {
        if (structClass == null) {
            Layouts.$$$reportNull$$$0(3);
        }
        NameAndClass[] assignableFields = Classes.assignableFieldsOf(structClass);
        return new RowLayout<C>(RowLayout.Kind.STRUCT, structClass, Object.class, assignableFields);
    }

    public static ResultLayout<Boolean> existence() {
        return EXISTENCE;
    }

    public static <V> ResultLayout<V> singleOf(@NotNull Class<V> valueClass) {
        if (valueClass == null) {
            Layouts.$$$reportNull$$$0(4);
        }
        return new ResultLayout(ResultLayout.Kind.SINGLE_ROW, false, Layouts.oneOf(valueClass));
    }

    public static <R> ResultLayout<R> rowOf(@NotNull RowLayout<R> rowLayout) {
        if (rowLayout == null) {
            Layouts.$$$reportNull$$$0(5);
        }
        return new ResultLayout(ResultLayout.Kind.SINGLE_ROW, false, rowLayout);
    }

    public static <V> ResultLayout<V[]> columnOf(@NotNull Class<V> valueClass) {
        if (valueClass == null) {
            Layouts.$$$reportNull$$$0(6);
        }
        return new ResultLayout<V[]>(ResultLayout.Kind.ARRAY, false, Layouts.oneOf(valueClass));
    }

    public static ResultLayout<int[]> columnOfInts(int initialCapacity) {
        return new ResultLayout<int[]>(ResultLayout.Kind.ARRAY_OF_PRIMITIVES, false, Layouts.oneOf(Integer.TYPE), initialCapacity);
    }

    public static ResultLayout<long[]> columnOfLongs(int initialCapacity) {
        return new ResultLayout<long[]>(ResultLayout.Kind.ARRAY_OF_PRIMITIVES, false, Layouts.oneOf(Long.TYPE), initialCapacity);
    }

    public static <R> ResultLayout<R[]> arrayOf(@NotNull RowLayout<R> rowLayout) {
        if (rowLayout == null) {
            Layouts.$$$reportNull$$$0(7);
        }
        return new ResultLayout<R[]>(ResultLayout.Kind.ARRAY, false, rowLayout);
    }

    public static <R> ResultLayout<List<R>> listOf(@NotNull RowLayout<R> rowLayout) {
        if (rowLayout == null) {
            Layouts.$$$reportNull$$$0(8);
        }
        return new ResultLayout<List<R>>(ResultLayout.Kind.LIST, false, rowLayout);
    }

    public static <K, V> ResultLayout<Map<K, V>> hashMapOf(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        if (keyClass == null) {
            Layouts.$$$reportNull$$$0(9);
        }
        if (valueClass == null) {
            Layouts.$$$reportNull$$$0(10);
        }
        return new ResultLayout<Map<K, V>>(ResultLayout.Kind.MAP, false, Layouts.arrayOf(keyClass, valueClass));
    }

    public static <K extends Comparable<K>, V> ResultLayout<SortedMap<K, V>> sortedMapOf(@NotNull Class<K> keyClass, @NotNull Class<V> valueClass) {
        if (keyClass == null) {
            Layouts.$$$reportNull$$$0(11);
        }
        if (valueClass == null) {
            Layouts.$$$reportNull$$$0(12);
        }
        return new ResultLayout<SortedMap<K, V>>(ResultLayout.Kind.MAP, true, Layouts.arrayOf(keyClass, valueClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentClasses";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structClass";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowLayout";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/jdba/core/Layouts";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "oneOf";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "arrayOf";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "structOf";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "singleOf";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "rowOf";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "columnOf";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "listOf";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "hashMapOf";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "sortedMapOf";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

