/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.sass.actions.DeleteRulesetQuickFix;
import org.jetbrains.plugins.sass.actions.EscapeColonInPropertyRulesetQuickFix;
import org.jetbrains.plugins.sass.highlighting.SassScssHighlightingColors;
import org.jetbrains.plugins.scss.SCSSLanguage;
import org.jetbrains.plugins.scss.psi.SCSSInterpolationImpl;
import org.jetbrains.plugins.scss.psi.SassScssControlDirective;
import org.jetbrains.plugins.scss.psi.SassScssInclude;
import org.jetbrains.plugins.scss.psi.SassScssPropertyRuleset;
import org.jetbrains.plugins.scss.psi.SassScssRuleset;
import org.jetbrains.plugins.scss.psi.SassScssStatement;
import org.jetbrains.plugins.scss.psi.SassScssVariableImpl;
import org.jetbrains.plugins.scss.references.SassScssQualifierReference;

public class SassScssAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Language stylesheetLanguage;
        if (element == null) {
            SassScssAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SassScssAnnotator.$$$reportNull$$$0(1);
        }
        if ((stylesheetLanguage = CssPsiUtil.getStylesheetLanguage((PsiElement)element)) != SASSLanguage.INSTANCE && stylesheetLanguage != SCSSLanguage.INSTANCE) {
            return;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, SassScssPropertyRuleset.class, (boolean)true) != null) {
            if (element instanceof SassScssControlDirective || element instanceof SassScssInclude || element instanceof SassScssPropertyRuleset) {
                return;
            }
            if (element instanceof CssRuleset || element instanceof CssAtRule || element instanceof SassScssRuleset || element instanceof SassScssStatement) {
                holder.newAnnotation(HighlightSeverity.ERROR, SASSBundle.message("annotator.property.illegal.nesting.error", new Object[0])).create();
            }
            return;
        }
        if (element instanceof SassScssVariableImpl) {
            ASTNode parent;
            SCSSInterpolationImpl interpolation = (SCSSInterpolationImpl)PsiTreeUtil.getParentOfType((PsiElement)element, SCSSInterpolationImpl.class);
            if (interpolation != null && (parent = interpolation.getNode().getTreeParent()) != null && parent.getElementType() == CssElementTypes.CSS_EXPRESSION_PARAMETER) {
                String description;
                String string = description = ApplicationManager.getApplication().isUnitTestMode() ? SassScssHighlightingColors.VARIABLE.getExternalName() : null;
                if (description == null) {
                    holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(SassScssHighlightingColors.VARIABLE).create();
                } else {
                    holder.newAnnotation(HighlightSeverity.INFORMATION, description).textAttributes(SassScssHighlightingColors.VARIABLE).create();
                }
            }
            return;
        }
        if (element.getNode().getElementType() == CssElementTypes.CSS_IDENT) {
            for (PsiReference reference : element.getReferences()) {
                if (!(reference instanceof SassScssQualifierReference) || reference.resolve() != null) continue;
                String message = SASSBundle.message("no.module.with.namespace.0", reference.getCanonicalText());
                holder.newAnnotation(HighlightSeverity.ERROR, message).create();
            }
        }
        if (stylesheetLanguage == SCSSLanguage.INSTANCE) {
            SassScssAnnotator.applyScssSpecificHighlighting(element, holder);
        } else {
            SassScssAnnotator.applySassSpecificHighlighting(element, holder);
        }
    }

    private static void applyScssSpecificHighlighting(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            SassScssAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SassScssAnnotator.$$$reportNull$$$0(3);
        }
        if (element instanceof PsiComment) {
            CssInspectionsUtil.checkUnclosedComment((PsiComment)((PsiComment)element), (AnnotationHolder)holder);
        }
    }

    private static void applySassSpecificHighlighting(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        CssSelectorList selectorList;
        if (element == null) {
            SassScssAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            SassScssAnnotator.$$$reportNull$$$0(5);
        }
        if (element.getParent() instanceof CssRulesetList) {
            if (element instanceof SassScssPropertyRuleset) {
                CssDeclaration namespace = ((SassScssPropertyRuleset)element).getNamespaceDeclaration();
                if (namespace != null) {
                    AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, SASSBundle.message("annotator.property.top.level.properties.error", new Object[0])).range((PsiElement)namespace);
                    if (StringUtil.startsWithChar((CharSequence)element.getText(), (char)':')) {
                        builder = builder.withFix((IntentionAction)new EscapeColonInPropertyRulesetQuickFix((SassScssPropertyRuleset)element));
                    }
                    builder.create();
                }
            } else if (element instanceof CssDeclaration) {
                holder.newAnnotation(HighlightSeverity.ERROR, SASSBundle.message("annotator.property.top.level.properties.error", new Object[0])).create();
            }
        }
        if (element instanceof CssRuleset && ((CssRuleset)element).getBlock() == null && (selectorList = ((CssRuleset)element).getSelectorList()) != null) {
            holder.newAnnotation(HighlightSeverity.WARNING, SASSBundle.message("annotator.selector.doesnt.have.properties.warning", new Object[0])).range((PsiElement)selectorList).withFix((IntentionAction)new DeleteRulesetQuickFix((CssRuleset)element)).create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/scss/annotator/SassScssAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "applyScssSpecificHighlighting";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "applySassSpecificHighlighting";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

