/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.formatter;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.FactoryMap;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.formatter.YAMLCodeStyleSettings;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

class YAMLFormattingContext {
    private static final Indent DIRECT_NORMAL_INDENT = Indent.getNormalIndent((boolean)true);
    private static final Indent SAME_AS_PARENT_INDENT = Indent.getSpaceIndent((int)0, (boolean)true);
    private static final Indent SAME_AS_INDENTED_ANCESTOR_INDENT = Indent.getSpaceIndent((int)0);
    @NotNull
    public final CodeStyleSettings mySettings;
    @NotNull
    private final PsiFile myFile;
    @NotNull
    private final SpacingBuilder mySpaceBuilder;
    @NotNull
    private final Map<ASTNode, Alignment> myChildIndentAlignments;
    @NotNull
    private final Map<ASTNode, Alignment> myChildValueAlignments;
    private final boolean shouldIndentSequenceValue;
    private final boolean shouldInlineSequenceIntoSequence;
    private final boolean shouldInlineBlockMappingIntoSequence;
    private final int getValueAlignment;
    @Nullable
    private String myFullText;

    YAMLFormattingContext(@NotNull CodeStyleSettings settings, @NotNull PsiFile file) {
        if (settings == null) {
            YAMLFormattingContext.$$$reportNull$$$0(0);
        }
        if (file == null) {
            YAMLFormattingContext.$$$reportNull$$$0(1);
        }
        this.myChildIndentAlignments = FactoryMap.create(node -> Alignment.createAlignment((boolean)true));
        this.myChildValueAlignments = FactoryMap.create(node -> Alignment.createAlignment((boolean)true));
        this.myFullText = null;
        this.mySettings = settings;
        this.myFile = file;
        YAMLCodeStyleSettings custom = (YAMLCodeStyleSettings)this.mySettings.getCustomSettings(YAMLCodeStyleSettings.class);
        CommonCodeStyleSettings common = this.mySettings.getCommonSettings((Language)YAMLLanguage.INSTANCE);
        this.mySpaceBuilder = new SpacingBuilder(this.mySettings, (Language)YAMLLanguage.INSTANCE).between((IElementType)YAMLTokenTypes.COLON, (IElementType)YAMLElementTypes.KEY_VALUE_PAIR).lineBreakInCode().between((IElementType)YAMLTokenTypes.COLON, (IElementType)YAMLElementTypes.SEQUENCE_ITEM).lineBreakInCode().before((IElementType)YAMLTokenTypes.COLON).spaceIf(custom.SPACE_BEFORE_COLON).after((IElementType)YAMLTokenTypes.COLON).spaces(1).after((IElementType)YAMLTokenTypes.LBRACKET).spaceIf(common.SPACE_WITHIN_BRACKETS).before((IElementType)YAMLTokenTypes.RBRACKET).spaceIf(common.SPACE_WITHIN_BRACKETS).after((IElementType)YAMLTokenTypes.LBRACE).spaceIf(common.SPACE_WITHIN_BRACES).before((IElementType)YAMLTokenTypes.RBRACE).spaceIf(common.SPACE_WITHIN_BRACES);
        this.shouldIndentSequenceValue = custom.INDENT_SEQUENCE_VALUE;
        this.shouldInlineSequenceIntoSequence = !custom.SEQUENCE_ON_NEW_LINE;
        this.shouldInlineBlockMappingIntoSequence = !custom.BLOCK_MAPPING_ON_NEW_LINE;
        this.getValueAlignment = custom.ALIGN_VALUES_PROPERTIES;
    }

    @Nullable
    Spacing computeSpacing(@NotNull Block parent, @Nullable Block child1, @NotNull Block child2) {
        Spacing simpleSpacing;
        if (parent == null) {
            YAMLFormattingContext.$$$reportNull$$$0(2);
        }
        if (child2 == null) {
            YAMLFormattingContext.$$$reportNull$$$0(3);
        }
        if ((simpleSpacing = this.mySpaceBuilder.getSpacing(parent, child1, child2)) != null) {
            return simpleSpacing;
        }
        if (!(child1 instanceof ASTBlock) || !(child2 instanceof ASTBlock)) {
            return null;
        }
        ASTNode node1 = ((ASTBlock)child1).getNode();
        ASTNode node2 = ((ASTBlock)child2).getNode();
        if (PsiUtilCore.getElementType((ASTNode)node1) != YAMLTokenTypes.SEQUENCE_MARKER) {
            return null;
        }
        IElementType node2Type = PsiUtilCore.getElementType((ASTNode)node2);
        int indentSize = this.mySettings.getIndentSize((FileType)YAMLFileType.YML);
        if (indentSize < 2) {
            indentSize = 2;
        }
        int spaces = 1;
        int minLineFeeds = 0;
        if (node2Type == YAMLElementTypes.SEQUENCE_ITEM) {
            if (this.shouldInlineSequenceIntoSequence) {
                spaces = indentSize - 1;
            } else {
                minLineFeeds = 1;
            }
        } else if (node2Type == YAMLElementTypes.KEY_VALUE_PAIR) {
            if (this.shouldInlineBlockMappingIntoSequence) {
                spaces = indentSize - 1;
            } else {
                minLineFeeds = 1;
            }
        }
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)minLineFeeds, (boolean)false, (int)0);
    }

    @Nullable
    Alignment computeAlignment(@NotNull ASTNode node) {
        ASTNode prev;
        IElementType type;
        if (node == null) {
            YAMLFormattingContext.$$$reportNull$$$0(4);
        }
        if ((type = PsiUtilCore.getElementType((ASTNode)node)) == YAMLElementTypes.SEQUENCE_ITEM) {
            if (node.getTreeParent().getElementType() == YAMLElementTypes.ARRAY) {
                YAMLSequence sequence = (YAMLSequence)node.getTreeParent().getPsi();
                for (YAMLSequenceItem child : sequence.getItems()) {
                    if (!child.textContains('\n')) continue;
                    return null;
                }
            }
            return this.myChildIndentAlignments.get(node.getTreeParent());
        }
        if (type == YAMLElementTypes.KEY_VALUE_PAIR) {
            return this.myChildIndentAlignments.get(node.getTreeParent());
        }
        if (this.getValueAlignment == 2) {
            if (type == YAMLTokenTypes.COLON) {
                return this.myChildValueAlignments.get(node.getTreeParent().getTreeParent());
            }
        } else if (this.getValueAlignment == 1 && YAMLElementTypes.SCALAR_ITEMS.contains(type) && PsiUtilCore.getElementType((ASTNode)(prev = YAMLFormattingContext.getPreviousNonBlankNode(node.getTreeParent()))) == YAMLTokenTypes.COLON) {
            return this.myChildValueAlignments.get(prev.getTreeParent().getTreeParent());
        }
        return null;
    }

    @Nullable
    Indent computeBlockIndent(@NotNull ASTNode node) {
        boolean grandParentIsDocument;
        if (node == null) {
            YAMLFormattingContext.$$$reportNull$$$0(5);
        }
        IElementType nodeType = PsiUtilCore.getElementType((ASTNode)node);
        IElementType parentType = PsiUtilCore.getElementType((ASTNode)node.getTreeParent());
        IElementType grandParentType = parentType == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        boolean bl = grandParentIsDocument = grandParentType == YAMLElementTypes.DOCUMENT;
        assert (nodeType != YAMLElementTypes.SEQUENCE) : "Sequence should be inlined!";
        assert (nodeType != YAMLElementTypes.MAPPING) : "Mapping should be inlined!";
        assert (nodeType != YAMLElementTypes.DOCUMENT) : "Document should be inlined!";
        if (YAMLElementTypes.DOCUMENT_BRACKETS.contains(nodeType)) {
            return SAME_AS_PARENT_INDENT;
        }
        if (YAMLElementTypes.BRACKETS.contains(nodeType)) {
            return SAME_AS_INDENTED_ANCESTOR_INDENT;
        }
        if (nodeType == YAMLTokenTypes.TEXT) {
            return grandParentIsDocument ? SAME_AS_PARENT_INDENT : DIRECT_NORMAL_INDENT;
        }
        if (nodeType == YAMLElementTypes.FILE) {
            return SAME_AS_PARENT_INDENT;
        }
        if (YAMLElementTypes.SCALAR_VALUES.contains(nodeType)) {
            return DIRECT_NORMAL_INDENT;
        }
        if (nodeType == YAMLElementTypes.SEQUENCE_ITEM) {
            return this.computeSequenceItemIndent(node);
        }
        if (nodeType == YAMLElementTypes.KEY_VALUE_PAIR) {
            return YAMLFormattingContext.computeKeyValuePairIndent(node);
        }
        if (nodeType == YAMLTokenTypes.COMMENT) {
            if (parentType == YAMLElementTypes.SEQUENCE) {
                return this.computeSequenceItemIndent(node);
            }
            if (parentType == YAMLElementTypes.MAPPING) {
                return YAMLFormattingContext.computeKeyValuePairIndent(node);
            }
        }
        return YAMLElementTypes.TOP_LEVEL.contains(parentType) ? SAME_AS_PARENT_INDENT : null;
    }

    @Nullable
    Indent computeNewChildIndent(@NotNull ASTNode node) {
        if (node == null) {
            YAMLFormattingContext.$$$reportNull$$$0(6);
        }
        return YAMLElementTypes.TOP_LEVEL.contains(PsiUtilCore.getElementType((ASTNode)node)) ? SAME_AS_PARENT_INDENT : DIRECT_NORMAL_INDENT;
    }

    public boolean isIncomplete(@NotNull ASTNode node) {
        YAMLValue value2;
        if (node == null) {
            YAMLFormattingContext.$$$reportNull$$$0(7);
        }
        Predicate<YAMLValue> possiblyIncompleteValue = value -> value == null || YAMLElementTypes.INCOMPLETE_BLOCKS.contains(PsiUtilCore.getElementType((PsiElement)value));
        if (PsiUtilCore.getElementType((ASTNode)node) == YAMLElementTypes.KEY_VALUE_PAIR ? possiblyIncompleteValue.test(value2 = ((YAMLKeyValue)node.getPsi()).getValue()) : PsiUtilCore.getElementType((ASTNode)node) == YAMLElementTypes.SEQUENCE_ITEM && possiblyIncompleteValue.test(value = ((YAMLSequenceItem)node.getPsi()).getValue())) {
            return true;
        }
        return FormatterUtil.isIncomplete((ASTNode)node);
    }

    @NotNull
    public String getFullText() {
        if (this.myFullText == null) {
            this.myFullText = this.myFile.getText();
        }
        String string = this.myFullText;
        if (string == null) {
            YAMLFormattingContext.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private static Indent computeKeyValuePairIndent(@NotNull ASTNode node) {
        boolean grandParentIsDocument;
        IElementType parentType;
        if (node == null) {
            YAMLFormattingContext.$$$reportNull$$$0(9);
        }
        IElementType grandParentType = (parentType = PsiUtilCore.getElementType((ASTNode)node.getTreeParent())) == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        boolean bl = grandParentIsDocument = grandParentType == YAMLElementTypes.DOCUMENT;
        if (parentType == YAMLElementTypes.HASH) {
            return Indent.getNormalIndent();
        }
        if (grandParentIsDocument) {
            return SAME_AS_PARENT_INDENT;
        }
        if (parentType == YAMLElementTypes.SEQUENCE_ITEM) {
            return Indent.getNormalIndent();
        }
        return DIRECT_NORMAL_INDENT;
    }

    @NotNull
    private Indent computeSequenceItemIndent(@NotNull ASTNode node) {
        boolean grandParentIsDocument;
        IElementType parentType;
        if (node == null) {
            YAMLFormattingContext.$$$reportNull$$$0(10);
        }
        IElementType grandParentType = (parentType = PsiUtilCore.getElementType((ASTNode)node.getTreeParent())) == null ? null : PsiUtilCore.getElementType((ASTNode)node.getTreeParent().getTreeParent());
        boolean bl = grandParentIsDocument = grandParentType == YAMLElementTypes.DOCUMENT;
        if (parentType == YAMLElementTypes.ARRAY) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                YAMLFormattingContext.$$$reportNull$$$0(11);
            }
            return indent;
        }
        if (grandParentType == YAMLElementTypes.KEY_VALUE_PAIR) {
            if (this.shouldIndentSequenceValue) {
                Indent indent = DIRECT_NORMAL_INDENT;
                if (indent == null) {
                    YAMLFormattingContext.$$$reportNull$$$0(12);
                }
                return indent;
            }
            Indent indent = SAME_AS_PARENT_INDENT;
            if (indent == null) {
                YAMLFormattingContext.$$$reportNull$$$0(13);
            }
            return indent;
        }
        if (grandParentIsDocument) {
            Indent indent = SAME_AS_PARENT_INDENT;
            if (indent == null) {
                YAMLFormattingContext.$$$reportNull$$$0(14);
            }
            return indent;
        }
        Indent indent = DIRECT_NORMAL_INDENT;
        if (indent == null) {
            YAMLFormattingContext.$$$reportNull$$$0(15);
        }
        return indent;
    }

    @Nullable
    private static ASTNode getPreviousNonBlankNode(ASTNode node) {
        do {
            if (YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((ASTNode)(node = TreeUtil.prevLeaf((ASTNode)node))))) continue;
            return node;
        } while (node != null);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/formatter/YAMLFormattingContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/formatter/YAMLFormattingContext";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullText";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSequenceItemIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeSpacing";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeAlignment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeBlockIndent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "computeNewChildIndent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isIncomplete";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeKeyValuePairIndent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeSequenceItemIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

