/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint.codestyle.rules;

import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TsLintRule;
import com.intellij.lang.javascript.linter.tslint.codestyle.rules.TslintJsonOption;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001d\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J \u0010\u0017\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/IndentRule;", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TsLintRule;", "()V", "optionId", "", "getOptionId", "()Ljava/lang/String;", "apply", "", "languageSettings", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "codeStyleSettings", "Lcom/intellij/lang/javascript/formatter/JSCodeStyleSettings;", "option", "Lcom/intellij/lang/javascript/linter/tslint/codestyle/rules/TslintJsonOption;", "getIndentSize", "", "optionsList", "", "", "(Ljava/util/List;)Ljava/lang/Integer;", "getUseTabs", "", "isAvailable", "intellij.tslint"})
public final class IndentRule
implements TsLintRule {
    @NotNull
    private final String optionId;

    @Override
    @NotNull
    public String getOptionId() {
        return this.optionId;
    }

    @Override
    public boolean isAvailable(@NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings, @NotNull TslintJsonOption option) {
        Intrinsics.checkNotNullParameter((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        CommonCodeStyleSettings.IndentOptions indentOptions = languageSettings.getIndentOptions();
        if (indentOptions == null) {
            indentOptions = languageSettings.initIndentOptions();
        }
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"languageSettings.indentO\u2026tings.initIndentOptions()");
        CommonCodeStyleSettings.IndentOptions stored = indentOptions;
        List<Object> optionsList = option.getOptionsList();
        boolean configContainsTabs = this.getUseTabs(optionsList);
        Integer indentSize = this.getIndentSize(optionsList);
        return stored.USE_TAB_CHARACTER != configContainsTabs || !configContainsTabs && indentSize != null && (stored.CONTINUATION_INDENT_SIZE != indentSize || stored.INDENT_SIZE != indentSize);
    }

    @Override
    public void apply(@NotNull CommonCodeStyleSettings languageSettings, @NotNull JSCodeStyleSettings codeStyleSettings, @NotNull TslintJsonOption option) {
        Intrinsics.checkNotNullParameter((Object)languageSettings, (String)"languageSettings");
        Intrinsics.checkNotNullParameter((Object)codeStyleSettings, (String)"codeStyleSettings");
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        CommonCodeStyleSettings.IndentOptions indentOptions = languageSettings.getIndentOptions();
        if (indentOptions == null) {
            indentOptions = languageSettings.initIndentOptions();
        }
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"languageSettings.indentO\u2026tings.initIndentOptions()");
        CommonCodeStyleSettings.IndentOptions stored = indentOptions;
        List<Object> optionsList = option.getOptionsList();
        boolean configContainsTabs = this.getUseTabs(optionsList);
        Integer indentSize = this.getIndentSize(optionsList);
        stored.USE_TAB_CHARACTER = configContainsTabs;
        if (!configContainsTabs && indentSize != null) {
            stored.CONTINUATION_INDENT_SIZE = indentSize;
            stored.INDENT_SIZE = indentSize;
        }
    }

    private final boolean getUseTabs(List<? extends Object> optionsList) {
        return Intrinsics.areEqual((Object)"tabs", (Object)CollectionsKt.getOrNull(optionsList, (int)0));
    }

    private final Integer getIndentSize(List<? extends Object> optionsList) {
        Object object = CollectionsKt.getOrNull(optionsList, (int)1);
        if (!(object instanceof Number)) {
            object = null;
        }
        Number number = (Number)object;
        return number != null ? Integer.valueOf(number.intValue()) : null;
    }

    public IndentRule() {
        this.optionId = "indent";
    }
}

