/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.ui;

import com.intellij.diff.FrameDiffTool;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.actions.diff.SelectionAwareGoToChangePopupActionProvider;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.PresentableChange;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.NullableFunction;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.vcs.log.BaseSingleTaskControllerKt;
import git4idea.index.GitStageDiffUtilKt;
import git4idea.index.GitStageTracker;
import git4idea.index.GitStageTrackerListener;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.GitStageDiffPreview;
import git4idea.index.ui.GitStageTree;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0014J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lgit4idea/index/ui/GitStageDiffPreview;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lgit4idea/index/ui/GitStageTree;", "tracker", "Lgit4idea/index/GitStageTracker;", "isInEditor", "", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/index/ui/GitStageTree;Lgit4idea/index/GitStageTracker;ZLcom/intellij/openapi/Disposable;)V", "createGoToChangeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getAllChanges", "Ljava/util/stream/Stream;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "getSelectedChanges", "getToolbarWrapper", "Lcom/intellij/ui/components/panels/Wrapper;", "selectChange", "", "change", "shouldAddToolbarBottomBorder", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "wrap", "modelData", "Lcom/intellij/openapi/vcs/changes/ui/VcsTreeModelData;", "GitFileStatusNodeWrapper", "MyGoToChangePopupProvider", "intellij.vcs.git"})
public final class GitStageDiffPreview
extends ChangeViewDiffRequestProcessor {
    private final GitStageTree tree;

    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return false;
    }

    @NotNull
    public final Wrapper getToolbarWrapper() {
        Wrapper wrapper = this.myToolbarWrapper;
        Intrinsics.checkNotNullExpressionValue((Object)wrapper, (String)"myToolbarWrapper");
        return wrapper;
    }

    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        if (!(change instanceof GitFileStatusNodeWrapper) && !(change instanceof ChangeViewDiffRequestProcessor.ChangeWrapper)) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getRoot()), (Object)change.getUserObject());
        if (defaultMutableTreeNode == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"TreeUtil.findNodeWithObj\u2026nge.userObject) ?: return");
        DefaultMutableTreeNode node2 = defaultMutableTreeNode;
        TreeUtil.selectPath((JTree)((JTree)((Object)this.tree)), (TreePath)TreeUtil.getPathFromRoot((TreeNode)node2), (boolean)false);
    }

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
        Stream<ChangeViewDiffRequestProcessor.Wrapper> stream;
        if (this.tree.isSelectionEmpty()) {
            stream = this.getAllChanges();
        } else {
            VcsTreeModelData vcsTreeModelData = VcsTreeModelData.selected((JTree)((JTree)((Object)this.tree)));
            Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"VcsTreeModelData.selected(tree)");
            stream = this.wrap(vcsTreeModelData);
        }
        return stream;
    }

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.all((JTree)((JTree)((Object)this.tree)));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"VcsTreeModelData.all(tree)");
        return this.wrap(vcsTreeModelData);
    }

    @NotNull
    protected AnAction createGoToChangeAction() {
        return new MyGoToChangePopupProvider().createGoToChangeAction();
    }

    private final Stream<ChangeViewDiffRequestProcessor.Wrapper> wrap(VcsTreeModelData modelData) {
        Stream<ChangeViewDiffRequestProcessor.Wrapper> stream = Stream.concat(modelData.userObjectsStream(GitFileStatusNode.class).filter(wrap.1.INSTANCE).map(wrap.2.INSTANCE), modelData.userObjectsStream(Change.class).map(wrap.3.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(stream, (String)"Stream.concat(\n      mod\u2026ChangeWrapper(it) }\n    )");
        return stream;
    }

    public GitStageDiffPreview(@NotNull Project project, @NotNull GitStageTree tree, @NotNull GitStageTracker tracker, boolean isInEditor, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(project, "Stage");
        this.tree = tree;
        if (!isInEditor) {
            Wrapper wrapper = this.myContentPanel;
            Intrinsics.checkNotNullExpressionValue((Object)wrapper, (String)"myContentPanel");
            wrapper.setBorder(IdeBorderFactory.createBorder((int)2));
        }
        this.tree.addSelectionListener(new Runnable(){

            @Override
            public final void run() {
                final boolean modelUpdateInProgress = tree.isModelUpdateInProgress();
                BaseSingleTaskControllerKt.runInEdtAsync((Disposable)((Disposable)this), (Function0)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        GitStageDiffPreview gitStageDiffPreview = this;
                        JComponent jComponent = this.getComponent();
                        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component");
                        gitStageDiffPreview.updatePreview(jComponent.isShowing(), modelUpdateInProgress);
                    }
                }));
            }
        }, (Disposable)this);
        tracker.addListener(new GitStageTrackerListener(){

            @Override
            public void update() {
                JComponent jComponent = this.getComponent();
                Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component");
                this.updatePreview(jComponent.isShowing(), true);
            }
        }, (Disposable)this);
        Disposer.register((Disposable)parent, (Disposable)((Disposable)this));
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0016J\n\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lgit4idea/index/ui/GitStageDiffPreview$MyGoToChangePopupProvider;", "Lcom/intellij/openapi/vcs/changes/actions/diff/SelectionAwareGoToChangePopupActionProvider;", "(Lgit4idea/index/ui/GitStageDiffPreview;)V", "getChanges", "", "Lcom/intellij/openapi/vcs/changes/ui/PresentableChange;", "getSelectedChange", "select", "", "change", "intellij.vcs.git"})
    private final class MyGoToChangePopupProvider
    extends SelectionAwareGoToChangePopupActionProvider {
        @NotNull
        public List<PresentableChange> getChanges() {
            ListSelection listSelection = GitStageDiffPreview.this.tree.statusNodesListSelection(true).map(new NullableFunction(this){
                final /* synthetic */ MyGoToChangePopupProvider this$0;

                @Nullable
                public final ChangeDiffRequestChain.Producer fun(GitFileStatusNode it) {
                    Project project = this.this$0.GitStageDiffPreview.this.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    GitFileStatusNode gitFileStatusNode = it;
                    Intrinsics.checkNotNullExpressionValue((Object)gitFileStatusNode, (String)"it");
                    return GitStageDiffUtilKt.createTwoSidesDiffRequestProducer(project, gitFileStatusNode);
                }
                {
                    this.this$0 = myGoToChangePopupProvider;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"tree.statusNodesListSele\u2026stProducer(project, it) }");
            List list2 = listSelection.getList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"tree.statusNodesListSele\u2026ducer(project, it) }.list");
            return list2;
        }

        public void select(@NotNull PresentableChange change) {
            Intrinsics.checkNotNullParameter((Object)change, (String)"change");
            GitStageDiffPreview.this.selectFilePath(change.getFilePath());
        }

        @Nullable
        public PresentableChange getSelectedChange() {
            return (PresentableChange)GitStageDiffPreview.this.getCurrentChange();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lgit4idea/index/ui/GitStageDiffPreview$GitFileStatusNodeWrapper;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "node", "Lgit4idea/index/ui/GitFileStatusNode;", "(Lgit4idea/index/ui/GitFileStatusNode;)V", "getNode", "()Lgit4idea/index/ui/GitFileStatusNode;", "createProducer", "Lcom/intellij/diff/chains/DiffRequestProducer;", "project", "Lcom/intellij/openapi/project/Project;", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "getFileStatus", "Lcom/intellij/openapi/vcs/FileStatus;", "getPresentableName", "", "getUserObject", "", "intellij.vcs.git"})
    private static final class GitFileStatusNodeWrapper
    extends ChangeViewDiffRequestProcessor.Wrapper {
        @NotNull
        private final GitFileStatusNode node;

        @NotNull
        public String getPresentableName() {
            String string = this.node.getFilePath().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.filePath.name");
            return string;
        }

        @NotNull
        public Object getUserObject() {
            return this.node;
        }

        @NotNull
        public FilePath getFilePath() {
            return this.node.getFilePath();
        }

        @NotNull
        public FileStatus getFileStatus() {
            return this.node.getFileStatus();
        }

        @Nullable
        public DiffRequestProducer createProducer(@Nullable Project project) {
            Project project2 = project;
            Intrinsics.checkNotNull((Object)project2);
            return (DiffRequestProducer)GitStageDiffUtilKt.createTwoSidesDiffRequestProducer(project2, this.node);
        }

        @NotNull
        public final GitFileStatusNode getNode() {
            return this.node;
        }

        public GitFileStatusNodeWrapper(@NotNull GitFileStatusNode node2) {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            this.node = node2;
        }
    }
}

