/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.actions.DvcsCompareWithBranchAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBranch;
import git4idea.GitContentRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.history.GitHistoryUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GitCompareWithBranchAction
extends DvcsCompareWithBranchAction<GitRepository> {
    protected boolean noBranchesToCompare(@NotNull GitRepository repository) {
        boolean haveRemotes;
        if (repository == null) {
            GitCompareWithBranchAction.$$$reportNull$$$0(0);
        }
        int locals = repository.getBranches().getLocalBranches().size();
        boolean bl = haveRemotes = !repository.getBranches().getRemoteBranches().isEmpty();
        if (repository.isOnBranch()) {
            return locals < 2 && !haveRemotes;
        }
        return locals == 0 && !haveRemotes;
    }

    @NotNull
    protected List<String> getBranchNamesExceptCurrent(@NotNull GitRepository repository) {
        if (repository == null) {
            GitCompareWithBranchAction.$$$reportNull$$$0(1);
        }
        ArrayList<GitLocalBranch> localBranches = new ArrayList<GitLocalBranch>(repository.getBranches().getLocalBranches());
        Collections.sort(localBranches);
        ArrayList<GitRemoteBranch> remoteBranches = new ArrayList<GitRemoteBranch>(repository.getBranches().getRemoteBranches());
        Collections.sort(remoteBranches);
        if (repository.isOnBranch()) {
            localBranches.remove(repository.getCurrentBranch());
        }
        ArrayList<String> branchNames = new ArrayList<String>();
        for (GitBranch gitBranch : localBranches) {
            branchNames.add(gitBranch.getName());
        }
        for (GitBranch gitBranch : remoteBranches) {
            branchNames.add(gitBranch.getName());
        }
        ArrayList<String> arrayList = branchNames;
        if (arrayList == null) {
            GitCompareWithBranchAction.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    protected GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            GitCompareWithBranchAction.$$$reportNull$$$0(3);
        }
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        if (gitRepositoryManager == null) {
            GitCompareWithBranchAction.$$$reportNull$$$0(4);
        }
        return gitRepositoryManager;
    }

    @NotNull
    protected Collection<Change> getDiffChanges(@NotNull Project project, @NotNull VirtualFile file, @NotNull String branchName) throws VcsException {
        if (project == null) {
            GitCompareWithBranchAction.$$$reportNull$$$0(5);
        }
        if (file == null) {
            GitCompareWithBranchAction.$$$reportNull$$$0(6);
        }
        if (branchName == null) {
            GitCompareWithBranchAction.$$$reportNull$$$0(7);
        }
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        GitRepository gitRepository = GitUtil.getRepositoryForFile(project, file);
        GitBranch branch = gitRepository.getBranches().findBranchByName(branchName);
        String branchToCompare = branch != null ? branch.getFullName() : branchName;
        VirtualFile gitRepositoryRoot = gitRepository.getRoot();
        GitRevisionNumber compareRevisionNumber = new GitRevisionNumber(branchToCompare);
        List changes = GitChangeUtils.getDiffWithWorkingDir(project, gitRepositoryRoot, branchToCompare, Collections.singletonList(filePath), false);
        if (changes.isEmpty() && GitHistoryUtils.getCurrentRevision(project, filePath, branchToCompare) == null) {
            throw new VcsException(GitCompareWithBranchAction.fileDoesntExistInBranchError((VirtualFile)file, (String)branchToCompare));
        }
        List list2 = changes.isEmpty() && !filePath.isDirectory() ? VcsDiffUtil.createChangesWithCurrentContentForFile((FilePath)filePath, (ContentRevision)GitContentRevision.createRevision(filePath, (VcsRevisionNumber)compareRevisionNumber, project)) : changes;
        if (list2 == null) {
            GitCompareWithBranchAction.$$$reportNull$$$0(8);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/actions/GitCompareWithBranchAction";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/actions/GitCompareWithBranchAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNamesExceptCurrent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepositoryManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDiffChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "noBranchesToCompare";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNamesExceptCurrent";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDiffChanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

