/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.EscapeUtil;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.CidrProjectModelBundle;
import com.jetbrains.cidr.lang.workspace.compiler.ClangFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerInfo;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.toolchains.OSType;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GCCCompiler
extends OCCompilerBase {
    @NonNls
    private static final String COMMAND_PREFIX = "____CIDR_command_";
    private static final Pattern COMMAND_PATTERN = Pattern.compile("^____CIDR_command_(\\w+)->([^=]+)=(.+)$");
    @NonNls
    public static final String QUOTES = "[\u2018\u2019`'\"]";
    private static final Pattern[] BAD_SWITCH_FILTER_RULES = new Pattern[]{Pattern.compile(".*error:.*?(-+\\S+) is not supported.*"), Pattern.compile(".*error:.*?[\u2018\u2019`'\"](-.+?)[\u2018\u2019`'\"].*"), Pattern.compile(".*error:\\s(.+):\\sNo such file or directory"), Pattern.compile(".*error: [\u2018\u2019`'\"](.+?)[\u2018\u2019`'\"].* not found"), Pattern.compile(".*\\berror\\s+parsing.*(-fpch-preprocess)\\b.*", 2), Pattern.compile(".*clang-cl: error: no such file or directory: [\u2018\u2019`'\"](.+?)[\u2018\u2019`'\"].*")};
    private static final Pattern INCLUDE_FILE_PATTERN = Pattern.compile("# 1 \"(.*)\" 1\\s*[\\r\\n]");
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile(".*:(?:\\s|(?:\\\\[\\r\\n]))+((?:[\\S&&[^\\\\]]+(?:\\\\[ ]?)*)*)");
    private static final String STANDARD_CPP = "STANDARD_CPP";
    private static final String STANDARD_C = "STANDARD_C";
    @NonNls
    static final String CIDR_DEFINITIONS_END = "___CIDR_DEFINITIONS_END";
    @NonNls
    static final String CIDR_FEATURES_START = "___CIDR_FEATURES_START";
    @NotNull
    @NonNls
    private static final String FSYCL = "-fsycl";
    @NotNull
    @NonNls
    private static final String FSYCL_DEVICE_ONLY = "-fsycl-device-only";
    private static final Map<String, OCCompilerFeatures.Feature> featureFlags = new LinkedHashMap<String, OCCompilerFeatures.Feature>();
    private static final Set<String> skipSwitches;
    private static final Set<String> skipEnvironment;
    private static final List<String> CLANG_TEST_MACROS;
    private static final List<String> GCC_BUILT_IN_FUNCTION_MACROS;

    public GCCCompiler(@NotNull File executable, @NotNull File workingDirectory, @NotNull CidrToolEnvironment env, @NotNull TempFilesPool tempFilesPool) {
        if (executable == null) {
            GCCCompiler.$$$reportNull$$$0(0);
        }
        if (workingDirectory == null) {
            GCCCompiler.$$$reportNull$$$0(1);
        }
        if (env == null) {
            GCCCompiler.$$$reportNull$$$0(2);
        }
        if (tempFilesPool == null) {
            GCCCompiler.$$$reportNull$$$0(3);
        }
        super(executable, workingDirectory, env, tempFilesPool);
    }

    @Nullable
    public String readVersion(@NotNull Pattern versionPattern) {
        if (versionPattern == null) {
            GCCCompiler.$$$reportNull$$$0(4);
        }
        return this.doReadVersion(Collections.singletonList("--version"), (Function<ProcessOutput, String>)((Function)output -> {
            List lines = output.getStdoutLines();
            for (String line : lines) {
                Matcher matcher;
                if (StringUtil.isEmptyOrSpaces((String)line) || !(matcher = versionPattern.matcher(line)).matches()) continue;
                return line;
            }
            return null;
        }));
    }

    @NotNull
    public static String getLanguageOption(@NotNull OCLanguageKind kind) {
        if (kind == null) {
            GCCCompiler.$$$reportNull$$$0(5);
        }
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    return "-xc";
                }
                case OBJ_C: {
                    return "-xobjective-c";
                }
                case CPP: {
                    return "-xc++";
                }
                case OBJ_CPP: {
                    return "-xobjective-c++";
                }
            }
        }
        return "";
    }

    @Nullable
    public static OCLanguageKind resolveLanguage(@NotNull List<String> switches) {
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(6);
        }
        for (int i = 0; i < switches.size(); ++i) {
            String currentSwitch = switches.get(i);
            if (!currentSwitch.startsWith("-x")) continue;
            OCLanguageKind kind = GCCCompiler.resolveOptionLanguage(currentSwitch = currentSwitch.substring(2));
            if (kind != null) {
                return kind;
            }
            if (StringUtil.isEmptyOrSpaces((String)currentSwitch) && i < switches.size() - 1) {
                kind = GCCCompiler.resolveOptionLanguage(switches.get(i + 1));
            }
            return kind;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind resolveOptionLanguage(@NotNull String option) {
        String langName;
        if (option == null) {
            GCCCompiler.$$$reportNull$$$0(7);
        }
        if ("objective-c".equals(langName = option.trim())) {
            return CLanguageKind.OBJ_C;
        }
        if ("objective-c++".equals(langName)) {
            return CLanguageKind.OBJ_CPP;
        }
        if ("c".equals(langName)) {
            return CLanguageKind.C;
        }
        if ("c++".equals(langName)) {
            return CLanguageKind.CPP;
        }
        if ("cu".equals(langName)) {
            return CUDALanguageKind.CUDA;
        }
        if ("cuda".equals(langName)) {
            return CUDALanguageKind.CUDA;
        }
        return null;
    }

    @NotNull
    protected CompilerSpecificSwitchBuilder getSwitchBuilder() {
        return new GCCSwitchBuilder();
    }

    @NotNull
    private static List<String> extractNonBuiltinSearchPaths(@NotNull @NotNull List<@NotNull String> rawSwitches, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory) {
        if (rawSwitches == null) {
            GCCCompiler.$$$reportNull$$$0(8);
        }
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(9);
        }
        if (workingDirectory == null) {
            GCCCompiler.$$$reportNull$$$0(10);
        }
        ArrayList<String> searchPaths = new ArrayList<String>();
        boolean includeIsNext = false;
        for (String element : rawSwitches) {
            if (includeIsNext) {
                element = environment.getHostMachine().toCanonicalPath(environment.toLocalPath(workingDirectory, element), true);
                searchPaths.add(element);
                includeIsNext = false;
                continue;
            }
            if (element.equals("-I")) {
                includeIsNext = true;
                continue;
            }
            if (!element.startsWith("-I")) continue;
            element = environment.getHostMachine().toCanonicalPath(environment.toLocalPath(workingDirectory, element.substring(2)), true);
            searchPaths.add(element);
        }
        ArrayList<String> arrayList = searchPaths;
        if (arrayList == null) {
            GCCCompiler.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public CompilerInfo collectInfo(@NotNull OCLanguageKind languageKind, @NotNull CidrCompilerSwitches switches) throws ExecutionException {
        if (languageKind == null) {
            GCCCompiler.$$$reportNull$$$0(12);
        }
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(13);
        }
        ArrayList<String> warnLog = new ArrayList<String>();
        try {
            switches = switches.expandResponseFiles(this.myWorkingDirectory, this.myEnvironment, CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
        }
        catch (IOException e) {
            throw new ExecutionException(CidrProjectModelBundle.message("cannot.expand.response.files.error.message", switches.getCommandLineString(CidrCompilerSwitches.Format.RAW)), (Throwable)e);
        }
        List<String> nonBuiltinSearchPaths = GCCCompiler.extractNonBuiltinSearchPaths(switches.getList(CidrCompilerSwitches.Format.RAW), this.myEnvironment, this.myWorkingDirectory);
        CompilerSpecificSwitchBuilder switchBuilder = this.getSwitchBuilder().withLanguageKind(languageKind).withSwitches(switches);
        if (Registry.is((String)"cidr.compiler.gcc.fpch.preprocess", (boolean)true)) {
            switchBuilder.withWritePchPreprocess();
        }
        switchBuilder.withSwitch("-v").withWritePreprocessorDefines().withSwitch("-E").withMacro(CIDR_DEFINITIONS_END);
        CidrCompilerSwitches requestSwitches = switchBuilder.build();
        ProcessOutput output = this.runGCC(this.myEnvironment, requestSwitches, GCCCompiler.buildFeaturesCheckText(), warnLog);
        OutputSections sections = GCCCompiler.splitOutput(output.getStdout(), warnLog);
        Pair<List<String>, Map<OCCompilerFeatures.Type<?>, Object>> definesAndFeatures = GCCCompiler.collectDefinitionsAndFeatures(sections, warnLog);
        List defines = (List)definesAndFeatures.first;
        Map features = (Map)definesAndFeatures.second;
        boolean isClang = GCCCompiler.isClang(defines);
        GCCCompiler.collectDiagnostics(switches, isClang, features);
        GCCCompiler.collectFeatureFlags(switches, features);
        boolean shouldEnableFrameworksWorkaround = this.myEnvironment.getHostMachine().getOSType() == OSType.MAC && !isClang;
        List<HeadersSearchPath> headersSearchPaths = GCCCompiler.collectHeaderSearchPaths(output, shouldEnableFrameworksWorkaround, this.myEnvironment, this.myWorkingDirectory, true, nonBuiltinSearchPaths);
        List<File> forcedHeaders = this.getForcedHeaders(switches, this.myEnvironment, sections.preprocessed, warnLog);
        GCCCompiler.addEmulatedWarning(warnLog);
        return new CompilerInfo(switches, defines, features, headersSearchPaths, forcedHeaders, Collections.emptyList(), warnLog, output.getExitCode());
    }

    @NotNull
    static OutputSections splitOutput(String output, List<String> warnLog) {
        String defines;
        String preprocessed = "";
        String featureChecks = "";
        int definesEnd = output.indexOf(CIDR_DEFINITIONS_END);
        int featuresStart = output.indexOf(CIDR_FEATURES_START);
        Function lineStart = index -> {
            while (index > 0 && !StringUtil.isLineBreak((char)output.charAt(index - 1))) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index - 1);
            }
            return index;
        };
        if (definesEnd >= 0 && featuresStart >= 0) {
            defines = output.substring(0, (Integer)lineStart.fun((Object)definesEnd));
            preprocessed = output.substring(definesEnd + CIDR_DEFINITIONS_END.length() + 1, (Integer)lineStart.fun((Object)featuresStart));
            featureChecks = output.substring(featuresStart + CIDR_FEATURES_START.length() + 1);
        } else {
            warnLog.add(CidrProjectModelBundle.message("unexpected.compiler.output.error.message", new Object[0]) + CidrProjectModelBundle.message("possibly.unsupported.compiler.error.message", new Object[0]));
            LOG.warn("Unexpected compiler output: CIDR_DEFINITIONS_END=" + definesEnd + " CIDR_FEATURES_START=" + featuresStart);
            defines = output;
        }
        return new OutputSections(Arrays.asList(StringUtil.splitByLines((String)defines)), preprocessed, featureChecks);
    }

    private static boolean isClang(@NotNull List<String> defines) {
        if (defines == null) {
            GCCCompiler.$$$reportNull$$$0(14);
        }
        return ContainerUtil.find(defines, define -> StringUtil.contains((CharSequence)define, (CharSequence)"__clang_version__")) != null;
    }

    @NotNull
    private List<File> getForcedHeaders(@NotNull CidrCompilerSwitches switches, @NotNull CidrToolEnvironment environment, @NotNull String preprocessed, @NotNull List<String> warnLog) {
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(15);
        }
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(16);
        }
        if (preprocessed == null) {
            GCCCompiler.$$$reportNull$$$0(17);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(18);
        }
        LinkedHashSet<File> result = new LinkedHashSet<File>(1);
        List<String> args = switches.getList(CidrCompilerSwitches.Format.RAW);
        boolean isFirst = true;
        for (int i = 0; i < args.size(); ++i) {
            String pathPCH;
            String arg = this.adjustArgument(args.get(i));
            if (!arg.startsWith("-include") && !arg.startsWith("--include")) continue;
            if (arg.equals("-include") || arg.equals("--include")) {
                if (++i >= args.size()) break;
                pathPCH = this.preparePath(environment, this.adjustArgument(args.get(i)));
            } else if (arg.startsWith("--include")) {
                if (!arg.startsWith("--include=")) continue;
                pathPCH = this.preparePath(environment, this.adjustArgument(arg.substring("--include=".length())));
            } else {
                pathPCH = this.preparePath(environment, this.adjustArgument(arg.substring("-include".length())));
            }
            File pch = new File(pathPCH);
            if (!pch.exists() || pch.isDirectory()) {
                File file = pch = isFirst ? this.extractOriginalPrecompiledHeaderFile(preprocessed, environment, pch, warnLog) : null;
            }
            if (pch != null) {
                result.add(pch);
            }
            isFirst = false;
        }
        return new SmartList(result);
    }

    @Nullable
    private File extractOriginalPrecompiledHeaderFile(@NonNls @NotNull String preprocessed, @NotNull CidrToolEnvironment env, @NotNull File pch, @NotNull List<String> warnLog) {
        Matcher matcher;
        boolean isGCC;
        if (preprocessed == null) {
            GCCCompiler.$$$reportNull$$$0(19);
        }
        if (env == null) {
            GCCCompiler.$$$reportNull$$$0(20);
        }
        if (pch == null) {
            GCCCompiler.$$$reportNull$$$0(21);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(22);
        }
        if (!(isGCC = preprocessed.contains("#pragma GCC pch_preprocess")) && (matcher = GCCCompiler.matchSafely(INCLUDE_FILE_PATTERN, preprocessed)).find()) {
            String unescaped = EscapeUtil.unescapeAnsiStringCharacters((String)matcher.group(1));
            String path = this.preparePath(env, unescaped);
            return new File(path);
        }
        File dependencyFile = null;
        if (!pch.isDirectory()) {
            dependencyFile = new File(pch.getAbsolutePath() + ".d");
        } else {
            File[] files = pch.listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.getName().endsWith(".d")) continue;
                    dependencyFile = file;
                    break;
                }
            }
        }
        if (dependencyFile != null && dependencyFile.exists()) {
            try {
                String data = FileUtil.loadFile((File)dependencyFile);
                Matcher dependency = GCCCompiler.matchSafely(DEPENDENCY_PATTERN, data);
                if (dependency.find()) {
                    String path = dependency.group(1).replaceAll("\\\\[ ]", " ");
                    File result = new File(this.preparePath(env, path));
                    return result.exists() ? result : null;
                }
            }
            catch (IOException e) {
                String warn = CidrProjectModelBundle.message("dependency.file.corrupted.error.message", dependencyFile);
                warnLog.add(warn);
                return null;
            }
        }
        if (isGCC) {
            String warn = CidrProjectModelBundle.message("cannot.get.the.original.file.name.of.the.precompiled.header", pch);
            warnLog.add(warn);
        }
        return null;
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(@NotNull ProcessOutput output, boolean enableFrameworksWorkaround, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory) {
        if (output == null) {
            GCCCompiler.$$$reportNull$$$0(23);
        }
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(24);
        }
        if (workingDirectory == null) {
            GCCCompiler.$$$reportNull$$$0(25);
        }
        return GCCCompiler.collectHeaderSearchPaths(output, enableFrameworksWorkaround, environment, workingDirectory, false, Collections.emptyList());
    }

    static List<HeadersSearchPath> collectHeaderSearchPaths(@NotNull ProcessOutput output, boolean enableFrameworksWorkaround, @NotNull CidrToolEnvironment environment, @NotNull File workingDirectory, boolean hasBuiltInSearchPaths, @NotNull @NotNull List<@NotNull String> nonBuiltinSearchPaths) {
        if (output == null) {
            GCCCompiler.$$$reportNull$$$0(26);
        }
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(27);
        }
        if (workingDirectory == null) {
            GCCCompiler.$$$reportNull$$$0(28);
        }
        if (nonBuiltinSearchPaths == null) {
            GCCCompiler.$$$reportNull$$$0(29);
        }
        ArrayList<HeadersSearchPath> headersSearchPaths = new ArrayList<HeadersSearchPath>();
        ArrayList<HeadersSearchPath> additionalFrameworks = enableFrameworksWorkaround ? new ArrayList<HeadersSearchPath>() : null;
        HeadersSearchPath.Kind kind = null;
        for (String each : output.getStderrLines()) {
            String file;
            if ("#include \"...\" search starts here:".equals(each = each.trim())) {
                kind = HeadersSearchPath.Kind.USER;
                continue;
            }
            if ("#include <...> search starts here:".equals(each)) {
                kind = HeadersSearchPath.Kind.SYSTEM;
                continue;
            }
            if ("End of search list.".equals(each)) break;
            if (kind == null) continue;
            String trimmed = StringUtil.trimEnd((String)each, (String)" (framework directory)");
            boolean isFramework = false;
            if (!each.equals(trimmed)) {
                each = trimmed;
                isFramework = true;
                enableFrameworksWorkaround = false;
            } else {
                each = StringUtil.trimEnd((String)each, (String)" (headermap)");
            }
            if ((file = environment.toLocalPath(workingDirectory, each = StringUtil.nullize((String)each.trim(), (boolean)true))) == null) continue;
            String canonicalPath = environment.getHostMachine().toCanonicalPath(file, true);
            try {
                canonicalPath = FileUtil.resolveShortWindowsName((String)canonicalPath);
            }
            catch (IOException ignored) {
                continue;
            }
            boolean isBuiltIn = hasBuiltInSearchPaths && kind.isSystem() && !isFramework && !nonBuiltinSearchPaths.contains(canonicalPath);
            headersSearchPaths.add(new HeadersSearchPath(canonicalPath, false, kind, isFramework, isBuiltIn));
            if (!enableFrameworksWorkaround) continue;
            additionalFrameworks.add(new HeadersSearchPath(canonicalPath, false, kind, true));
        }
        if (enableFrameworksWorkaround && additionalFrameworks != null) {
            headersSearchPaths.addAll(additionalFrameworks);
        }
        return headersSearchPaths;
    }

    @NotNull
    static Pair<List<String>, Map<OCCompilerFeatures.Type<?>, Object>> collectDefinitionsAndFeatures(@NotNull OutputSections output, List<String> warnLog) {
        if (output == null) {
            GCCCompiler.$$$reportNull$$$0(30);
        }
        LinkedHashMap<Object, Object> cidrFeatures = new LinkedHashMap<Object, Object>();
        List<String> defines = output.defines.stream().map(line -> line.trim()).filter(line -> line.startsWith("#define ")).collect(Collectors.toList());
        boolean isClang = GCCCompiler.isClang(defines);
        if (isClang) {
            defines.addAll(GCCCompiler.getClangTestMacros());
        }
        for (String eachLine : StringUtil.splitByLines((String)output.featureChecks)) {
            Command command;
            Matcher matcher = GCCCompiler.matchSafely(COMMAND_PATTERN, eachLine);
            if (!matcher.find()) continue;
            try {
                command = Command.valueOf(matcher.group(1));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Unexpected command: " + matcher.group(1));
                continue;
            }
            String key = matcher.group(2);
            String value = matcher.group(3);
            try {
                switch (command) {
                    case SET_TYPE_SIZE: {
                        try {
                            cidrFeatures.put(OCCompilerFeatures.TypeSize.valueOf(key), Short.parseShort(value));
                        }
                        catch (NumberFormatException e) {
                            warnLog.add(CidrProjectModelBundle.message("cannot.determine.type.size.for.key.value", key, value) + "\n" + CidrProjectModelBundle.message("possibly.unsupported.compiler.error.message", new Object[0]));
                        }
                        break;
                    }
                    case SET_FEATURE: {
                        cidrFeatures.put(OCCompilerFeatures.Feature.valueOf(key), value.equals("1"));
                        break;
                    }
                    case ADD_DEFINITION: {
                        Object realName;
                        if (key.startsWith("__CIDR_macro_")) {
                            realName = StringUtil.substringAfter((String)key, (String)"__CIDR_macro");
                            defines.add("#define " + (String)realName + " " + value);
                        }
                        if (key.startsWith("__CIDR_builtin_")) {
                            realName = StringUtil.substringAfter((String)key, (String)"__CIDR_builtin");
                            realName = (String)realName + "(x)";
                            defines.add("#define " + (String)realName + " " + (String)realName);
                            break;
                        }
                        defines.add("#define " + key + " " + value);
                        break;
                    }
                    case SET_LANGUAGE_STANDARD: {
                        cidrFeatures.put(OCCompilerFeatures.LANGUAGE_STANDARD, (Object)(key.equals(STANDARD_CPP) ? OCLanguageStandard.getCppStandard(value) : OCLanguageStandard.getCStandard(value)));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                warnLog.add(CidrProjectModelBundle.message("invalid.query.message", eachLine));
            }
        }
        defines.add("#define __extension__");
        defines.addAll(GCCCompiler.getGCCBuiltInFunctionMacros());
        return new Pair(defines, cidrFeatures);
    }

    @NonNls
    private static String buildFeaturesCheckText() {
        @NonNls StringBuilder result = new StringBuilder("#define ___CIDR_FEATURES_START\n");
        class QueryBuilder {
            final /* synthetic */ StringBuilder val$result;

            QueryBuilder(StringBuilder stringBuilder) {
                this.val$result = stringBuilder;
            }

            void appendLanguageStandardQuery(@NotNull String macro, boolean isCPP) {
                if (macro == null) {
                    QueryBuilder.$$$reportNull$$$0(0);
                }
                this.val$result.append("#if defined(").append(macro).append(")\n");
                this.appendCommand(Command.SET_LANGUAGE_STANDARD, isCPP ? GCCCompiler.STANDARD_CPP : GCCCompiler.STANDARD_C, macro);
                this.val$result.append("#endif\n");
            }

            void appendTypeSizeQuery(@NotNull String macro, @NotNull OCCompilerFeatures.TypeSize type) {
                if (macro == null) {
                    QueryBuilder.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    QueryBuilder.$$$reportNull$$$0(2);
                }
                this.val$result.append("#if defined(").append(macro).append(")\n");
                this.appendCommand(Command.SET_TYPE_SIZE, type.name(), macro);
                this.val$result.append("#endif\n");
            }

            void appendBuiltinQuery(@NonNls @NotNull String condition, @NonNls @NotNull String emulationMacroName, boolean supported) {
                if (condition == null) {
                    QueryBuilder.$$$reportNull$$$0(3);
                }
                if (emulationMacroName == null) {
                    QueryBuilder.$$$reportNull$$$0(4);
                }
                if (supported) {
                    this.val$result.append("#if ").append(condition).append("\n");
                    this.appendEmulationMacroCommand(emulationMacroName, "1");
                    this.val$result.append("#else\n");
                }
                this.appendEmulationMacroCommand(emulationMacroName, "0");
                if (supported) {
                    this.val$result.append("#endif\n");
                }
            }

            void appendSetFeatureCommand(@NonNls @NotNull String condition, @NotNull OCCompilerFeatures.Feature cidrFeature) {
                if (condition == null) {
                    QueryBuilder.$$$reportNull$$$0(5);
                }
                if (cidrFeature == null) {
                    QueryBuilder.$$$reportNull$$$0(6);
                }
                this.val$result.append("#if ").append(condition).append("\n");
                this.appendCommand(Command.SET_FEATURE, cidrFeature.name(), "1");
                if (cidrFeature == OCCompilerFeatures.Feature.OBJC_BOOL) {
                    this.appendCommand(Command.ADD_DEFINITION, "__objc_no", "((BOOL)0)");
                    this.appendCommand(Command.ADD_DEFINITION, "__objc_yes", "((BOOL)1)");
                }
                this.val$result.append("#else\n");
                this.appendCommand(Command.SET_FEATURE, cidrFeature.name(), "0");
                this.val$result.append("#endif\n");
            }

            private void appendCommand(Command type, @NonNls String key, @NonNls String value) {
                this.val$result.append(GCCCompiler.COMMAND_PREFIX).append((Object)type).append("->").append(key).append("=").append(value).append("\n");
            }

            private void appendEmulationMacroCommand(@NonNls @Nullable String emulationMacroName, @NonNls String value) {
                if (emulationMacroName != null) {
                    this.appendCommand(Command.ADD_DEFINITION, emulationMacroName, value);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "macro";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "condition";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "emulationMacroName";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cidrFeature";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$1QueryBuilder";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendLanguageStandardQuery";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendTypeSizeQuery";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendBuiltinQuery";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "appendSetFeatureCommand";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        QueryBuilder queryBuilder = new QueryBuilder(result);
        queryBuilder.appendLanguageStandardQuery("__STDC_VERSION__", false);
        queryBuilder.appendLanguageStandardQuery("__cplusplus", true);
        result.append("#ifdef __FILE_NAME__\n");
        queryBuilder.appendCommand(Command.ADD_DEFINITION, "__CIDR_macro__FILE_NAME__", "\"_file_name_short_\"");
        result.append("#endif\n");
        queryBuilder.appendBuiltinQuery("defined(__has_include)", "__CIDR_builtin__has_include", true);
        queryBuilder.appendBuiltinQuery("defined(__has_include_next)", "__CIDR_builtin__has_include_next", true);
        queryBuilder.appendBuiltinQuery("defined(__has_cpp_attribute)", "__CIDR_builtin__has_cpp_attribute", true);
        result.append("#if __clang__\n");
        result.append("#if !(defined (__has_extension)) && defined(__has_feature)\n  #define __has_extension __has_feature\n#endif\n#if !defined(__has_attribute)\n  #define __has_attribute(x) 0\n#endif\n#if !defined(__has_builtin)\n  #define __has_builtin(x) 0\n#endif\n#if !defined(__is_identifier)\n  #define __is_identifier(x) 1\n#endif\n#if !__has_builtin(__is_target_arch)\n  #define __is_target_arch(x) 0\n#endif\n#if !__has_builtin(__is_target_vendor)\n  #define __is_target_vendor(x) 0\n#endif\n#if !__has_builtin(__is_target_os)\n  #define __is_target_os(x) 0\n#endif\n#if !__has_builtin(__is_target_variant_os)\n  #define __is_target_variant_os(x) 0\n#endif\n#if !__has_builtin(__is_target_environment)\n  #define __is_target_environment(x) 0\n#endif\n#if !__has_builtin(__is_target_variant_environment)\n  #define __is_target_variant_environment(x) 0\n#endif\n");
        ClangFeatures.getAllFeatures().forEach(each -> {
            boolean supported = !ClangFeatures.getUnsupportedClangFeatures().contains(each);
            String featureCondition = "__has_feature(" + each + ")";
            String extensionCondition = "__has_extension(" + each + ")";
            queryBuilder.appendBuiltinQuery(featureCondition, GCCCompiler.clangFeatureMacro(each), supported);
            queryBuilder.appendBuiltinQuery(extensionCondition, GCCCompiler.clangExtensionMacro(each), supported);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(each);
            if (cidrFeature != null) {
                queryBuilder.appendSetFeatureCommand(featureCondition + " || " + extensionCondition, cidrFeature);
            }
        });
        ClangFeatures.getAllBuiltins().forEach(each -> {
            String condition = "__has_builtin(" + each + ")";
            queryBuilder.appendBuiltinQuery(condition, GCCCompiler.clangBuiltinMacro(each), true);
            OCCompilerFeatures.Feature cidrFeature = ClangFeatures.getFeatureForClangId(each);
            if (cidrFeature != null) {
                queryBuilder.appendSetFeatureCommand(condition, cidrFeature);
            }
        });
        ClangFeatures.getAllAttributes().forEach(each -> queryBuilder.appendBuiltinQuery("__has_attribute(" + each + ")", GCCCompiler.clangAttributeMacro(each), true));
        ClangFeatures.getAllTargetArchs().forEach(arch -> queryBuilder.appendBuiltinQuery("__is_target_arch(" + arch + ")", GCCCompiler.clangTargetArchMacro(arch), true));
        ClangFeatures.getAllTargetVendors().forEach(vendor -> queryBuilder.appendBuiltinQuery("__is_target_vendor(" + vendor + ")", GCCCompiler.clangTargetVendorMacro(vendor), true));
        ClangFeatures.getAllTargetOss().forEach(os -> {
            queryBuilder.appendBuiltinQuery("__is_target_os(" + os + ")", GCCCompiler.clangTargetOsMacro(os), true);
            queryBuilder.appendBuiltinQuery("__is_target_variant_os(" + os + ")", GCCCompiler.clangTargetVariantOsMacro(os), true);
        });
        ClangFeatures.getAllTargetEnvironemts().forEach(environment -> {
            queryBuilder.appendBuiltinQuery("__is_target_environment(" + environment + ")", GCCCompiler.clangTargetEnvironmentMacro(environment), true);
            queryBuilder.appendBuiltinQuery("__is_target_variant_environment(" + environment + ")", GCCCompiler.clangTargetVariantEnvironmentMacro(environment), true);
        });
        queryBuilder.appendSetFeatureCommand("!__is_identifier(__auto_type)", OCCompilerFeatures.Feature.GCC_AUTO_TYPE);
        result.append("#else\n");
        result.append("#define __CIDR_GCC_VERSION (__GNUC__ * 10000 + __GNUC_MINOR__ * 100 + __GNUC_PATCHLEVEL__)\n");
        LinkedHashMap<OCCompilerFeatures.Feature, @NonNls String> checks = new LinkedHashMap<OCCompilerFeatures.Feature, String>();
        checks.put(OCCompilerFeatures.Feature.GCC_AUTO_TYPE, "!defined(__cplusplus) && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.C_STATIC_ASSERT, "!defined(__cplusplus) && __STDC_VERSION__ >= 201112L && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_AUTO_TYPE, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_OVERRIDE_CONTROL, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERALIZED_INITIALIZERS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40400");
        checks.put(OCCompilerFeatures.Feature.CXX_NULLPTR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_NONSTATIC_MEMBER_INIT, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_EXCEPTIONS, "defined(__cplusplus) && __EXCEPTIONS");
        checks.put(OCCompilerFeatures.Feature.CXX_CONSTEXPR, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40600");
        checks.put(OCCompilerFeatures.Feature.CXX_RAW_STRING_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40500");
        checks.put(OCCompilerFeatures.Feature.CXX_USER_LITERALS, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_ATTRIBUTES, "__cplusplus >= 201103 && __CIDR_GCC_VERSION >= 40700");
        checks.put(OCCompilerFeatures.Feature.CXX_BINARY_LITERALS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_RETURN_TYPE_DEDUCTION, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.put(OCCompilerFeatures.Feature.CXX_GENERIC_LAMBDAS, "__cplusplus >= 201402 && __CIDR_GCC_VERSION >= 40900");
        checks.forEach((feature, check) -> queryBuilder.appendSetFeatureCommand((String)check, (OCCompilerFeatures.Feature)feature));
        result.append("#endif\n");
        GCCCompiler.getTypeSizesMacros().forEach((type, macro) -> queryBuilder.appendTypeSizeQuery((String)macro, (OCCompilerFeatures.TypeSize)type));
        return result.toString();
    }

    @NotNull
    public static LinkedHashMap<OCCompilerFeatures.TypeSize, String> getTypeSizesMacros() {
        LinkedHashMap<OCCompilerFeatures.TypeSize, @NonNls String> sizes = new LinkedHashMap<OCCompilerFeatures.TypeSize, String>();
        sizes.put(OCCompilerFeatures.TypeSize.WCHAR_T, "__SIZEOF_WCHAR_T__");
        sizes.put(OCCompilerFeatures.TypeSize.SHORT, "__SIZEOF_SHORT__");
        sizes.put(OCCompilerFeatures.TypeSize.INT, "__SIZEOF_INT__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG, "__SIZEOF_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.POINTER, "__SIZEOF_POINTER__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_LONG, "__SIZEOF_LONG_LONG__");
        sizes.put(OCCompilerFeatures.TypeSize.INT128_T, "__SIZEOF_INT128__");
        sizes.put(OCCompilerFeatures.TypeSize.FLOAT, "__SIZEOF_FLOAT__");
        sizes.put(OCCompilerFeatures.TypeSize.DOUBLE, "__SIZEOF_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.LONG_DOUBLE, "__SIZEOF_LONG_DOUBLE__");
        sizes.put(OCCompilerFeatures.TypeSize.SIZE_T, "__SIZEOF_SIZE_T__");
        sizes.put(OCCompilerFeatures.TypeSize.PTRDIFF_T, "__SIZEOF_PTRDIFF_T__");
        LinkedHashMap<OCCompilerFeatures.TypeSize, String> linkedHashMap = sizes;
        if (linkedHashMap == null) {
            GCCCompiler.$$$reportNull$$$0(31);
        }
        return linkedHashMap;
    }

    private static void collectDiagnostics(@NotNull CidrCompilerSwitches switches, boolean isClang, final Map<OCCompilerFeatures.Type<?>, Object> result) {
        THashSet set;
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(32);
        }
        if ((set = new THashSet(switches.getList(CidrCompilerSwitches.Format.RAW))).contains("-w")) {
            return;
        }
        boolean everythingEnabled = set.contains("-Weverything");
        boolean allWarningsEnabled = everythingEnabled || set.contains("-Wall");
        boolean pedanticAsErrors = set.contains("-pedantic-errors");
        boolean pedanticEnabled = everythingEnabled || pedanticAsErrors || set.contains("-pedantic") || set.contains("-Wpedantic");
        boolean warningsAsErrors = set.contains("-Werror");
        class Checker {
            final /* synthetic */ Set val$set;

            Checker() {
                this.val$set = set;
            }

            void add(OCCompilerFeatures.Diagnostic diagnostic, boolean globallyEnabled, boolean globallyEnabledAsError, @NonNls String id) {
                OCCompilerFeatures.DiagnosticLevel level = this.getLevel(globallyEnabled, globallyEnabledAsError, id);
                result.put(diagnostic, level != null ? level : OCCompilerFeatures.DiagnosticLevel.DISABLED);
            }

            @Nullable
            private OCCompilerFeatures.DiagnosticLevel getLevel(boolean globallyEnabled, boolean globallyEnabledAsError, @NonNls String id) {
                if (globallyEnabled && globallyEnabledAsError || this.val$set.contains("-Werror=" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.ERROR;
                }
                if (globallyEnabled || this.val$set.contains("-W" + id)) {
                    return OCCompilerFeatures.DiagnosticLevel.WARNING;
                }
                return null;
            }
        }
        Checker checker = new Checker();
        checker.add(OCCompilerFeatures.Diagnostic.MISSING_RETURN_FROM_NON_VOID, isClang || allWarningsEnabled, warningsAsErrors, "return-type");
        if (isClang) {
            checker.add(OCCompilerFeatures.Diagnostic.FOLDING_CONSTANT, pedanticEnabled, pedanticAsErrors, "gnu-folding-constant");
        }
    }

    private static void collectFeatureFlags(@NotNull CidrCompilerSwitches switches, Map<OCCompilerFeatures.Type<?>, Object> result) {
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(33);
        }
        THashSet set = new THashSet(switches.getList(CidrCompilerSwitches.Format.RAW));
        featureFlags.forEach((arg_0, arg_1) -> GCCCompiler.lambda$collectFeatureFlags$14((Set)set, result, arg_0, arg_1));
    }

    @NotNull
    ProcessOutput runGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull String fileText, @NotNull List<String> warnLog) throws ExecutionException {
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(34);
        }
        if (options == null) {
            GCCCompiler.$$$reportNull$$$0(35);
        }
        if (fileText == null) {
            GCCCompiler.$$$reportNull$$$0(36);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(37);
        }
        Set skipOptions = ContainerUtil.set((Object[])new String[]{"-fdiagnostics-format", "-imacros", "-"});
        return this.tryRunGCC(environment, GCCCompiler.handleFsycl(options), skipOptions, 0, 0, false, fileText, warnLog);
    }

    protected String getCommandLineString(CidrCompilerSwitches options) {
        return options.getCommandLineString(CidrCompilerSwitches.Format.GCC_RESPONSE_FILE);
    }

    @NotNull
    private static CidrCompilerSwitches handleFsycl(@NotNull CidrCompilerSwitches options) {
        List<String> rawOptions;
        boolean shouldHandleFsycl;
        if (options == null) {
            GCCCompiler.$$$reportNull$$$0(38);
        }
        boolean bl = shouldHandleFsycl = (rawOptions = options.getList(CidrCompilerSwitches.Format.RAW)).contains("-E") && rawOptions.contains(FSYCL) && !rawOptions.contains(FSYCL_DEVICE_ONLY) && Registry.is((String)"cidr.compiler.clang.fsycl", (boolean)false);
        if (shouldHandleFsycl) {
            @NotNull ArrayList<@NotNull String> newRawOptions = new ArrayList<String>(rawOptions);
            newRawOptions.add(FSYCL_DEVICE_ONLY);
            return new CidrCompilerSwitches(newRawOptions);
        }
        CidrCompilerSwitches cidrCompilerSwitches = options;
        if (cidrCompilerSwitches == null) {
            GCCCompiler.$$$reportNull$$$0(39);
        }
        return cidrCompilerSwitches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private ProcessOutput tryRunGCC(@NotNull CidrToolEnvironment environment, @NotNull CidrCompilerSwitches options, @NotNull Set<String> skipOptions, int optionsRetriesNumber, int timeoutsNumber, boolean skipResponseFile, @NotNull String fileText, @NotNull List<String> warnLog) throws ExecutionException {
        ProcessOutput output;
        String clCommandLineString;
        String responseFileText;
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(40);
        }
        if (options == null) {
            GCCCompiler.$$$reportNull$$$0(41);
        }
        if (skipOptions == null) {
            GCCCompiler.$$$reportNull$$$0(42);
        }
        if (fileText == null) {
            GCCCompiler.$$$reportNull$$$0(43);
        }
        if (warnLog == null) {
            GCCCompiler.$$$reportNull$$$0(44);
        }
        CidrCompilerSwitches filteredOptions = this.filterOptions(options, skipOptions);
        Path responseFile = null;
        String responseFileArg = null;
        Path bodyFile = null;
        String gccPath = this.myExecutable.getPath();
        HostMachine host = environment.getHostMachine();
        Path tmpDir = host.getTempDirectory();
        try {
            try {
                responseFileText = this.getCommandLineString(filteredOptions);
                if (!skipResponseFile) {
                    responseFile = this.myTempFilesPool.writeToTempFile(host, responseFileText, tmpDir, "response-file", ".txt");
                    responseFileArg = "@" + environment.toEnvPath(responseFile.toAbsolutePath().toString());
                }
                bodyFile = this.myTempFilesPool.writeToTempFile(host, fileText, tmpDir, "compiler-file", "");
            }
            catch (IOException e) {
                throw new ExecutionException(CidrProjectModelBundle.message("unable.to.create.temporary.file", new Object[0]), (Throwable)e);
            }
            GeneralCommandLine cl = new GeneralCommandLine();
            environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
            cl.setExePath(gccPath);
            cl.withWorkDirectory(this.myWorkingDirectory);
            Map clEnvironment = cl.getEnvironment();
            clEnvironment.put("LC_ALL", "C");
            for (String skipVariables : skipEnvironment) {
                clEnvironment.remove(skipVariables);
            }
            if (!skipResponseFile) {
                cl.addParameters(new String[]{responseFileArg});
            } else {
                cl.addParameters(filteredOptions.getList(CidrCompilerSwitches.Format.RAW));
            }
            cl.addParameters(new String[]{environment.toEnvPath(bodyFile.toAbsolutePath().toString())});
            clCommandLineString = cl.getCommandLineString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Running compiler: " + clCommandLineString + "\nArguments file contents: " + filteredOptions);
            }
            output = outCompilerRunner.run(cl, environment);
            if (bodyFile != null) {
                this.myTempFilesPool.delete(bodyFile);
            }
            if (responseFile != null) {
                this.myTempFilesPool.delete(responseFile);
            }
        }
        catch (Throwable throwable) {
            if (bodyFile != null) {
                this.myTempFilesPool.delete(bodyFile);
            }
            if (responseFile != null) {
                this.myTempFilesPool.delete(responseFile);
            }
            throw throwable;
        }
        @NonNls String userFriendlyCommandLine = gccPath + " " + responseFileText.replaceFirst(Matcher.quoteReplacement(" -D___CIDR_DEFINITIONS_END"), "");
        if (output.isTimeout()) {
            if (timeoutsNumber < 1) {
                LOG.debug("Trying to run compiler after timeout");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber + 1, skipResponseFile, fileText, warnLog);
            }
            throw GCCCompiler.throwCompilerTimeout(userFriendlyCommandLine);
        }
        if (output.getExitCode() != 0) {
            if (!skipResponseFile && output.getStderr().contains(responseFileArg)) {
                LOG.debug("Trying to run compiler without a @response file");
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber, timeoutsNumber, true, fileText, warnLog);
            }
            if (optionsRetriesNumber < 2 && GCCCompiler.collectSkipOptionsGcc(output.getStderrLines(), skipOptions, warnLog)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Trying to run compiler with skipped options: " + StringUtil.join(skipOptions, (String)" "));
                }
                return this.tryRunGCC(environment, options, skipOptions, optionsRetriesNumber + 1, timeoutsNumber, skipResponseFile, fileText, warnLog);
            }
            if (!GCCCompiler.allowResultsWithError(output)) {
                throw GCCCompiler.throwCompilerError(output, userFriendlyCommandLine);
            }
        }
        if (LOG.isDebugEnabled()) {
            @NonNls String dbg = "Compiler finished `" + clCommandLineString + "` with " + output.getExitCode();
            if (LOG.isTraceEnabled()) {
                dbg = dbg + ":\n>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\nStdout:\n " + output.getStdout() + "\nStderr:\n " + output.getStderr() + "\n<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n";
            }
            LOG.debug(dbg);
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            GCCCompiler.$$$reportNull$$$0(45);
        }
        return processOutput;
    }

    private static boolean allowResultsWithError(@NotNull ProcessOutput output) {
        if (output == null) {
            GCCCompiler.$$$reportNull$$$0(46);
        }
        return PlatformUtils.isAppCode() && output.getExitCode() == 1;
    }

    @Override
    @NotNull
    public CidrCompilerSwitches filterOptions(@NotNull CidrCompilerSwitches switches, final @NotNull Set<String> skipOptions) {
        if (switches == null) {
            GCCCompiler.$$$reportNull$$$0(47);
        }
        if (skipOptions == null) {
            GCCCompiler.$$$reportNull$$$0(48);
        }
        BiFunction<String, String, Boolean> argumentsFilter2 = new BiFunction<String, String, Boolean>(){
            boolean archAdded = false;
            boolean skipOptionValue = false;
            boolean skipRest = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipRest) {
                    return false;
                }
                parameter = GCCCompiler.this.adjustArgument(parameter.trim());
                boolean tokenIsSwitch = GCCCompiler.isOptionSwitch(parameter);
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    if (!tokenIsSwitch) {
                        return false;
                    }
                }
                if (!skipOptions.contains(parameter)) {
                    if (skipSwitches.contains(parameter)) {
                        this.skipOptionValue = true;
                        return false;
                    }
                    String finalParameter = parameter;
                    if (skipSwitches.stream().anyMatch(s -> finalParameter.startsWith((String)s))) {
                        return false;
                    }
                    if (parameter.startsWith("-Werror") || parameter.startsWith("-Wno-error")) {
                        return false;
                    }
                    if ("-arch".equals(parameter)) {
                        if (this.archAdded) {
                            this.skipOptionValue = true;
                            return false;
                        }
                        this.archAdded = true;
                    }
                    if (parameter.startsWith("-include") || parameter.startsWith("--include")) {
                        String includeArg;
                        if (("-include".equals(parameter) || "--include".equals(parameter)) && skipOptions.contains(GCCCompiler.this.adjustArgument(nextParameter))) {
                            return false;
                        }
                        if (parameter.startsWith("--include=") ? skipOptions.contains(includeArg = parameter.substring("--include=".length())) : skipOptions.contains(includeArg = parameter.substring("-include".length()))) {
                            return false;
                        }
                    }
                    if (parameter.equals("--")) {
                        this.skipRest = true;
                        return false;
                    }
                    return true;
                }
                this.skipOptionValue = tokenIsSwitch;
                return false;
            }
        };
        CidrCompilerSwitches cidrCompilerSwitches = switches.filterOptions((BiFunction<? super String, ? super String, Boolean>)argumentsFilter2);
        if (cidrCompilerSwitches == null) {
            GCCCompiler.$$$reportNull$$$0(49);
        }
        return cidrCompilerSwitches;
    }

    private static boolean isOptionSwitch(@NotNull String option) {
        if (option == null) {
            GCCCompiler.$$$reportNull$$$0(50);
        }
        return option.startsWith("-");
    }

    static boolean collectSkipOptionsGcc(List<String> lines, Set<String> skipOptions, List<String> warnLog) {
        return GCCCompiler.collectOptionsToSkip(lines, skipOptions, warnLog, BAD_SWITCH_FILTER_RULES);
    }

    @NonNls
    @NotNull
    protected String adjustArgument(@NotNull String arg) {
        if (arg == null) {
            GCCCompiler.$$$reportNull$$$0(51);
        }
        String string = arg;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(52);
        }
        return string;
    }

    @NonNls
    @NotNull
    protected String preparePath(@NotNull CidrToolEnvironment env, @NotNull String path) {
        if (env == null) {
            GCCCompiler.$$$reportNull$$$0(53);
        }
        if (path == null) {
            GCCCompiler.$$$reportNull$$$0(54);
        }
        String string = FileUtil.toCanonicalPath((String)env.toLocalPath(this.myWorkingDirectory, path));
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(55);
        }
        return string;
    }

    @NonNls
    public static List<String> getClangTestMacros() {
        return CLANG_TEST_MACROS;
    }

    @NonNls
    @NotNull
    public static List<String> getGCCBuiltInFunctionMacros() {
        List<String> list = GCC_BUILT_IN_FUNCTION_MACROS;
        if (list == null) {
            GCCCompiler.$$$reportNull$$$0(56);
        }
        return list;
    }

    @NonNls
    @NotNull
    public static String clangFeatureMacro(@NotNull String feature) {
        if (feature == null) {
            GCCCompiler.$$$reportNull$$$0(57);
        }
        String string = "__CIDR_clang__has_feature_" + feature;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangExtensionMacro(@NotNull String extension) {
        if (extension == null) {
            GCCCompiler.$$$reportNull$$$0(59);
        }
        String string = "__CIDR_clang__has_extension_" + extension;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangAttributeMacro(@NotNull String attribute) {
        if (attribute == null) {
            GCCCompiler.$$$reportNull$$$0(61);
        }
        String string = "__CIDR_clang__has_attribute_" + attribute;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(62);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangBuiltinMacro(@NotNull String extension) {
        if (extension == null) {
            GCCCompiler.$$$reportNull$$$0(63);
        }
        String string = "__CIDR_clang__has_builtin_" + extension;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(64);
        }
        return string;
    }

    @NonNls
    @NotNull
    @VisibleForTesting
    public static String clangTargetArchMacro(@NotNull String arch) {
        if (arch == null) {
            GCCCompiler.$$$reportNull$$$0(65);
        }
        String string = "__CIDR_clang__is_target_arch_" + arch;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(66);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetVendorMacro(@NotNull String vendor) {
        if (vendor == null) {
            GCCCompiler.$$$reportNull$$$0(67);
        }
        String string = "__CIDR_clang__is_target_vendor_" + vendor;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(68);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetOsMacro(@NotNull String os) {
        if (os == null) {
            GCCCompiler.$$$reportNull$$$0(69);
        }
        String string = "__CIDR_clang__is_target_os_" + os;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(70);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetEnvironmentMacro(@NotNull String environment) {
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(71);
        }
        String string = "__CIDR_clang__is_target_environment_" + environment;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(72);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetVariantOsMacro(@NotNull String os) {
        if (os == null) {
            GCCCompiler.$$$reportNull$$$0(73);
        }
        String string = "__CIDR_clang__is_target_variant_os_" + os;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(74);
        }
        return string;
    }

    @NonNls
    @NotNull
    static String clangTargetVariantEnvironmentMacro(@NotNull String environment) {
        if (environment == null) {
            GCCCompiler.$$$reportNull$$$0(75);
        }
        String string = "__CIDR_clang__is_target_variant_environment_" + environment;
        if (string == null) {
            GCCCompiler.$$$reportNull$$$0(76);
        }
        return string;
    }

    private static /* synthetic */ void lambda$collectFeatureFlags$14(Set set, Map result, String flag, OCCompilerFeatures.Feature feature) {
        if (set.contains(flag)) {
            result.put(feature, true);
        }
    }

    static {
        featureFlags.put("-fms-extensions", OCCompilerFeatures.Feature.MS_EXTENSIONS);
        featureFlags.put("-fms-compatibility", OCCompilerFeatures.Feature.MS_EXTENSIONS);
        skipSwitches = ContainerUtil.newHashSet((Object[])new String[]{"-o", "--output", "--output=", "-M", "-MM", "-MF", "-MG", "-MP", "-MT", "-MQ", "-MD", "-MMD"});
        skipEnvironment = ContainerUtil.newHashSet((Object[])new String[]{"DEPENDENCIES_OUTPUT", "SUNPRO_DEPENDENCIES"});
        CLANG_TEST_MACROS = List.of("#define __has_feature(X) " + GCCCompiler.clangFeatureMacro("##X"), "#define __has_extension(X) " + GCCCompiler.clangExtensionMacro("##X"), "#define __has_attribute(X) " + GCCCompiler.clangAttributeMacro("##X"), "#define __has_builtin(X) " + GCCCompiler.clangBuiltinMacro("##X"), "#define __is_target_arch(X) " + GCCCompiler.clangTargetArchMacro("##X"), "#define __is_target_vendor(X) " + GCCCompiler.clangTargetVendorMacro("##X"), "#define __is_target_os(X) " + GCCCompiler.clangTargetOsMacro("##X"), "#define __is_target_environment(X) " + GCCCompiler.clangTargetEnvironmentMacro("##X"), "#define __is_target_variant_os(X) " + GCCCompiler.clangTargetVariantOsMacro("##X"), "#define __is_target_variant_environment(X) " + GCCCompiler.clangTargetVariantEnvironmentMacro("##X"));
        GCC_BUILT_IN_FUNCTION_MACROS = List.of("#define __builtin_va_start(list, paramN) ((void)(list = sizeof(paramN)))", "#define __builtin_va_arg(list, type) ((type)list)", "#define __builtin_va_end(list) ((void)list)", "#define __builtin_va_copy(dest, src) ((void)(dest = src))", "#define __builtin_offsetof(type, member) ((size_t)(&(((type *)0)->member)))", "#define __builtin_types_compatible_p(X,Y) 1", "#define __builtin_choose_expr(C,T,E) T");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 31: 
            case 39: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 31: 
            case 39: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executable";
                break;
            }
            case 1: 
            case 10: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 2: 
            case 20: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFilesPool";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionPattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 32: 
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 7: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawSwitches";
                break;
            }
            case 9: 
            case 16: 
            case 24: 
            case 27: 
            case 34: 
            case 40: 
            case 71: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 11: 
            case 31: 
            case 39: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageKind";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preprocessed";
                break;
            }
            case 18: 
            case 22: 
            case 37: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warnLog";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pch";
                break;
            }
            case 23: 
            case 26: 
            case 30: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nonBuiltinSearchPaths";
                break;
            }
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 36: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 42: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipOptions";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feature";
                break;
            }
            case 59: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arch";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vendor";
                break;
            }
            case 69: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNonBuiltinSearchPaths";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSizesMacros";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "handleFsycl";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "tryRunGCC";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOptions";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustArgument";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "preparePath";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getGCCBuiltInFunctionMacros";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "clangFeatureMacro";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "clangExtensionMacro";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "clangAttributeMacro";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "clangBuiltinMacro";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetArchMacro";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetVendorMacro";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetOsMacro";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetEnvironmentMacro";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetVariantOsMacro";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "clangTargetVariantEnvironmentMacro";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageOption";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptionLanguage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extractNonBuiltinSearchPaths";
                break;
            }
            case 11: 
            case 31: 
            case 39: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectInfo";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isClang";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getForcedHeaders";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractOriginalPrecompiledHeaderFile";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectHeaderSearchPaths";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectDefinitionsAndFeatures";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectDiagnostics";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectFeatureFlags";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "runGCC";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "handleFsycl";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "tryRunGCC";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "allowResultsWithError";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "filterOptions";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isOptionSwitch";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "adjustArgument";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "preparePath";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "clangFeatureMacro";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "clangExtensionMacro";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "clangAttributeMacro";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "clangBuiltinMacro";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetArchMacro";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetVendorMacro";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetOsMacro";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetEnvironmentMacro";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetVariantOsMacro";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "clangTargetVariantEnvironmentMacro";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 31: 
            case 39: 
            case 45: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OutputSections {
        @NotNull
        final List<String> defines;
        @NotNull
        final String preprocessed;
        @NotNull
        final String featureChecks;

        OutputSections(@NotNull List<String> defines, @NotNull String preprocessed, @NotNull String featureTests) {
            if (defines == null) {
                OutputSections.$$$reportNull$$$0(0);
            }
            if (preprocessed == null) {
                OutputSections.$$$reportNull$$$0(1);
            }
            if (featureTests == null) {
                OutputSections.$$$reportNull$$$0(2);
            }
            this.defines = defines;
            this.preprocessed = preprocessed;
            this.featureChecks = featureTests;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defines";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "preprocessed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "featureTests";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/workspace/compiler/GCCCompiler$OutputSections";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum Command {
        SET_TYPE_SIZE,
        SET_FEATURE,
        ADD_DEFINITION,
        SET_LANGUAGE_STANDARD;

    }
}

