/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.util.Arrays;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum OCLanguageStandard {
    C89(CLanguageKind.C),
    C99(CLanguageKind.C),
    C11(CLanguageKind.C),
    CPP98(CLanguageKind.CPP),
    CPP11(CLanguageKind.CPP),
    CPP14(CLanguageKind.CPP),
    CPP17(CLanguageKind.CPP),
    CPP20(CLanguageKind.CPP);

    @NotNull
    private final OCLanguageKind myKind;
    public static final String __STDC_VERSION__VALUE_C89 = "199409L";
    public static final String __STDC_VERSION__VALUE_C99 = "199901L";
    public static final String __STDC_VERSION__VALUE_C11 = "201112L";
    public static final String __CPLUSPLUS_VALUE_CPP98 = "199711L";
    public static final String __CPLUSPLUS_VALUE_CPP11 = "201103L";
    public static final String __CPLUSPLUS_VALUE_CPP14 = "201402L";
    public static final String __CPLUSPLUS_VALUE_CPP17 = "201705L";
    public static final String __CPLUSPLUS_VALUE_CPP20 = "202002L";

    private OCLanguageStandard(OCLanguageKind kind) {
        if (kind == null) {
            OCLanguageStandard.$$$reportNull$$$0(0);
        }
        this.myKind = kind;
    }

    public boolean supports(@NotNull OCLanguageStandard standard) {
        if (standard == null) {
            OCLanguageStandard.$$$reportNull$$$0(1);
        }
        return Comparing.equal((Object)this.myKind, (Object)standard.myKind) && this.compareTo(standard) >= 0;
    }

    @NotNull
    public static OCLanguageStandard getCStandard(@Nullable String stdc_version) {
        if (stdc_version != null) {
            if (stdc_version.compareTo(__STDC_VERSION__VALUE_C99) > 0) {
                OCLanguageStandard oCLanguageStandard = C11;
                if (oCLanguageStandard == null) {
                    OCLanguageStandard.$$$reportNull$$$0(2);
                }
                return oCLanguageStandard;
            }
            if (stdc_version.compareTo(__STDC_VERSION__VALUE_C89) > 0) {
                OCLanguageStandard oCLanguageStandard = C99;
                if (oCLanguageStandard == null) {
                    OCLanguageStandard.$$$reportNull$$$0(3);
                }
                return oCLanguageStandard;
            }
        }
        OCLanguageStandard oCLanguageStandard = C89;
        if (oCLanguageStandard == null) {
            OCLanguageStandard.$$$reportNull$$$0(4);
        }
        return oCLanguageStandard;
    }

    @NotNull
    public static OCLanguageStandard getCppStandard(@Nullable String cplusplus) {
        if (cplusplus != null) {
            if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP17) > 0) {
                OCLanguageStandard oCLanguageStandard = CPP20;
                if (oCLanguageStandard == null) {
                    OCLanguageStandard.$$$reportNull$$$0(5);
                }
                return oCLanguageStandard;
            }
            if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP14) > 0) {
                OCLanguageStandard oCLanguageStandard = CPP17;
                if (oCLanguageStandard == null) {
                    OCLanguageStandard.$$$reportNull$$$0(6);
                }
                return oCLanguageStandard;
            }
            if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP11) > 0) {
                OCLanguageStandard oCLanguageStandard = CPP14;
                if (oCLanguageStandard == null) {
                    OCLanguageStandard.$$$reportNull$$$0(7);
                }
                return oCLanguageStandard;
            }
            if (cplusplus.compareTo(__CPLUSPLUS_VALUE_CPP98) > 0) {
                OCLanguageStandard oCLanguageStandard = CPP11;
                if (oCLanguageStandard == null) {
                    OCLanguageStandard.$$$reportNull$$$0(8);
                }
                return oCLanguageStandard;
            }
        }
        OCLanguageStandard oCLanguageStandard = CPP98;
        if (oCLanguageStandard == null) {
            OCLanguageStandard.$$$reportNull$$$0(9);
        }
        return oCLanguageStandard;
    }

    @NotNull
    public static OCLanguageStandard latestCpp() {
        OCLanguageStandard oCLanguageStandard = Arrays.stream(OCLanguageStandard.values()).filter(it -> it.myKind == CLanguageKind.CPP).max(Comparator.naturalOrder()).get();
        if (oCLanguageStandard == null) {
            OCLanguageStandard.$$$reportNull$$$0(10);
        }
        return oCLanguageStandard;
    }

    @NotNull
    public static OCLanguageStandard latestC() {
        OCLanguageStandard oCLanguageStandard = Arrays.stream(OCLanguageStandard.values()).filter(it -> it.myKind == CLanguageKind.C).max(Comparator.naturalOrder()).get();
        if (oCLanguageStandard == null) {
            OCLanguageStandard.$$$reportNull$$$0(11);
        }
        return oCLanguageStandard;
    }

    @NotNull
    public static String latestCValue() {
        switch (OCLanguageStandard.latestC()) {
            case C89: {
                return __STDC_VERSION__VALUE_C89;
            }
            case C99: {
                return __STDC_VERSION__VALUE_C99;
            }
        }
        return __STDC_VERSION__VALUE_C11;
    }

    @NotNull
    public static String latestCppValue() {
        switch (OCLanguageStandard.latestCpp()) {
            case CPP11: {
                return __CPLUSPLUS_VALUE_CPP11;
            }
            case CPP14: {
                return __CPLUSPLUS_VALUE_CPP14;
            }
            case CPP17: {
                return __CPLUSPLUS_VALUE_CPP17;
            }
        }
        return __CPLUSPLUS_VALUE_CPP20;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "standard";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCLanguageStandard";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCLanguageStandard";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCStandard";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCppStandard";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "latestCpp";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "latestC";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "supports";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

