/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedComboBoxEditor;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.EnvReader;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import com.jetbrains.cidr.cpp.toolchains.CPPDebugger;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSetWithHome;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.cpp.toolchains.msvc.CLionCmdExeLocator;
import com.jetbrains.cidr.cpp.toolchains.msvc.CLionMsvcEnvCache;
import com.jetbrains.cidr.cpp.toolchains.msvc.cmdExeLocators.CLionComSpecBased;
import com.jetbrains.cidr.cpp.toolchains.msvc.cmdExeLocators.CLionSystemDriveBased;
import com.jetbrains.cidr.cpp.toolchains.msvc.cmdExeLocators.CLionSystemRootBased;
import com.jetbrains.cidr.cpp.util.CPPPropertiesProvider;
import com.jetbrains.cidr.cpp.util.CPPRegistryPropertiesProvider;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Triple;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MSVC
extends CPPToolSetWithHome {
    private static final Logger LOG = Logger.getInstance(MSVC.class);
    @NonNls
    public static final String VS_VERSION_ENV = "VisualStudioVersion";
    public static final com.intellij.openapi.util.Version MIN_VERSION = new com.intellij.openapi.util.Version(12, -1, -1);
    public static final com.intellij.openapi.util.Version MAX_VERSION = new com.intellij.openapi.util.Version(16, -1, -1);
    @NotNull
    private final CPPPropertiesProvider myPropertiesProvider;

    public MSVC(@NotNull File home) {
        if (home == null) {
            MSVC.$$$reportNull$$$0(0);
        }
        this(home, CPPRegistryPropertiesProvider.INSTANCE);
    }

    public MSVC(@NotNull File home, @NotNull CPPPropertiesProvider propertiesProvider) {
        if (home == null) {
            MSVC.$$$reportNull$$$0(1);
        }
        if (propertiesProvider == null) {
            MSVC.$$$reportNull$$$0(2);
        }
        super(CPPToolSet.Kind.MSVC, home);
        this.myPropertiesProvider = propertiesProvider;
    }

    @Override
    @Nullable
    public final String readVersion() {
        try {
            GeneralCommandLine cl = new GeneralCommandLine(new String[]{""});
            this.prepareEnvironment(cl, CidrToolEnvironment.PrepareFor.BUILD, Collections.emptyList());
            cl.setExePath(MSVC.getCommandExe());
            cl.withParameters(new String[]{"/C", "echo", "VisualStudioVersion=%VisualStudioVersion%"});
            ProcessOutput output = CidrToolsUtil.runWithProgress((BaseProcessHandler)new CapturingProcessHandler(cl), (int)10000);
            if (output.getExitCode() != 0 || output.isTimeout()) {
                throw new ExecutionException(ToolchainsBundle.message("msvc.error.exit.code", output.getExitCode(), output.getStdout(), output.getStderr()));
            }
            Matcher matcher = Pattern.compile("VisualStudioVersion=(\\d.+)").matcher(output.getStdout());
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new ExecutionException(ToolchainsBundle.message("msvc.error.cannot.detect.msvc.version", output.getStdout(), output.getStderr()));
        }
        catch (ExecutionException e) {
            LOG.info("Cannot read MSVC version: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static String readVersion(@NotNull File home) {
        if (home == null) {
            MSVC.$$$reportNull$$$0(3);
        }
        return new MSVC(home).readVersion();
    }

    @Override
    public final String checkVersion(@NotNull String version) {
        if (version == null) {
            MSVC.$$$reportNull$$$0(4);
        }
        return CPPToolchainsUtil.checkVersion(MIN_VERSION, MAX_VERSION, MSVC.parseToolVersion(version));
    }

    @Override
    @Nullable
    public final ToolVersion readToolVersion() {
        String version = this.readVersion();
        return version == null ? null : MSVC.parseToolVersion(version);
    }

    @NotNull
    private static ToolVersion parseToolVersion(@NotNull String version) {
        if (version == null) {
            MSVC.$$$reportNull$$$0(5);
        }
        ToolVersion toolVersion = ToolVersion.parse((String)version, (Pattern[])new Pattern[]{Pattern.compile("(\\d+\\.\\d+).*")});
        if (toolVersion == null) {
            MSVC.$$$reportNull$$$0(6);
        }
        return toolVersion;
    }

    @Override
    public final boolean supportsDebugger(@NotNull CPPDebugger.Kind debuggerKind) {
        if (debuggerKind == null) {
            MSVC.$$$reportNull$$$0(7);
        }
        return debuggerKind == CPPDebugger.Kind.BUNDLED_LLDB;
    }

    @Override
    @Nullable
    public final File getGDBPath() {
        return null;
    }

    @Override
    public final void prepareEnvironment(@NotNull GeneralCommandLine cl, @NotNull CidrToolEnvironment.PrepareFor prepareFor, @NotNull List<CPPToolSet.Option> options) throws ExecutionException {
        if (cl == null) {
            MSVC.$$$reportNull$$$0(8);
        }
        if (prepareFor == null) {
            MSVC.$$$reportNull$$$0(9);
        }
        if (options == null) {
            MSVC.$$$reportNull$$$0(10);
        }
        if (prepareFor == CidrToolEnvironment.PrepareFor.BUILD) {
            Triple<Arch, Platform, Version> apv = MSVC.getOptions(options);
            ArrayList<String> args = new ArrayList<String>();
            args.add(apv.component1() != null ? ((Arch)apv.component1()).getValue() : "x86");
            ContainerUtil.addIfNotNull(args, apv.component2() != null ? ((Platform)apv.component2()).getValue() : null);
            ContainerUtil.addIfNotNull(args, apv.component3() != null ? ((Version)apv.component3()).getValue() : null);
            String cmdExePath2 = Optional.ofNullable(MSVC.getCommandExeOrNull()).orElse("cmd.exe");
            Map msvcEnvironment = CollectionFactory.createCaseInsensitiveStringMap(CLionMsvcEnvCache.getEnvironment(this.getHome().toPath(), args, cmdExePath2, this.myPropertiesProvider, this::newEnvReader));
            @NonNls String msvcPath = (String)msvcEnvironment.get("PATH");
            if (msvcPath != null) {
                MSVC.prependPathVariable(cl, msvcPath);
            }
            Map userEnvironment = CollectionFactory.createCaseInsensitiveStringMap((Map)cl.getEnvironment());
            cl.withEnvironment(msvcEnvironment).getEnvironment().putAll(userEnvironment);
        }
    }

    @Contract(value="_ -> new")
    @NotNull
    protected EnvReader newEnvReader(long timeoutMillis) {
        return new EnvReader(timeoutMillis);
    }

    @Nullable
    @NlsSafe
    private static String getCommandExeOrNull() {
        for (CLionCmdExeLocator cmdExeLocator : Arrays.asList(CLionComSpecBased.INSTANCE, CLionSystemRootBased.INSTANCE, CLionSystemDriveBased.INSTANCE)) {
            @Nullable String cmdPath = cmdExeLocator.getCmdExePath();
            if (cmdPath == null) continue;
            return cmdPath;
        }
        return null;
    }

    @NotNull
    @NlsSafe
    private static String getCommandExe() throws ExecutionException {
        String string = Optional.ofNullable(MSVC.getCommandExeOrNull()).orElseThrow(() -> new ExecutionException(ToolchainsBundle.message("msvc.error.windows.cmd.not.found.in.comspec", new Object[0])));
        if (string == null) {
            MSVC.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static OptionsConfigurable createOptionsConfigurable() {
        final List<@NlsSafe String> archs = Arrays.asList("x86", "amd64", "arm", "x86_amd64", "x86_arm", "amd64_x86", "amd64_arm");
        final List<@NlsSafe String> platforms = Arrays.asList("store", "uwp", "onecore");
        return new OptionsConfigurable(){
            private ComboBox<String> myArchComboBox;
            private ComboBox<String> myPlatformField;
            private ComboBox<String> myVersionField;

            @Override
            public JPanel createPanel(@NotNull Runnable onChange) {
                if (onChange == null) {
                    1.$$$reportNull$$$0(0);
                }
                JPanel panel = new JPanel(new GridBagLayout());
                GridBag bag = new GridBag().setDefaultInsets(0, 0, 4, 10).setDefaultAnchor(17);
                bag.nextLine();
                panel.add((Component)new JLabel(ToolchainsBundle.message("msvc.option.arch", new Object[0])), bag.next());
                panel.add((Component)new JLabel(ToolchainsBundle.message("msvc.option.platform", new Object[0])), bag.next());
                panel.add((Component)new JLabel(ToolchainsBundle.message("msvc.option.version", new Object[0])), bag.next());
                bag.nextLine();
                this.myArchComboBox = this.createComboWithElementsAndHint(onChange, archs, "x86");
                panel.add((Component)this.myArchComboBox, bag.next());
                this.myPlatformField = this.createComboWithElementsAndHint(onChange, platforms, "");
                panel.add((Component)this.myPlatformField, bag.next());
                @Nls String versionHint = ToolchainsBundle.message("msvc.option.version.hint", new Object[0]);
                this.myVersionField = this.createComboWithElementsAndHint(onChange, Collections.singletonList("8.1"), versionHint);
                this.myVersionField.setToolTipText(versionHint);
                panel.add((Component)this.myVersionField, bag.next().fillCell().coverLine().weightx(1.0).insetRight(0));
                return panel;
            }

            private ComboBox<String> createComboWithElementsAndHint(final Runnable onChange, List<String> values, @NlsContexts.HintText String hint) {
                ComboBox result = new ComboBox((ComboBoxModel)new CollectionComboBoxModel(values));
                FixedComboBoxEditor editor = new FixedComboBoxEditor();
                result.setEditor((ComboBoxEditor)editor);
                editor.getField().getEmptyText().setText(hint);
                result.setEditable(true);
                ((JTextField)editor.getEditorComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        onChange.run();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/toolchains/MSVC$1$1", "textChanged"));
                    }
                });
                return result;
            }

            @Override
            public boolean isModified(@NotNull List<CPPToolSet.Option> currentOptions) {
                if (currentOptions == null) {
                    1.$$$reportNull$$$0(1);
                }
                return !Comparing.equal(MSVC.getOptions(currentOptions), this.getFieldValues());
            }

            @Override
            @NotNull
            public Triple<Arch, Platform, Version> getFieldValues() {
                String a = this.getComboBoxValue(this.myArchComboBox);
                String p = this.getComboBoxValue(this.myPlatformField);
                String v = this.getComboBoxValue(this.myVersionField);
                return new Triple((Object)(a == null ? null : new Arch(a)), (Object)(p == null ? null : new Platform(p)), (Object)(v == null ? null : new Version(v)));
            }

            @Nullable
            public String getComboBoxValue(ComboBox<String> comboBox2) {
                return StringUtil.trim((String)StringUtil.nullize((String)((String)comboBox2.getEditor().getItem()), (boolean)true));
            }

            @Override
            @NotNull
            public List<CPPToolSet.Option> apply() {
                Triple<Arch, Platform, Version> values = this.getFieldValues();
                ArrayList<CPPToolSet.Option> result = new ArrayList<CPPToolSet.Option>(3);
                ContainerUtil.addIfNotNull(result, (Object)((Arch)values.component1()));
                ContainerUtil.addIfNotNull(result, (Object)((Platform)values.component2()));
                ContainerUtil.addIfNotNull(result, (Object)((Version)values.component3()));
                ArrayList<CPPToolSet.Option> arrayList = result;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(2);
                }
                return arrayList;
            }

            @Override
            public void reset(@NotNull List<CPPToolSet.Option> currentOptions) {
                Triple<Arch, Platform, Version> apv;
                if (currentOptions == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.myArchComboBox.setSelectedItem((apv = MSVC.getOptions(currentOptions)).component1() == null ? null : ((Arch)apv.component1()).getValue());
                this.myPlatformField.setSelectedItem(apv.component2() == null ? null : ((Platform)apv.component2()).getValue());
                this.myVersionField.setSelectedItem(apv.component3() == null ? null : ((Version)apv.component3()).getValue());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "onChange";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currentOptions";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "apply";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createPanel";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "isModified";
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "reset";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public static Triple<Arch, Platform, Version> getOptions(@NotNull List<CPPToolSet.Option> options) {
        if (options == null) {
            MSVC.$$$reportNull$$$0(12);
        }
        Arch a = null;
        Platform p = null;
        Version v = null;
        for (CPPToolSet.Option each : options) {
            if (each instanceof Arch) {
                a = (Arch)each;
            }
            if (each instanceof Platform) {
                p = (Platform)each;
            }
            if (!(each instanceof Version)) continue;
            v = (Version)each;
        }
        return new Triple(a, p, v);
    }

    @Nullable
    public static CPPToolSet.Option loadOption(@NotNull Element element) {
        if (element == null) {
            MSVC.$$$reportNull$$$0(13);
        }
        String type = element.getAttributeValue("type");
        String value = element.getAttributeValue("value");
        if (type == null || value == null) {
            return null;
        }
        switch (type) {
            case "msvc.arch": {
                return new Arch(value);
            }
            case "msvc.platform": {
                return new Platform(value);
            }
            case "version": {
                return new Version(value);
            }
        }
        return null;
    }

    public static boolean processVisualStudioInstallations(CPPToolSet.InstallationProcessor processor) {
        Processor wrappedProcessor = file -> {
            if (!file.isDirectory()) {
                return true;
            }
            boolean vcInstalled = new File((File)file, "VC").exists();
            return processor.process((File)file, vcInstalled);
        };
        for (File eachVersionDir : MSVC.sortedSubdirs(new File("C:\\Program Files (x86)\\Microsoft Visual Studio"), (f1, f2) -> -StringUtil.compareVersionNumbers((String)f1, (String)f2))) {
            if (!eachVersionDir.getName().matches("\\d+")) continue;
            for (File eachEditionDir : MSVC.sortedSubdirs(eachVersionDir, String::compareToIgnoreCase)) {
                if (wrappedProcessor.process((Object)eachEditionDir)) continue;
                return false;
            }
        }
        @NonNls String installDir = WindowsRegistryUtil.readRegistryValue((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Microsoft\\VisualStudio\\14.0", (String)"InstallDir");
        if (installDir != null && !wrappedProcessor.process((Object)new File(installDir = StringUtil.trimEnd((String)StringUtil.trimEnd((String)installDir, (String)"\\"), (String)"Common7\\IDE")))) {
            return false;
        }
        installDir = WindowsRegistryUtil.readRegistryValue((String)"HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Microsoft\\VisualStudio\\12.0\\Setup\\VS", (String)"ProductDir");
        if (installDir != null) {
            return wrappedProcessor.process((Object)new File(StringUtil.trimEnd((String)installDir, (String)"\\")));
        }
        return true;
    }

    @NotNull
    private static List<File> sortedSubdirs(@NotNull File dir, Comparator<String> comparator) {
        File[] subdirs;
        if (dir == null) {
            MSVC.$$$reportNull$$$0(14);
        }
        if ((subdirs = dir.listFiles()) != null) {
            ArrayList<File> list = new ArrayList<File>(Arrays.asList(subdirs));
            list.sort((f1, f2) -> comparator.compare(f1.getName(), f2.getName()));
            ArrayList<File> arrayList = list;
            if (arrayList == null) {
                MSVC.$$$reportNull$$$0(15);
            }
            return arrayList;
        }
        List<File> list = Collections.emptyList();
        if (list == null) {
            MSVC.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Override
    @NotNull
    public final CidrFileSeparators getSupportedFileSeparators() {
        CidrFileSeparators cidrFileSeparators = CidrFileSeparators.WINDOWS_UNIX;
        if (cidrFileSeparators == null) {
            MSVC.$$$reportNull$$$0(17);
        }
        return cidrFileSeparators;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "home";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debuggerKind";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepareFor";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseToolVersion";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandExe";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "sortedSubdirs";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFileSeparators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseToolVersion";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "supportsDebugger";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "prepareEnvironment";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOptions";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "loadOption";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sortedSubdirs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Version
    extends BasicOption {
        public static final String TYPE = "version";

        public Version(@NotNull String value) {
            if (value == null) {
                Version.$$$reportNull$$$0(0);
            }
            super(value);
        }

        @Override
        @NotNull
        protected String getType() {
            return TYPE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/cpp/toolchains/MSVC$Version", "<init>"));
        }
    }

    public static class Platform
    extends BasicOption {
        public static final String TYPE = "msvc.platform";

        public Platform(@NotNull String value) {
            if (value == null) {
                Platform.$$$reportNull$$$0(0);
            }
            super(value);
        }

        @Override
        @NotNull
        protected String getType() {
            return TYPE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/cpp/toolchains/MSVC$Platform", "<init>"));
        }
    }

    public static class Arch
    extends MSVCOption {
        public static final String TYPE = "msvc.arch";
        @NlsSafe
        public static final String DEFAULT = "x86";

        public Arch(@NotNull String value) {
            if (value == null) {
                Arch.$$$reportNull$$$0(0);
            }
            super(value);
        }

        @Override
        @NotNull
        protected String getType() {
            return TYPE;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/cpp/toolchains/MSVC$Arch", "<init>"));
        }
    }

    private static abstract class MSVCOption
    extends BasicOption {
        MSVCOption(@NotNull String value) {
            if (value == null) {
                MSVCOption.$$$reportNull$$$0(0);
            }
            super(value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/cpp/toolchains/MSVC$MSVCOption", "<init>"));
        }
    }

    protected static abstract class BasicOption
    implements CPPToolSet.Option {
        public static final String TYPE_ATTR = "type";
        public static final String VALUE_ATTR = "value";
        @NotNull
        private final String myValue;

        public BasicOption(@NotNull String value) {
            if (value == null) {
                BasicOption.$$$reportNull$$$0(0);
            }
            this.myValue = value;
        }

        @Override
        @NlsSafe
        @NotNull
        public String getValue() {
            String string = this.myValue;
            if (string == null) {
                BasicOption.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public void write(@NotNull Element element) {
            if (element == null) {
                BasicOption.$$$reportNull$$$0(2);
            }
            element.setAttribute(TYPE_ATTR, this.getType());
            element.setAttribute(VALUE_ATTR, this.myValue);
        }

        @Override
        @NotNull
        public String getUniqueID() {
            String string = this.getType() + "=" + this.myValue;
            if (string == null) {
                BasicOption.$$$reportNull$$$0(3);
            }
            return string;
        }

        @NotNull
        protected abstract String getType();

        public String toString() {
            return this.getType() + "=" + this.myValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasicOption arch = (BasicOption)o;
            return this.myValue.equals(arch.myValue);
        }

        public int hashCode() {
            return this.myValue.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = VALUE_ATTR;
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/MSVC$BasicOption";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/MSVC$BasicOption";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValue";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUniqueID";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "write";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface OptionsConfigurable {
        public JPanel createPanel(@NotNull Runnable var1);

        public boolean isModified(@NotNull List<CPPToolSet.Option> var1);

        @NotNull
        public List<CPPToolSet.Option> apply();

        public void reset(@NotNull List<CPPToolSet.Option> var1);

        public Triple<Arch, Platform, Version> getFieldValues();

        default public void disposeUIResources() {
        }
    }
}

