/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.ui.AppIcon;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.StringKt;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.ide.RestService;
import org.jetbrains.ide.RestServiceKt;
import org.jetbrains.io.Responses;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0019\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH'J\b\u0010 \u001a\u00020\u0010H%J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0015J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010&\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR/\u0010\u000e\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00110\u00110\u000f\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016RN\u0010\u0017\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00140\u0014 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00100\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/ide/RestService;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "abuseCounter", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Ljava/net/InetAddress;", "kotlin.jvm.PlatformType", "Ljava/util/concurrent/atomic/AtomicInteger;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "hostLocks", "Ljava/util/concurrent/ConcurrentMap;", "", "", "Lorg/jetbrains/annotations/NotNull;", "isBlockUnknownHosts", "", "isPrefixlessAllowed", "()Z", "trustedOrigins", "Lcom/github/benmanes/caffeine/cache/Cache;", "execute", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "getServiceName", "isHostTrusted", "isMethodSupported", "method", "Lio/netty/handler/codec/http/HttpMethod;", "isSupported", "process", "Companion", "intellij.platform.builtInServer.impl"})
public abstract class RestService
extends HttpRequestHandler {
    @NotNull
    private final Lazy gson$delegate = LazyKt.lazy((Function0)gson.2.INSTANCE);
    private final LoadingCache<InetAddress, AtomicInteger> abuseCounter = Caffeine.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)abuseCounter.1.INSTANCE);
    private final Cache<String, Boolean> trustedOrigins = Caffeine.newBuilder().maximumSize(1024L).expireAfterWrite(1L, TimeUnit.DAYS).build();
    private final ConcurrentMap<String, Object> hostLocks;
    private boolean isBlockUnknownHosts;
    @JvmField
    @NotNull
    public static final Logger LOG;
    @NotNull
    public static final String PREFIX = "api";
    @NotNull
    public static final Companion Companion;

    @NotNull
    protected final Gson getGson() {
        Lazy lazy = this.gson$delegate;
        RestService restService = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Gson)lazy.getValue();
    }

    protected boolean isPrefixlessAllowed() {
        return false;
    }

    @NlsSafe
    @NotNull
    protected abstract String getServiceName();

    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        HttpMethod httpMethod = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)httpMethod, (String)"request.method()");
        if (!this.isMethodSupported(httpMethod)) {
            return false;
        }
        String uri = request.uri();
        if (this.isPrefixlessAllowed()) {
            String string = uri;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri");
            if (HttpRequestHandler.Companion.checkPrefix(string, this.getServiceName())) {
                return true;
            }
        }
        String serviceName = this.getServiceName();
        int minLength = 5 + serviceName.length();
        if (uri.length() >= minLength && uri.charAt(0) == '/') {
            String string = uri;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri");
            if (StringsKt.regionMatches((String)string, (int)1, (String)PREFIX, (int)0, (int)PREFIX.length(), (boolean)true) && StringsKt.regionMatches((String)uri, (int)5, (String)serviceName, (int)0, (int)serviceName.length(), (boolean)true)) {
                if (uri.length() == minLength) {
                    return true;
                }
                char c = uri.charAt(minLength);
                return c == '/' || c == '?';
            }
        }
        return false;
    }

    protected boolean isMethodSupported(@NotNull HttpMethod method2) {
        Intrinsics.checkNotNullParameter((Object)method2, (String)"method");
        return method2 == HttpMethod.GET;
    }

    /*
     * Unable to fully structure code
     */
    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            v0 = context.channel().remoteAddress();
            if (v0 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.InetSocketAddress");
            }
            v1 = this.abuseCounter.get((Object)((InetSocketAddress)v0).getAddress());
            Intrinsics.checkNotNull((Object)v1);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"abuseCounter.get((contex\u2026SocketAddress).address)!!");
            counter = (AtomicInteger)v1;
            if (counter.incrementAndGet() > Registry.intValue((String)"ide.rest.api.requests.per.minute", (int)30)) {
                v2 = HttpResponseStatus.TOO_MANY_REQUESTS;
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"HttpResponseStatus.TOO_MANY_REQUESTS");
                v3 = HttpResponseStatus.OK;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"HttpResponseStatus.OK");
                v4 = RestServiceKt.orInSafeMode(v2, v3);
                v5 = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"context.channel()");
                Responses.send$default((HttpResponseStatus)v4, (Channel)v5, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
                return true;
            }
            if (!this.isHostTrusted(request, urlDecoder)) {
                v6 = HttpResponseStatus.FORBIDDEN;
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"HttpResponseStatus.FORBIDDEN");
                v7 = HttpResponseStatus.OK;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"HttpResponseStatus.OK");
                v8 = RestServiceKt.orInSafeMode(v6, v7);
                v9 = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"context.channel()");
                Responses.send$default((HttpResponseStatus)v8, (Channel)v9, (HttpRequest)((HttpRequest)request), null, null, (int)12, null);
                return true;
            }
            error = this.execute(urlDecoder, request, context);
            if (error != null) {
                v10 = HttpResponseStatus.BAD_REQUEST;
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"HttpResponseStatus.BAD_REQUEST");
                v11 = context.channel();
                Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"context.channel()");
                Responses.send$default((HttpResponseStatus)v10, (Channel)v11, (HttpRequest)((HttpRequest)request), (String)error, null, (int)8, null);
            }
        }
        catch (Throwable e) {
            status = null;
            if (e instanceof MalformedJsonException) ** GOTO lbl-1000
            if (e instanceof IllegalStateException) {
                v12 = e.getMessage();
                Intrinsics.checkNotNull((Object)v12);
                ** if (!StringsKt.startsWith$default((String)v12, (String)"Expected a ", (boolean)false, (int)2, null)) goto lbl-1000
            }
            ** GOTO lbl-1000
lbl-1000:
            // 2 sources

            {
                RestService.LOG.warn(e);
                status = HttpResponseStatus.BAD_REQUEST;
                ** GOTO lbl54
            }
lbl-1000:
            // 2 sources

            {
                RestService.LOG.error(e);
                status = HttpResponseStatus.INTERNAL_SERVER_ERROR;
            }
lbl54:
            // 2 sources

            v13 = status;
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"status");
            v14 = context.channel();
            Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"context.channel()");
            Responses.send$default((HttpResponseStatus)v13, (Channel)v14, (HttpRequest)((HttpRequest)request), (String)ExceptionUtil.getThrowableText((Throwable)e), null, (int)8, null);
        }
        return true;
    }

    protected boolean isHostTrusted(@NotNull FullHttpRequest request, @NotNull QueryStringDecoder urlDecoder) throws InterruptedException, InvocationTargetException {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
        return this.isHostTrusted(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated(message="Use {@link #isHostTrusted(FullHttpRequest, QueryStringDecoder)}")
    protected boolean isHostTrusted(@NotNull FullHttpRequest request) throws InterruptedException, InvocationTargetException {
        Object lock2;
        String string;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (BuiltInWebServerKt.isSignedRequest((HttpRequest)request)) return true;
        if (this.isOriginAllowed((HttpRequest)request) == HttpRequestHandler.OriginCheckResult.ALLOW) {
            return true;
        }
        String string2 = NettyKt.getOrigin((HttpRequest)((HttpRequest)request));
        if (string2 == null) {
            string2 = NettyKt.getReferrer((HttpRequest)((HttpRequest)request));
        }
        String referrer = string2;
        try {
            string = referrer == null ? null : StringKt.nullize$default((String)new URI(referrer).getHost(), (boolean)false, (int)1, null);
        }
        catch (URISyntaxException ignored) {
            return false;
        }
        String host = string;
        String string3 = host;
        if (string3 == null) {
            string3 = "";
        }
        Object object = lock2 = this.hostLocks.computeIfAbsent(string3, isHostTrusted.lock.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lock");
        Object object2 = object;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object2) {
            void isTrusted;
            boolean bl3 = false;
            if (host != null) {
                if (NetUtils.isLocalhost((String)host)) {
                    return true;
                }
                Boolean bl4 = (Boolean)this.trustedOrigins.getIfPresent((Object)host);
                if (bl4 != null) {
                    Boolean bl5 = bl4;
                    boolean bl6 = false;
                    boolean bl7 = false;
                    Boolean it = bl5;
                    boolean bl8 = false;
                    Boolean bl9 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)bl9, (String)"it");
                    return bl9;
                }
            } else if (this.isBlockUnknownHosts) {
                return false;
            }
            Ref.BooleanRef booleanRef = new Ref.BooleanRef();
            booleanRef.element = false;
            ApplicationManager.getApplication().invokeAndWait(new Runnable((Ref.BooleanRef)isTrusted, this, host){
                final /* synthetic */ Ref.BooleanRef $isTrusted;
                final /* synthetic */ RestService this$0;
                final /* synthetic */ String $host$inlined;
                {
                    this.$isTrusted = booleanRef;
                    this.this$0 = restService;
                    this.$host$inlined = string;
                }

                public final void run() {
                    AppIcon.getInstance().requestAttention(null, true);
                    String string = this.$host$inlined != null ? IdeBundle.message((String)"warning.use.rest.api.0.and.trust.host.1", (Object[])new Object[]{this.this$0.getServiceName(), this.$host$inlined}) : IdeBundle.message((String)"warning.use.rest.api.0.and.trust.host.unknown", (Object[])new Object[]{this.this$0.getServiceName()});
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (host != null) {\n    \u2026erviceName())\n          }");
                    String message2 = string;
                    this.$isTrusted.element = ProjectUtil.showYesNoDialog(message2, "title.use.rest.api");
                    if (this.$host$inlined != null) {
                        RestService.access$getTrustedOrigins$p(this.this$0).put((Object)this.$host$inlined, (Object)this.$isTrusted.element);
                    } else if (!this.$isTrusted.element) {
                        RestService.access$setBlockUnknownHosts$p(this.this$0, ProjectUtil.showYesNoDialog(IdeBundle.message((String)"warning.use.rest.api.block.unknown.hosts", (Object[])new Object[0]), "title.use.rest.api"));
                    }
                }
            }, ModalityState.any());
            return isTrusted.element;
        }
    }

    @NonNls
    @Nullable
    public abstract String execute(@NotNull QueryStringDecoder var1, @NotNull FullHttpRequest var2, @NotNull ChannelHandlerContext var3) throws IOException;

    public RestService() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026akValueMap<String, Any>()");
        this.hostLocks = concurrentMap;
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RestService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Cache access$getTrustedOrigins$p(RestService $this) {
        return $this.trustedOrigins;
    }

    public static final /* synthetic */ boolean access$isBlockUnknownHosts$p(RestService $this) {
        return $this.isBlockUnknownHosts;
    }

    public static final /* synthetic */ void access$setBlockUnknownHosts$p(RestService $this, boolean bl) {
        $this.isBlockUnknownHosts = bl;
    }

    @JvmStatic
    public static final void activateLastFocusedFrame() {
        Companion.activateLastFocusedFrame();
    }

    @JvmStatic
    @NotNull
    public static final JsonReader createJsonReader(@NotNull FullHttpRequest request) {
        return Companion.createJsonReader(request);
    }

    @JvmStatic
    @NotNull
    public static final JsonWriter createJsonWriter(@NotNull OutputStream out) {
        return Companion.createJsonWriter(out);
    }

    @JvmStatic
    @Nullable
    public static final Project getLastFocusedOrOpenedProject() {
        return Companion.getLastFocusedOrOpenedProject();
    }

    @JvmStatic
    public static final void sendOk(@NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context2) {
        Companion.sendOk(request, context2);
    }

    @JvmStatic
    public static final void sendStatus(@NotNull HttpResponseStatus status, boolean keepAlive, @NotNull Channel channel2) {
        Companion.sendStatus(status, keepAlive, channel2);
    }

    @JvmStatic
    public static final void send(@NotNull BufferExposingByteArrayOutputStream byteOut, @NotNull HttpRequest request, @NotNull ChannelHandlerContext context2) {
        Companion.send(byteOut, request, context2);
    }

    @JvmStatic
    public static final void sendResponse(@NotNull HttpRequest request, @NotNull ChannelHandlerContext context2, @NotNull HttpResponse response) {
        Companion.sendResponse(request, context2, response);
    }

    @JvmStatic
    @Nullable
    public static final String getStringParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        return Companion.getStringParameter(name, urlDecoder);
    }

    @JvmStatic
    public static final int getIntParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        return Companion.getIntParameter(name, urlDecoder);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder, boolean defaultValue) {
        return Companion.getBooleanParameter(name, urlDecoder, defaultValue);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
        return org.jetbrains.ide.RestService$Companion.getBooleanParameter$default(Companion, name, urlDecoder, false, 4, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u0013H\u0007J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u000e\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0007J \u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\f\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0007J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0007J \u0010%\u001a\u00020\t2\u0006\u0010\f\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0007J \u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020-H\u0007R\u0015\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/jetbrains/ide/RestService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PREFIX", "", "activateLastFocusedFrame", "", "createJsonReader", "Lcom/google/gson/stream/JsonReader;", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "createJsonWriter", "Lcom/google/gson/stream/JsonWriter;", "out", "Ljava/io/OutputStream;", "getBooleanParameter", "", "name", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "defaultValue", "getIntParameter", "", "getLastFocusedOrOpenedProject", "Lcom/intellij/openapi/project/Project;", "getStringParameter", "parameterMissedErrorMessage", "send", "byteOut", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "Lio/netty/handler/codec/http/HttpRequest;", "context", "Lio/netty/channel/ChannelHandlerContext;", "sendOk", "sendResponse", "response", "Lio/netty/handler/codec/http/HttpResponse;", "sendStatus", "status", "Lio/netty/handler/codec/http/HttpResponseStatus;", "keepAlive", "channel", "Lio/netty/channel/Channel;", "intellij.platform.builtInServer.impl"})
    public static final class Companion {
        @JvmStatic
        public final void activateLastFocusedFrame() {
            block1: {
                IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
                Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getGlobalInstance()");
                IdeFrame ideFrame = ideFocusManager.getLastFocusedFrame();
                if (!(ideFrame instanceof Window)) {
                    ideFrame = null;
                }
                Window window = (Window)ideFrame;
                if (window == null) break block1;
                window.toFront();
            }
        }

        @JvmStatic
        @NotNull
        public final JsonReader createJsonReader(@NotNull FullHttpRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            InputStream inputStream2 = (InputStream)new ByteBufInputStream(request.content());
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(inputStream2, charset));
            reader.setLenient(true);
            return reader;
        }

        @JvmStatic
        @NotNull
        public final JsonWriter createJsonWriter(@NotNull OutputStream out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            OutputStream outputStream = out;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter(outputStream, charset));
            writer.setIndent("  ");
            return writer;
        }

        @JvmStatic
        @Nullable
        public final Project getLastFocusedOrOpenedProject() {
            IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
            Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getGlobalInstance()");
            IdeFrame ideFrame = ideFocusManager.getLastFocusedFrame();
            if (ideFrame == null || (ideFrame = ideFrame.getProject()) == null) {
                ProjectManager projectManager = ProjectManager.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)projectManager, (String)"ProjectManager.getInstance()");
                Object[] objectArray = projectManager.getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"ProjectManager.getInstance().openProjects");
                ideFrame = (Project)ArraysKt.firstOrNull((Object[])objectArray);
            }
            return ideFrame;
        }

        @JvmStatic
        public final void sendOk(@NotNull FullHttpRequest request, @NotNull ChannelHandlerContext context2) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;
            Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"HttpResponseStatus.OK");
            boolean bl = HttpUtil.isKeepAlive((HttpMessage)((HttpMessage)request));
            Channel channel2 = context2.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"context.channel()");
            this.sendStatus(httpResponseStatus, bl, channel2);
        }

        @JvmStatic
        public final void sendStatus(@NotNull HttpResponseStatus status, boolean keepAlive, @NotNull Channel channel2) {
            Intrinsics.checkNotNullParameter((Object)status, (String)"status");
            Intrinsics.checkNotNullParameter((Object)channel2, (String)"channel");
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
            HttpUtil.setContentLength((HttpMessage)((HttpMessage)response), (long)0L);
            Responses.addCommonHeaders((HttpResponse)((HttpResponse)response));
            Responses.addNoCache((HttpResponse)((HttpResponse)response));
            if (keepAlive) {
                HttpUtil.setKeepAlive((HttpMessage)((HttpMessage)response), (boolean)true);
            }
            response.headers().set("X-Frame-Options", (Object)"Deny");
            Responses.send((HttpResponse)((HttpResponse)response), (Channel)channel2, (!keepAlive ? 1 : 0) != 0);
        }

        @JvmStatic
        public final void send(@NotNull BufferExposingByteArrayOutputStream byteOut, @NotNull HttpRequest request, @NotNull ChannelHandlerContext context2) {
            Intrinsics.checkNotNullParameter((Object)byteOut, (String)"byteOut");
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            FullHttpResponse response = Responses.response((String)"application/json", (ByteBuf)Unpooled.wrappedBuffer((byte[])byteOut.getInternalBuffer(), (int)0, (int)byteOut.size()));
            this.sendResponse(request, context2, (HttpResponse)response);
        }

        @JvmStatic
        public final void sendResponse(@NotNull HttpRequest request, @NotNull ChannelHandlerContext context2, @NotNull HttpResponse response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Responses.addNoCache((HttpResponse)response);
            response.headers().set("X-Frame-Options", (Object)"Deny");
            Channel channel2 = context2.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"context.channel()");
            Responses.send$default((HttpResponse)response, (Channel)channel2, (HttpRequest)request, null, (int)4, null);
        }

        @JvmStatic
        @Nullable
        public final String getStringParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            List list2 = (List)urlDecoder.parameters().get(name);
            return list2 != null ? (String)CollectionsKt.lastOrNull((List)list2) : null;
        }

        @JvmStatic
        public final int getIntParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            return StringUtilRt.parseInt((String)StringKt.nullize((String)this.getStringParameter(name, urlDecoder), (boolean)true), (int)-1);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder, boolean defaultValue) {
            String value2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)urlDecoder, (String)"urlDecoder");
            List list2 = (List)urlDecoder.parameters().get(name);
            if (list2 == null) {
                return defaultValue;
            }
            List values2 = list2;
            String string = (String)CollectionsKt.lastOrNull((List)values2);
            if (string == null) {
                return true;
            }
            String string2 = value2 = string;
            boolean bl = false;
            return Boolean.parseBoolean(string2);
        }

        public static /* synthetic */ boolean getBooleanParameter$default(Companion companion, String string, QueryStringDecoder queryStringDecoder, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.getBooleanParameter(string, queryStringDecoder, bl);
        }

        @JvmStatic
        @JvmOverloads
        public final boolean getBooleanParameter(@NotNull String name, @NotNull QueryStringDecoder urlDecoder) {
            return org.jetbrains.ide.RestService$Companion.getBooleanParameter$default(this, name, urlDecoder, false, 4, null);
        }

        @NotNull
        public final String parameterMissedErrorMessage(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return "Parameter \"" + name + "\" is not specified";
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

