/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.references;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.BasicAttributeValueReference;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrefixReferenceProvider
extends PsiReferenceProvider {
    private static final Logger LOG = Logger.getInstance(PrefixReferenceProvider.class);

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
        XmlAttributeValue value2;
        String s;
        int i2;
        if (element2 == null) {
            PrefixReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context2 == null) {
            PrefixReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((i2 = (s = (value2 = (XmlAttributeValue)element2).getValue()).indexOf(58)) <= 0 || s.startsWith("xml:")) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PrefixReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PrefixReference(value2, i2)};
        if (psiReferenceArray == null) {
            PrefixReferenceProvider.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PrefixReference
    extends BasicAttributeValueReference
    implements EmptyResolveMessageProvider,
    LocalQuickFixProvider {
        PrefixReference(XmlAttributeValue value2, int length) {
            super((PsiElement)value2, TextRange.from((int)1, (int)length));
        }

        @Nullable
        public PsiElement resolve() {
            String prefix2 = this.getCanonicalText();
            for (XmlTag tag2 = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class); tag2 != null; tag2 = tag2.getParentTag()) {
                if (!tag2.getLocalNamespaceDeclarations().containsKey(prefix2)) continue;
                XmlAttribute attribute = tag2.getAttribute("xmlns:" + prefix2, "");
                TextRange textRange = TextRange.from((int)"xmlns:".length(), (int)prefix2.length());
                return new SchemaPrefix(attribute, textRange, prefix2);
            }
            return null;
        }

        @Override
        public boolean isReferenceTo(@NotNull PsiElement element2) {
            PsiElement e;
            if (element2 == null) {
                PrefixReference.$$$reportNull$$$0(0);
            }
            if (element2 instanceof SchemaPrefix && element2.getContainingFile() == this.myElement.getContainingFile() && (e = this.resolve()) instanceof SchemaPrefix) {
                String s = ((SchemaPrefix)e).getName();
                return s != null && s.equals(((SchemaPrefix)element2).getName());
            }
            return super.isReferenceTo(element2);
        }

        public LocalQuickFix @Nullable [] getQuickFixes() {
            PsiElement element2 = this.getElement();
            XmlElementFactory factory2 = XmlElementFactory.getInstance((Project)element2.getProject());
            String value2 = ((XmlAttributeValue)element2).getValue();
            String[] name = value2.split(":");
            XmlTag tag2 = factory2.createTagFromText((CharSequence)("<" + (name.length > 1 ? name[1] : value2) + " />"), (Language)XMLLanguage.INSTANCE);
            return new LocalQuickFix[]{XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)tag2, this.getCanonicalText(), null)};
        }

        public boolean isSoft() {
            return false;
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            String string = RelaxngBundle.message("relaxng.annotator.unresolved-namespace-prefix", new Object[0]);
            if (string == null) {
                PrefixReference.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider$PrefixReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/intellij/plugins/relaxNG/references/PrefixReferenceProvider$PrefixReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnresolvedMessagePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

