/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupSurrounder
implements Surrounder {
    private final @NlsActions.ActionText String myTitle;
    private final String myGroupStart;

    GroupSurrounder(@NlsActions.ActionText String title2, String groupStart) {
        this.myTitle = title2;
        this.myGroupStart = groupStart;
    }

    public String getTemplateDescription() {
        return this.myTitle;
    }

    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            GroupSurrounder.$$$reportNull$$$0(0);
        }
        return elements.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements) == elements[0].getParent();
    }

    @Nullable
    public TextRange surroundElements(@NotNull Project project, @NotNull Editor editor, PsiElement @NotNull [] elements) throws IncorrectOperationException {
        if (project == null) {
            GroupSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GroupSurrounder.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            GroupSurrounder.$$$reportNull$$$0(3);
        }
        assert (elements.length == 1 || PsiTreeUtil.findCommonParent((PsiElement[])elements) == elements[0].getParent());
        PsiElement e = elements[0];
        ASTNode node2 = e.getNode();
        assert (node2 != null);
        ASTNode parent = node2.getTreeParent();
        StringBuilder s = new StringBuilder();
        for (int i2 = 0; i2 < elements.length; ++i2) {
            PsiElement element2 = elements[i2];
            if (element2 instanceof RegExpElementImpl) {
                s.append(((RegExpElementImpl)element2).getUnescapedText());
            } else {
                s.append(element2.getText());
            }
            if (i2 <= 0) continue;
            ASTNode child2 = element2.getNode();
            assert (child2 != null);
            parent.removeChild(child2);
        }
        PsiFileFactory factory2 = PsiFileFactory.getInstance((Project)project);
        PsiFile f = factory2.createFileFromText("dummy.regexp", (FileType)RegExpFileType.INSTANCE, (CharSequence)this.makeReplacement(s));
        RegExpPattern pattern = (RegExpPattern)PsiTreeUtil.getChildOfType((PsiElement)f, RegExpPattern.class);
        assert (pattern != null);
        RegExpAtom element3 = pattern.getBranches()[0].getAtoms()[0];
        if (GroupSurrounder.isInsideStringLiteral(e)) {
            Document doc = editor.getDocument();
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(doc);
            TextRange tr = e.getTextRange();
            doc.replaceString(tr.getStartOffset(), tr.getEndOffset(), (CharSequence)StringUtil.escapeStringCharacters((String)element3.getText()));
            return TextRange.from((int)e.getTextRange().getEndOffset(), (int)0);
        }
        PsiElement n = e.replace((PsiElement)element3);
        return TextRange.from((int)n.getTextRange().getEndOffset(), (int)0);
    }

    private static boolean isInsideStringLiteral(PsiElement context2) {
        while (context2 != null) {
            if (RegExpElementImpl.isLiteralExpression(context2)) {
                return true;
            }
            context2 = context2.getContext();
        }
        return false;
    }

    protected String makeReplacement(StringBuilder s) {
        return this.myGroupStart + s + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/regexp/surroundWith/GroupSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

