/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.RegExpHighlighter;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpMatch;
import org.intellij.lang.regexp.RegExpMatchResult;
import org.intellij.lang.regexp.RegExpMatcherProvider;
import org.intellij.lang.regexp.RegExpModifierProvider;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CheckRegExpForm {
    private static final Logger LOG = Logger.getInstance(CheckRegExpForm.class);
    public static final Key<Boolean> CHECK_REG_EXP_EDITOR = Key.create((String)"CHECK_REG_EXP_EDITOR");
    private static final Key<List<RegExpMatch>> LATEST_MATCHES = Key.create((String)"REG_EXP_LATEST_MATCHES");
    private static final Key<RegExpMatchResult> RESULT = Key.create((String)"REG_EXP_RESULT");
    private static final String LAST_EDITED_REGEXP = "last.edited.regexp";
    private final EditorTextField myRegExp;
    private final EditorTextField mySampleText;
    private final JPanel myRootPanel;
    private final JBLabel myRegExpIcon;
    private final JBLabel mySampleIcon;
    private final List<RangeHighlighter> mySampleHighlights;
    private RangeHighlighter myRegExpHighlight;

    public CheckRegExpForm(final @NotNull PsiFile regExpFile) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(0);
        }
        this.myRegExpIcon = new JBLabel();
        this.mySampleIcon = new JBLabel();
        this.mySampleHighlights = new SmartList();
        this.myRegExpHighlight = null;
        final Project project = regExpFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(regExpFile);
        Language language = regExpFile.getLanguage();
        LanguageFileType fileType = language instanceof RegExpLanguage ? RegExpLanguage.INSTANCE.getAssociatedFileType() : RegExpFileType.forLanguage(language);
        this.myRegExp = new EditorTextField(document, project, (FileType)fileType, false, false){
            private Disposable disposable;

            @Override
            public void addNotify() {
                super.addNotify();
                this.disposable = PluginManager.getInstance().createDisposable(CheckRegExpForm.class);
                final Editor editor = this.getEditor();
                assert (editor != null) : "editor should not be null after it has been added to a container";
                editor.getCaretModel().addCaretListener(new CaretListener(){

                    public void caretPositionChanged(@NotNull CaretEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        int offset = editor.logicalPositionToOffset(event.getNewPosition());
                        RegExpGroup group2 = CheckRegExpForm.findCapturingGroupAtOffset(regExpFile, offset);
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)regExpFile.getProject());
                        CheckRegExpForm.this.removeHighlights(highlightManager);
                        if (group2 != null) {
                            int index2 = SyntaxTraverser.psiTraverser((PsiElement)regExpFile).filter(RegExpGroup.class).indexOf(e -> e == group2) + 1;
                            CheckRegExpForm.this.highlightRegExpGroup(group2, highlightManager);
                            CheckRegExpForm.this.highlightMatchGroup(highlightManager, CheckRegExpForm.getMatches(regExpFile), index2);
                        } else {
                            CheckRegExpForm.this.highlightMatchGroup(highlightManager, CheckRegExpForm.getMatches(regExpFile), 0);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/lang/regexp/intention/CheckRegExpForm$1$1", "caretPositionChanged"));
                    }
                }, this.disposable);
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                CheckRegExpForm.this.removeHighlights(HighlightManager.getInstance((Project)regExpFile.getProject()));
                Disposer.dispose((Disposable)this.disposable);
            }

            @Override
            @NotNull
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.putUserData(CHECK_REG_EXP_EDITOR, Boolean.TRUE);
                editor.putUserData(IncrementalFindAction.SEARCH_DISABLED, Boolean.TRUE);
                editor.setEmbeddedIntoDialogWrapper(true);
                EditorEx editorEx = editor;
                if (editorEx == null) {
                    1.$$$reportNull$$$0(0);
                }
                return editorEx;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.setupBorder(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/intention/CheckRegExpForm$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEditor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/intention/CheckRegExpForm$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "updateBorder";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        CheckRegExpForm.setupIcon(this.myRegExp, (JComponent)this.myRegExpIcon);
        String sampleText = PropertiesComponent.getInstance((Project)project).getValue(LAST_EDITED_REGEXP, RegExpBundle.message("checker.sample.text", new Object[0]));
        this.mySampleText = new EditorTextField(sampleText, project, (FileType)PlainTextFileType.INSTANCE){
            private Disposable disposable;

            @Override
            public void addNotify() {
                super.addNotify();
                this.disposable = PluginManager.getInstance().createDisposable(CheckRegExpForm.class);
                final Editor editor = this.getEditor();
                assert (editor != null) : "editor should not be null after it has been added to a container";
                editor.getCaretModel().addCaretListener(new CaretListener(){

                    public void caretPositionChanged(@NotNull CaretEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        int offset = editor.logicalPositionToOffset(event.getNewPosition());
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)regExpFile.getProject());
                        CheckRegExpForm.this.removeHighlights(highlightManager);
                        List<RegExpMatch> matches = CheckRegExpForm.getMatches(regExpFile);
                        int index2 = CheckRegExpForm.indexOfGroupAtOffset(matches, offset);
                        if (index2 > 0) {
                            @Nullable RegExpGroup group2 = (RegExpGroup)SyntaxTraverser.psiTraverser((PsiElement)regExpFile).filter(RegExpGroup.class).filter(RegExpGroup::isCapturing).get(index2 - 1);
                            CheckRegExpForm.this.highlightRegExpGroup(group2, highlightManager);
                            CheckRegExpForm.this.highlightMatchGroup(highlightManager, matches, index2);
                        } else {
                            CheckRegExpForm.this.highlightMatchGroup(highlightManager, matches, 0);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/intellij/lang/regexp/intention/CheckRegExpForm$2$1", "caretPositionChanged"));
                    }
                }, this.disposable);
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                CheckRegExpForm.this.removeHighlights(HighlightManager.getInstance((Project)regExpFile.getProject()));
                Disposer.dispose((Disposable)this.disposable);
            }

            @Override
            @NotNull
            protected EditorEx createEditor() {
                EditorEx editor = super.createEditor();
                editor.putUserData(IncrementalFindAction.SEARCH_DISABLED, Boolean.TRUE);
                editor.setEmbeddedIntoDialogWrapper(true);
                EditorEx editorEx = editor;
                if (editorEx == null) {
                    2.$$$reportNull$$$0(0);
                }
                return editorEx;
            }

            @Override
            protected void updateBorder(@NotNull EditorEx editor) {
                if (editor == null) {
                    2.$$$reportNull$$$0(1);
                }
                this.setupBorder(editor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/intellij/lang/regexp/intention/CheckRegExpForm$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createEditor";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/intellij/lang/regexp/intention/CheckRegExpForm$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "updateBorder";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        CheckRegExpForm.setupIcon(this.mySampleText, (JComponent)this.mySampleIcon);
        this.mySampleText.setOneLineMode(false);
        int preferredWidth = Math.max(JBUIScale.scale((int)250), this.myRegExp.getPreferredSize().width);
        this.myRegExp.setPreferredWidth(preferredWidth);
        this.mySampleText.setPreferredWidth(preferredWidth);
        this.myRootPanel = new JPanel(new GridBagLayout()){
            Disposable disposable;
            Alarm updater;

            @Override
            public void addNotify() {
                super.addNotify();
                this.disposable = Disposer.newDisposable();
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)CheckRegExpForm.this.mySampleText), true);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.myRegExp), "shift TAB", CheckRegExpForm.this.mySampleText);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.myRegExp), "TAB", CheckRegExpForm.this.mySampleText);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.mySampleText), "shift TAB", CheckRegExpForm.this.myRegExp);
                this.registerFocusShortcut((JComponent)((Object)CheckRegExpForm.this.mySampleText), "TAB", CheckRegExpForm.this.myRegExp);
                this.updater = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, this.disposable);
                DocumentListener documentListener = new DocumentListener(){

                    public void documentChanged(@NotNull DocumentEvent e) {
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.update();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/regexp/intention/CheckRegExpForm$3$1", "documentChanged"));
                    }
                };
                CheckRegExpForm.this.myRegExp.addDocumentListener(documentListener);
                CheckRegExpForm.this.mySampleText.addDocumentListener(documentListener);
                this.update();
                CheckRegExpForm.this.mySampleText.selectAll();
            }

            private void registerFocusShortcut(JComponent source, String shortcut, final EditorTextField target2) {
                AnAction action2 = new AnAction(){

                    public void actionPerformed(@NotNull AnActionEvent e) {
                        if (e == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        IdeFocusManager.findInstance().requestFocus((Component)target2.getFocusTarget(), true);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/intellij/lang/regexp/intention/CheckRegExpForm$3$2", "actionPerformed"));
                    }
                };
                action2.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{shortcut}), source);
            }

            private void update() {
                CheckRegExpForm.this.myRootPanel.revalidate();
                Balloon balloon2 = JBPopupFactory.getInstance().getParentBalloonFor((Component)CheckRegExpForm.this.myRootPanel);
                if (balloon2 != null && !balloon2.isDisposed()) {
                    balloon2.revalidate();
                }
                this.updater.cancelAllRequests();
                if (!this.updater.isDisposed()) {
                    this.updater.addRequest(() -> {
                        RegExpMatchResult result2 = CheckRegExpForm.isMatchingText(regExpFile, CheckRegExpForm.this.myRegExp.getText(), CheckRegExpForm.this.mySampleText.getText());
                        regExpFile.putUserData(RESULT, (Object)result2);
                        if (result2 != RegExpMatchResult.MATCHES && result2 != RegExpMatchResult.FOUND) {
                            CheckRegExpForm.setMatches(regExpFile, null);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> CheckRegExpForm.this.reportResult(result2, regExpFile), ModalityState.any(), __ -> this.updater.isDisposed());
                    }, 0);
                }
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)this.disposable);
                PropertiesComponent.getInstance((Project)project).setValue(CheckRegExpForm.LAST_EDITED_REGEXP, CheckRegExpForm.this.mySampleText.getText());
            }
        };
        this.myRootPanel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = JBUI.insets((int)2, (int)5);
        c.gridx = 0;
        c.gridy = 0;
        this.myRootPanel.add((Component)CheckRegExpForm.createLabel(RegExpBundle.message("label.regexp", new Object[0]), (JComponent)((Object)this.myRegExp)), c);
        c.gridx = 1;
        this.myRootPanel.add((Component)((Object)this.myRegExp), c);
        c.gridx = 0;
        ++c.gridy;
        this.myRootPanel.add((Component)CheckRegExpForm.createLabel(RegExpBundle.message("label.sample", new Object[0]), (JComponent)((Object)this.mySampleText)), c);
        c.gridx = 1;
        this.myRootPanel.add((Component)((Object)this.mySampleText), c);
    }

    private static int indexOfGroupAtOffset(List<RegExpMatch> matches, int offset) {
        int index2 = -1;
        block0: for (RegExpMatch match : matches) {
            int count = match.count();
            for (int i2 = 0; i2 < count; ++i2) {
                int start2 = match.start(i2);
                if (start2 <= offset && match.end(i2) >= offset) {
                    index2 = i2;
                    continue;
                }
                if (start2 > offset) continue block0;
            }
        }
        return index2;
    }

    private static RegExpGroup findCapturingGroupAtOffset(@NotNull PsiFile regExpFile, int offset) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(1);
        }
        RegExpGroup group2 = null;
        for (PsiElement element2 = regExpFile.findElementAt(offset); element2 != null; element2 = element2.getParent()) {
            RegExpGroup g;
            if (!(element2 instanceof RegExpGroup) || !(g = (RegExpGroup)element2).isCapturing()) continue;
            group2 = g;
            break;
        }
        return group2;
    }

    private void highlightMatchGroup(HighlightManager highlightManager, List<RegExpMatch> matches, int group2) {
        Editor editor = this.mySampleText.getEditor();
        if (editor == null) {
            return;
        }
        for (RegExpMatch match : matches) {
            int start2 = match.start(group2);
            int end = match.end(group2);
            if (group2 == 0 && start2 == 0 && end == this.mySampleText.getText().length()) continue;
            highlightManager.addRangeHighlight(editor, start2, end, RegExpHighlighter.MATCHED_GROUPS, true, this.mySampleHighlights);
        }
    }

    private void highlightRegExpGroup(RegExpGroup group2, HighlightManager highlightManager) {
        Editor editor = this.myRegExp.getEditor();
        if (editor == null) {
            return;
        }
        PsiElement[] array2 = new PsiElement[]{group2};
        SmartList highlighter = new SmartList();
        highlightManager.addOccurrenceHighlights(editor, array2, RegExpHighlighter.MATCHED_GROUPS, true, (Collection)highlighter);
        this.myRegExpHighlight = (RangeHighlighter)highlighter.get(0);
    }

    private void removeHighlights(HighlightManager highlightManager) {
        Editor sampleEditor = this.mySampleText.getEditor();
        if (sampleEditor != null) {
            for (RangeHighlighter highlighter : this.mySampleHighlights) {
                highlightManager.removeSegmentHighlighter(sampleEditor, highlighter);
            }
            this.mySampleHighlights.clear();
        }
        Editor regExpEditor = this.myRegExp.getEditor();
        if (this.myRegExpHighlight != null && regExpEditor != null) {
            highlightManager.removeSegmentHighlighter(regExpEditor, this.myRegExpHighlight);
            this.myRegExpHighlight = null;
        }
    }

    private static JLabel createLabel(@NotNull @NlsContexts.Label String labelText, @NotNull JComponent component2) {
        if (labelText == null) {
            CheckRegExpForm.$$$reportNull$$$0(2);
        }
        if (component2 == null) {
            CheckRegExpForm.$$$reportNull$$$0(3);
        }
        JLabel label2 = new JLabel(UIUtil.removeMnemonic((String)labelText));
        int index2 = UIUtil.getDisplayMnemonicIndex((String)labelText);
        if (index2 != -1) {
            label2.setDisplayedMnemonic(labelText.charAt(index2 + 1));
            label2.setDisplayedMnemonicIndex(index2);
        }
        label2.setLabelFor(component2);
        return label2;
    }

    private static void setupIcon(@NotNull EditorTextField field, @NotNull JComponent icon2) {
        if (field == null) {
            CheckRegExpForm.$$$reportNull$$$0(4);
        }
        if (icon2 == null) {
            CheckRegExpForm.$$$reportNull$$$0(5);
        }
        field.addSettingsProvider(editor -> {
            icon2.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
            JScrollPane scrollPane = editor.getScrollPane();
            scrollPane.setHorizontalScrollBarPolicy(31);
            scrollPane.setVerticalScrollBarPolicy(22);
            JScrollBar verticalScrollBar = scrollPane.getVerticalScrollBar();
            verticalScrollBar.setBackground(editor.getBackgroundColor());
            verticalScrollBar.add("JB_SCROLL_BAR_LEADING_COMPONENT", icon2);
            verticalScrollBar.setOpaque(true);
        });
    }

    void reportResult(RegExpMatchResult result2, @NotNull PsiFile regExpFile) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(6);
        }
        switch (result2) {
            case NO_MATCH: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.BalloonError, RegExpBundle.message("tooltip.no.match", new Object[0]));
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case MATCHES: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.InspectionsOK, RegExpBundle.message("tooltip.matches", new Object[0]));
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case FOUND: {
                List<RegExpMatch> matches = CheckRegExpForm.getMatches(regExpFile);
                Editor editor = this.mySampleText.getEditor();
                if (editor != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        HighlightManager highlightManager = HighlightManager.getInstance((Project)regExpFile.getProject());
                        this.removeHighlights(highlightManager);
                        this.highlightMatchGroup(highlightManager, matches, 0);
                    });
                }
                if (matches.size() > 1) {
                    CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.InspectionsOK, RegExpBundle.message("tooltip.found.multiple", matches.size()));
                } else {
                    CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.InspectionsOK, RegExpBundle.message("tooltip.found", new Object[0]));
                }
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case INCOMPLETE: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, AllIcons.General.BalloonWarning, RegExpBundle.message("tooltip.more.input.expected", new Object[0]));
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, null, null);
                break;
            }
            case BAD_REGEXP: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, null, null);
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, AllIcons.General.BalloonError, RegExpBundle.message("tooltip.bad.pattern", new Object[0]));
                break;
            }
            case TIMEOUT: {
                CheckRegExpForm.setIconAndTooltip(this.mySampleIcon, null, null);
                CheckRegExpForm.setIconAndTooltip(this.myRegExpIcon, AllIcons.General.BalloonWarning, RegExpBundle.message("tooltip.pattern.is.too.complex", new Object[0]));
            }
        }
    }

    private static void setIconAndTooltip(JBLabel label2, Icon icon2, @NlsContexts.Tooltip String tooltip2) {
        label2.setIcon(icon2);
        label2.setToolTipText(tooltip2);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.mySampleText;
        if (editorTextField == null) {
            CheckRegExpForm.$$$reportNull$$$0(7);
        }
        return editorTextField;
    }

    @NotNull
    public JPanel getRootPanel() {
        JPanel jPanel2 = this.myRootPanel;
        if (jPanel2 == null) {
            CheckRegExpForm.$$$reportNull$$$0(8);
        }
        return jPanel2;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<RegExpMatch> getMatches(@NotNull PsiFile regExpFile) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(9);
        }
        List list2 = (List)ObjectUtils.notNull((Object)((List)regExpFile.getUserData(LATEST_MATCHES)), Collections.emptyList());
        if (list2 == null) {
            CheckRegExpForm.$$$reportNull$$$0(10);
        }
        return list2;
    }

    public static void setMatches(@NotNull PsiFile regExpFile, @Nullable List<RegExpMatch> matches) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(11);
        }
        regExpFile.putUserData(LATEST_MATCHES, matches);
    }

    @TestOnly
    public static boolean isMatchingTextTest(@NotNull PsiFile regExpFile, @NotNull String sampleText) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(12);
        }
        if (sampleText == null) {
            CheckRegExpForm.$$$reportNull$$$0(13);
        }
        return CheckRegExpForm.getMatchResult(regExpFile, sampleText) == RegExpMatchResult.MATCHES;
    }

    @TestOnly
    public static RegExpMatchResult getMatchResult(@NotNull PsiFile regExpFile, @NotNull String sampleText) {
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(14);
        }
        if (sampleText == null) {
            CheckRegExpForm.$$$reportNull$$$0(15);
        }
        return CheckRegExpForm.isMatchingText(regExpFile, regExpFile.getText(), sampleText);
    }

    static RegExpMatchResult isMatchingText(@NotNull PsiFile regExpFile, String regExpText, @NotNull String sampleText) {
        RegExpMatchResult result2;
        Language regExpFileLanguage;
        RegExpMatcherProvider matcherProvider;
        if (regExpFile == null) {
            CheckRegExpForm.$$$reportNull$$$0(16);
        }
        if (sampleText == null) {
            CheckRegExpForm.$$$reportNull$$$0(17);
        }
        if ((matcherProvider = (RegExpMatcherProvider)RegExpMatcherProvider.EP.forLanguage(regExpFileLanguage = regExpFile.getLanguage())) != null && (result2 = (RegExpMatchResult)((Object)ReadAction.compute(() -> {
            PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)regExpFile.getProject()).getInjectionHost((PsiElement)regExpFile);
            if (host != null) {
                return matcherProvider.matches(regExpText, regExpFile, (PsiElement)host, sampleText, 1000L);
            }
            return null;
        }))) != null) {
            return result2;
        }
        Integer patternFlags = (Integer)ReadAction.compute(() -> {
            int flags;
            block1: {
                RegExpModifierProvider provider2;
                PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)regExpFile.getProject()).getInjectionHost((PsiElement)regExpFile);
                flags = 0;
                if (host == null) break block1;
                Iterator iterator2 = RegExpModifierProvider.EP.allForLanguage(host.getLanguage()).iterator();
                while (iterator2.hasNext() && (flags = (provider2 = (RegExpModifierProvider)iterator2.next()).getFlags((PsiElement)host, regExpFile)) <= 0) {
                }
            }
            return flags;
        });
        try {
            Matcher matcher = Pattern.compile(regExpText, patternFlags).matcher(StringUtil.newBombedCharSequence((CharSequence)sampleText, (long)1000L));
            if (matcher.matches()) {
                CheckRegExpForm.setMatches(regExpFile, CheckRegExpForm.collectMatches(matcher));
                return RegExpMatchResult.MATCHES;
            }
            if (matcher.find()) {
                CheckRegExpForm.setMatches(regExpFile, CheckRegExpForm.collectMatches(matcher));
                return RegExpMatchResult.FOUND;
            }
            if (matcher.hitEnd()) {
                return RegExpMatchResult.INCOMPLETE;
            }
            return RegExpMatchResult.NO_MATCH;
        }
        catch (ProcessCanceledException ignore) {
            return RegExpMatchResult.TIMEOUT;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return RegExpMatchResult.BAD_REGEXP;
        }
    }

    private static SmartList<RegExpMatch> collectMatches(Matcher matcher) {
        SmartList matches = new SmartList();
        do {
            RegExpMatch match = new RegExpMatch();
            int count = matcher.groupCount();
            for (int i2 = 0; i2 <= count; ++i2) {
                match.add(matcher.start(i2), matcher.end(i2));
            }
            matches.add((Object)match);
        } while (matcher.find());
        return matches;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regExpFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/intention/CheckRegExpForm";
                break;
            }
            case 13: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/intention/CheckRegExpForm";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredFocusedComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findCapturingGroupAtOffset";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "reportResult";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getMatches";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setMatches";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingTextTest";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMatchResult";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isMatchingText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

