/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl.validations;

import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonErrorPriority;
import com.jetbrains.jsonSchema.extension.JsonSchemaValidation;
import com.jetbrains.jsonSchema.extension.JsonValidationHost;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectValidation
implements JsonSchemaValidation {
    public static final ObjectValidation INSTANCE = new ObjectValidation();

    @Override
    public void validate(JsonValueAdapter propValue, JsonSchemaObject schema2, JsonSchemaType schemaType, JsonValidationHost consumer, JsonComplianceCheckerOptions options2) {
        ObjectValidation.checkObject(propValue, schema2, consumer, options2);
    }

    private static void checkObject(@NotNull JsonValueAdapter value2, @NotNull JsonSchemaObject schema2, JsonValidationHost consumer, JsonComplianceCheckerOptions options2) {
        JsonObjectValueAdapter object;
        if (value2 == null) {
            ObjectValidation.$$$reportNull$$$0(0);
        }
        if (schema2 == null) {
            ObjectValidation.$$$reportNull$$$0(1);
        }
        if ((object = value2.getAsObject()) == null) {
            return;
        }
        List<JsonPropertyAdapter> propertyList = object.getPropertyList();
        HashSet<String> set2 = new HashSet<String>();
        for (JsonPropertyAdapter property2 : propertyList) {
            JsonPointerPosition step2;
            Pair<ThreeState, JsonSchemaObject> pair;
            JsonValidationHost checker;
            JsonValueAdapter nameValueAdapter;
            String name = StringUtil.notNullize((String)property2.getName());
            JsonSchemaObject jsonSchemaObject = schema2.getPropertyNamesSchema();
            if (jsonSchemaObject != null && (nameValueAdapter = property2.getNameValueAdapter()) != null && (checker = consumer.checkByMatchResult(nameValueAdapter, consumer.resolve(jsonSchemaObject), options2)) != null) {
                consumer.addErrorsFrom(checker);
            }
            if (ThreeState.NO.equals((pair = JsonSchemaVariantsTreeBuilder.doSingleStep(step2 = JsonPointerPosition.createSingleProperty(name), schema2, false)).getFirst()) && !set2.contains(name)) {
                consumer.error(JsonBundle.message("json.schema.annotation.not.allowed.property", name), property2.getDelegate(), JsonValidationError.FixableIssueKind.ProhibitedProperty, new JsonValidationError.ProhibitedPropertyIssueData(name), JsonErrorPriority.LOW_PRIORITY);
            } else if (ThreeState.UNSURE.equals(pair.getFirst())) {
                for (JsonValueAdapter propertyValue : property2.getValues()) {
                    consumer.checkObjectBySchemaRecordErrors((JsonSchemaObject)pair.getSecond(), propertyValue);
                }
            }
            set2.add(name);
        }
        if (object.shouldCheckIntegralRequirements() || options2.isForceStrict()) {
            Map<String, JsonSchemaObject> schemaDependencies;
            Map<String, List<String>> dependencies;
            Set<String> required = schema2.getRequired();
            if (required != null) {
                LinkedHashSet<String> requiredNames = new LinkedHashSet<String>(required);
                requiredNames.removeAll(set2);
                if (!requiredNames.isEmpty()) {
                    JsonValidationError.MissingMultiplePropsIssueData data2 = ObjectValidation.createMissingPropertiesData(schema2, requiredNames, consumer);
                    consumer.error(JsonBundle.message("schema.validation.missing.required.property.or.properties", data2.getMessage(false)), value2.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data2, JsonErrorPriority.MISSING_PROPS);
                }
            }
            if (schema2.getMinProperties() != null && propertyList.size() < schema2.getMinProperties()) {
                consumer.error(JsonBundle.message("schema.validation.number.of.props.less.than", schema2.getMinProperties()), value2.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            }
            if (schema2.getMaxProperties() != null && propertyList.size() > schema2.getMaxProperties()) {
                consumer.error(JsonBundle.message("schema.validation.number.of.props.greater.than", schema2.getMaxProperties()), value2.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            }
            if ((dependencies = schema2.getPropertyDependencies()) != null) {
                for (Map.Entry entry2 : dependencies.entrySet()) {
                    if (!set2.contains(entry2.getKey())) continue;
                    List list2 = (List)entry2.getValue();
                    HashSet<String> deps = new HashSet<String>(list2);
                    deps.removeAll(set2);
                    if (deps.isEmpty()) continue;
                    JsonValidationError.MissingMultiplePropsIssueData data3 = ObjectValidation.createMissingPropertiesData(schema2, deps, consumer);
                    consumer.error(JsonBundle.message("schema.validation.violated.dependency", data3.getMessage(false), entry2.getKey()), value2.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data3, JsonErrorPriority.MISSING_PROPS);
                }
            }
            if ((schemaDependencies = schema2.getSchemaDependencies()) != null) {
                for (Map.Entry<String, JsonSchemaObject> entry3 : schemaDependencies.entrySet()) {
                    if (!set2.contains(entry3.getKey())) continue;
                    consumer.checkObjectBySchemaRecordErrors(entry3.getValue(), value2);
                }
            }
        }
    }

    private static JsonValidationError.MissingMultiplePropsIssueData createMissingPropertiesData(@NotNull JsonSchemaObject schema2, HashSet<String> requiredNames, JsonValidationHost consumer) {
        if (schema2 == null) {
            ObjectValidation.$$$reportNull$$$0(2);
        }
        ArrayList<JsonValidationError.MissingPropertyIssueData> allProps = new ArrayList<JsonValidationError.MissingPropertyIssueData>();
        for (String req : requiredNames) {
            JsonSchemaObject propertySchema = ObjectValidation.resolvePropertySchema(schema2, req);
            Object defaultValue = propertySchema == null ? null : propertySchema.getDefault();
            Ref enumCount = Ref.create((Object)0);
            JsonSchemaType type = null;
            if (propertySchema != null) {
                MatchResult result2 = null;
                Object valueFromEnum = ObjectValidation.getDefaultValueFromEnum(propertySchema, (Ref<Integer>)enumCount);
                if (valueFromEnum != null) {
                    defaultValue = valueFromEnum;
                } else {
                    result2 = consumer.resolve(propertySchema);
                    if (result2.mySchemas.size() == 1 && (valueFromEnum = ObjectValidation.getDefaultValueFromEnum(result2.mySchemas.get(0), (Ref<Integer>)enumCount)) != null) {
                        defaultValue = valueFromEnum;
                    }
                }
                type = propertySchema.getType();
                if (type == null) {
                    if (result2 == null) {
                        result2 = consumer.resolve(propertySchema);
                    }
                    if (result2.mySchemas.size() == 1) {
                        type = result2.mySchemas.get(0).getType();
                    }
                }
            }
            allProps.add(new JsonValidationError.MissingPropertyIssueData(req, type, defaultValue, (Integer)enumCount.get()));
        }
        return new JsonValidationError.MissingMultiplePropsIssueData(allProps);
    }

    private static JsonSchemaObject resolvePropertySchema(@NotNull JsonSchemaObject schema2, String req) {
        if (schema2 == null) {
            ObjectValidation.$$$reportNull$$$0(3);
        }
        if (schema2.getProperties().containsKey(req)) {
            return schema2.getProperties().get(req);
        }
        JsonSchemaObject propertySchema = schema2.getMatchingPatternPropertySchema(req);
        if (propertySchema != null) {
            return propertySchema;
        }
        JsonSchemaObject additionalPropertiesSchema = schema2.getAdditionalPropertiesSchema();
        if (additionalPropertiesSchema != null) {
            return additionalPropertiesSchema;
        }
        return null;
    }

    @Nullable
    private static Object getDefaultValueFromEnum(@NotNull JsonSchemaObject propertySchema, @NotNull Ref<Integer> enumCount) {
        List<Object> enumValues;
        if (propertySchema == null) {
            ObjectValidation.$$$reportNull$$$0(4);
        }
        if (enumCount == null) {
            ObjectValidation.$$$reportNull$$$0(5);
        }
        if ((enumValues = propertySchema.getEnum()) != null) {
            enumCount.set((Object)enumValues.size());
            if (enumValues.size() == 1) {
                Object defaultObject = enumValues.get(0);
                return defaultObject instanceof String ? StringUtil.unquoteString((String)((String)defaultObject)) : defaultObject;
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySchema";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumCount";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/jsonSchema/impl/validations/ObjectValidation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkObject";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createMissingPropertiesData";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolvePropertySchema";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultValueFromEnum";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

