/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaInfo {
    @Nullable
    private final JsonSchemaFileProvider myProvider;
    @Nullable
    @NlsSafe
    private final String myUrl;
    @Nullable
    @Nls
    private String myName;
    @Nullable
    @Nls
    private String myDocumentation;
    @NotNull
    private static final Set<String> myDumbNames = ContainerUtil.set((Object[])new String[]{"schema", "lib", "cli", "packages", "master", "format", "angular", "config"});
    private static final @NotNull Map<String, @Nls String> myWeirdNames = ContainerUtil.stringMap((String[])new String[]{"http://json.schemastore.org/config", "asp.net config", "https://schemastore.azurewebsites.net/schemas/json/config.json", "asp.net config", "http://json.schemastore.org/2.0.0-csd.2.beta.2018-10-10.json", "sarif-2.0.0-csd.2.beta.2018-10-10", "https://schemastore.azurewebsites.net/schemas/json/2.0.0-csd.2.beta.2018-10-10.json", "sarif-2.0.0-csd.2.beta.2018-10-10"});

    public JsonSchemaInfo(@NotNull JsonSchemaFileProvider provider2) {
        if (provider2 == null) {
            JsonSchemaInfo.$$$reportNull$$$0(0);
        }
        this.myName = null;
        this.myDocumentation = null;
        this.myProvider = provider2;
        this.myUrl = null;
    }

    public JsonSchemaInfo(@NotNull String url) {
        if (url == null) {
            JsonSchemaInfo.$$$reportNull$$$0(1);
        }
        this.myName = null;
        this.myDocumentation = null;
        this.myUrl = url;
        this.myProvider = null;
    }

    @Nullable
    public JsonSchemaFileProvider getProvider() {
        return this.myProvider;
    }

    @NotNull
    public String getUrl(Project project) {
        if (this.myProvider != null) {
            String remoteSource = this.myProvider.getRemoteSource();
            if (remoteSource != null) {
                String string = remoteSource;
                if (string == null) {
                    JsonSchemaInfo.$$$reportNull$$$0(2);
                }
                return string;
            }
            VirtualFile schemaFile = this.myProvider.getSchemaFile();
            if (schemaFile == null) {
                return "";
            }
            if (schemaFile instanceof HttpVirtualFile) {
                String string = schemaFile.getUrl();
                if (string == null) {
                    JsonSchemaInfo.$$$reportNull$$$0(3);
                }
                return string;
            }
            return JsonSchemaInfo.getRelativePath(project, schemaFile.getPath());
        }
        assert (this.myUrl != null);
        String string = this.myUrl;
        if (string == null) {
            JsonSchemaInfo.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getDescription() {
        if (this.myProvider != null) {
            String providerName = this.myProvider.getPresentableName();
            return JsonSchemaInfo.sanitizeName(providerName);
        }
        if (this.getName() != null) {
            String string = this.getName();
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(5);
            }
            return string;
        }
        assert (this.myUrl != null);
        if (myWeirdNames.containsKey(this.myUrl)) {
            String string = myWeirdNames.get(this.myUrl);
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(6);
            }
            return string;
        }
        String url = this.myUrl.replace('\\', '/');
        String string = ContainerUtil.reverse((List)StringUtil.split((String)url, (String)"/")).stream().filter(p -> !JsonSchemaInfo.isVeryDumbName(p)).findFirst().orElse(this.myUrl);
        if (string == null) {
            JsonSchemaInfo.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    @Nls
    public String getDocumentation() {
        return this.myDocumentation;
    }

    public void setDocumentation(@Nullable @Nls String documentation) {
        this.myDocumentation = documentation;
    }

    @Nullable
    @Nls
    public String getName() {
        return this.myName;
    }

    public void setName(@Nullable @Nls String name) {
        this.myName = name;
    }

    public static boolean isVeryDumbName(@Nullable String possibleName) {
        if (StringUtil.isEmptyOrSpaces((String)possibleName) || myDumbNames.contains(possibleName)) {
            return true;
        }
        return StringUtil.split((String)possibleName, (String)".").stream().allMatch(s -> JsonSchemaType.isInteger(s));
    }

    @NotNull
    @NlsSafe
    private static String sanitizeName(@NotNull String providerName) {
        if (providerName == null) {
            JsonSchemaInfo.$$$reportNull$$$0(8);
        }
        String string = StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)providerName, (String)".json"), (String)"-schema"), (String)".schema");
        if (string == null) {
            JsonSchemaInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public JsonSchemaVersion getSchemaVersion() {
        JsonSchemaVersion jsonSchemaVersion = this.myProvider != null ? this.myProvider.getSchemaVersion() : JsonSchemaVersion.SCHEMA_4;
        if (jsonSchemaVersion == null) {
            JsonSchemaInfo.$$$reportNull$$$0(10);
        }
        return jsonSchemaVersion;
    }

    @NotNull
    public static String getRelativePath(@NotNull Project project, @NotNull String text2) {
        String path2;
        if (project == null) {
            JsonSchemaInfo.$$$reportNull$$$0(11);
        }
        if (text2 == null) {
            JsonSchemaInfo.$$$reportNull$$$0(12);
        }
        text2 = text2.trim();
        if (project.isDefault() || project.getBasePath() == null || Strings.isEmptyOrSpaces((CharSequence)text2)) {
            String string = text2;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(13);
            }
            return string;
        }
        Path file2 = Paths.get(text2, new String[0]);
        if (!file2.isAbsolute()) {
            String string = text2;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(14);
            }
            return string;
        }
        String relativePath = FileUtil.getRelativePath((String)project.getBasePath(), (String)FileUtil.toSystemIndependentName((String)file2.toString()), (char)'/');
        if (relativePath != null) {
            String string = relativePath;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(15);
            }
            return string;
        }
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByNioFile(file2);
        if (virtualFile2 == null) {
            String string = text2;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(16);
            }
            return string;
        }
        VirtualFile projectBaseDir = LocalFileSystem.getInstance().findFileByPath(project.getBasePath());
        if (projectBaseDir == null) {
            String string = text2;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(17);
            }
            return string;
        }
        if (JsonSchemaInfo.isMeaningfulAncestor(VfsUtilCore.getCommonAncestor((VirtualFile)virtualFile2, (VirtualFile)projectBaseDir)) && (path2 = VfsUtilCore.findRelativePath((VirtualFile)projectBaseDir, (VirtualFile)virtualFile2, (char)File.separatorChar)) != null) {
            String string = path2;
            if (string == null) {
                JsonSchemaInfo.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = text2;
        if (string == null) {
            JsonSchemaInfo.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static boolean isMeaningfulAncestor(@Nullable VirtualFile ancestor) {
        if (ancestor == null) {
            return false;
        }
        VirtualFile homeDir = VfsUtil.getUserHomeDir();
        return homeDir != null && VfsUtilCore.isAncestor((VirtualFile)homeDir, (VirtualFile)ancestor, (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/extension/JsonSchemaInfo";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providerName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonSchemaInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrl";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaVersion";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

