/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.arrangement;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.DefaultArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.Stack;
import com.intellij.xml.arrangement.XmlArrangementParseInfo;
import com.intellij.xml.arrangement.XmlElementArrangementEntry;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlArrangementVisitor
extends XmlElementVisitor {
    private final Stack<XmlElementArrangementEntry> myStack;
    private final XmlArrangementParseInfo myInfo;
    private final Collection<? extends TextRange> myRanges;

    public XmlArrangementVisitor(@NotNull XmlArrangementParseInfo info2, @NotNull Collection<? extends TextRange> ranges) {
        if (info2 == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(0);
        }
        if (ranges == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(1);
        }
        this.myStack = new Stack();
        this.myInfo = info2;
        this.myRanges = ranges;
    }

    public void visitXmlFile(XmlFile file2) {
        XmlDocument document = file2.getDocument();
        List tags = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)document, XmlTag.class);
        for (XmlTag tag2 : tags) {
            if (tag2 == null) continue;
            tag2.accept((PsiElementVisitor)this);
        }
    }

    public void visitXmlTag(XmlTag tag2) {
        XmlElementArrangementEntry entry2 = this.createNewEntry((PsiElement)tag2, StdArrangementTokens.EntryType.XML_TAG, tag2.getName(), tag2.getNamespace());
        this.processEntry(entry2, (PsiElement)tag2);
        if (entry2 != null) {
            this.postProcessTag(tag2, entry2);
        }
    }

    protected void postProcessTag(@NotNull XmlTag xmlTagValue, @NotNull XmlElementArrangementEntry entry2) {
        if (xmlTagValue == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(2);
        }
        if (entry2 == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(3);
        }
    }

    public void visitXmlAttribute(XmlAttribute attribute) {
        XmlElementArrangementEntry entry2 = this.createNewEntry((PsiElement)attribute, (ArrangementSettingsToken)StdArrangementTokens.EntryType.XML_ATTRIBUTE, attribute.getName(), attribute.getNamespace());
        this.processEntry(entry2, null);
    }

    private void processEntry(@Nullable XmlElementArrangementEntry entry2, @Nullable PsiElement nextElement) {
        if (entry2 == null || nextElement == null) {
            return;
        }
        this.myStack.push((Object)entry2);
        try {
            nextElement.acceptChildren((PsiElementVisitor)this);
        }
        finally {
            this.myStack.pop();
        }
    }

    @Nullable
    private XmlElementArrangementEntry createNewEntry(@NotNull PsiElement element2, @NotNull ArrangementSettingsToken type, @Nullable String name, @Nullable String namespace) {
        TextRange range2;
        if (element2 == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(4);
        }
        if (type == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(5);
        }
        if ((range2 = element2.getTextRange()).getStartOffset() == 0 && range2.getEndOffset() == 0 || !this.isWithinBounds(range2)) {
            return null;
        }
        DefaultArrangementEntry current2 = this.getCurrent();
        if (current2 != null && type == StdArrangementTokens.EntryType.XML_ATTRIBUTE) {
            current2 = (ArrangementEntry)current2.getChildren().get(0);
        }
        XmlElementArrangementEntry entry2 = new XmlElementArrangementEntry((ArrangementEntry)current2, range2, type, name, namespace, true);
        if (type == StdArrangementTokens.EntryType.XML_TAG) {
            ASTNode startName = XmlChildRole.START_TAG_NAME_FINDER.findChild(element2.getNode());
            assert (startName != null);
            ASTNode end = XmlChildRole.START_TAG_END_FINDER.findChild(element2.getNode());
            end = end == null ? XmlChildRole.EMPTY_TAG_END_FINDER.findChild(element2.getNode()) : end;
            UnfairTextRange attributesRange = new UnfairTextRange(startName.getTextRange().getEndOffset(), end != null ? end.getStartOffset() : range2.getEndOffset());
            if (attributesRange.getLength() > 0) {
                entry2.addChild((ArrangementEntry)new XmlElementArrangementEntry((ArrangementEntry)entry2, (TextRange)attributesRange, (ArrangementSettingsToken)StdArrangementTokens.EntryType.XML_ATTRIBUTE, null, null, false));
            }
        }
        if (current2 == null) {
            this.myInfo.addEntry(entry2);
        } else {
            current2.addChild((ArrangementEntry)entry2);
        }
        return entry2;
    }

    @Nullable
    private DefaultArrangementEntry getCurrent() {
        return this.myStack.isEmpty() ? null : (DefaultArrangementEntry)this.myStack.peek();
    }

    private boolean isWithinBounds(@NotNull TextRange range2) {
        if (range2 == null) {
            XmlArrangementVisitor.$$$reportNull$$$0(6);
        }
        for (TextRange textRange : this.myRanges) {
            if (!textRange.intersects(range2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTagValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/arrangement/XmlArrangementVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessTag";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewEntry";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isWithinBounds";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

