/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.actions.xmlbeans.FileUtils;
import com.intellij.xml.actions.xmlbeans.GenerateInstanceDocumentFromSchemaDialog;
import com.intellij.xml.actions.xmlbeans.Xsd2InstanceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class GenerateInstanceDocumentFromSchemaAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateInstanceDocumentFromSchemaAction.$$$reportNull$$$0(0);
        }
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean enabled = GenerateInstanceDocumentFromSchemaAction.isAcceptableFile(file2);
        e.getPresentation().setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(enabled);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            GenerateInstanceDocumentFromSchemaAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        VirtualFile file2 = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        GenerateInstanceDocumentFromSchemaDialog dialog2 = new GenerateInstanceDocumentFromSchemaDialog(project, file2);
        dialog2.setOkAction(() -> GenerateInstanceDocumentFromSchemaAction.doAction(project, dialog2));
        dialog2.show();
    }

    public static void doAction(Project project, GenerateInstanceDocumentFromSchemaDialog dialog2) {
        String xml;
        String pathToUse;
        FileDocumentManager.getInstance().saveAllDocuments();
        @NonNls LinkedList<Object> parameters2 = new LinkedList<Object>();
        String url = dialog2.getUrl().getText();
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)ExternalResourceManager.getInstance().getResourceLocation(url), null);
        if (relativeFile == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        PsiFile file2 = PsiManager.getInstance((Project)project).findFile(relativeFile);
        if (!(file2 instanceof XmlFile)) {
            Messages.showErrorDialog((Project)project, (String)(" (" + file2.getFileType().getDescription() + ")"), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        VirtualFile relativeFileDir = relativeFile.getParent();
        if (relativeFileDir == null) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"file.doesnt.exist", (Object[])new Object[]{url}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        if (!dialog2.enableRestrictionCheck()) {
            parameters2.add("-nopvr");
        }
        if (!dialog2.enableUniquenessCheck()) {
            parameters2.add("-noupa");
        }
        parameters2.add("-dl");
        try {
            final File tempDir = FileUtil.createTempFile((String)"xsd2inst", (String)"");
            tempDir.delete();
            tempDir.mkdir();
            pathToUse = tempDir.getPath() + File.separatorChar + Xsd2InstanceUtils.processAndSaveAllSchemas((XmlFile)file2, new HashMap<String, String>(), new Xsd2InstanceUtils.SchemaReferenceProcessor(){

                @Override
                public void processSchema(String schemaFileName, byte[] schemaContent) {
                    try {
                        String fullFileName = tempDir.getPath() + File.separatorChar + schemaFileName;
                        FileUtils.saveStreamContentAsFile(fullFileName, new ByteArrayInputStream(schemaContent));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (IOException e) {
            return;
        }
        parameters2.add(pathToUse);
        parameters2.add("-name");
        parameters2.add(dialog2.getElementName());
        try {
            xml = Xsd2InstanceUtils.generate(ArrayUtilRt.toStringArray(parameters2));
        }
        catch (IllegalArgumentException e) {
            Messages.showErrorDialog((Project)project, (String)StringUtil.getMessage((Throwable)e), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
            return;
        }
        String xmlFileName = relativeFileDir.getPath() + File.separatorChar + dialog2.getOutputFileName();
        try {
            File xmlFile = new File(xmlFileName);
            FileUtil.writeToFile((File)xmlFile, (String)xml);
            VirtualFile virtualFile2 = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(xmlFile));
            FileEditorManager.getInstance((Project)project).openFile(virtualFile2, true);
        }
        catch (IOException e) {
            Messages.showErrorDialog((Project)project, (String)XmlBundle.message((String)"could.not.save.generated.xml.document.0", (Object[])new Object[]{StringUtil.getMessage((Throwable)e)}), (String)XmlBundle.message((String)"error", (Object[])new Object[0]));
        }
    }

    static boolean isAcceptableFileForGenerateSchemaFromInstanceDocument(VirtualFile virtualFile2) {
        return virtualFile2 != null && "xsd".equalsIgnoreCase(virtualFile2.getExtension());
    }

    public static boolean isAcceptableFile(VirtualFile file2) {
        return GenerateInstanceDocumentFromSchemaAction.isAcceptableFileForGenerateSchemaFromInstanceDocument(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/xml/actions/xmlbeans/GenerateInstanceDocumentFromSchemaAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

