/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.validate;

import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.actions.validate.StdErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import com.intellij.xml.actions.validate.ValidateXmlHandler;
import org.jetbrains.annotations.NotNull;

public class ValidateXmlAction
extends AnAction {
    private static final Key<String> runningValidationKey = Key.create((String)"xml.running.validation.indicator");

    private ValidateXmlHandler getHandler(@NotNull PsiFile file2) {
        if (file2 == null) {
            ValidateXmlAction.$$$reportNull$$$0(0);
        }
        for (ValidateXmlHandler handler2 : ValidateXmlHandler.EP_NAME.getExtensionList()) {
            if (!handler2.isAvailable((XmlFile)file2)) continue;
            return handler2;
        }
        ValidateXmlActionHandler handler3 = new ValidateXmlActionHandler(true);
        handler3.setErrorReporter(new StdErrorReporter(handler3, file2, () -> this.doRunAction(file2)));
        return handler3;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile psiFile;
        if (e == null) {
            ValidateXmlAction.$$$reportNull$$$0(1);
        }
        if ((psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) != null && psiFile.getVirtualFile() != null) {
            this.doRunAction(psiFile);
        }
    }

    private void doRunAction(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ValidateXmlAction.$$$reportNull$$$0(2);
        }
        CommandProcessor.getInstance().executeCommand(psiFile.getProject(), () -> {
            Runnable action2 = () -> {
                try {
                    psiFile.putUserData(runningValidationKey, (Object)"");
                    PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitAllDocuments();
                    this.getHandler(psiFile).doValidate((XmlFile)psiFile);
                }
                finally {
                    psiFile.putUserData(runningValidationKey, null);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, this.getCommandName(), null);
    }

    @NlsContexts.Command
    private String getCommandName() {
        String text2 = this.getTemplatePresentation().getText();
        return text2 != null ? text2 : "";
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            ValidateXmlAction.$$$reportNull$$$0(3);
        }
        Presentation presentation2 = event.getPresentation();
        PsiElement psiElement = (PsiElement)event.getData(CommonDataKeys.PSI_FILE);
        boolean visible = psiElement instanceof XmlFile;
        presentation2.setVisible(visible);
        boolean enabled = psiElement instanceof XmlFile;
        if (enabled) {
            PsiFile containingFile = psiElement.getContainingFile();
            enabled = containingFile != null && containingFile.getVirtualFile() != null && (containingFile.getFileType() == XmlFileType.INSTANCE || containingFile.getFileType() == XHtmlFileType.INSTANCE) ? containingFile.getUserData(runningValidationKey) == null : false;
        }
        presentation2.setEnabled(enabled);
        if (ActionPlaces.isPopupPlace((String)event.getPlace())) {
            presentation2.setVisible(enabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/actions/validate/ValidateXmlAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doRunAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

