/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.packaging;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.webcore.packaging.PackageManagementService;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PackageManagementUsageCollector
extends CounterUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("package.management.ui", 2);
    private static final StringEventField SERVICE = EventFields.String((String)"service", Arrays.asList("Node.js", "Python", "Bower"));
    private static final EventId1<String> BROWSE_AVAILABLE_PACKAGES = GROUP.registerEvent("browseAvailablePackages", (EventField)SERVICE);
    private static final EventId1<String> INSTALL = GROUP.registerEvent("install", (EventField)SERVICE);
    private static final EventId1<String> UPGRADE = GROUP.registerEvent("upgrade", (EventField)SERVICE);
    private static final EventId1<String> UNINSTALL = GROUP.registerEvent("uninstall", (EventField)SERVICE);

    private PackageManagementUsageCollector() {
    }

    public EventLogGroup getGroup() {
        return GROUP;
    }

    public static void triggerBrowseAvailablePackagesPerformed(@NotNull Project project, @Nullable PackageManagementService service) {
        if (project == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(0);
        }
        PackageManagementUsageCollector.trigger(project, service, BROWSE_AVAILABLE_PACKAGES);
    }

    public static void triggerInstallPerformed(@NotNull Project project, @Nullable PackageManagementService service) {
        if (project == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(1);
        }
        PackageManagementUsageCollector.trigger(project, service, INSTALL);
    }

    public static void triggerUpgradePerformed(@NotNull Project project, @Nullable PackageManagementService service) {
        if (project == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(2);
        }
        PackageManagementUsageCollector.trigger(project, service, UPGRADE);
    }

    public static void triggerUninstallPerformed(@NotNull Project project, @Nullable PackageManagementService service) {
        if (project == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(3);
        }
        PackageManagementUsageCollector.trigger(project, service, UNINSTALL);
    }

    private static void trigger(@NotNull Project project, @Nullable PackageManagementService service, EventId1<String> event) {
        String serviceName;
        if (project == null) {
            PackageManagementUsageCollector.$$$reportNull$$$0(4);
        }
        if ((serviceName = PackageManagementUsageCollector.toKnownServiceName(service)) != null) {
            event.log(project, (Object)serviceName);
        }
    }

    @Nullable
    private static String toKnownServiceName(@Nullable PackageManagementService service) {
        if (service == null) {
            return null;
        }
        PluginInfo info2 = PluginInfoDetectorKt.getPluginInfo(service.getClass());
        return info2.isSafeToReport() ? service.getID() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/webcore/packaging/PackageManagementUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerBrowseAvailablePackagesPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerInstallPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerUpgradePerformed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerUninstallPerformed";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "trigger";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

