/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogInternalDataKeys;
import com.intellij.vcs.log.ui.actions.BooleanPropertyToggleAction;
import com.intellij.vcs.log.ui.table.column.Date;
import com.intellij.vcs.log.ui.table.column.VcsLogColumnUtilKt;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PreferCommitDateAction
extends BooleanPropertyToggleAction
implements DumbAware {
    public PreferCommitDateAction() {
        super(VcsBundle.messagePointer((String)"prefer.commit.timestamp.action.text", (Object[])new Object[0]), VcsBundle.messagePointer((String)"prefer.commit.timestamp.action.description", (Object[])new Object[0]), null);
    }

    @Override
    protected VcsLogUiProperties.VcsLogUiProperty<Boolean> getProperty() {
        return CommonUiProperties.PREFER_COMMIT_DATE;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PreferCommitDateAction.$$$reportNull$$$0(0);
        }
        super.update(e);
        VcsLogData data2 = (VcsLogData)e.getData(VcsLogInternalDataKeys.LOG_DATA);
        VcsLogUi logUi = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (data2 == null || logUi == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Map<VirtualFile, VcsLogProvider> providers = data2.getLogProviders();
        if (!PreferCommitDateAction.isCommitDateSupported(providers.values())) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Set visibleRoots = (Set)e.getData(VcsLogInternalDataKeys.VCS_LOG_VISIBLE_ROOTS);
        if (visibleRoots == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Set visibleProviders = ContainerUtil.map2SetNotNull((Collection)visibleRoots, root -> (VcsLogProvider)providers.get(root));
        if (!PreferCommitDateAction.isDateDisplayed((VcsLogUiProperties)e.getData(VcsLogInternalDataKeys.LOG_UI_PROPERTIES)) || !PreferCommitDateAction.isCommitDateSupported(visibleProviders)) {
            e.getPresentation().setEnabled(false);
        }
    }

    private static boolean isCommitDateSupported(@NotNull Collection<VcsLogProvider> providers) {
        if (providers == null) {
            PreferCommitDateAction.$$$reportNull$$$0(1);
        }
        return providers.stream().anyMatch(arg_0 -> ((VcsLogProperties.VcsLogProperty)VcsLogProperties.HAS_COMMITTER).getOrDefault(arg_0));
    }

    private static boolean isDateDisplayed(@Nullable VcsLogUiProperties properties) {
        if (properties != null && VcsLogColumnUtilKt.supportsColumnsToggling(properties)) {
            return VcsLogColumnUtilKt.isVisible(Date.INSTANCE, properties);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/actions/PreferCommitDateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isCommitDateSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

