/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairFunction;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.history.ReachableNodesUtilKt;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.visible.VisiblePack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a,\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u00a8\u0006\f"}, d2={"isNewHistoryEnabled", "", "jumpToNearestCommit", "", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "silently", "intellij.platform.vcs.log.impl"})
public final class VcsLogFileHistoryProviderImplKt {
    public static final boolean isNewHistoryEnabled() {
        return Registry.is((String)"vcs.new.history");
    }

    private static final void jumpToNearestCommit(VcsLogUiEx $this$jumpToNearestCommit, VcsLogStorage storage2, Hash hash, VirtualFile root, boolean silently) {
        $this$jumpToNearestCommit.jumpTo(hash, (PairFunction)new PairFunction(storage2, root){
            final /* synthetic */ VcsLogStorage $storage;
            final /* synthetic */ VirtualFile $root;

            public final Integer fun(@NotNull VisiblePack visiblePack, @Nullable Hash h) {
                Integer n;
                Intrinsics.checkNotNullParameter((Object)visiblePack, (String)"visiblePack");
                Hash hash = h;
                Intrinsics.checkNotNull((Object)hash);
                if (!this.$storage.containsCommit(new CommitId(hash, this.$root))) {
                    return -1;
                }
                int commitIndex = this.$storage.getCommitIndex(h, this.$root);
                Integer rowIndex = visiblePack.getVisibleGraph().getVisibleRowIndex((Object)commitIndex);
                if (rowIndex == null) {
                    rowIndex = ReachableNodesUtilKt.findVisibleAncestorRow(commitIndex, visiblePack);
                }
                if ((n = rowIndex) == null) {
                    n = -2;
                }
                return n;
            }
            {
                this.$storage = vcsLogStorage;
                this.$root = virtualFile2;
            }
        }, (SettableFuture<? super Boolean>)SettableFuture.create(), silently, true);
    }

    public static final /* synthetic */ void access$jumpToNearestCommit(VcsLogUiEx $this$access_u24jumpToNearestCommit, VcsLogStorage storage2, Hash hash, VirtualFile root, boolean silently) {
        VcsLogFileHistoryProviderImplKt.jumpToNearestCommit($this$access_u24jumpToNearestCommit, storage2, hash, root, silently);
    }
}

