/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.ByteArrayUtils;
import org.jetbrains.annotations.NotNull;

public final class SmartDeltaCompressor
implements IntList {
    private final int mySize;
    private final byte[] myDeltas;
    private final long[] myMajorBits;
    private final long[] myMinorBits;
    private final int[] myStrongIndexes;

    @NotNull
    public static SmartDeltaCompressor newInstance(@NotNull IntList deltaList) {
        if (deltaList == null) {
            SmartDeltaCompressor.$$$reportNull$$$0(0);
        }
        if (deltaList.size() < 0) {
            throw new NegativeArraySizeException("size < 0: " + deltaList.size());
        }
        int bytesAfterCompression = ByteArrayUtils.countBytesAfterCompression(deltaList);
        byte[] deltas = new byte[bytesAfterCompression];
        int size2 = deltaList.size();
        int groundPointCount = ByteArrayUtils.groundPointCount(size2, 64);
        int[] groundIndexes = new int[groundPointCount];
        long[] majorBits = new long[groundPointCount];
        long[] minorBits = new long[groundPointCount];
        int offset = 0;
        for (int main2 = 0; main2 < groundPointCount; ++main2) {
            int index2;
            groundIndexes[main2] = offset;
            for (int rem = 0; rem < 64 && (index2 = main2 * 64 + rem) < size2; ++rem) {
                int sizeOf = ByteArrayUtils.sizeOf(deltaList.get(index2));
                ByteArrayUtils.writeDelta(offset, deltaList.get(index2), sizeOf, deltas);
                long mask = 1L << rem;
                if (sizeOf == 3 || sizeOf == 4) {
                    int n = main2;
                    majorBits[n] = majorBits[n] | mask;
                }
                if (sizeOf == 2 || sizeOf == 4) {
                    int n = main2;
                    minorBits[n] = minorBits[n] | mask;
                }
                offset += sizeOf;
            }
        }
        return new SmartDeltaCompressor(size2, deltas, majorBits, minorBits, groundIndexes);
    }

    private SmartDeltaCompressor(int size2, byte[] deltas, long[] majorBits, long[] minorBits, int[] strongIndexes) {
        this.mySize = size2;
        this.myDeltas = deltas;
        this.myMajorBits = majorBits;
        this.myMinorBits = minorBits;
        this.myStrongIndexes = strongIndexes;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public int get(int index2) {
        int main2 = index2 >>> 6;
        int rem = index2 & 0x3F;
        int shift = 63 - rem;
        long major = this.myMajorBits[main2] << shift;
        long minor = this.myMinorBits[main2] << shift;
        int sizeOf = (int)(2L * (major >>> 63) + (minor >>> 63) + 1L);
        int endIndex = this.myStrongIndexes[main2] + 2 * Long.bitCount(major) + Long.bitCount(minor) + rem + 1;
        return ByteArrayUtils.readDelta(endIndex - sizeOf, sizeOf, this.myDeltas);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deltaList", "com/intellij/vcs/log/graph/utils/impl/SmartDeltaCompressor", "newInstance"));
    }
}

