/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EdgesInRowGenerator {
    private static final int CACHE_SIZE = 10;
    private static final int BLOCK_SIZE = 40;
    private final int WALK_SIZE;
    @NotNull
    private final LinearGraph myGraph;
    @NotNull
    private final SLRUMap<Integer, GraphEdges> cacheNU;
    @NotNull
    private final SLRUMap<Integer, GraphEdges> cacheND;

    public EdgesInRowGenerator(@NotNull LinearGraph graph2) {
        if (graph2 == null) {
            EdgesInRowGenerator.$$$reportNull$$$0(0);
        }
        this(graph2, 1000);
    }

    public EdgesInRowGenerator(@NotNull LinearGraph graph2, int walk_size) {
        if (graph2 == null) {
            EdgesInRowGenerator.$$$reportNull$$$0(1);
        }
        this.cacheNU = new SLRUMap(10, 20);
        this.cacheND = new SLRUMap(10, 20);
        this.myGraph = graph2;
        this.WALK_SIZE = walk_size;
    }

    @NotNull
    public Set<GraphEdge> getEdgesInRow(int rowIndex) {
        GraphEdges neighborU = this.getNeighborU(rowIndex);
        while (neighborU.myRow < rowIndex) {
            neighborU = this.oneDownStep(neighborU);
        }
        GraphEdges neighborD = this.getNeighborD(rowIndex);
        while (neighborD.myRow > rowIndex) {
            neighborD = this.oneUpStep(neighborD);
        }
        Set<GraphEdge> result2 = neighborU.myEdges;
        result2.addAll(neighborD.myEdges);
        Set<GraphEdge> set2 = result2;
        if (set2 == null) {
            EdgesInRowGenerator.$$$reportNull$$$0(2);
        }
        return set2;
    }

    public void invalidate() {
        this.cacheNU.clear();
        this.cacheND.clear();
    }

    @NotNull
    private GraphEdges getNeighborU(int rowIndex) {
        int upNeighborIndex = EdgesInRowGenerator.getUpNeighborIndex(rowIndex);
        GraphEdges graphEdges = (GraphEdges)this.cacheNU.get((Object)upNeighborIndex);
        if (graphEdges == null) {
            graphEdges = this.getUCorrectEdges(upNeighborIndex);
            this.cacheNU.put((Object)upNeighborIndex, (Object)graphEdges);
        }
        GraphEdges graphEdges2 = graphEdges.copyInstance();
        if (graphEdges2 == null) {
            EdgesInRowGenerator.$$$reportNull$$$0(3);
        }
        return graphEdges2;
    }

    @NotNull
    private GraphEdges getNeighborD(int rowIndex) {
        int downNeighborIndex = EdgesInRowGenerator.getUpNeighborIndex(rowIndex) + 40;
        if (downNeighborIndex >= this.myGraph.nodesCount()) {
            return new GraphEdges(this.myGraph.nodesCount() - 1);
        }
        GraphEdges graphEdges = (GraphEdges)this.cacheND.get((Object)downNeighborIndex);
        if (graphEdges == null) {
            graphEdges = this.getDCorrectEdges(downNeighborIndex);
            this.cacheND.put((Object)downNeighborIndex, (Object)graphEdges);
        }
        GraphEdges graphEdges2 = graphEdges.copyInstance();
        if (graphEdges2 == null) {
            EdgesInRowGenerator.$$$reportNull$$$0(4);
        }
        return graphEdges2;
    }

    private static int getUpNeighborIndex(int rowIndex) {
        return rowIndex / 40 * 40;
    }

    @NotNull
    private GraphEdges getUCorrectEdges(int rowIndex) {
        int startCalculateIndex = Math.max(rowIndex - this.WALK_SIZE, 0);
        GraphEdges graphEdges = new GraphEdges(startCalculateIndex);
        for (int i2 = startCalculateIndex; i2 < rowIndex; ++i2) {
            graphEdges = this.oneDownStep(graphEdges);
        }
        GraphEdges graphEdges2 = graphEdges;
        if (graphEdges2 == null) {
            EdgesInRowGenerator.$$$reportNull$$$0(5);
        }
        return graphEdges2;
    }

    @NotNull
    private GraphEdges getDCorrectEdges(int rowIndex) {
        int endCalculateIndex = Math.min(rowIndex + this.WALK_SIZE, this.myGraph.nodesCount() - 1);
        GraphEdges graphEdges = new GraphEdges(endCalculateIndex);
        for (int i2 = endCalculateIndex; i2 > rowIndex; --i2) {
            graphEdges = this.oneUpStep(graphEdges);
        }
        GraphEdges graphEdges2 = graphEdges;
        if (graphEdges2 == null) {
            EdgesInRowGenerator.$$$reportNull$$$0(6);
        }
        return graphEdges2;
    }

    @NotNull
    private GraphEdges oneDownStep(@NotNull GraphEdges graphEdges) {
        if (graphEdges == null) {
            EdgesInRowGenerator.$$$reportNull$$$0(7);
        }
        Set<GraphEdge> edgesInCurrentRow = graphEdges.myEdges;
        int currentRow = graphEdges.myRow;
        edgesInCurrentRow.addAll(this.createDownEdges(currentRow));
        edgesInCurrentRow.removeAll(this.createUpEdges(currentRow + 1));
        return new GraphEdges(edgesInCurrentRow, currentRow + 1);
    }

    @NotNull
    private GraphEdges oneUpStep(@NotNull GraphEdges graphEdges) {
        if (graphEdges == null) {
            EdgesInRowGenerator.$$$reportNull$$$0(8);
        }
        Set<GraphEdge> edgesInCurrentRow = graphEdges.myEdges;
        int currentRow = graphEdges.myRow;
        edgesInCurrentRow.addAll(this.createUpEdges(currentRow));
        edgesInCurrentRow.removeAll(this.createDownEdges(currentRow - 1));
        return new GraphEdges(edgesInCurrentRow, currentRow - 1);
    }

    public List<GraphEdge> createUpEdges(int nodeIndex) {
        return this.myGraph.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_UP);
    }

    public List<GraphEdge> createDownEdges(int nodeIndex) {
        return this.myGraph.getAdjacentEdges(nodeIndex, EdgeFilter.NORMAL_DOWN);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphEdges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgesInRow";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNeighborU";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNeighborD";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUCorrectEdges";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDCorrectEdges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "oneDownStep";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "oneUpStep";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class GraphEdges {
        @NotNull
        private final Set<GraphEdge> myEdges;
        private final int myRow;

        private GraphEdges(int row2) {
            this(new HashSet<GraphEdge>(), row2);
        }

        private GraphEdges(@NotNull Set<GraphEdge> edges, int row2) {
            if (edges == null) {
                GraphEdges.$$$reportNull$$$0(0);
            }
            this.myEdges = edges;
            this.myRow = row2;
        }

        @NotNull
        GraphEdges copyInstance() {
            return new GraphEdges(new HashSet<GraphEdge>(this.myEdges), this.myRow);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edges", "com/intellij/vcs/log/graph/impl/print/EdgesInRowGenerator$GraphEdges", "<init>"));
        }
    }
}

