/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.bek;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BekChecker {
    private static final Logger LOG = Logger.getInstance(BekChecker.class);

    public static void checkLinearGraph(@NotNull LinearGraph linearGraph) {
        Pair<Integer, Integer> reversedEdge;
        if (linearGraph == null) {
            BekChecker.$$$reportNull$$$0(0);
        }
        if ((reversedEdge = BekChecker.findReversedEdge(linearGraph)) != null) {
            LOG.error("Illegal edge: up node " + reversedEdge.first + ", downNode " + reversedEdge.second);
        }
    }

    @Nullable
    public static Pair<Integer, Integer> findReversedEdge(@NotNull LinearGraph linearGraph) {
        if (linearGraph == null) {
            BekChecker.$$$reportNull$$$0(1);
        }
        for (int i2 = 0; i2 < linearGraph.nodesCount(); ++i2) {
            for (int downNode : LinearGraphUtils.getDownNodes(linearGraph, i2)) {
                if (downNode > i2) continue;
                return Pair.create((Object)i2, (Object)downNode);
            }
            for (int upNode : LinearGraphUtils.getUpNodes(linearGraph, i2)) {
                if (upNode < i2) continue;
                return Pair.create((Object)upNode, (Object)i2);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "linearGraph";
        objectArray2[1] = "com/intellij/vcs/log/graph/impl/facade/bek/BekChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLinearGraph";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findReversedEdge";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

