/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.branch;

import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.branch.BranchData;
import com.intellij.vcs.branch.BranchPresentation;
import com.intellij.vcs.branch.LinkedBranchData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0015\u0010\u0007\u001a\u00070\u0004\u00a2\u0006\u0002\b\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0016\u0010\n\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/branch/BranchPresentation;", "", "()V", "getMultiTooltip", "", "branch", "Lcom/intellij/vcs/branch/BranchData;", "getPresentableText", "Lorg/jetbrains/annotations/Nullable;", "getSingleTooltip", "getText", "branches", "", "getTooltip", "intellij.platform.vcs.impl"})
public final class BranchPresentation {
    @NotNull
    public static final BranchPresentation INSTANCE;

    @Nls
    @NotNull
    public final String getText(@NotNull Collection<? extends BranchData> branches) {
        String string;
        Intrinsics.checkNotNullParameter(branches, (String)"branches");
        Iterable $this$distinctBy$iv = branches;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            String key$iv = it.getBranchName();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        switch (distinct.size()) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = this.getPresentableText((BranchData)CollectionsKt.first((List)distinct));
                break;
            }
            default: {
                string = this.getPresentableText((BranchData)CollectionsKt.first((List)distinct)) + ",...";
            }
        }
        return string;
    }

    @Nls
    @NotNull
    public final String getPresentableText(@NotNull BranchData branch) {
        String string;
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        if (branch instanceof LinkedBranchData) {
            string = ((LinkedBranchData)branch).getBranchName();
            if (string == null) {
                string = "!";
            }
        } else {
            String string2 = branch.getBranchName();
            boolean bl = false;
            string = string2;
            if (string == null) {
                string = "";
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (branch is LinkedBran\u2026anch.branchName.orEmpty()");
        return string;
    }

    @Nls
    @Nullable
    public final String getTooltip(@NotNull Collection<? extends BranchData> branches) {
        String string;
        Intrinsics.checkNotNullParameter(branches, (String)"branches");
        Iterable $this$distinctBy$iv = branches;
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            BranchData it = (BranchData)e$iv;
            boolean bl = false;
            String string2 = it.getBranchName();
            BranchData branchData = it;
            if (!(branchData instanceof LinkedBranchData)) {
                branchData = null;
            }
            LinkedBranchData linkedBranchData = (LinkedBranchData)branchData;
            Pair key$iv = TuplesKt.to((Object)string2, (Object)(linkedBranchData != null ? linkedBranchData.getLinkedBranchName() : null));
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinct = list$iv;
        switch (distinct.size()) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = this.getSingleTooltip((BranchData)CollectionsKt.first((List)distinct));
                break;
            }
            default: {
                Iterable $this$sortedBy$iv = branches;
                boolean $i$f$sortedBy = false;
                boolean bl = false;
                string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        BranchData it = (BranchData)a;
                        boolean bl2 = false;
                        Comparable comparable = (Comparable)((Object)it.getPresentableRootName());
                        it = (BranchData)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        String string = it.getPresentableRootName();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
                    }
                }), (CharSequence)"", null, null, (int)0, null, (Function1)getTooltip.2.INSTANCE, (int)30, null);
            }
        }
        return string;
    }

    @Nls
    @Nullable
    public final String getSingleTooltip(@NotNull BranchData branch) {
        String string;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                    string = ((LinkedBranchData)branch).getLinkedBranchName();
                    if (string == null) break block3;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    string = ((LinkedBranchData)branch).getBranchName() + ' ' + UIUtil.rightArrow() + ' ' + it;
                    if (string != null) break block4;
                }
                String string3 = VcsBundle.message((String)"changes.no.tracking.branch", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VcsBundle.message(\"changes.no.tracking.branch\")");
                break block4;
            }
            string = null;
        }
        return string;
    }

    @Nls
    @NotNull
    public final String getMultiTooltip(@NotNull BranchData branch) {
        String string;
        block4: {
            block2: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
                    if (!(branch instanceof LinkedBranchData) || ((LinkedBranchData)branch).getBranchName() == null) break block2;
                    string = ((LinkedBranchData)branch).getLinkedBranchName();
                    if (string == null) break block3;
                    String string2 = string;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string2;
                    boolean bl3 = false;
                    string = ' ' + UIUtil.rightArrow() + ' ' + it;
                    if (string != null) break block4;
                }
                String string3 = VcsBundle.message((String)"changes.no.tracking.branch.suffix", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VcsBundle.message(\"chang\u2026.tracking.branch.suffix\")");
                break block4;
            }
            string = "";
        }
        String linkedBranchPart = string;
        return "<tr><td>" + branch.getPresentableRootName() + ":</td><td>" + this.getPresentableText(branch) + linkedBranchPart + "</td></tr>";
    }

    private BranchPresentation() {
    }

    static {
        BranchPresentation branchPresentation;
        INSTANCE = branchPresentation = new BranchPresentation();
    }
}

