/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.SmartList;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.ElementStub;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomStub
extends ObjectStubBase<DomStub> {
    @NotNull
    private final String myName;
    @NotNull
    private final String myLocalName;
    @Nullable
    private final String myNamespace;
    private DomInvocationHandler myHandler;

    DomStub(DomStub parent, @NotNull String name, @Nullable String namespace) {
        if (name == null) {
            DomStub.$$$reportNull$$$0(0);
        }
        super((Stub)parent);
        this.myNamespace = namespace;
        if (parent != null) {
            ((ElementStub)parent).addChild((Stub)this);
        }
        this.myName = name;
        this.myLocalName = StringUtil.getShortName((String)this.myName, (char)':');
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DomStub.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getNamespaceKey() {
        return this.myNamespace;
    }

    public boolean matches(XmlName name) {
        return name.getLocalName().equals(this.myLocalName) && StringUtil.notNullize((String)name.getNamespaceKey()).equals(this.getNamespaceKey());
    }

    public List<DomStub> getChildrenByName(XmlName xmlName) {
        List stubs = this.getChildrenStubs();
        if (stubs.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result2 = new SmartList();
        int size2 = stubs.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            Stub stub = (Stub)stubs.get(i2);
            if (!(stub instanceof DomStub) || !((DomStub)stub).matches(xmlName)) continue;
            result2.add((DomStub)stub);
        }
        return result2;
    }

    @Nullable
    public AttributeStub getAttributeStub(XmlName name) {
        List stubs = this.getChildrenStubs();
        if (stubs.isEmpty()) {
            return null;
        }
        int size2 = stubs.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            Stub stub = (Stub)stubs.get(i2);
            if (!(stub instanceof AttributeStub) || !((AttributeStub)stub).getName().equals(name.getLocalName())) continue;
            return (AttributeStub)stub;
        }
        return null;
    }

    @Nullable
    public ElementStub getElementStub(String name, int index2) {
        List stubs = this.getChildrenStubs();
        int i2 = 0;
        for (Stub stub : stubs) {
            if (!(stub instanceof ElementStub) || !name.equals(((ElementStub)stub).getName()) || i2++ != index2) continue;
            return (ElementStub)stub;
        }
        return null;
    }

    public synchronized DomInvocationHandler getOrCreateHandler(DomChildDescriptionImpl description2, DomManagerImpl manager2) {
        if (this.myHandler == null) {
            XmlName name = description2.getXmlName();
            EvaluatedXmlNameImpl evaluatedXmlName = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)name, (String)name.getNamespaceKey(), (boolean)true);
            this.myHandler = new CollectionElementInvocationHandler((EvaluatedXmlName)evaluatedXmlName, description2, manager2, (ElementStub)this);
        }
        return this.myHandler;
    }

    public DomInvocationHandler getHandler() {
        return this.myHandler;
    }

    public void setHandler(DomInvocationHandler handler2) {
        this.myHandler = handler2;
    }

    public boolean isCustom() {
        return false;
    }

    public abstract int getIndex();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DomStub stub = (DomStub)((Object)o);
        if (stub.getIndex() != this.getIndex()) {
            return false;
        }
        if (stub.isCustom() != this.isCustom()) {
            return false;
        }
        return Comparing.strEqual((String)stub.getName(), (String)this.getName()) && Comparing.strEqual((String)stub.getNamespaceKey(), (String)this.getNamespaceKey());
    }

    public int hashCode() {
        int result2 = this.myName.hashCode();
        result2 = 31 * result2 + (this.myNamespace == null ? 0 : this.myNamespace.hashCode());
        result2 = 31 * result2 + this.getIndex();
        result2 = 31 * result2 + (this.isCustom() ? 1 : 0);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/stubs/DomStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/stubs/DomStub";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

