/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Key;
import java.awt.FontMetrics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum SwingTextTrimmer {
    ELLIPSIS_AT_LEFT("\u2026", 2),
    ELLIPSIS_AT_RIGHT("\u2026", 4),
    ELLIPSIS_IN_CENTER("\u2026", 0),
    THREE_DOTS_AT_LEFT("...", 2),
    THREE_DOTS_AT_RIGHT("...", 4),
    THREE_DOTS_IN_CENTER("...", 0);

    public static final Key<SwingTextTrimmer> KEY;
    private final String ellipsis;
    private final int alignment;

    private SwingTextTrimmer(String ellipsis, int alignment) {
        if (ellipsis == null) {
            SwingTextTrimmer.$$$reportNull$$$0(0);
        }
        this.ellipsis = ellipsis;
        this.alignment = alignment;
    }

    @NotNull
    public String trim(@Nullable String text2, @NotNull FontMetrics metrics, int availableWidth) {
        if (metrics == null) {
            SwingTextTrimmer.$$$reportNull$$$0(1);
        }
        if (text2 == null || availableWidth <= 0) {
            return "";
        }
        if (SwingTextTrimmer.isFit(text2, metrics, availableWidth)) {
            String string = text2;
            if (string == null) {
                SwingTextTrimmer.$$$reportNull$$$0(2);
            }
            return string;
        }
        int ellipsisWidth = metrics.stringWidth(this.ellipsis);
        if (availableWidth <= ellipsisWidth) {
            String string = this.ellipsis;
            if (string == null) {
                SwingTextTrimmer.$$$reportNull$$$0(3);
            }
            return string;
        }
        int width = availableWidth - ellipsisWidth;
        if (this.alignment == 2) {
            String string = this.ellipsis + SwingTextTrimmer.trimLeft(text2, metrics, width);
            if (string == null) {
                SwingTextTrimmer.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (this.alignment == 4) {
            String string = SwingTextTrimmer.trimRight(text2, metrics, width) + this.ellipsis;
            if (string == null) {
                SwingTextTrimmer.$$$reportNull$$$0(5);
            }
            return string;
        }
        String postfix = SwingTextTrimmer.trimRight(text2, metrics, width / 2) + this.ellipsis;
        String string = postfix + SwingTextTrimmer.trimLeft(text2, metrics, availableWidth - metrics.stringWidth(postfix));
        if (string == null) {
            SwingTextTrimmer.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static boolean isFit(@NotNull String text2, @NotNull FontMetrics metrics, int width) {
        if (text2 == null) {
            SwingTextTrimmer.$$$reportNull$$$0(7);
        }
        if (metrics == null) {
            SwingTextTrimmer.$$$reportNull$$$0(8);
        }
        return text2.isEmpty() || metrics.stringWidth(text2) <= width;
    }

    @NotNull
    private static String trimLeft(@NotNull String text2, @NotNull FontMetrics metrics, int width) {
        if (text2 == null) {
            SwingTextTrimmer.$$$reportNull$$$0(9);
        }
        if (metrics == null) {
            SwingTextTrimmer.$$$reportNull$$$0(10);
        }
        int min = 0;
        int max = text2.length();
        while (true) {
            int pos = max - (max - min) / 2;
            String str = text2.substring(pos);
            if (pos == max) {
                String string = str;
                if (string == null) {
                    SwingTextTrimmer.$$$reportNull$$$0(11);
                }
                return string;
            }
            if (SwingTextTrimmer.isFit(str, metrics, width)) {
                max = pos;
                continue;
            }
            min = pos;
        }
    }

    @NotNull
    private static String trimRight(@NotNull String text2, @NotNull FontMetrics metrics, int width) {
        if (text2 == null) {
            SwingTextTrimmer.$$$reportNull$$$0(12);
        }
        if (metrics == null) {
            SwingTextTrimmer.$$$reportNull$$$0(13);
        }
        int min = 0;
        int max = text2.length();
        while (true) {
            int pos = min + (max - min) / 2;
            String str = text2.substring(0, pos);
            if (pos == min) {
                String string = str;
                if (string == null) {
                    SwingTextTrimmer.$$$reportNull$$$0(14);
                }
                return string;
            }
            if (SwingTextTrimmer.isFit(str, metrics, width)) {
                min = pos;
                continue;
            }
            max = pos;
        }
    }

    static {
        KEY = Key.create((String)SwingTextTrimmer.class.getSimpleName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ellipsis";
                break;
            }
            case 1: 
            case 8: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metrics";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/SwingTextTrimmer";
                break;
            }
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/SwingTextTrimmer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeft";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "trimRight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isFit";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "trimLeft";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "trimRight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

