/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.UiActivity;
import com.intellij.ide.UiActivityMonitor;
import com.intellij.ide.actions.WindowAction;
import com.intellij.ide.ui.PopupLocationTracker;
import com.intellij.ide.ui.ScreenAreaConsumer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.MnemonicHelper;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.actionSystem.impl.AutoPopupSupportingListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindow;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.MaskProvider;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.ui.popup.StackingPopupDispatcher;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.LightColors;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.PopupBorder;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.TitlePanel;
import com.intellij.ui.UiInterceptors;
import com.intellij.ui.WindowMoveListener;
import com.intellij.ui.WindowResizeListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.mac.touchbar.TouchbarSupport;
import com.intellij.ui.popup.PopupComponent;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.ui.speedSearch.SpeedSearch;
import com.intellij.util.Alarm;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import com.intellij.util.ui.ChildFocusWatcher;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ScrollUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicHTML;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractPopup
implements JBPopup,
ScreenAreaConsumer {
    @NonNls
    public static final String SHOW_HINTS = "ShowHints";
    @NonNls
    public static final String FIRST_TIME_SIZE = "FirstTimeSize";
    private static final Logger LOG = Logger.getInstance(AbstractPopup.class);
    private PopupComponent myPopup;
    private MyContentPanel myContent;
    private JComponent myPreferredFocusedComponent;
    private boolean myRequestFocus;
    private boolean myFocusable;
    private boolean myForcedHeavyweight;
    private boolean myLocateWithinScreen;
    private boolean myResizable;
    private WindowResizeListener myResizeListener;
    private WindowMoveListener myMoveListener;
    private JPanel myHeaderPanel;
    private CaptionPanel myCaption;
    private JComponent myComponent;
    private SpeedSearch mySpeedSearchFoundInRootComponent;
    private String myDimensionServiceKey;
    private Computable<Boolean> myCallBack;
    private Project myProject;
    private boolean myCancelOnClickOutside;
    private final List<JBPopupListener> myListeners = new CopyOnWriteArrayList<JBPopupListener>();
    private boolean myUseDimServiceForXYLocation;
    private MouseChecker myCancelOnMouseOutCallback;
    private Canceller myMouseOutCanceller;
    private boolean myCancelOnWindow;
    private boolean myCancelOnWindowDeactivation = true;
    private Dimension myForcedSize;
    private Point myForcedLocation;
    private boolean myCancelKeyEnabled;
    private boolean myLocateByContent;
    private Dimension myMinSize;
    private List<Object> myUserData;
    private boolean myShadowed;
    private float myAlpha;
    private float myLastAlpha;
    private MaskProvider myMaskProvider;
    private Window myWindow;
    private boolean myInStack;
    private MyWindowListener myWindowListener;
    private boolean myModalContext;
    private Component[] myFocusOwners;
    private PopupBorder myPopupBorder;
    private Dimension myRestoreWindowSize;
    protected Component myOwner;
    private Component myRequestorComponent;
    private boolean myHeaderAlwaysFocusable;
    private boolean myMovable;
    private JComponent myHeaderComponent;
    InputEvent myDisposeEvent;
    private Runnable myFinalRunnable;
    private Runnable myOkHandler;
    @Nullable
    private BooleanFunction<? super KeyEvent> myKeyEventHandler;
    protected boolean myOk;
    private final List<Runnable> myResizeListeners = new ArrayList<Runnable>();
    private static final WeakList<JBPopup> all = new WeakList();
    private boolean mySpeedSearchAlwaysShown;
    protected final SpeedSearch mySpeedSearch = new SpeedSearch(){
        boolean searchFieldShown;

        public void update() {
            AbstractPopup.this.mySpeedSearchPatternField.getTextEditor().setBackground(UIUtil.getTextFieldBackground());
            AbstractPopup.this.onSpeedSearchPatternChanged();
            AbstractPopup.this.mySpeedSearchPatternField.setText(this.getFilter());
            if (!AbstractPopup.this.mySpeedSearchAlwaysShown) {
                if (this.isHoldingFilter() && !this.searchFieldShown) {
                    AbstractPopup.this.setHeaderComponent((JComponent)AbstractPopup.this.mySpeedSearchPatternField);
                    this.searchFieldShown = true;
                } else if (!this.isHoldingFilter() && this.searchFieldShown) {
                    AbstractPopup.this.setHeaderComponent(null);
                    this.searchFieldShown = false;
                }
            }
        }

        public void noHits() {
            AbstractPopup.this.mySpeedSearchPatternField.getTextEditor().setBackground(LightColors.RED);
        }
    };
    protected SearchTextField mySpeedSearchPatternField;
    private boolean myNativePopup;
    private boolean myMayBeParent;
    private JComponent myAdComponent;
    private boolean myDisposed;
    private boolean myNormalWindowLevel;
    private UiActivity myActivityKey;
    private Disposable myProjectDisposable;
    private volatile State myState = State.NEW;

    void setNormalWindowLevel(boolean normalWindowLevel) {
        this.myNormalWindowLevel = normalWindowLevel;
    }

    private void debugState(@NonNls @NotNull String message2, State ... states) {
        if (message2 == null) {
            AbstractPopup.$$$reportNull$$$0(0);
        }
        if (states == null) {
            AbstractPopup.$$$reportNull$$$0(1);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.hashCode() + " - " + message2);
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                LOG.debug("unexpected thread");
            }
            for (State state : states) {
                if (state != this.myState) continue;
                return;
            }
            LOG.debug((Throwable)new IllegalStateException("myState=" + this.myState));
        }
    }

    protected AbstractPopup() {
    }

    @NotNull
    protected AbstractPopup init(Project project, @NotNull JComponent component2, @Nullable JComponent preferredFocusedComponent, boolean requestFocus, boolean focusable, boolean movable, String dimensionServiceKey, boolean resizable, @NlsContexts.PopupTitle @Nullable String caption, @Nullable Computable<Boolean> callback2, boolean cancelOnClickOutside, @NotNull Set<? extends JBPopupListener> listeners2, boolean useDimServiceForXYLocation, ActiveComponent commandButton, @Nullable IconButton cancelButton, @Nullable MouseChecker cancelOnMouseOutCallback, boolean cancelOnWindow, @Nullable ActiveIcon titleIcon, boolean cancelKeyEnabled, boolean locateByContent, boolean placeWithinScreenBounds, @Nullable Dimension minSize, float alpha, @Nullable MaskProvider maskProvider, boolean inStack, boolean modalContext, Component @NotNull [] focusOwners, @Nullable @NlsContexts.PopupAdvertisement String adText, int adTextAlignment, boolean headerAlwaysFocusable, @NotNull List<? extends Pair<ActionListener, KeyStroke>> keyboardActions, Component settingsButtons, @Nullable Processor<? super JBPopup> pinCallback, boolean mayBeParent, boolean showShadow, boolean showBorder, Color borderColor, boolean cancelOnWindowDeactivation, @Nullable BooleanFunction<? super KeyEvent> keyEventHandler) {
        if (component2 == null) {
            AbstractPopup.$$$reportNull$$$0(2);
        }
        if (listeners2 == null) {
            AbstractPopup.$$$reportNull$$$0(3);
        }
        if (keyboardActions == null) {
            AbstractPopup.$$$reportNull$$$0(4);
        }
        if (focusOwners == null) {
            AbstractPopup.$$$reportNull$$$0(5);
        }
        assert (!requestFocus || focusable) : "Incorrect argument combination: requestFocus=true focusable=false";
        all.add((Object)this);
        this.myActivityKey = new UiActivity.Focus("Popup:" + this);
        this.myProject = project;
        this.myComponent = component2;
        this.mySpeedSearchFoundInRootComponent = (SpeedSearch)AbstractPopup.findInComponentHierarchy(component2, it -> it instanceof ListWithFilter ? ((ListWithFilter)it).getSpeedSearch() : null);
        this.myPopupBorder = showBorder ? (borderColor != null ? PopupBorder.Factory.createColored((Color)borderColor) : PopupBorder.Factory.create((boolean)true, (boolean)showShadow)) : PopupBorder.Factory.createEmpty();
        this.myShadowed = showShadow;
        this.myContent = this.createContentPanel(resizable, this.myPopupBorder, false);
        this.myMayBeParent = mayBeParent;
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        this.myContent.add((Component)component2, "Center");
        if (adText != null) {
            this.setAdText(adText, adTextAlignment);
        }
        this.myCancelKeyEnabled = cancelKeyEnabled;
        this.myLocateByContent = locateByContent;
        this.myLocateWithinScreen = placeWithinScreenBounds;
        this.myAlpha = alpha;
        this.myMaskProvider = maskProvider;
        this.myInStack = inStack;
        this.myModalContext = modalContext;
        this.myFocusOwners = focusOwners;
        this.myHeaderAlwaysFocusable = headerAlwaysFocusable;
        this.myMovable = movable;
        ActiveIcon actualIcon = titleIcon == null ? new ActiveIcon(EmptyIcon.ICON_0) : titleIcon;
        this.myHeaderPanel = new JPanel(new BorderLayout());
        if (caption != null) {
            if (!caption.isEmpty()) {
                this.myCaption = new TitlePanel(actualIcon.getRegular(), actualIcon.getInactive());
                ((TitlePanel)this.myCaption).setText(caption);
            } else {
                this.myCaption = new CaptionPanel();
            }
            if (pinCallback != null) {
                Icon icon2 = ToolWindowManager.getInstance((Project)(this.myProject != null ? this.myProject : ProjectUtil.guessCurrentProject((JComponent)((JComponent)this.myOwner)))).getLocationIcon("Find", AllIcons.General.Pin_tab);
                this.myCaption.setButtonComponent((ActiveComponent)new InplaceButton(new IconButton(IdeBundle.message((String)"show.in.find.window.button.name", (Object[])new Object[0]), icon2), e -> pinCallback.process((Object)this)), JBUI.Borders.empty((int)4));
            } else if (cancelButton != null) {
                this.myCaption.setButtonComponent((ActiveComponent)new InplaceButton(cancelButton, e -> this.cancel()), JBUI.Borders.empty((int)4));
            } else if (commandButton != null) {
                this.myCaption.setButtonComponent(commandButton, null);
            }
        } else {
            this.myCaption = new CaptionPanel();
            this.myCaption.setBorder(null);
            this.myCaption.setPreferredSize((Dimension)JBUI.emptySize());
        }
        this.setWindowActive(this.myHeaderAlwaysFocusable);
        this.myHeaderPanel.add((Component)this.myCaption, "North");
        this.myContent.add((Component)this.myHeaderPanel, "North");
        this.myForcedHeavyweight = true;
        this.myResizable = resizable;
        this.myPreferredFocusedComponent = preferredFocusedComponent;
        this.myRequestFocus = requestFocus;
        this.myFocusable = focusable;
        this.myDimensionServiceKey = dimensionServiceKey;
        this.myCallBack = callback2;
        this.myCancelOnClickOutside = cancelOnClickOutside;
        this.myCancelOnMouseOutCallback = cancelOnMouseOutCallback;
        this.myListeners.addAll(listeners2);
        this.myUseDimServiceForXYLocation = useDimServiceForXYLocation;
        this.myCancelOnWindow = cancelOnWindow;
        this.myMinSize = minSize;
        if (Registry.is((String)"ide.popup.horizontal.scroll.bar.opaque")) {
            this.forHorizontalScrollBar((Consumer<JScrollBar>)((Consumer)bar2 -> bar2.setOpaque(true)));
        }
        for (Pair<ActionListener, KeyStroke> pair : keyboardActions) {
            this.myContent.registerKeyboardAction((ActionListener)pair.getFirst(), (KeyStroke)pair.getSecond(), 2);
        }
        if (settingsButtons != null) {
            this.myCaption.addSettingsComponent(settingsButtons);
        }
        this.myKeyEventHandler = keyEventHandler;
        this.debugState("popup initialized", State.NEW);
        this.myState = State.INIT;
        AbstractPopup abstractPopup = this;
        if (abstractPopup == null) {
            AbstractPopup.$$$reportNull$$$0(6);
        }
        return abstractPopup;
    }

    private void setWindowActive(boolean active) {
        boolean value2;
        boolean bl = value2 = this.myHeaderAlwaysFocusable || active;
        if (this.myCaption != null) {
            this.myCaption.setActive(value2);
        }
        this.myPopupBorder.setActive(value2);
        this.myContent.repaint();
    }

    @NotNull
    protected MyContentPanel createContentPanel(boolean resizable, @NotNull PopupBorder border, boolean isToDrawMacCorner) {
        if (border == null) {
            AbstractPopup.$$$reportNull$$$0(7);
        }
        return new MyContentPanel(border);
    }

    public void setShowHints(boolean show2) {
        JRootPane rootPane;
        Window ancestor = AbstractPopup.getContentWindow(this.myComponent);
        if (ancestor instanceof RootPaneContainer && (rootPane = ((RootPaneContainer)((Object)ancestor)).getRootPane()) != null) {
            rootPane.putClientProperty(SHOW_HINTS, show2);
        }
    }

    public String getDimensionServiceKey() {
        return this.myDimensionServiceKey;
    }

    public void setDimensionServiceKey(@Nullable String dimensionServiceKey) {
        this.myDimensionServiceKey = dimensionServiceKey;
    }

    public void setAdText(@NotNull @NlsContexts.PopupAdvertisement String s) {
        if (s == null) {
            AbstractPopup.$$$reportNull$$$0(8);
        }
        this.setAdText(s, 2);
    }

    @NotNull
    public PopupBorder getPopupBorder() {
        PopupBorder popupBorder = this.myPopupBorder;
        if (popupBorder == null) {
            AbstractPopup.$$$reportNull$$$0(9);
        }
        return popupBorder;
    }

    public void setAdText(@NotNull @NlsContexts.PopupAdvertisement String s, int alignment) {
        Window popupWindow;
        JLabel label2;
        if (s == null) {
            AbstractPopup.$$$reportNull$$$0(10);
        }
        if (this.myAdComponent == null || !(this.myAdComponent instanceof JLabel)) {
            label2 = HintUtil.createAdComponent(s, JBUI.CurrentTheme.Advertiser.border(), alignment);
            this.setFooterComponent(label2);
        } else {
            label2 = (JLabel)this.myAdComponent;
        }
        JBDimension prefSize = label2.isVisible() ? this.myAdComponent.getPreferredSize() : JBUI.emptySize();
        boolean keepSize = BasicHTML.isHTMLString(s);
        label2.setVisible(StringUtil.isNotEmpty((String)s));
        label2.setText(keepSize ? s : this.wrapToSize(s));
        label2.setHorizontalAlignment(alignment);
        JBDimension newPrefSize = label2.isVisible() ? this.myAdComponent.getPreferredSize() : JBUI.emptySize();
        int delta = newPrefSize.height - prefSize.height;
        if (this.myPopup != null && !this.isBusy() && delta != 0 && !keepSize && (popupWindow = AbstractPopup.getContentWindow(this.myContent)) != null) {
            Dimension size2 = popupWindow.getSize();
            size2.height += delta;
            this.myContent.setPreferredSize(size2);
            popupWindow.pack();
            this.updateMaskAndAlpha(popupWindow);
        }
    }

    protected void setFooterComponent(JComponent c) {
        if (this.myAdComponent != null) {
            this.myContent.remove(this.myAdComponent);
        }
        this.myContent.add((Component)c, "South");
        this.pack(false, true);
        this.myAdComponent = c;
    }

    @NotNull
    @Nls
    private String wrapToSize(@NotNull @Nls String hint) {
        if (hint == null) {
            AbstractPopup.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmpty((String)hint)) {
            String string = hint;
            if (string == null) {
                AbstractPopup.$$$reportNull$$$0(12);
            }
            return string;
        }
        Dimension size2 = this.myContent.getSize();
        if (size2.width == 0 && size2.height == 0) {
            size2 = this.myContent.computePreferredSize();
        }
        JBInsets.removeFrom((Dimension)size2, (Insets)this.myContent.getInsets());
        JBInsets.removeFrom((Dimension)size2, (Insets)this.myAdComponent.getInsets());
        int width = Math.max(JBUI.CurrentTheme.Popup.minimumHintWidth(), size2.width);
        String string = HtmlChunk.text((String)hint).wrapWith(HtmlChunk.div().attr("width", width)).wrapWith(HtmlChunk.html()).toString();
        if (string == null) {
            AbstractPopup.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public static Point getCenterOf(@NotNull Component aContainer, @NotNull JComponent content2) {
        if (aContainer == null) {
            AbstractPopup.$$$reportNull$$$0(14);
        }
        if (content2 == null) {
            AbstractPopup.$$$reportNull$$$0(15);
        }
        return AbstractPopup.getCenterOf(aContainer, content2.getPreferredSize());
    }

    @NotNull
    private static Point getCenterOf(@NotNull Component aContainer, @NotNull Dimension contentSize) {
        JComponent component2;
        if (aContainer == null) {
            AbstractPopup.$$$reportNull$$$0(16);
        }
        if (contentSize == null) {
            AbstractPopup.$$$reportNull$$$0(17);
        }
        Rectangle visibleBounds = (component2 = AbstractPopup.getTargetComponent(aContainer)) != null ? component2.getVisibleRect() : new Rectangle(aContainer.getSize());
        Point containerScreenPoint = visibleBounds.getLocation();
        SwingUtilities.convertPointToScreen(containerScreenPoint, aContainer);
        visibleBounds.setLocation(containerScreenPoint);
        Point point = UIUtil.getCenterPoint((Rectangle)visibleBounds, (Dimension)contentSize);
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(18);
        }
        return point;
    }

    public void showCenteredInCurrentWindow(@NotNull Project project) {
        Component parent;
        if (project == null) {
            AbstractPopup.$$$reportNull$$$0(19);
        }
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        Window window = null;
        Component focusedComponent = AbstractPopup.getWndManager().getFocusedComponent(project);
        if (focusedComponent != null && (parent = UIUtil.findUltimateParent((Component)focusedComponent)) instanceof Window) {
            window = (Window)parent;
        }
        if (window == null) {
            window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        }
        if (window != null && window.isShowing()) {
            this.showInCenterOf(window);
        }
    }

    public void showInCenterOf(@NotNull Component aComponent) {
        if (aComponent == null) {
            AbstractPopup.$$$reportNull$$$0(20);
        }
        HelpTooltip.setMasterPopup((Component)aComponent, (JBPopup)this);
        Point popupPoint = AbstractPopup.getCenterOf(aComponent, this.getPreferredContentSize());
        this.show(aComponent, popupPoint.x, popupPoint.y, false);
    }

    public void showUnderneathOf(@NotNull Component aComponent) {
        if (aComponent == null) {
            AbstractPopup.$$$reportNull$$$0(21);
        }
        this.show(new RelativePoint(aComponent, new Point(JBUIScale.scale((int)2), aComponent.getHeight())));
    }

    public void show(@NotNull RelativePoint aPoint) {
        if (aPoint == null) {
            AbstractPopup.$$$reportNull$$$0(22);
        }
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        HelpTooltip.setMasterPopup((Component)aPoint.getOriginalComponent(), (JBPopup)this);
        Point screenPoint = aPoint.getScreenPoint();
        this.show(aPoint.getComponent(), screenPoint.x, screenPoint.y, false);
    }

    public void showInScreenCoordinates(@NotNull Component owner, @NotNull Point point) {
        if (owner == null) {
            AbstractPopup.$$$reportNull$$$0(23);
        }
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(24);
        }
        this.show(owner, point.x, point.y, false);
    }

    @NotNull
    public Point getBestPositionFor(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            AbstractPopup.$$$reportNull$$$0(25);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null && editor.getComponent().isShowing()) {
            Point point = this.getBestPositionFor(editor).getScreenPoint();
            if (point == null) {
                AbstractPopup.$$$reportNull$$$0(26);
            }
            return point;
        }
        Point point = this.relativePointByQuickSearch(dataContext).getScreenPoint();
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(27);
        }
        return point;
    }

    public void showInBestPositionFor(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            AbstractPopup.$$$reportNull$$$0(28);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR_EVEN_IF_INACTIVE.getData(dataContext)) != null && editor.getComponent().isShowing()) {
            this.showInBestPositionFor(editor);
        } else {
            this.show(this.relativePointByQuickSearch(dataContext));
        }
    }

    public void showInFocusCenter() {
        Component focused = AbstractPopup.getWndManager().getFocusedComponent(this.myProject);
        if (focused != null) {
            this.showInCenterOf(focused);
        } else {
            WindowManager manager2 = WindowManager.getInstance();
            JFrame frame = this.myProject != null ? manager2.getFrame(this.myProject) : manager2.findVisibleFrame();
            this.showInCenterOf(frame.getRootPane());
        }
    }

    @NotNull
    private RelativePoint relativePointByQuickSearch(@NotNull DataContext dataContext) {
        Component focusedComponent;
        Rectangle dominantArea;
        if (dataContext == null) {
            AbstractPopup.$$$reportNull$$$0(29);
        }
        if ((dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(dataContext)) != null && (focusedComponent = AbstractPopup.getWndManager().getFocusedComponent(this.myProject)) != null) {
            JLayeredPane layeredPane2;
            Window window = SwingUtilities.windowForComponent(focusedComponent);
            if (window instanceof JFrame) {
                layeredPane2 = ((JFrame)window).getLayeredPane();
            } else if (window instanceof JDialog) {
                layeredPane2 = ((JDialog)window).getLayeredPane();
            } else if (window instanceof JWindow) {
                layeredPane2 = ((JWindow)window).getLayeredPane();
            } else {
                throw new IllegalStateException("cannot find parent window: project=" + this.myProject + "; window=" + window);
            }
            return this.relativePointWithDominantRectangle(layeredPane2, dominantArea);
        }
        Component contextComponent = (Component)dataContext.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        RelativePoint location = contextComponent == this.myComponent ? new RelativePoint((Component)this.myComponent, new Point()) : JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        if (this.myLocateWithinScreen) {
            Point screenPoint = location.getScreenPoint();
            Rectangle rectangle = new Rectangle(screenPoint, this.getSizeForPositioning());
            Rectangle screen = ScreenUtil.getScreenRectangle((Point)screenPoint);
            ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)screen, null);
            location = new RelativePoint(rectangle.getLocation()).getPointOn(location.getComponent());
        }
        RelativePoint relativePoint = location;
        if (relativePoint == null) {
            AbstractPopup.$$$reportNull$$$0(30);
        }
        return relativePoint;
    }

    public Dimension getSizeForPositioning() {
        Dimension size2 = this.getSize();
        if (size2 == null) {
            size2 = this.getStoredSize();
        }
        if (size2 == null) {
            Dimension contentPreferredSize = this.myContent.getPreferredSize();
            Dimension titlePreferredSize = this.getTitle().getPreferredSize();
            size2 = new JBDimension(Math.max(contentPreferredSize.width, titlePreferredSize.width), contentPreferredSize.height + titlePreferredSize.height, true);
        }
        return size2;
    }

    public void showInBestPositionFor(@NotNull Editor editor) {
        if (editor == null) {
            AbstractPopup.$$$reportNull$$$0(31);
        }
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        assert (UIUtil.isShowing((Component)editor.getContentComponent())) : "Editor must be showing on the screen";
        AccessibleContextUtil.setParent((Component)this.myComponent, (Component)editor.getContentComponent());
        this.show(this.getBestPositionFor(editor));
    }

    @NotNull
    private RelativePoint getBestPositionFor(@NotNull Editor editor) {
        DataContext context2;
        Rectangle dominantArea;
        if (editor == null) {
            AbstractPopup.$$$reportNull$$$0(32);
        }
        if (editor instanceof EditorEx && (dominantArea = (Rectangle)PlatformDataKeys.DOMINANT_HINT_AREA_RECTANGLE.getData(context2 = ((EditorEx)editor).getDataContext())) != null && !this.myRequestFocus) {
            JLayeredPane layeredPane2 = editor.getContentComponent().getRootPane().getLayeredPane();
            return this.relativePointWithDominantRectangle(layeredPane2, dominantArea);
        }
        return this.guessBestPopupLocation(editor);
    }

    @NotNull
    private RelativePoint guessBestPopupLocation(@NotNull Editor editor) {
        if (editor == null) {
            AbstractPopup.$$$reportNull$$$0(33);
        }
        RelativePoint preferredLocation = JBPopupFactory.getInstance().guessBestPopupLocation(editor);
        Dimension targetSize = this.getSizeForPositioning();
        Point preferredPoint = preferredLocation.getScreenPoint();
        Point result2 = AbstractPopup.getLocationAboveEditorLineIfPopupIsClippedAtTheBottom(preferredPoint, targetSize, editor);
        if (this.myLocateWithinScreen) {
            Rectangle rectangle = new Rectangle(result2, targetSize);
            Rectangle screen = ScreenUtil.getScreenRectangle((Point)preferredPoint);
            ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)screen, null);
            result2 = rectangle.getLocation();
        }
        return AbstractPopup.toRelativePoint(result2, preferredLocation.getComponent());
    }

    @NotNull
    private static RelativePoint toRelativePoint(@NotNull Point screenPoint, @Nullable Component component2) {
        if (screenPoint == null) {
            AbstractPopup.$$$reportNull$$$0(34);
        }
        if (component2 == null) {
            RelativePoint relativePoint = RelativePoint.fromScreen((Point)screenPoint);
            if (relativePoint == null) {
                AbstractPopup.$$$reportNull$$$0(35);
            }
            return relativePoint;
        }
        SwingUtilities.convertPointFromScreen(screenPoint, component2);
        return new RelativePoint(component2, screenPoint);
    }

    @NotNull
    private static Point getLocationAboveEditorLineIfPopupIsClippedAtTheBottom(@NotNull Point originalLocation, @NotNull Dimension popupSize, @NotNull Editor editor) {
        if (originalLocation == null) {
            AbstractPopup.$$$reportNull$$$0(36);
        }
        if (popupSize == null) {
            AbstractPopup.$$$reportNull$$$0(37);
        }
        if (editor == null) {
            AbstractPopup.$$$reportNull$$$0(38);
        }
        Rectangle preferredBounds = new Rectangle(originalLocation, popupSize);
        Rectangle adjustedBounds = new Rectangle(preferredBounds);
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)adjustedBounds);
        if (preferredBounds.y - adjustedBounds.y <= 0) {
            Point point = originalLocation;
            if (point == null) {
                AbstractPopup.$$$reportNull$$$0(39);
            }
            return point;
        }
        int adjustedY = preferredBounds.y - editor.getLineHeight() - popupSize.height;
        if (adjustedY < 0) {
            Point point = originalLocation;
            if (point == null) {
                AbstractPopup.$$$reportNull$$$0(40);
            }
            return point;
        }
        return new Point(preferredBounds.x, adjustedY);
    }

    @NotNull
    private RelativePoint relativePointWithDominantRectangle(@NotNull JLayeredPane layeredPane2, @NotNull Rectangle bounds2) {
        if (layeredPane2 == null) {
            AbstractPopup.$$$reportNull$$$0(41);
        }
        if (bounds2 == null) {
            AbstractPopup.$$$reportNull$$$0(42);
        }
        Dimension size2 = this.getSizeForPositioning();
        List<Supplier> optionsToTry = Arrays.asList(() -> new Point(bounds2.x + bounds2.width, bounds2.y), () -> new Point(bounds2.x - size2.width, bounds2.y));
        for (Supplier option2 : optionsToTry) {
            Point location = (Point)option2.get();
            SwingUtilities.convertPointToScreen(location, layeredPane2);
            Point adjustedLocation = AbstractPopup.fitToScreenAdjustingVertically(location, size2);
            if (adjustedLocation == null) continue;
            RelativePoint relativePoint = new RelativePoint(adjustedLocation).getPointOn((Component)layeredPane2);
            if (relativePoint == null) {
                AbstractPopup.$$$reportNull$$$0(43);
            }
            return relativePoint;
        }
        this.setDimensionServiceKey(null);
        Point rightTopCorner = new Point(bounds2.x + bounds2.width, bounds2.y);
        Point rightTopCornerScreen = (Point)rightTopCorner.clone();
        SwingUtilities.convertPointToScreen(rightTopCornerScreen, layeredPane2);
        Rectangle screen = ScreenUtil.getScreenRectangle((int)rightTopCornerScreen.x, (int)rightTopCornerScreen.y);
        int spaceOnTheLeft = bounds2.x;
        int spaceOnTheRight = screen.x + screen.width - rightTopCornerScreen.x;
        if (spaceOnTheLeft > spaceOnTheRight) {
            this.myComponent.setPreferredSize(new Dimension(spaceOnTheLeft, Math.max(size2.height, JBUIScale.scale((int)200))));
            return new RelativePoint((Component)layeredPane2, new Point(0, bounds2.y));
        }
        this.myComponent.setPreferredSize(new Dimension(spaceOnTheRight, Math.max(size2.height, JBUIScale.scale((int)200))));
        return new RelativePoint((Component)layeredPane2, rightTopCorner);
    }

    @Nullable
    private static Point fitToScreenAdjustingVertically(@NotNull Point position, @NotNull Dimension size2) {
        if (position == null) {
            AbstractPopup.$$$reportNull$$$0(44);
        }
        if (size2 == null) {
            AbstractPopup.$$$reportNull$$$0(45);
        }
        Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Point)position);
        Rectangle rectangle = new Rectangle(position, size2);
        if (rectangle.height > screenRectangle.height || rectangle.x < screenRectangle.x || rectangle.x + rectangle.width > screenRectangle.x + screenRectangle.width) {
            return null;
        }
        ScreenUtil.moveToFit((Rectangle)rectangle, (Rectangle)screenRectangle, null);
        return rectangle.getLocation();
    }

    @NotNull
    public Dimension getPreferredContentSize() {
        if (this.myForcedSize != null) {
            Dimension dimension = this.myForcedSize;
            if (dimension == null) {
                AbstractPopup.$$$reportNull$$$0(46);
            }
            return dimension;
        }
        Dimension size2 = this.getStoredSize();
        if (size2 != null) {
            Dimension dimension = size2;
            if (dimension == null) {
                AbstractPopup.$$$reportNull$$$0(47);
            }
            return dimension;
        }
        Dimension dimension = this.myComponent.getPreferredSize();
        if (dimension == null) {
            AbstractPopup.$$$reportNull$$$0(48);
        }
        return dimension;
    }

    public final void closeOk(@Nullable InputEvent e) {
        this.setOk(true);
        this.myFinalRunnable = FunctionUtil.composeRunnables((Runnable)this.myOkHandler, (Runnable)this.myFinalRunnable);
        this.cancel(e);
    }

    public final void cancel() {
        InputEvent inputEvent = null;
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof InputEvent && this.myPopup != null) {
            InputEvent ie = (InputEvent)event;
            Window window = this.myPopup.getWindow();
            if (window != null && UIUtil.isDescendingFrom((Component)ie.getComponent(), (Component)window)) {
                inputEvent = ie;
            }
        }
        this.cancel(inputEvent);
    }

    public void setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
    }

    public void cancel(InputEvent e) {
        if (this.myState == State.CANCEL || this.myState == State.DISPOSE) {
            return;
        }
        this.debugState("cancel popup", State.SHOWN);
        this.myState = State.CANCEL;
        if (this.isDisposed()) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Throwable)new Exception("cancel popup stack trace"));
        }
        if (this.myPopup != null) {
            Point location;
            JRootPane root;
            if (!this.canClose()) {
                this.debugState("cannot cancel popup", State.CANCEL);
                this.myState = State.SHOWN;
                return;
            }
            this.storeDimensionSize();
            if (this.myUseDimServiceForXYLocation && (root = this.myComponent.getRootPane()) != null && (location = AbstractPopup.getLocationOnScreen(root.getParent())) != null) {
                this.storeLocation(this.fixLocateByContent(location, true));
            }
            if (e instanceof MouseEvent) {
                IdeEventQueue.getInstance().blockNextEvents((MouseEvent)e);
            }
            this.myPopup.hide(false);
            if (ApplicationManager.getApplication() != null) {
                StackingPopupDispatcher.getInstance().onPopupHidden((JBPopup)this);
            }
            this.disposePopup();
        }
        this.myListeners.forEach(listener2 -> listener2.onClosed(new LightweightWindowEvent((LightweightWindow)((Object)this), this.myOk)));
        Disposer.dispose((Disposable)this, (boolean)false);
        if (this.myProjectDisposable != null) {
            Disposer.dispose((Disposable)this.myProjectDisposable);
        }
    }

    private void disposePopup() {
        all.remove((Object)this);
        if (this.myPopup != null) {
            this.resetWindow();
            this.myPopup.hide(true);
        }
        this.myPopup = null;
    }

    public boolean canClose() {
        return this.myCallBack == null || (Boolean)this.myCallBack.compute() != false;
    }

    public boolean isVisible() {
        if (this.myPopup == null) {
            return false;
        }
        Window window = this.myPopup.getWindow();
        if (window != null && window.isShowing()) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("window hidden, popup's state: " + this.myState);
        }
        return false;
    }

    public void show(@NotNull Component owner) {
        if (owner == null) {
            AbstractPopup.$$$reportNull$$$0(49);
        }
        this.show(owner, -1, -1, true);
    }

    public void show(@NotNull Component owner, int aScreenX, int aScreenY, boolean considerForcedXY) {
        Object root;
        Insets insets;
        Point storedLocation;
        if (owner == null) {
            AbstractPopup.$$$reportNull$$$0(50);
        }
        if (UiInterceptors.tryIntercept((Object)this)) {
            return;
        }
        if (ApplicationManager.getApplication() != null && ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        if (this.isDisposed()) {
            throw new IllegalStateException("Popup was already disposed. Recreate a new instance to show again");
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        assert (this.myState == State.INIT) : "Popup was already shown. Recreate a new instance to show again.";
        this.debugState("show popup", State.INIT);
        this.myState = State.SHOWING;
        this.installProjectDisposer();
        this.addActivity();
        boolean shouldShow = this.beforeShow();
        if (!shouldShow) {
            this.removeActivity();
            this.debugState("rejected to show popup", State.SHOWING);
            this.myState = State.INIT;
            return;
        }
        this.prepareToShow();
        AbstractPopup.installWindowHook(this);
        Dimension sizeToSet = this.getStoredSize();
        if (this.myForcedSize != null) {
            sizeToSet = this.myForcedSize;
        }
        Rectangle screen = ScreenUtil.getScreenRectangle((int)aScreenX, (int)aScreenY);
        if (this.myLocateWithinScreen) {
            Dimension size2;
            Dimension preferredSize = this.myContent.getPreferredSize();
            Object o = this.myContent.getClientProperty(FIRST_TIME_SIZE);
            if (sizeToSet == null && o instanceof Dimension) {
                int w = ((Dimension)o).width;
                int h = ((Dimension)o).height;
                if (w > 0) {
                    preferredSize.width = w;
                }
                if (h > 0) {
                    preferredSize.height = h;
                }
                sizeToSet = preferredSize;
            }
            Dimension dimension = size2 = sizeToSet != null ? sizeToSet : preferredSize;
            if (size2.width > screen.width) {
                size2.width = screen.width;
                sizeToSet = size2;
            }
            if (size2.height > screen.height) {
                size2.height = screen.height;
                sizeToSet = size2;
            }
        }
        if (sizeToSet != null) {
            JBInsets.addTo((Dimension)sizeToSet, (Insets)this.myContent.getInsets());
            sizeToSet.width = Math.max(sizeToSet.width, this.myContent.getMinimumSize().width);
            sizeToSet.height = Math.max(sizeToSet.height, this.myContent.getMinimumSize().height);
            this.myContent.setSize(sizeToSet);
            this.myContent.setPreferredSize(sizeToSet);
        }
        Point xy = new Point(aScreenX, aScreenY);
        boolean adjustXY = true;
        if (this.myUseDimServiceForXYLocation && (storedLocation = this.getStoredLocation()) != null) {
            xy = storedLocation;
            adjustXY = false;
        }
        if (adjustXY && (insets = this.myContent.getInsets()) != null) {
            xy.x -= insets.left;
            xy.y -= insets.top;
        }
        if (considerForcedXY && this.myForcedLocation != null) {
            xy = this.myForcedLocation;
        }
        this.fixLocateByContent(xy, false);
        Rectangle targetBounds = new Rectangle(xy, this.myContent.getPreferredSize());
        if (targetBounds.width > screen.width || targetBounds.height > screen.height) {
            StringBuilder sb = new StringBuilder("popup preferred size is bigger than screen: ");
            sb.append(targetBounds.width).append("x").append(targetBounds.height);
            IJSwingUtilities.appendComponentClassNames(sb, this.myContent);
            LOG.warn(sb.toString());
        }
        Rectangle original = new Rectangle(targetBounds);
        if (this.myLocateWithinScreen) {
            ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)screen, null);
        } else {
            AbstractPopup.fitToVisibleArea(targetBounds);
        }
        if (this.myMouseOutCanceller != null) {
            this.myMouseOutCanceller.myEverEntered = targetBounds.equals(original);
        }
        Point pointOnOwner = new Point(aScreenX, aScreenY);
        SwingUtilities.convertPointFromScreen(pointOnOwner, owner);
        if (ActionToolbarImpl.isInPopupToolbar(SwingUtilities.getDeepestComponentAt(owner, pointOnOwner.x, pointOnOwner.y))) {
            AutoPopupSupportingListener.installOn(this);
        }
        this.myOwner = AbstractPopup.getFrameOrDialog(owner);
        if (this.myOwner == null) {
            this.myOwner = owner;
        }
        this.myRequestorComponent = owner;
        boolean forcedDialog = this.myMayBeParent || SystemInfo.isMac && !(this.myOwner instanceof IdeFrame) && this.myOwner.isShowing();
        PopupComponent.Factory factory2 = this.getFactory(this.myForcedHeavyweight || this.myResizable, forcedDialog);
        this.myNativePopup = factory2.isNativePopup();
        Component popupOwner = this.myOwner;
        if (popupOwner instanceof RootPaneContainer && (!(popupOwner instanceof IdeFrame) || Registry.is((String)"popup.fix.ide.frame.owner"))) {
            root = (RootPaneContainer)((Object)popupOwner);
            popupOwner = root.getRootPane();
            LOG.debug("popup owner fixed for JDK cache");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("expected preferred size: " + this.myContent.getPreferredSize());
        }
        this.myPopup = factory2.getPopup(popupOwner, this.myContent, targetBounds.x, targetBounds.y, this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("  actual preferred size: " + this.myContent.getPreferredSize());
        }
        if (targetBounds.width != this.myContent.getWidth() || targetBounds.height != this.myContent.getHeight()) {
            LOG.debug("the expected size is not equal to the actual size");
            Window popup2 = this.myPopup.getWindow();
            if (popup2 != null) {
                popup2.setSize(targetBounds.width, targetBounds.height);
                if (this.myContent.getParent().getComponentCount() != 1) {
                    LOG.debug("unexpected count of components in heavy-weight popup");
                }
            } else {
                LOG.debug("cannot fix size for non-heavy-weight popup");
            }
        }
        if (this.myResizable) {
            root = this.myContent.getRootPane();
            final IdeGlassPaneImpl glass = new IdeGlassPaneImpl((JRootPane)root);
            ((JRootPane)root).setGlassPane(glass);
            int i2 = Registry.intValue((String)"ide.popup.resizable.border.sensitivity", (int)4);
            WindowResizeListener resizeListener = new WindowResizeListener(this.myComponent, (Insets)(this.myMovable ? JBUI.insets((int)i2) : JBUI.insets((int)0, (int)0, (int)i2, (int)i2)), null){
                private Cursor myCursor;

                @Override
                protected void setCursor(@NotNull Component content2, Cursor cursor) {
                    if (content2 == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (this.myCursor != cursor || this.myCursor != Cursor.getDefaultCursor()) {
                        glass.setCursor(cursor, this);
                        this.myCursor = cursor;
                        if (content2 instanceof JComponent) {
                            IdeGlassPaneImpl.savePreProcessedCursor((JComponent)content2, content2.getCursor());
                        }
                        super.setCursor(content2, cursor);
                    }
                }

                @Override
                protected void notifyResized() {
                    AbstractPopup.this.myResizeListeners.forEach(Runnable::run);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ui/popup/AbstractPopup$2", "setCursor"));
                }
            };
            glass.addMousePreprocessor(resizeListener, this);
            glass.addMouseMotionPreprocessor(resizeListener, this);
            this.myResizeListener = resizeListener;
        }
        if (this.myCaption != null && this.myMovable) {
            WindowMoveListener moveListener2 = new WindowMoveListener((Component)this.myCaption){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.isConsumed()) {
                        return;
                    }
                    if (UIUtil.isCloseClick((MouseEvent)e) && AbstractPopup.this.myCaption.isWithinPanel(e)) {
                        AbstractPopup.this.cancel();
                    } else {
                        super.mousePressed(e);
                    }
                }
            };
            this.myCaption.addMouseListener((MouseListener)moveListener2);
            this.myCaption.addMouseMotionListener((MouseMotionListener)moveListener2);
            MyContentPanel saved = this.myContent;
            Disposer.register((Disposable)this, () -> {
                ListenerUtil.removeMouseListener(saved, moveListener2);
                ListenerUtil.removeMouseMotionListener(saved, moveListener2);
            });
            this.myMoveListener = moveListener2;
        }
        this.myListeners.forEach(listener2 -> listener2.beforeShown(new LightweightWindowEvent((LightweightWindow)((Object)this))));
        this.myPopup.setRequestFocus(this.myRequestFocus);
        Window window = AbstractPopup.getContentWindow(this.myContent);
        if (window instanceof IdeFrame) {
            LOG.warn("Lightweight popup is shown using AbstractPopup class. But this class is not supposed to work with lightweight popups.");
        }
        window.setFocusableWindowState(this.myRequestFocus);
        window.setFocusable(this.myRequestFocus);
        window.setAlwaysOnTop(false);
        if (this.myFocusable) {
            FocusTraversalPolicy focusTraversalPolicy = new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container aContainer, Component aComponent) {
                    return this.getComponent();
                }

                private Component getComponent() {
                    return AbstractPopup.this.myPreferredFocusedComponent == null ? AbstractPopup.this.myComponent : AbstractPopup.this.myPreferredFocusedComponent;
                }

                @Override
                public Component getComponentBefore(Container aContainer, Component aComponent) {
                    return this.getComponent();
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return this.getComponent();
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    return this.getComponent();
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return this.getComponent();
                }
            };
            window.setFocusTraversalPolicy(focusTraversalPolicy);
            Disposer.register((Disposable)this, () -> window.setFocusTraversalPolicy(null));
        }
        window.setAutoRequestFocus(this.myRequestFocus);
        String data2 = this.getUserData(String.class);
        boolean popupIsSimpleWindow = "TRUE".equals(this.getContent().getClientProperty("BookmarkPopup"));
        this.myContent.getRootPane().putClientProperty("SIMPLE_WINDOW", "SIMPLE_WINDOW".equals(data2) || popupIsSimpleWindow);
        this.myWindow = window;
        if (this.myNormalWindowLevel) {
            this.myWindow.setType(Window.Type.NORMAL);
        }
        this.setMinimumSize(this.myMinSize);
        TouchbarSupport.showPopupItems(this, this.myContent);
        this.myPopup.show();
        Rectangle bounds2 = window.getBounds();
        PopupLocationTracker.register(this);
        if (bounds2.width > screen.width || bounds2.height > screen.height) {
            ScreenUtil.fitToScreen((Rectangle)bounds2);
            window.setBounds(bounds2);
        }
        WindowAction.setEnabledFor(this.myPopup.getWindow(), this.myResizable);
        this.myWindowListener = new MyWindowListener();
        window.addWindowListener(this.myWindowListener);
        if (this.myWindow != null && !this.myMayBeParent && !(this.myWindow instanceof Frame)) {
            WindowManager.getInstance().doNotSuggestAsParent(this.myWindow);
        }
        Runnable afterShow = () -> {
            if (this.isDisposed()) {
                LOG.debug("popup is disposed after showing");
                this.removeActivity();
                return;
            }
            if ((this.myPreferredFocusedComponent instanceof AbstractButton || this.myPreferredFocusedComponent instanceof JTextField) && this.myFocusable) {
                IJSwingUtilities.moveMousePointerOn(this.myPreferredFocusedComponent);
            }
            this.removeActivity();
            this.afterShow();
        };
        if (this.myRequestFocus) {
            if (this.myPreferredFocusedComponent != null) {
                this.myPreferredFocusedComponent.requestFocus();
            } else {
                this._requestFocus();
            }
            window.setAutoRequestFocus(this.myRequestFocus);
            SwingUtilities.invokeLater(afterShow);
        } else {
            SwingUtilities.invokeLater(() -> {
                if (this.isDisposed()) {
                    this.removeActivity();
                    return;
                }
                afterShow.run();
            });
        }
        this.debugState("popup shown", State.SHOWING);
        this.myState = State.SHOWN;
        this.afterShowSync();
    }

    private static void fitToVisibleArea(Rectangle targetBounds) {
        Point topLeft = new Point(targetBounds.x, targetBounds.y);
        Point bottomRight = new Point((int)targetBounds.getMaxX(), (int)targetBounds.getMaxY());
        Rectangle topLeftScreen = ScreenUtil.getScreenRectangle((Point)topLeft);
        Rectangle bottomRightScreen = ScreenUtil.getScreenRectangle((Point)bottomRight);
        if (topLeft.x < topLeftScreen.x || topLeft.y < topLeftScreen.y || (double)bottomRight.x > bottomRightScreen.getMaxX() || (double)bottomRight.y > bottomRightScreen.getMaxY()) {
            GraphicsDevice device = ScreenUtil.getScreenDevice((Rectangle)targetBounds);
            Rectangle mostAppropriateScreenRectangle = device != null ? ScreenUtil.getScreenRectangle((GraphicsConfiguration)device.getDefaultConfiguration()) : ScreenUtil.getMainScreenBounds();
            ScreenUtil.moveToFit((Rectangle)targetBounds, (Rectangle)mostAppropriateScreenRectangle, null);
        }
    }

    public void focusPreferredComponent() {
        this._requestFocus();
    }

    private void installProjectDisposer() {
        DataContext context2;
        Project project;
        Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (c != null && (project = (Project)CommonDataKeys.PROJECT.getData(context2 = DataManager.getInstance().getDataContext(c))) != null) {
            this.myProjectDisposable = () -> {
                if (!this.isDisposed()) {
                    Disposer.dispose((Disposable)this);
                }
            };
            Disposer.register((Disposable)project, (Disposable)this.myProjectDisposable);
        }
    }

    private static void installWindowHook(@NotNull AbstractPopup popup2) {
        if (popup2 == null) {
            AbstractPopup.$$$reportNull$$$0(51);
        }
        if (popup2.myCancelOnWindow) {
            popup2.myCancelOnWindow = false;
            new Alarm((Disposable)popup2).addRequest(() -> {
                popup2.myCancelOnWindow = true;
            }, 100);
        }
    }

    private void addActivity() {
        UiActivityMonitor.getInstance().addActivity(this.myActivityKey);
    }

    private void removeActivity() {
        UiActivityMonitor.getInstance().removeActivity(this.myActivityKey);
    }

    private void prepareToShow() {
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Rectangle bounds2 = AbstractPopup.getBoundsOnScreen(AbstractPopup.this.myContent);
                if (bounds2 != null) {
                    bounds2.x -= 2;
                    bounds2.y -= 2;
                    bounds2.width += 4;
                    bounds2.height += 4;
                }
                if (bounds2 == null || !bounds2.contains(e.getLocationOnScreen())) {
                    AbstractPopup.this.cancel();
                }
            }
        };
        this.myContent.addMouseListener(mouseAdapter2);
        Disposer.register((Disposable)this, () -> this.myContent.removeMouseListener(mouseAdapter2));
        this.myContent.addKeyListener((KeyListener)this.mySpeedSearch);
        if (this.myCancelOnMouseOutCallback != null || this.myCancelOnWindow) {
            this.myMouseOutCanceller = new Canceller();
            Toolkit.getDefaultToolkit().addAWTEventListener(this.myMouseOutCanceller, 255L);
        }
        ChildFocusWatcher focusWatcher = new ChildFocusWatcher(this.myContent){

            @Override
            protected void onFocusGained(FocusEvent event) {
                AbstractPopup.this.setWindowActive(true);
            }

            @Override
            protected void onFocusLost(FocusEvent event) {
                AbstractPopup.this.setWindowActive(false);
            }
        };
        Disposer.register((Disposable)this, (Disposable)focusWatcher);
        this.mySpeedSearchPatternField = new SearchTextField(false){

            protected void onFieldCleared() {
                AbstractPopup.this.mySpeedSearch.reset();
            }
        };
        this.mySpeedSearchPatternField.getTextEditor().setFocusable(this.mySpeedSearchAlwaysShown);
        if (this.mySpeedSearchAlwaysShown) {
            this.setHeaderComponent((JComponent)this.mySpeedSearchPatternField);
            this.mySpeedSearchPatternField.setBorder(JBUI.Borders.customLine((Color)JBUI.CurrentTheme.BigPopup.searchFieldBorderColor(), (int)1, (int)0, (int)1, (int)0));
            this.mySpeedSearchPatternField.getTextEditor().setBorder((Border)JBUI.Borders.empty());
        }
        if (SystemInfo.isMac) {
            RelativeFont.TINY.install((Component)this.mySpeedSearchPatternField);
        }
    }

    private void updateMaskAndAlpha(Window window) {
        if (window == null) {
            return;
        }
        if (!window.isDisplayable() || !window.isShowing()) {
            return;
        }
        WindowManagerEx wndManager = AbstractPopup.getWndManager();
        if (wndManager == null) {
            return;
        }
        if (!wndManager.isAlphaModeEnabled(window)) {
            return;
        }
        if (this.myAlpha != this.myLastAlpha) {
            wndManager.setAlphaModeRatio(window, this.myAlpha);
            this.myLastAlpha = this.myAlpha;
        }
        if (this.myMaskProvider != null) {
            Dimension size2 = window.getSize();
            Shape mask = this.myMaskProvider.getMask(size2);
            wndManager.setWindowMask(window, mask);
        }
        WindowManagerEx.WindowShadowMode mode = this.myShadowed ? WindowManagerEx.WindowShadowMode.NORMAL : WindowManagerEx.WindowShadowMode.DISABLED;
        WindowManagerEx.getInstanceEx().setWindowShadow(window, mode);
    }

    private static WindowManagerEx getWndManager() {
        return ApplicationManager.getApplication() != null ? WindowManagerEx.getInstanceEx() : null;
    }

    public boolean isDisposed() {
        return this.myContent == null;
    }

    protected boolean beforeShow() {
        if (ApplicationManager.getApplication() == null) {
            return true;
        }
        StackingPopupDispatcher.getInstance().onPopupShown((JBPopup)this, this.myInStack);
        return true;
    }

    protected void afterShow() {
    }

    protected void afterShowSync() {
    }

    protected final boolean requestFocus() {
        if (!this.myFocusable) {
            return false;
        }
        this.getFocusManager().doWhenFocusSettlesDown(() -> this._requestFocus());
        return true;
    }

    private void _requestFocus() {
        if (!this.myFocusable) {
            return;
        }
        JComponent toFocus = (JComponent)ObjectUtils.chooseNotNull((Object)this.myPreferredFocusedComponent, (Object)(this.mySpeedSearchAlwaysShown ? this.mySpeedSearchPatternField : null));
        if (toFocus != null) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
                if (!this.myDisposed) {
                    IdeFocusManager.getGlobalInstance().requestFocus((Component)toFocus, true);
                }
            });
        }
    }

    private IdeFocusManager getFocusManager() {
        if (this.myProject != null) {
            return IdeFocusManager.getInstance((Project)this.myProject);
        }
        if (this.myOwner != null) {
            return IdeFocusManager.findInstanceByComponent((Component)this.myOwner);
        }
        return IdeFocusManager.findInstance();
    }

    private static JComponent getTargetComponent(Component aComponent) {
        if (aComponent instanceof JComponent) {
            return (JComponent)aComponent;
        }
        if (aComponent instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)aComponent)).getRootPane();
        }
        LOG.error("Cannot find target for:" + aComponent);
        return null;
    }

    private @NotNull PopupComponent.Factory getFactory(boolean forceHeavyweight, boolean forceDialog) {
        boolean noFocus;
        boolean cannotBeDialog;
        if (Registry.is((String)"allow.dialog.based.popups") && !(cannotBeDialog = (noFocus = !this.myFocusable || !this.myRequestFocus)) && (this.isPersistent() || forceDialog)) {
            return new PopupComponent.Factory.Dialog();
        }
        if (forceHeavyweight) {
            return new PopupComponent.Factory.AwtHeavyweight();
        }
        return new PopupComponent.Factory.AwtDefault();
    }

    @NotNull
    public JComponent getContent() {
        MyContentPanel myContentPanel = this.myContent;
        if (myContentPanel == null) {
            AbstractPopup.$$$reportNull$$$0(52);
        }
        return myContentPanel;
    }

    public void setLocation(@NotNull RelativePoint p) {
        if (p == null) {
            AbstractPopup.$$$reportNull$$$0(53);
        }
        if (this.isBusy()) {
            return;
        }
        AbstractPopup.setLocation(p, this.myPopup);
    }

    private static void setLocation(@NotNull RelativePoint p, @Nullable PopupComponent popup2) {
        if (p == null) {
            AbstractPopup.$$$reportNull$$$0(54);
        }
        if (popup2 == null) {
            return;
        }
        Window wnd = popup2.getWindow();
        assert (wnd != null);
        wnd.setLocation(p.getScreenPoint());
    }

    public void pack(boolean width, boolean height) {
        Window window;
        int delta;
        Rectangle screen;
        if (!this.isVisible() || !width && !height || this.isBusy()) {
            return;
        }
        Dimension size2 = this.getSize();
        Dimension prefSize = this.myContent.computePreferredSize();
        Point location = !this.myLocateWithinScreen ? null : this.getLocationOnScreen();
        Rectangle rectangle = screen = location == null ? null : ScreenUtil.getScreenRectangle((Point)location);
        if (width) {
            size2.width = prefSize.width;
            if (screen != null && size2.width > (delta = screen.width + screen.x - location.x)) {
                size2.width = delta;
            }
        }
        if (height) {
            if (size2.width < prefSize.width && (!SystemInfo.isMac || Registry.is((String)"mac.scroll.horizontal.gap"))) {
                this.forHorizontalScrollBar((Consumer<JScrollBar>)((Consumer)bar2 -> prefSize.height += bar2.getPreferredSize().height));
            }
            size2.height = prefSize.height;
            if (screen != null && size2.height > (delta = screen.height + screen.y - location.y)) {
                size2.height = delta;
            }
        }
        if ((window = AbstractPopup.getContentWindow(this.myContent)) != null) {
            window.setSize(size2);
        }
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void dispose() {
        Toolkit toolkit;
        if (this.myState == State.SHOWN) {
            LOG.debug("shown popup must be cancelled");
            this.cancel();
        }
        if (this.myState == State.DISPOSE) {
            return;
        }
        this.debugState("dispose popup", State.INIT, State.CANCEL);
        this.myState = State.DISPOSE;
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("start disposing " + this.myContent);
        }
        Disposer.dispose((Disposable)this, (boolean)false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPopup != null) {
            this.cancel(this.myDisposeEvent);
        }
        if (this.myContent != null) {
            Container parent = this.myContent.getParent();
            if (parent != null) {
                parent.remove(this.myContent);
            }
            this.myContent.removeAll();
            this.myContent.removeKeyListener((KeyListener)this.mySpeedSearch);
        }
        this.myContent = null;
        this.myPreferredFocusedComponent = null;
        this.myComponent = null;
        this.mySpeedSearchFoundInRootComponent = null;
        this.myCallBack = null;
        this.myListeners.clear();
        if (this.myMouseOutCanceller != null && (toolkit = Toolkit.getDefaultToolkit()) != null) {
            toolkit.removeAWTEventListener(this.myMouseOutCanceller);
        }
        this.myMouseOutCanceller = null;
        if (this.myFinalRunnable != null) {
            ModalityState modalityState = ModalityState.current();
            Runnable finalRunnable = this.myFinalRunnable;
            this.getFocusManager().doWhenFocusSettlesDown(() -> {
                if (ModalityState.current().equals(modalityState)) {
                    ((TransactionGuardImpl)TransactionGuard.getInstance()).performUserActivity(finalRunnable);
                } else {
                    LOG.debug("Final runnable of popup is skipped");
                }
            });
            this.myFinalRunnable = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("stop disposing content");
        }
    }

    private void resetWindow() {
        if (this.myWindow != null && AbstractPopup.getWndManager() != null) {
            AbstractPopup.getWndManager().resetWindow(this.myWindow);
            if (this.myWindowListener != null) {
                this.myWindow.removeWindowListener(this.myWindowListener);
            }
            if (this.myWindow instanceof RootPaneContainer) {
                RootPaneContainer container = (RootPaneContainer)((Object)this.myWindow);
                JRootPane root = container.getRootPane();
                root.putClientProperty("JBPopup", null);
                if (root.getGlassPane() instanceof IdeGlassPaneImpl) {
                    JPanel glass = new JPanel();
                    glass.setName(root.getName() + ".glassPane");
                    glass.setVisible(false);
                    glass.setOpaque(false);
                    root.setGlassPane(glass);
                }
            }
            this.myWindow = null;
            this.myWindowListener = null;
        }
    }

    @Nullable
    private Project getProjectDependingOnKey(String key) {
        return !key.startsWith("APPLICATION_WIDE_STORE_") ? this.myProject : null;
    }

    public void storeDimensionSize() {
        if (this.myDimensionServiceKey != null) {
            Dimension size2 = this.myContent.getSize();
            JBInsets.removeFrom((Dimension)size2, (Insets)this.myContent.getInsets());
            AbstractPopup.getWindowStateService(this.getProjectDependingOnKey(this.myDimensionServiceKey)).putSize(this.myDimensionServiceKey, size2);
        }
    }

    private void storeLocation(Point xy) {
        if (this.myDimensionServiceKey != null) {
            AbstractPopup.getWindowStateService(this.getProjectDependingOnKey(this.myDimensionServiceKey)).putLocation(this.myDimensionServiceKey, xy);
        }
    }

    boolean isCancelOnClickOutside() {
        return this.myCancelOnClickOutside;
    }

    boolean isCancelOnWindowDeactivation() {
        return this.myCancelOnWindowDeactivation;
    }

    public void setLocation(@NotNull Point screenPoint) {
        if (screenPoint == null) {
            AbstractPopup.$$$reportNull$$$0(55);
        }
        if (this.myPopup == null) {
            this.myForcedLocation = screenPoint;
        } else if (!this.isBusy()) {
            Insets insets = this.myContent.getInsets();
            if (insets != null && (insets.top != 0 || insets.left != 0)) {
                screenPoint = new Point(screenPoint.x - insets.left, screenPoint.y - insets.top);
            }
            AbstractPopup.moveTo(this.myContent, screenPoint, this.myLocateByContent ? this.myHeaderPanel.getPreferredSize() : null);
        }
    }

    private static void moveTo(@NotNull JComponent content2, @NotNull Point screenPoint, @Nullable Dimension headerCorrectionSize) {
        Window wnd;
        if (content2 == null) {
            AbstractPopup.$$$reportNull$$$0(56);
        }
        if (screenPoint == null) {
            AbstractPopup.$$$reportNull$$$0(57);
        }
        if ((wnd = AbstractPopup.getContentWindow(content2)) != null) {
            wnd.setCursor(Cursor.getDefaultCursor());
            if (headerCorrectionSize != null) {
                screenPoint.y -= headerCorrectionSize.height;
            }
            wnd.setLocation(screenPoint);
        }
    }

    private static Window getContentWindow(@NotNull Component content2) {
        Window window;
        if (content2 == null) {
            AbstractPopup.$$$reportNull$$$0(58);
        }
        if ((window = SwingUtilities.getWindowAncestor(content2)) == null && LOG.isDebugEnabled()) {
            LOG.debug("no window ancestor for " + content2);
        }
        return window;
    }

    @NotNull
    public Point getLocationOnScreen() {
        Window window = AbstractPopup.getContentWindow(this.myContent);
        Point screenPoint = window == null ? new Point() : window.getLocation();
        this.fixLocateByContent(screenPoint, false);
        Insets insets = this.myContent.getInsets();
        if (insets != null) {
            screenPoint.x += insets.left;
            screenPoint.y += insets.top;
        }
        Point point = screenPoint;
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(59);
        }
        return point;
    }

    public void setSize(@NotNull Dimension size2) {
        if (size2 == null) {
            AbstractPopup.$$$reportNull$$$0(60);
        }
        if (this.isBusy()) {
            return;
        }
        Dimension toSet = new Dimension(size2);
        toSet.height += this.getAdComponentHeight();
        if (this.myPopup == null) {
            this.myForcedSize = toSet;
        } else {
            this.updateMaskAndAlpha(AbstractPopup.setSize(this.myContent, toSet));
        }
    }

    private int getAdComponentHeight() {
        return this.myAdComponent != null ? this.myAdComponent.getPreferredSize().height + JBUIScale.scale((int)1) : 0;
    }

    protected boolean isAdVisible() {
        return this.myAdComponent != null && this.myAdComponent.isVisible();
    }

    public Dimension getSize() {
        Window popupWindow;
        if (this.myPopup != null && (popupWindow = AbstractPopup.getContentWindow(this.myContent)) != null) {
            Dimension size2 = popupWindow.getSize();
            size2.height -= this.getAdComponentHeight();
            return size2;
        }
        return this.myForcedSize;
    }

    public void moveToFitScreen() {
        if (this.myPopup == null || this.isBusy()) {
            return;
        }
        Window popupWindow = AbstractPopup.getContentWindow(this.myContent);
        if (popupWindow == null) {
            return;
        }
        Rectangle bounds2 = popupWindow.getBounds();
        ScreenUtil.moveRectangleToFitTheScreen((Rectangle)bounds2);
        popupWindow.setBounds(bounds2);
        this.updateMaskAndAlpha(popupWindow);
    }

    public static Window setSize(@NotNull JComponent content2, @NotNull Dimension size2) {
        Window popupWindow;
        if (content2 == null) {
            AbstractPopup.$$$reportNull$$$0(61);
        }
        if (size2 == null) {
            AbstractPopup.$$$reportNull$$$0(62);
        }
        if ((popupWindow = AbstractPopup.getContentWindow(content2)) == null) {
            return null;
        }
        JBInsets.addTo((Dimension)size2, (Insets)content2.getInsets());
        content2.setPreferredSize(size2);
        popupWindow.pack();
        return popupWindow;
    }

    public void setCaption(@NotNull @NlsContexts.PopupTitle String title2) {
        if (title2 == null) {
            AbstractPopup.$$$reportNull$$$0(63);
        }
        if (this.myCaption instanceof TitlePanel) {
            ((TitlePanel)this.myCaption).setText(title2);
        }
    }

    protected void setSpeedSearchAlwaysShown() {
        assert (this.myState == State.INIT);
        this.mySpeedSearchAlwaysShown = true;
    }

    public boolean isPersistent() {
        return !this.myCancelOnClickOutside && !this.myCancelOnWindow;
    }

    public boolean isNativePopup() {
        return this.myNativePopup;
    }

    public void setUiVisible(boolean visible) {
        if (this.myPopup != null) {
            if (visible) {
                this.myPopup.show();
                Window window = this.getPopupWindow();
                if (window != null && this.myRestoreWindowSize != null) {
                    window.setSize(this.myRestoreWindowSize);
                    this.myRestoreWindowSize = null;
                }
            } else {
                Window window = this.getPopupWindow();
                if (window != null) {
                    this.myRestoreWindowSize = window.getSize();
                    window.setVisible(false);
                }
            }
        }
    }

    public Window getPopupWindow() {
        return this.myPopup != null ? this.myPopup.getWindow() : null;
    }

    public void setUserData(@NotNull List<Object> userData) {
        if (userData == null) {
            AbstractPopup.$$$reportNull$$$0(64);
        }
        this.myUserData = userData;
    }

    public <T> T getUserData(@NotNull Class<T> userDataClass) {
        if (userDataClass == null) {
            AbstractPopup.$$$reportNull$$$0(65);
        }
        if (this.myUserData != null) {
            for (Object o : this.myUserData) {
                if (!userDataClass.isInstance(o)) continue;
                Object t = o;
                return (T)t;
            }
        }
        return null;
    }

    public boolean isModalContext() {
        return this.myModalContext;
    }

    public boolean isFocused() {
        if (this.myComponent != null && AbstractPopup.isFocused(new Component[]{SwingUtilities.getWindowAncestor(this.myComponent)})) {
            return true;
        }
        return AbstractPopup.isFocused(this.myFocusOwners);
    }

    private static boolean isFocused(Component @NotNull [] components) {
        Component owner;
        if (components == null) {
            AbstractPopup.$$$reportNull$$$0(66);
        }
        if ((owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) == null) {
            return false;
        }
        Window wnd = ComponentUtil.getWindow((Component)owner);
        for (Component each : components) {
            Window eachWindow;
            if (each == null || !SwingUtilities.isDescendingFrom(owner, each) || (eachWindow = ComponentUtil.getWindow((Component)each)) != wnd) continue;
            return true;
        }
        return false;
    }

    public boolean isCancelKeyEnabled() {
        return this.myCancelKeyEnabled;
    }

    @NotNull
    public CaptionPanel getTitle() {
        CaptionPanel captionPanel = this.myCaption;
        if (captionPanel == null) {
            AbstractPopup.$$$reportNull$$$0(67);
        }
        return captionPanel;
    }

    protected void setHeaderComponent(JComponent c) {
        boolean doRevalidate = false;
        if (this.myHeaderComponent != null) {
            this.myHeaderPanel.remove(this.myHeaderComponent);
            this.myHeaderComponent = null;
            doRevalidate = true;
        }
        if (c != null) {
            this.myHeaderPanel.add((Component)c, "Center");
            this.myHeaderComponent = c;
            if (this.isVisible()) {
                Dimension size2 = this.myContent.getSize();
                if (size2.height < c.getPreferredSize().height * 2) {
                    size2.height += c.getPreferredSize().height;
                    this.setSize(size2);
                }
            }
            doRevalidate = true;
        }
        if (doRevalidate) {
            this.myContent.revalidate();
        }
    }

    public void setWarning(@NotNull @NlsContexts.Label String text2) {
        if (text2 == null) {
            AbstractPopup.$$$reportNull$$$0(68);
        }
        JBLabel label2 = new JBLabel(text2, UIUtil.getBalloonWarningIcon(), 0);
        label2.setOpaque(true);
        Color color = HintUtil.getInformationColor();
        label2.setBackground(color);
        label2.setBorder(BorderFactory.createLineBorder(color, 3));
        this.myHeaderPanel.add((Component)label2, "South");
    }

    public void addListener(@NotNull JBPopupListener listener2) {
        if (listener2 == null) {
            AbstractPopup.$$$reportNull$$$0(69);
        }
        this.myListeners.add(0, listener2);
    }

    public void removeListener(@NotNull JBPopupListener listener2) {
        if (listener2 == null) {
            AbstractPopup.$$$reportNull$$$0(70);
        }
        this.myListeners.remove(listener2);
    }

    protected void onSpeedSearchPatternChanged() {
    }

    public Component getOwner() {
        return this.myRequestorComponent;
    }

    public void setMinimumSize(Dimension size2) {
        Dimension sizeFromHeader = this.myHeaderPanel.getPreferredSize();
        if (sizeFromHeader == null) {
            sizeFromHeader = this.myHeaderPanel.getMinimumSize();
        }
        if (sizeFromHeader == null) {
            int minimumSize = this.myWindow.getGraphics().getFontMetrics(this.myHeaderPanel.getFont()).getHeight();
            sizeFromHeader = new Dimension(minimumSize, minimumSize);
        }
        if (size2 == null) {
            this.myMinSize = sizeFromHeader;
        } else {
            int width = Math.max(size2.width, sizeFromHeader.width);
            int height = Math.max(size2.height, sizeFromHeader.height);
            this.myMinSize = new Dimension(width, height);
        }
        if (this.myWindow != null) {
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle((Point)this.myWindow.getLocation());
            int width = Math.min(screenRectangle.width, this.myMinSize.width);
            int height = Math.min(screenRectangle.height, this.myMinSize.height);
            this.myWindow.setMinimumSize(new Dimension(width, height));
        }
    }

    public void setOkHandler(Runnable okHandler) {
        this.myOkHandler = okHandler;
    }

    public void setFinalRunnable(Runnable finalRunnable) {
        this.myFinalRunnable = finalRunnable;
    }

    public void setOk(boolean ok) {
        this.myOk = ok;
    }

    public void setDataProvider(@NotNull DataProvider dataProvider) {
        if (dataProvider == null) {
            AbstractPopup.$$$reportNull$$$0(71);
        }
        if (this.myContent != null) {
            this.myContent.setDataProvider(dataProvider);
        }
    }

    public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
        BooleanFunction<? super KeyEvent> handler2;
        if (e == null) {
            AbstractPopup.$$$reportNull$$$0(72);
        }
        if ((handler2 = this.myKeyEventHandler) != null && handler2.fun((Object)e)) {
            return true;
        }
        if (AbstractPopup.isCloseRequest(e) && this.myCancelKeyEnabled && !this.mySpeedSearch.isHoldingFilter()) {
            if (this.mySpeedSearchFoundInRootComponent != null && this.mySpeedSearchFoundInRootComponent.isHoldingFilter()) {
                this.mySpeedSearchFoundInRootComponent.reset();
            } else {
                this.cancel(e);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public Dimension getHeaderPreferredSize() {
        Dimension dimension = this.myHeaderPanel.getPreferredSize();
        if (dimension == null) {
            AbstractPopup.$$$reportNull$$$0(73);
        }
        return dimension;
    }

    @NotNull
    public Dimension getFooterPreferredSize() {
        Dimension dimension = this.myAdComponent == null ? new Dimension(0, 0) : this.myAdComponent.getPreferredSize();
        if (dimension == null) {
            AbstractPopup.$$$reportNull$$$0(74);
        }
        return dimension;
    }

    public static boolean isCloseRequest(KeyEvent e) {
        return e != null && e.getID() == 401 && e.getKeyCode() == 27 && e.getModifiers() == 0;
    }

    @NotNull
    private Point fixLocateByContent(@NotNull Point location, boolean save2) {
        Dimension size2;
        if (location == null) {
            AbstractPopup.$$$reportNull$$$0(75);
        }
        Dimension dimension = size2 = !this.myLocateByContent ? null : this.myHeaderPanel.getPreferredSize();
        if (size2 != null) {
            location.y = location.y - (save2 ? -size2.height : size2.height);
        }
        Point point = location;
        if (point == null) {
            AbstractPopup.$$$reportNull$$$0(76);
        }
        return point;
    }

    protected boolean isBusy() {
        return this.myResizeListener != null && this.myResizeListener.isBusy() || this.myMoveListener != null && this.myMoveListener.isBusy();
    }

    private static Component getFrameOrDialog(Component component2) {
        while (component2 != null) {
            if (component2 instanceof Window) {
                return component2;
            }
            component2 = component2.getParent();
        }
        return null;
    }

    @Nullable
    private static Point getLocationOnScreen(@Nullable Component component2) {
        return component2 == null || !component2.isShowing() ? null : component2.getLocationOnScreen();
    }

    @Nullable
    private static Rectangle getBoundsOnScreen(@Nullable Component component2) {
        Point point = AbstractPopup.getLocationOnScreen(component2);
        return point == null ? null : new Rectangle(point, component2.getSize());
    }

    @NotNull
    public static List<JBPopup> getChildPopups(@NotNull Component component2) {
        if (component2 == null) {
            AbstractPopup.$$$reportNull$$$0(77);
        }
        List list2 = ContainerUtil.filter((Collection)all.toStrongList(), popup2 -> {
            for (Component owner = popup2.getOwner(); owner != null; owner = owner.getParent()) {
                if (!owner.equals(component2)) continue;
                return true;
            }
            return false;
        });
        if (list2 == null) {
            AbstractPopup.$$$reportNull$$$0(78);
        }
        return list2;
    }

    public boolean canShow() {
        return this.myState == State.INIT;
    }

    @Override
    @NotNull
    public Rectangle getConsumedScreenBounds() {
        Rectangle rectangle = this.myWindow.getBounds();
        if (rectangle == null) {
            AbstractPopup.$$$reportNull$$$0(79);
        }
        return rectangle;
    }

    @Override
    public Window getUnderlyingWindow() {
        return this.myWindow.getOwner();
    }

    public void addResizeListener(@NotNull Runnable runnable2, @NotNull Disposable parentDisposable) {
        if (runnable2 == null) {
            AbstractPopup.$$$reportNull$$$0(80);
        }
        if (parentDisposable == null) {
            AbstractPopup.$$$reportNull$$$0(81);
        }
        this.myResizeListeners.add(runnable2);
        Disposer.register((Disposable)parentDisposable, () -> this.myResizeListeners.remove(runnable2));
    }

    private static boolean isCancelNeeded(@NotNull WindowEvent event, @Nullable Window popup2) {
        if (event == null) {
            AbstractPopup.$$$reportNull$$$0(82);
        }
        for (Window window = event.getWindow(); window != null; window = window.getOwner()) {
            if (popup2 != window) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private Point getStoredLocation() {
        if (this.myDimensionServiceKey == null) {
            return null;
        }
        return AbstractPopup.getWindowStateService(this.getProjectDependingOnKey(this.myDimensionServiceKey)).getLocation(this.myDimensionServiceKey);
    }

    @Nullable
    private Dimension getStoredSize() {
        if (this.myDimensionServiceKey == null) {
            return null;
        }
        return AbstractPopup.getWindowStateService(this.getProjectDependingOnKey(this.myDimensionServiceKey)).getSize(this.myDimensionServiceKey);
    }

    @NotNull
    private static WindowStateService getWindowStateService(@Nullable Project project) {
        WindowStateService windowStateService = project == null ? WindowStateService.getInstance() : WindowStateService.getInstance((Project)project);
        if (windowStateService == null) {
            AbstractPopup.$$$reportNull$$$0(83);
        }
        return windowStateService;
    }

    private static <T> T findInComponentHierarchy(@NotNull Component component2, Function<? super @NotNull Component, ? extends @Nullable T> mapper2) {
        Object found;
        if (component2 == null) {
            AbstractPopup.$$$reportNull$$$0(84);
        }
        if ((found = mapper2.fun((Object)component2)) != null) {
            return (T)found;
        }
        if (component2 instanceof JComponent) {
            for (Component child2 : ((JComponent)component2).getComponents()) {
                found = AbstractPopup.findInComponentHierarchy(child2, mapper2);
                if (found == null) continue;
                return (T)found;
            }
        }
        return null;
    }

    @Nullable
    private JScrollBar findHorizontalScrollBar() {
        JScrollPane pane2 = ScrollUtil.findScrollPane((JComponent)this.myContent);
        if (pane2 == null || 31 == pane2.getHorizontalScrollBarPolicy()) {
            return null;
        }
        return pane2.getHorizontalScrollBar();
    }

    private void forHorizontalScrollBar(@NotNull Consumer<JScrollBar> consumer) {
        JScrollBar bar2;
        if (consumer == null) {
            AbstractPopup.$$$reportNull$$$0(85);
        }
        if ((bar2 = this.findHorizontalScrollBar()) != null) {
            consumer.consume((Object)bar2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 2: 
            case 77: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyboardActions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusOwners";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/popup/AbstractPopup";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "border";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aContainer";
                break;
            }
            case 15: 
            case 56: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentSize";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aComponent";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aPoint";
                break;
            }
            case 23: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 34: 
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenPoint";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalLocation";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupSize";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layeredPane";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 45: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userDataClass";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/popup/AbstractPopup";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "init";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupBorder";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapToSize";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCenterOf";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestPositionFor";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePointByQuickSearch";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "toRelativePoint";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationAboveEditorLineIfPopupIsClippedAtTheBottom";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePointWithDominantRectangle";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredContentSize";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationOnScreen";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeaderPreferredSize";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getFooterPreferredSize";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "fixLocateByContent";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildPopups";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsumedScreenBounds";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "getWindowStateService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "debugState";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createContentPanel";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAdText";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "wrapToSize";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCenterOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showCenteredInCurrentWindow";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showInCenterOf";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "showUnderneathOf";
                break;
            }
            case 22: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "show";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showInScreenCoordinates";
                break;
            }
            case 25: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getBestPositionFor";
                break;
            }
            case 28: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showInBestPositionFor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "relativePointByQuickSearch";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "guessBestPopupLocation";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "toRelativePoint";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLocationAboveEditorLineIfPopupIsClippedAtTheBottom";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "relativePointWithDominantRectangle";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "fitToScreenAdjustingVertically";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "installWindowHook";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "moveTo";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getContentWindow";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "setSize";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "setCaption";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "setUserData";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isFocused";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "setWarning";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setDataProvider";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "dispatchKeyEvent";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "fixLocateByContent";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getChildPopups";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "addResizeListener";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isCancelNeeded";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "findInComponentHierarchy";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "forHorizontalScrollBar";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 18: 
            case 26: 
            case 27: 
            case 30: 
            case 35: 
            case 39: 
            case 40: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 52: 
            case 59: 
            case 67: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 83: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        @Override
        public void windowOpened(WindowEvent e) {
            AbstractPopup.this.updateMaskAndAlpha(AbstractPopup.this.myWindow);
        }

        @Override
        public void windowClosing(WindowEvent e) {
            AbstractPopup.this.resetWindow();
            AbstractPopup.this.cancel();
        }
    }

    private class Canceller
    implements AWTEventListener {
        private boolean myEverEntered;

        private Canceller() {
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            switch (event.getID()) {
                case 205: 
                case 207: {
                    if (!AbstractPopup.this.myCancelOnWindow || AbstractPopup.this.myPopup == null || !AbstractPopup.isCancelNeeded((WindowEvent)event, AbstractPopup.this.myPopup.getWindow())) break;
                    AbstractPopup.this.cancel();
                    break;
                }
                case 504: {
                    if (!this.withinPopup(event)) break;
                    this.myEverEntered = true;
                    break;
                }
                case 501: 
                case 503: {
                    if (AbstractPopup.this.myCancelOnMouseOutCallback == null || !this.myEverEntered || this.withinPopup(event) || !AbstractPopup.this.myCancelOnMouseOutCallback.check((MouseEvent)event)) break;
                    AbstractPopup.this.cancel();
                }
            }
        }

        private boolean withinPopup(@NotNull AWTEvent event) {
            if (event == null) {
                Canceller.$$$reportNull$$$0(0);
            }
            MouseEvent mouse = (MouseEvent)event;
            Rectangle bounds2 = AbstractPopup.getBoundsOnScreen(AbstractPopup.this.myContent);
            return bounds2 != null && bounds2.contains(mouse.getLocationOnScreen());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ui/popup/AbstractPopup$Canceller", "withinPopup"));
        }
    }

    public static class MyContentPanel
    extends JPanel
    implements DataProvider {
        @Nullable
        private DataProvider myDataProvider;

        public MyContentPanel(@NotNull PopupBorder border) {
            if (border == null) {
                MyContentPanel.$$$reportNull$$$0(0);
            }
            super(new BorderLayout());
            MnemonicHelper.init((Component)this);
            this.putClientProperty(UIUtil.TEXT_COPY_ROOT, Boolean.TRUE);
            this.setBorder((Border)border);
        }

        public Dimension computePreferredSize() {
            if (this.isPreferredSizeSet()) {
                Dimension setSize = this.getPreferredSize();
                this.setPreferredSize(null);
                Dimension result2 = this.getPreferredSize();
                this.setPreferredSize(setSize);
                return result2;
            }
            return this.getPreferredSize();
        }

        @Override
        @Nullable
        public Object getData(@NotNull @NonNls String dataId) {
            if (dataId == null) {
                MyContentPanel.$$$reportNull$$$0(1);
            }
            return this.myDataProvider != null ? this.myDataProvider.getData(dataId) : null;
        }

        public void setDataProvider(@Nullable DataProvider dataProvider) {
            this.myDataProvider = dataProvider;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "border";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ui/popup/AbstractPopup$MyContentPanel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getData";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum State {
        NEW,
        INIT,
        SHOWING,
        SHOWN,
        CANCEL,
        DISPOSE;

    }
}

