/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.Executor;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.mac.touchbar.ActionsLoader;
import com.intellij.ui.mac.touchbar.Customizer;
import com.intellij.ui.mac.touchbar.TouchBarsManager;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.Component;
import java.util.Map;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CtxDefault {
    private static final Logger LOG = Logger.getInstance(CtxDefault.class);
    private static MessageBusConnection ourConnection = null;
    private static final String RUN_DEBUG_GROUP_TOUCHBAR = "RunnerActionsTouchbar";

    CtxDefault() {
    }

    static void initialize() {
        for (Project project : ProjectUtil.getOpenProjects()) {
            CtxDefault.registerTouchbarActions(project);
        }
        ourConnection = ApplicationManager.getApplication().getMessageBus().connect();
        ourConnection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                CtxDefault.registerTouchbarActions(project);
            }

            public void projectClosed(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.debug("closed project: %s", new Object[]{project});
                JFrame frame = WindowManager.getInstance().getFrame(project);
                if (frame == null) {
                    LOG.debug("null frame for project: %s", new Object[]{project});
                    return;
                }
                TouchBarsManager.unregister(frame);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "project";
                objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxDefault$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectOpened";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "projectClosed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        CtxDefault.fillRunDebugGroup();
    }

    static void disable() {
        if (ourConnection != null) {
            ourConnection.disconnect();
        }
        ourConnection = null;
    }

    private static void registerTouchbarActionsImpl(@NotNull Project project) {
        if (project == null) {
            CtxDefault.$$$reportNull$$$0(0);
        }
        if (project.isDisposed()) {
            return;
        }
        JFrame frame = WindowManager.getInstance().getFrame(project);
        if (frame == null) {
            LOG.debug("null frame for project: %s", new Object[]{project});
            return;
        }
        @Nullable Pair<Map<Long, ActionGroup>, Customizer> defaultGroup = ActionsLoader.getProjectDefaultActionGroup();
        if (defaultGroup == null) {
            LOG.debug("can't load default action group for project: %s", new Object[]{project});
            TouchBarsManager.unregister(frame);
            return;
        }
        LOG.debug("register project-default action group %s | frame %s", new Object[]{project, frame});
        TouchBarsManager.registerAndShow((Component)frame, (Map)defaultGroup.first, (Customizer)defaultGroup.second);
    }

    private static void registerTouchbarActions(@NotNull Project project) {
        if (project == null) {
            CtxDefault.$$$reportNull$$$0(1);
        }
        StartupManager.getInstance((Project)project).runAfterOpened(() -> {
            if (project.isDisposed()) {
                return;
            }
            LOG.debug("register touchbar actions for project %s", new Object[]{project});
            CtxDefault.registerTouchbarActionsImpl(project);
        });
    }

    static void reloadAllActions() {
        for (Project project : ProjectUtil.getOpenProjects()) {
            CtxDefault.registerTouchbarActionsImpl(project);
        }
    }

    private static void fillRunDebugGroup() {
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            LOG.debug("service ActionManager wasn't cerated, schedule next try after 500ms");
            SimpleTimer.getInstance().setUp(() -> CtxDefault.fillRunDebugGroup(), 500L);
            return;
        }
        AnAction runButtons = actionManager.getAction(RUN_DEBUG_GROUP_TOUCHBAR);
        if (runButtons == null) {
            LOG.debug("RunnersGroup for touchbar is unregistered");
            return;
        }
        if (!(runButtons instanceof DefaultActionGroup)) {
            LOG.debug("RunnersGroup for touchbar isn't a group");
            return;
        }
        if (((DefaultActionGroup)runButtons).getChildrenCount() > 0) {
            LOG.debug("RunnersGroup for touchbar is already filled, skip fill");
            return;
        }
        DefaultActionGroup group2 = (DefaultActionGroup)runButtons;
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            if (!executor.getId().equals("Run") && !executor.getId().equals("Debug")) continue;
            group2.add(actionManager.getAction(executor.getId()), actionManager);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/intellij/ui/mac/touchbar/CtxDefault";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTouchbarActionsImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerTouchbarActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

