/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.DefaultLinkButtonUIKt;
import com.intellij.ui.components.UnderlinedView;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.StringReader;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000U\n\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0001\u001a\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0002\u001a\u0015\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\f2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u001d0\u001fH\u0002\u001a\u000e\u0010!\u001a\u0004\u0018\u00010\"*\u00020\u0010H\u0002\u001a\f\u0010#\u001a\u00020$*\u00020\u0010H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\"\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"sharedEditorKit", "com/intellij/ui/components/DefaultLinkButtonUIKt$sharedEditorKit$2$1", "getSharedEditorKit", "()Lcom/intellij/ui/components/DefaultLinkButtonUIKt$sharedEditorKit$2$1;", "sharedEditorKit$delegate", "Lkotlin/Lazy;", "sharedUnderlineStyles", "Ljavax/swing/text/html/StyleSheet;", "getSharedUnderlineStyles", "()Ljavax/swing/text/html/StyleSheet;", "sharedUnderlineStyles$delegate", "underlineStyles", "", "createUnderlinedView", "Ljavax/swing/text/View;", "button", "Ljavax/swing/AbstractButton;", "text", "getColor", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "htmlView", "isEnabled", "", "isFocused", "isHovered", "isPressed", "isVisited", "readSafely", "", "read", "Lkotlin/Function1;", "Ljava/io/StringReader;", "focusInsets", "Ljava/awt/Insets;", "viewBounds", "Ljava/awt/Rectangle;", "intellij.platform.ide.impl"})
public final class DefaultLinkButtonUIKt {
    @NonNls
    private static final String underlineStyles = "\np { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }\nbody { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }\nfont {text-decoration: underline}\n";
    private static final Lazy sharedUnderlineStyles$delegate = LazyKt.lazy((Function0)sharedUnderlineStyles.2.INSTANCE);
    private static final Lazy sharedEditorKit$delegate = LazyKt.lazy((Function0)sharedEditorKit.2.INSTANCE);

    private static final Rectangle viewBounds(AbstractButton $this$viewBounds) {
        Rectangle rectangle = new Rectangle($this$viewBounds.getWidth(), $this$viewBounds.getHeight());
        boolean bl = false;
        boolean bl2 = false;
        Rectangle it = rectangle;
        boolean bl3 = false;
        JBInsets.removeFrom((Rectangle)it, (Insets)$this$viewBounds.getInsets());
        JBInsets.removeFrom((Rectangle)it, (Insets)DefaultLinkButtonUIKt.focusInsets($this$viewBounds));
        return rectangle;
    }

    private static final Insets focusInsets(AbstractButton $this$focusInsets) {
        if (!$this$focusInsets.isFocusPainted()) {
            return null;
        }
        int margin = JBUIScale.scale((int)1);
        return new Insets(0, margin, 0, margin);
    }

    private static final boolean isEnabled(AbstractButton button4) {
        ButtonModel buttonModel = button4.getModel();
        return buttonModel != null ? buttonModel.isEnabled() : false;
    }

    private static final boolean isHovered(AbstractButton button4) {
        ButtonModel buttonModel = button4.getModel();
        return buttonModel != null ? buttonModel.isRollover() : false;
    }

    private static final boolean isPressed(AbstractButton button4) {
        boolean bl;
        ButtonModel buttonModel = button4.getModel();
        if (buttonModel != null) {
            ButtonModel buttonModel2 = buttonModel;
            boolean bl2 = false;
            boolean bl3 = false;
            ButtonModel it = buttonModel2;
            boolean bl4 = false;
            bl = it.isArmed() && it.isPressed();
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isVisited(AbstractButton button4) {
        AbstractButton abstractButton = button4;
        if (!(abstractButton instanceof ActionLink)) {
            abstractButton = null;
        }
        ActionLink actionLink2 = (ActionLink)abstractButton;
        return actionLink2 != null ? actionLink2.getVisited() : false;
    }

    private static final boolean isFocused(AbstractButton button4) {
        return button4.isFocusPainted() && button4.hasFocus() && !DefaultLinkButtonUIKt.isPressed(button4);
    }

    private static final Color getColor(AbstractButton button4) {
        Color color = !DefaultLinkButtonUIKt.isEnabled(button4) ? JBUI.CurrentTheme.Link.Foreground.DISABLED : (DefaultLinkButtonUIKt.isPressed(button4) ? JBUI.CurrentTheme.Link.Foreground.PRESSED : (DefaultLinkButtonUIKt.isHovered(button4) ? JBUI.CurrentTheme.Link.Foreground.HOVERED : (DefaultLinkButtonUIKt.isVisited(button4) ? JBUI.CurrentTheme.Link.Foreground.VISITED : JBUI.CurrentTheme.Link.Foreground.ENABLED)));
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"when {\n  !isEnabled(butt\u2026Link.Foreground.ENABLED\n}");
        return color;
    }

    private static final View htmlView(AbstractButton button4) {
        Object object = button4.getClientProperty("html");
        if (!(object instanceof View)) {
            object = null;
        }
        return (View)object;
    }

    private static final View createUnderlinedView(AbstractButton button4, String text2) {
        StyleSheet styles = new StyleSheet();
        styles.addStyleSheet(DefaultLinkButtonUIKt.getSharedUnderlineStyles());
        styles.addStyleSheet(DefaultLinkButtonUIKt.getSharedEditorKit().getStyleSheet());
        styles.addRule(UIUtilities.displayPropertiesToCSS((Font)button4.getFont(), (Color)button4.getForeground()));
        HTMLDocument document = new HTMLDocument(styles);
        document.setAsynchronousLoadPriority(Integer.MAX_VALUE);
        document.setPreservesUnknownTags(false);
        Object base = button4.getClientProperty("html.base");
        if (base instanceof URL) {
            document.setBase((URL)base);
        }
        DefaultLinkButtonUIKt.readSafely(text2, (Function1<? super StringReader, Unit>)((Function1)new Function1<StringReader, Unit>(document){
            final /* synthetic */ HTMLDocument $document;

            public final void invoke(@NotNull StringReader it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DefaultLinkButtonUIKt.access$getSharedEditorKit$p().read(it, (Document)this.$document, 0);
            }
            {
                this.$document = hTMLDocument;
                super(1);
            }
        }));
        sharedEditorKit.lazyViewFactory.1 v0 = DefaultLinkButtonUIKt.getSharedEditorKit().getViewFactory();
        Element element2 = document.getDefaultRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"document.defaultRootElement");
        return new UnderlinedView(button4, v0.create(element2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void readSafely(String text2, Function1<? super StringReader, Unit> read) {
        try (StringReader reader = new StringReader(text2);){
            read.invoke((Object)reader);
        }
    }

    private static final StyleSheet getSharedUnderlineStyles() {
        Lazy lazy = sharedUnderlineStyles$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (StyleSheet)lazy.getValue();
    }

    private static final sharedEditorKit.1 getSharedEditorKit() {
        Lazy lazy = sharedEditorKit$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return lazy.getValue();
    }

    public static final /* synthetic */ View access$htmlView(AbstractButton button4) {
        return DefaultLinkButtonUIKt.htmlView(button4);
    }

    public static final /* synthetic */ Insets access$focusInsets(AbstractButton $this$access_u24focusInsets) {
        return DefaultLinkButtonUIKt.focusInsets($this$access_u24focusInsets);
    }

    public static final /* synthetic */ Rectangle access$viewBounds(AbstractButton $this$access_u24viewBounds) {
        return DefaultLinkButtonUIKt.viewBounds($this$access_u24viewBounds);
    }

    public static final /* synthetic */ boolean access$isPressed(AbstractButton button4) {
        return DefaultLinkButtonUIKt.isPressed(button4);
    }

    public static final /* synthetic */ boolean access$isHovered(AbstractButton button4) {
        return DefaultLinkButtonUIKt.isHovered(button4);
    }

    public static final /* synthetic */ boolean access$isEnabled(AbstractButton button4) {
        return DefaultLinkButtonUIKt.isEnabled(button4);
    }

    public static final /* synthetic */ View access$createUnderlinedView(AbstractButton button4, String text2) {
        return DefaultLinkButtonUIKt.createUnderlinedView(button4, text2);
    }

    public static final /* synthetic */ boolean access$isFocused(AbstractButton button4) {
        return DefaultLinkButtonUIKt.isFocused(button4);
    }

    public static final /* synthetic */ Color access$getColor(AbstractButton button4) {
        return DefaultLinkButtonUIKt.getColor(button4);
    }

    public static final /* synthetic */ sharedEditorKit.1 access$getSharedEditorKit$p() {
        return DefaultLinkButtonUIKt.getSharedEditorKit();
    }

    public static final /* synthetic */ void access$readSafely(String text2, Function1 read) {
        DefaultLinkButtonUIKt.readSafely(text2, (Function1<? super StringReader, Unit>)read);
    }
}

