/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorPipette;
import com.intellij.ui.colorpicker.SaturationBrightnessComponentKt;
import com.intellij.ui.colorpicker.SaturationBrightnessImageProducer;
import com.intellij.ui.colorpicker.UtilsKt;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MultiResolutionImage;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.image.ToolkitImage;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u000e\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0014J\u000e\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u000200J\u0010\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\"H\u0016J(\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\f2\u0006\u00107\u001a\u00020\f2\u0006\u00108\u001a\u00020\f2\u0006\u00109\u001a\u00020\bH\u0002J\u0010\u0010:\u001a\u00020\u001f2\u0006\u0010;\u001a\u00020\"H\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000f\u00a8\u0006<"}, d2={"Lcom/intellij/ui/colorpicker/SaturationBrightnessComponent;", "Ljavax/swing/JComponent;", "Lcom/intellij/ui/picker/ColorListener;", "Lcom/intellij/ui/colorpicker/ColorPipette$Callback;", "myModel", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "(Lcom/intellij/ui/colorpicker/ColorPickerModel;)V", "<set-?>", "", "alpha", "getAlpha", "()I", "", "brightness", "getBrightness", "()F", "hue", "getHue", "pipetteMode", "", "getPipetteMode", "()Z", "setPipetteMode", "(Z)V", "robot", "Ljava/awt/Robot;", "getRobot", "()Ljava/awt/Robot;", "saturation", "getSaturation", "cancel", "", "colorChanged", "color", "Ljava/awt/Color;", "source", "", "getColorByPoint", "p", "Ljava/awt/Point;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "handleMouseEvent", "e", "Ljava/awt/event/MouseEvent;", "paintComponent", "g", "Ljava/awt/Graphics;", "paintPipetteMode", "graphics", "picked", "pickedColor", "setHSBAValue", "h", "s", "b", "a", "update", "updatedColor", "intellij.platform.ide.impl"})
public final class SaturationBrightnessComponent
extends JComponent
implements ColorListener,
ColorPipette.Callback {
    private float brightness;
    private float hue;
    private float saturation;
    private int alpha;
    private boolean pipetteMode;
    @NotNull
    private final Robot robot;
    private final ColorPickerModel myModel;

    public final float getBrightness() {
        return this.brightness;
    }

    public final float getHue() {
        return this.hue;
    }

    public final float getSaturation() {
        return this.saturation;
    }

    public final int getAlpha() {
        return this.alpha;
    }

    public final boolean getPipetteMode() {
        return this.pipetteMode;
    }

    public final void setPipetteMode(boolean bl) {
        this.pipetteMode = bl;
    }

    @NotNull
    public final Robot getRobot() {
        return this.robot;
    }

    private final void handleMouseEvent(MouseEvent e) {
        Point point = e.getPoint();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
        this.myModel.setColor(this.getColorByPoint(point), this);
    }

    @NotNull
    public final Color getColorByPoint(@NotNull Point p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int x = Math.max(0, Math.min(p.x, this.getSize().width));
        int y = Math.max(0, Math.min(p.y, this.getSize().height));
        float saturation = (float)x / (float)this.getSize().width;
        float brightness = 1.0f - (float)y / (float)this.getSize().height;
        int argb = UtilsKt.ahsbToArgb(this.alpha, this.hue, saturation, brightness);
        Color newColor = new Color(argb, true);
        return newColor;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        JBDimension jBDimension = JBUI.size((int)300, (int)150);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"JBUI.size(PICKER_PREFERRED_WIDTH, 150)");
        return (Dimension)jBDimension;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        JBDimension jBDimension = JBUI.size((int)150, (int)140);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"JBUI.size(150, 140)");
        return (Dimension)jBDimension;
    }

    public final void paintPipetteMode(@NotNull Graphics graphics) {
        MultiResolutionImage img;
        Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
        Container container = this.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)container, (String)"parent");
        graphics.setColor(container.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics graphics2 = graphics.create();
        if (graphics2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g = (Graphics2D)graphics2;
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Intrinsics.checkNotNullExpressionValue((Object)pointerInfo, (String)"MouseInfo.getPointerInfo()");
        Point p = pointerInfo.getLocation();
        double size2 = (double)this.getWidth() / 21.0;
        MultiResolutionImage multiResolutionImage = img = this.robot.createMultiResolutionScreenCapture(new Rectangle(p.x - 10, p.y - 5, 21, 11));
        Intrinsics.checkNotNullExpressionValue((Object)multiResolutionImage, (String)"img");
        List<Image> list2 = multiResolutionImage.getResolutionVariants();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"img.resolutionVariants");
        Image image = (Image)CollectionsKt.last(list2);
        int iW = image.getWidth(null);
        int iH = image.getHeight(null);
        g.scale((double)this.getWidth() / 21.0, (double)this.getWidth() / 21.0);
        double d = (double)(iH - 11) / 2.0;
        boolean bl = false;
        g.drawImage(image, -((int)((double)(iW - 21) / 2.0)), -((int)Math.ceil(d)), null);
        g.dispose();
        double d2 = size2 * (double)10;
        boolean bl2 = false;
        int xx = (int)Math.ceil(d2);
        double d3 = size2 * (double)5;
        boolean bl3 = false;
        int yy = (int)Math.ceil(d3);
        graphics.setColor(Color.white);
        graphics.drawRect(xx, yy, (int)(size2 - 1.0), (int)(size2 - 1.0));
        graphics.setColor(Color.black);
        graphics.drawRect(xx + 1, yy + 1, (int)(size2 - (double)3), (int)(size2 - (double)3));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (Registry.is((String)"ide.color.picker.new.pipette") && this.pipetteMode) {
            this.paintPipetteMode(g);
            return;
        }
        component = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        image = this.createImage(new SaturationBrightnessImageProducer(this.getSize().width, this.getSize().height, this.hue));
        g.setColor(UIUtil.getPanelBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(image, component.x, component.y, null);
        knobX = Math.round(this.saturation * (float)component.width);
        knobY = Math.round((float)component.height * (1.0f - this.brightness));
        if (!(image instanceof ToolkitImage)) ** GOTO lbl-1000
        v0 = ((ToolkitImage)image).getBufferedImage();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"image.bufferedImage");
        if (v0.getWidth() <= knobX) ** GOTO lbl-1000
        v1 = ((ToolkitImage)image).getBufferedImage();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"image.bufferedImage");
        if (v1.getHeight() > knobY) {
            rgb = ((ToolkitImage)image).getBufferedImage().getRGB(knobX, knobY);
            g.setColor(ColorUtil.isDark((Color)new Color(rgb)) != false ? Color.WHITE : Color.BLACK);
        } else lbl-1000:
        // 3 sources

        {
            g.setColor(SaturationBrightnessComponentKt.access$getKNOB_COLOR$p());
        }
        config = GraphicsUtil.setupAAPainting((Graphics)g);
        g.drawOval(knobX - JBUI.scale((int)4), knobY - JBUI.scale((int)4), JBUI.scale((int)8), JBUI.scale((int)8));
        config.restore();
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        float[] hsbValues = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        this.setHSBAValue(hsbValues[0], hsbValues[1], hsbValues[2], color.getAlpha());
    }

    private final void setHSBAValue(float h, float s, float b, int a) {
        this.hue = h;
        this.saturation = s;
        this.brightness = b;
        this.alpha = a;
        this.repaint();
    }

    @Override
    public void picked(@NotNull Color pickedColor) {
        Intrinsics.checkNotNullParameter((Object)pickedColor, (String)"pickedColor");
        this.pipetteMode = false;
    }

    @Override
    public void update(@NotNull Color updatedColor) {
        Intrinsics.checkNotNullParameter((Object)updatedColor, (String)"updatedColor");
        this.pipetteMode = true;
        this.repaint();
    }

    @Override
    public void cancel() {
        this.pipetteMode = false;
    }

    public SaturationBrightnessComponent(@NotNull ColorPickerModel myModel) {
        Intrinsics.checkNotNullParameter((Object)myModel, (String)"myModel");
        this.myModel = myModel;
        this.brightness = 1.0f;
        this.hue = 1.0f;
        this.alpha = 255;
        this.robot = new Robot();
        this.setOpaque(false);
        this.setBackground(Color.WHITE);
        MouseAdapter mouseAdapter2 = new MouseAdapter(this){
            final /* synthetic */ SaturationBrightnessComponent this$0;

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e);
            }

            public void mouseDragged(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SaturationBrightnessComponent.access$handleMouseEvent(this.this$0, e);
            }
            {
                this.this$0 = this$0;
            }
        };
        this.addMouseListener(mouseAdapter2);
        this.addMouseMotionListener(mouseAdapter2);
        this.myModel.addListener(this);
        if (Registry.is((String)"ide.color.picker.new.pipette")) {
            this.myModel.addPipetteListener(this);
        }
    }

    public static final /* synthetic */ void access$handleMouseEvent(SaturationBrightnessComponent $this, MouseEvent e) {
        $this.handleMouseEvent(e);
    }
}

