/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.colorpicker.AlphaSliderComponent;
import com.intellij.ui.colorpicker.ColorAdjustPanelKt;
import com.intellij.ui.colorpicker.ColorIndicator;
import com.intellij.ui.colorpicker.ColorPickerBuilderKt;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorPipetteButton;
import com.intellij.ui.colorpicker.ColorPipetteProvider;
import com.intellij.ui.colorpicker.HueSliderComponent;
import com.intellij.ui.colorpicker.SliderComponent;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicButtonUI;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016R\u001c\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u00020\u00118\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0012\u0010\r\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/ui/colorpicker/ColorAdjustPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/ui/picker/ColorListener;", "model", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "pipetteProvider", "Lcom/intellij/ui/colorpicker/ColorPipetteProvider;", "showAlpha", "", "(Lcom/intellij/ui/colorpicker/ColorPickerModel;Lcom/intellij/ui/colorpicker/ColorPipetteProvider;Z)V", "alphaSlider", "Lcom/intellij/ui/colorpicker/AlphaSliderComponent;", "getAlphaSlider$annotations", "()V", "getAlphaSlider", "()Lcom/intellij/ui/colorpicker/AlphaSliderComponent;", "colorIndicator", "Lcom/intellij/ui/colorpicker/ColorIndicator;", "getColorIndicator$annotations", "getColorIndicator", "()Lcom/intellij/ui/colorpicker/ColorIndicator;", "hueSlider", "Lcom/intellij/ui/colorpicker/HueSliderComponent;", "getHueSlider$annotations", "getHueSlider", "()Lcom/intellij/ui/colorpicker/HueSliderComponent;", "pipetteButton", "Lcom/intellij/ui/colorpicker/ColorPipetteButton;", "getPipetteButton", "()Lcom/intellij/ui/colorpicker/ColorPipetteButton;", "pipetteButton$delegate", "Lkotlin/Lazy;", "colorChanged", "", "color", "Ljava/awt/Color;", "source", "", "intellij.platform.ide.impl"})
public final class ColorAdjustPanel
extends JPanel
implements ColorListener {
    private final Lazy pipetteButton$delegate;
    @NotNull
    private final ColorIndicator colorIndicator;
    @NotNull
    private final HueSliderComponent hueSlider;
    @NotNull
    private final AlphaSliderComponent alphaSlider;
    private final ColorPickerModel model;
    private final ColorPipetteProvider pipetteProvider;

    private final ColorPipetteButton getPipetteButton() {
        Lazy lazy = this.pipetteButton$delegate;
        ColorAdjustPanel colorAdjustPanel = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ColorPipetteButton)lazy.getValue();
    }

    @VisibleForTesting
    public static /* synthetic */ void getColorIndicator$annotations() {
    }

    @NotNull
    public final ColorIndicator getColorIndicator() {
        return this.colorIndicator;
    }

    @VisibleForTesting
    public static /* synthetic */ void getHueSlider$annotations() {
    }

    @NotNull
    public final HueSliderComponent getHueSlider() {
        return this.hueSlider;
    }

    @VisibleForTesting
    public static /* synthetic */ void getAlphaSlider$annotations() {
    }

    @NotNull
    public final AlphaSliderComponent getAlphaSlider() {
        return this.alphaSlider;
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (Intrinsics.areEqual((Object)this.colorIndicator.getColor(), (Object)color) ^ true) {
            this.colorIndicator.setColor(color);
        }
        float hue = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[0];
        int hueDegree = MathKt.roundToInt((float)(hue * (float)360));
        int n = ((Number)this.hueSlider.getValue()).intValue() - hueDegree;
        boolean bl = false;
        if (Math.abs(n) != 360) {
            this.hueSlider.setValue(hueDegree);
        }
        this.alphaSlider.setSliderBackgroundColor(color);
        if (((Number)this.alphaSlider.getValue()).intValue() != color.getAlpha()) {
            this.alphaSlider.setValue(color.getAlpha());
        }
        this.repaint();
    }

    public ColorAdjustPanel(@NotNull ColorPickerModel model2, @NotNull ColorPipetteProvider pipetteProvider, boolean showAlpha) {
        JComponent $this$apply;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)pipetteProvider, (String)"pipetteProvider");
        super(new GridBagLayout());
        this.model = model2;
        this.pipetteProvider = pipetteProvider;
        this.pipetteButton$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ColorPipetteButton>(this){
            final /* synthetic */ ColorAdjustPanel this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ColorPipetteButton invoke() {
                void var1_1;
                ColorPipetteButton colorPipetteButton = new ColorPipetteButton(ColorAdjustPanel.access$getModel$p(this.this$0), ColorAdjustPanel.access$getPipetteProvider$p(this.this$0).createPipette(this.this$0));
                boolean bl = false;
                boolean bl2 = false;
                ColorPipetteButton $this$with = colorPipetteButton;
                boolean bl3 = false;
                $this$with.setBorder((Border)ColorAdjustPanelKt.access$getPIPETTE_BUTTON_BORDER$p());
                $this$with.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
                $this$with.setUI(new BasicButtonUI());
                $this$with.setFocusable(false);
                $this$with.setPreferredSize((Dimension)ColorAdjustPanelKt.access$getCOLOR_INDICATOR_SIZE$p());
                return var1_1;
            }
            {
                this.this$0 = colorAdjustPanel;
                super(0);
            }
        }));
        JComponent jComponent = new ColorIndicator(null, 1, null);
        boolean bl = false;
        boolean bl2 = false;
        ColorIndicator colorIndicator = jComponent;
        ColorAdjustPanel colorAdjustPanel = this;
        boolean bl3 = false;
        $this$apply.setBorder(ColorAdjustPanelKt.access$getCOLOR_INDICATOR_BORDER$p());
        $this$apply.setPreferredSize((Dimension)ColorAdjustPanelKt.access$getCOLOR_INDICATOR_SIZE$p());
        Unit unit = Unit.INSTANCE;
        colorAdjustPanel.colorIndicator = jComponent;
        jComponent = new HueSliderComponent();
        bl = false;
        bl2 = false;
        $this$apply = jComponent;
        colorAdjustPanel = this;
        boolean bl4 = false;
        $this$apply.setBorder((Border)ColorAdjustPanelKt.access$getHUE_SLIDER_BORDER$p());
        $this$apply.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        ((SliderComponent)$this$apply).addListener((Function1)new Function1<Integer, Unit>(this, showAlpha){
            final /* synthetic */ ColorAdjustPanel this$0;
            final /* synthetic */ boolean $showAlpha$inlined;
            {
                this.this$0 = colorAdjustPanel;
                this.$showAlpha$inlined = bl;
                super(1);
            }

            public final void invoke(int it) {
                if (ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getRed() == ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getGreen() && ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getGreen() == ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getBlue()) {
                    return;
                }
                float hue = (float)it / 360.0f;
                float[] hsbValues = Color.RGBtoHSB(ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getRed(), ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getGreen(), ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getBlue(), null);
                int rgb = Color.HSBtoRGB(hue, hsbValues[1], hsbValues[2]);
                int argb = ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getAlpha() << 24 | rgb & 0xFFFFFF;
                Color newColor = this.$showAlpha$inlined ? new Color(argb, true) : new Color(rgb);
                ColorAdjustPanel.access$getModel$p(this.this$0).setColor(newColor, this.this$0);
            }
        });
        unit = Unit.INSTANCE;
        colorAdjustPanel.hueSlider = jComponent;
        jComponent = new AlphaSliderComponent();
        bl = false;
        bl2 = false;
        $this$apply = jComponent;
        colorAdjustPanel = this;
        boolean bl5 = false;
        $this$apply.setBorder((Border)ColorAdjustPanelKt.access$getALPHA_SLIDER_BORDER$p());
        $this$apply.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        ((SliderComponent)$this$apply).addListener((Function1)new Function1<Integer, Unit>(this){
            final /* synthetic */ ColorAdjustPanel this$0;
            {
                this.this$0 = colorAdjustPanel;
                super(1);
            }

            public final void invoke(int it) {
                ColorAdjustPanel.access$getModel$p(this.this$0).setColor(new Color(ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getRed(), ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getGreen(), ColorAdjustPanel.access$getModel$p(this.this$0).getColor().getBlue(), it), this.this$0);
            }
        });
        unit = Unit.INSTANCE;
        colorAdjustPanel.alphaSlider = jComponent;
        this.setBorder((Border)ColorAdjustPanelKt.access$getPANEL_BORDER$p());
        this.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        this.setPreferredSize((Dimension)ColorAdjustPanelKt.access$getPANEL_PREFERRED_SIZE$p());
        GridBagConstraints c = new GridBagConstraints();
        if (ColorAdjustPanelKt.access$canPickupColorFromDisplay()) {
            c.gridx = 0;
            c.gridy = 0;
            c.weightx = 0.12;
            this.add((Component)this.getPipetteButton(), c);
        }
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.12;
        this.add((Component)this.colorIndicator, c);
        c.fill = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.weightx = 0.76;
        JPanel sliderPanel = new JPanel();
        sliderPanel.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        if (showAlpha) {
            sliderPanel.setBorder((Border)JBUI.Borders.empty());
            sliderPanel.setLayout(new BoxLayout(sliderPanel, 1));
            sliderPanel.add(this.hueSlider);
            sliderPanel.add(this.alphaSlider);
        } else {
            sliderPanel.setBorder((Border)JBUI.Borders.empty((int)9, (int)0));
            sliderPanel.setLayout(new BorderLayout());
            sliderPanel.add(this.hueSlider);
        }
        this.add((Component)sliderPanel, c);
        this.model.addListener(this);
    }

    public /* synthetic */ ColorAdjustPanel(ColorPickerModel colorPickerModel, ColorPipetteProvider colorPipetteProvider, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(colorPickerModel, colorPipetteProvider, bl);
    }

    public static final /* synthetic */ ColorPickerModel access$getModel$p(ColorAdjustPanel $this) {
        return $this.model;
    }

    public static final /* synthetic */ ColorPipetteProvider access$getPipetteProvider$p(ColorAdjustPanel $this) {
        return $this.pipetteProvider;
    }
}

