/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.SpeedSearchBase;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public final class SpeedSearchObjectWithWeight {
    public final Object node;
    private final int weight;

    SpeedSearchObjectWithWeight(Object element2, int weight2) {
        this.node = element2;
        this.weight = weight2;
    }

    public int compareWith(SpeedSearchObjectWithWeight obj2) {
        return Integer.compare(obj2.weight, this.weight);
    }

    public static List<SpeedSearchObjectWithWeight> findElement(String pattern, SpeedSearchBase<?> speedSearch2) {
        ArrayList<SpeedSearchObjectWithWeight> elements = new ArrayList<SpeedSearchObjectWithWeight>();
        pattern = pattern.trim();
        ListIterator<Object> it = speedSearch2.getElementIterator(0);
        while (it.hasNext()) {
            Object element2 = it.next();
            String text2 = speedSearch2.getElementText(element2);
            if (text2 == null) continue;
            elements.add(new SpeedSearchObjectWithWeight(element2, speedSearch2.getComparator().matchingDegree(pattern, text2)));
        }
        SpeedSearchObjectWithWeight cur = null;
        ArrayList<SpeedSearchObjectWithWeight> current2 = new ArrayList<SpeedSearchObjectWithWeight>();
        for (SpeedSearchObjectWithWeight element3 : elements) {
            if (cur == null) {
                cur = element3;
                current2.add(cur);
                continue;
            }
            int i2 = element3.compareWith(cur);
            if (i2 == 0) {
                current2.add(element3);
                continue;
            }
            if (i2 >= 0) continue;
            cur = element3;
            current2.clear();
            current2.add(cur);
        }
        return current2;
    }
}

