/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/DumpFocusableComponentHierarchyAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.ide.impl"})
public final class DumpFocusableComponentHierarchyAction
extends AnAction
implements DumbAware {
    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JFrame visibleFrame = WindowManager.getInstance().findVisibleFrame();
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Intrinsics.checkNotNullExpressionValue((Object)keyboardFocusManager, (String)"KeyboardFocusManager.get\u2026entKeyboardFocusManager()");
        Window activeWindow = keyboardFocusManager.getActiveWindow();
        KeyboardFocusManager keyboardFocusManager2 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Intrinsics.checkNotNullExpressionValue((Object)keyboardFocusManager2, (String)"KeyboardFocusManager.get\u2026entKeyboardFocusManager()");
        Window focusedWindow = keyboardFocusManager2.getFocusedWindow();
        KeyboardFocusManager keyboardFocusManager3 = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Intrinsics.checkNotNullExpressionValue((Object)keyboardFocusManager3, (String)"KeyboardFocusManager.get\u2026entKeyboardFocusManager()");
        Component focusedComponent = keyboardFocusManager3.getFocusOwner();
        CopyOnWriteArrayList<String> dump = new CopyOnWriteArrayList<String>();
        dump.add("Active Window: " + (activeWindow == null ? "null" : activeWindow.getClass().getName()));
        dump.add("Focused Window: " + (focusedWindow == null ? "null" : focusedWindow.getClass().getName()));
        dump.add("Focused Component: " + (focusedComponent == null ? "null" : focusedComponent.getClass().getName()));
        ArrayList<Component> componentTrace = new ArrayList<Component>();
        for (Component c = focusedComponent; c != null; c = (Component)c.getParent()) {
            componentTrace.add(c);
        }
        int n = ((Collection)componentTrace).size();
        --n;
        boolean bl = false;
        while (n >= 0) {
            void i2;
            dump.add(((Component)componentTrace.get((int)i2)).getClass().getName());
            if (i2 != false) {
                dump.add("^");
            }
            --i2;
        }
        Component component2 = focusedComponent;
        if (!(component2 instanceof JComponent)) {
            component2 = null;
        }
        JComponent jComponent = (JComponent)component2;
        if (jComponent != null) {
            JComponent i2 = jComponent;
            bl = false;
            boolean bl2 = false;
            JComponent it = i2;
            boolean bl3 = false;
            dump.add("Children count in focused component: " + it.getComponentCount());
        }
        int fontHeight = 30;
        JPanel contentPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(dump, fontHeight, new BorderLayout()){
            final /* synthetic */ CopyOnWriteArrayList $dump;
            final /* synthetic */ int $fontHeight;

            /*
             * WARNING - void declaration
             */
            protected void paintComponent(@NotNull Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                g.setColor((Color)JBColor.BLACK);
                g.fillRect(0, 0, this.getBounds().width, this.getBounds().height);
                g.setColor((Color)JBColor.WHITE);
                int n = ((Collection)this.$dump).size();
                --n;
                boolean bl = false;
                while (n >= 0) {
                    void i2;
                    g.drawString((String)this.$dump.get((int)i2), 20, 50 + i2 * this.$fontHeight);
                    --i2;
                }
            }
            {
                this.$dump = $captured_local_variable$0;
                this.$fontHeight = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
        JFrame jFrame = visibleFrame;
        Intrinsics.checkNotNull((Object)jFrame);
        contentPanel2.setPreferredSize(new Dimension(jFrame.getWidth(), dump.size() * fontHeight));
        contentPanel2.add(jPanel2);
        JScrollPane scrollPane = (JScrollPane)new JBScrollPane((Component)contentPanel2);
        scrollPane.setPreferredSize(visibleFrame.getSize());
        Popup popup2 = PopupFactory.getSharedInstance().getPopup(visibleFrame, scrollPane, visibleFrame.getX(), visibleFrame.getY());
        JButton closeButton2 = new JButton(new AbstractAction(dump, popup2, IdeBundle.message((String)"dump.focusable.component.hierarchy.close.button", (Object[])new Object[0])){
            final /* synthetic */ CopyOnWriteArrayList $dump;
            final /* synthetic */ Popup $popup;

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StringBuilder dumpAsString = new StringBuilder();
                int n = ((Collection)this.$dump).size();
                --n;
                boolean bl = false;
                while (n >= 0) {
                    void i2;
                    dumpAsString.append((String)this.$dump.get((int)i2)).append("\n");
                    --i2;
                }
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Intrinsics.checkNotNullExpressionValue((Object)toolkit, (String)"Toolkit.getDefaultToolkit()");
                toolkit.getSystemClipboard().setContents(new StringSelection(dumpAsString.toString()), null);
                this.$popup.hide();
            }
            {
                this.$dump = $captured_local_variable$0;
                this.$popup = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
        jPanel2.add((Component)closeButton2, "North");
        popup2.show();
    }
}

