/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui.filters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.ui.filters.FilterAction;
import com.intellij.structuralsearch.plugin.ui.filters.FilterEditor;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.fields.ExpandableSupport;
import com.intellij.util.Function;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.jetbrains.annotations.NotNull;

class ScriptFilter
extends FilterAction {
    ScriptFilter() {
        super(SSRBundle.messagePointer("script.filter.name", new Object[0]));
    }

    @Override
    @NotNull
    public String getShortText(NamedScriptableDefinition variable) {
        return variable.getScriptCodeConstraint().length() > 2 ? SSRBundle.message("script.tooltip.message", new Object[0]) : "";
    }

    @Override
    public boolean hasFilter() {
        NamedScriptableDefinition variable = this.myTable.getVariable();
        return variable != null && !StringUtil.isEmpty((String)variable.getScriptCodeConstraint());
    }

    @Override
    public void clearFilter() {
        this.myTable.getVariable().setScriptCodeConstraint("");
    }

    @Override
    public boolean isApplicable(List<? extends PsiElement> nodes, boolean completePattern, boolean target2) {
        return true;
    }

    @Override
    protected void setLabel(SimpleColoredComponent component2) {
        component2.append(SSRBundle.message("script.0.label", StringUtil.unquoteString((String)this.myTable.getVariable().getScriptCodeConstraint())));
    }

    public FilterEditor<NamedScriptableDefinition> getEditor() {
        return new FilterEditor<NamedScriptableDefinition>(this.myTable.getVariable(), this.myTable.getConstraintChangedCallback()){
            private final JLabel myLabel;
            private final EditorTextField myTextField;
            private ContextHelpLabel myHelpLabel;
            {
                this.myLabel = new JLabel(SSRBundle.message("script.label", new Object[0]));
                this.myTextField = UIUtil.createScriptComponent("", ScriptFilter.this.myTable.getProject());
            }

            @Override
            protected void layoutComponents() {
                new ExpandableEditorSupport(this.myTextField){

                    @Override
                    @NotNull
                    protected ExpandableSupport.Content prepare(@NotNull EditorTextField field, @NotNull Function<? super String, String> onShow) {
                        if (field == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (onShow == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        ExpandableSupport.Content popup2 = super.prepare(field, onShow);
                        popup2.getContentComponent().setPreferredSize(new Dimension(600, 150));
                        ExpandableSupport.Content content2 = popup2;
                        if (content2 == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return content2;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        RuntimeException runtimeException;
                        Object[] objectArray;
                        Object[] objectArray2;
                        int n2;
                        String string;
                        switch (n) {
                            default: {
                                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                break;
                            }
                            case 2: {
                                string = "@NotNull method %s.%s must not return null";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                n2 = 3;
                                break;
                            }
                            case 2: {
                                n2 = 2;
                                break;
                            }
                        }
                        Object[] objectArray3 = new Object[n2];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "field";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "onShow";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/filters/ScriptFilter$1$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/filters/ScriptFilter$1$1";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[1] = "prepare";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "prepare";
                                break;
                            }
                            case 2: {
                                break;
                            }
                        }
                        String string2 = String.format(string, objectArray);
                        switch (n) {
                            default: {
                                runtimeException = new IllegalArgumentException(string2);
                                break;
                            }
                            case 2: {
                                runtimeException = new IllegalStateException(string2);
                                break;
                            }
                        }
                        throw runtimeException;
                    }
                };
                CharSequence[] variableNames = new String[]{"__context__", "__log__"};
                String variableText = String.join((CharSequence)", ", variableNames);
                this.myHelpLabel = this.myConstraint instanceof MatchVariableConstraint ? ContextHelpLabel.create((String)SSRBundle.message("script.filter.match.variable.help.text", variableText)) : ContextHelpLabel.create((String)SSRBundle.message("script.filter.replacement.variable.help.text", variableText));
                GroupLayout layout = new GroupLayout(this);
                this.setLayout(layout);
                layout.setAutoCreateContainerGaps(true);
                layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.myLabel).addComponent((Component)((Object)this.myTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 1, 1).addComponent((Component)this.myHelpLabel));
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.myLabel).addComponent((Component)((Object)this.myTextField)).addComponent((Component)this.myHelpLabel));
            }

            @Override
            protected void loadValues() {
                this.myTextField.setText(StringUtil.unquoteString((String)this.myConstraint.getScriptCodeConstraint()));
            }

            @Override
            protected void saveValues() {
                this.myConstraint.setScriptCodeConstraint("\"" + this.myTextField.getText() + "\"");
            }

            @Override
            public JComponent getPreferredFocusedComponent() {
                return this.myTextField;
            }

            @Override
            public JComponent[] getFocusableComponents() {
                return new JComponent[]{this.myTextField};
            }
        };
    }
}

