/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.find.FindBundle;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectExtension;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.ide.util.scopeChooser.ScopeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.DumbAwareToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProviderImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.Scopes;
import com.intellij.structuralsearch.plugin.ui.DirectoryComboBoxWithButtons;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScopePanel
extends JPanel {
    private static final Condition<ScopeDescriptor> SCOPE_FILTER = descriptor2 -> IdeBundle.message((String)"scope.class.hierarchy", (Object[])new Object[0]).equals(descriptor2.getDisplayName()) || !(descriptor2.getScope() instanceof ModuleWithDependenciesScope);
    private final Project myProject;
    @NotNull
    private SearchScope myScope;
    private NullableConsumer<? super SearchScope> myConsumer;
    Scopes.Type myScopeType;
    final ActionToolbarImpl myToolbar;
    final JPanel myScopeDetailsPanel;
    private final ModulesComboBox myModulesComboBox;
    private final DirectoryComboBoxWithButtons myDirectoryComboBox;
    private final ScopeChooserCombo myScopesComboBox;

    public ScopePanel(@NotNull Project project, Disposable parent) {
        if (project == null) {
            ScopePanel.$$$reportNull$$$0(0);
        }
        super(null);
        this.myScopeDetailsPanel = new JPanel(new CardLayout());
        this.myModulesComboBox = new ModulesComboBox();
        this.myScopesComboBox = new ScopeChooserCombo();
        this.myProject = project;
        this.myScope = GlobalSearchScope.projectScope((Project)this.myProject);
        Module[] allModules = ModuleManager.getInstance((Project)project).getModules();
        this.myModulesComboBox.setModules(Arrays.asList(allModules));
        if (allModules.length > 0) {
            this.myModulesComboBox.setSelectedModule(allModules[0]);
        }
        this.myModulesComboBox.addItemListener(e -> this.setScopeFromUI(Scopes.Type.MODULE, false));
        this.myModulesComboBox.setMinimumAndPreferredWidth(JBUIScale.scale((int)300));
        this.myScopesComboBox.init(project, true, false, "", SCOPE_FILTER);
        this.myScopesComboBox.getComboBox().addItemListener(e -> this.setScopeFromUI(Scopes.Type.NAMED, false));
        Disposer.register((Disposable)parent, (Disposable)this.myScopesComboBox);
        this.myDirectoryComboBox = new DirectoryComboBoxWithButtons(this.myProject);
        this.myDirectoryComboBox.setCallback(() -> this.setScopeFromUI(Scopes.Type.DIRECTORY, false));
        this.myScopeDetailsPanel.add(Scopes.Type.PROJECT.toString(), new JLabel());
        this.myScopeDetailsPanel.add(Scopes.Type.MODULE.toString(), ScopePanel.shrinkWrap((JComponent)((Object)this.myModulesComboBox)));
        this.myScopeDetailsPanel.add(Scopes.Type.DIRECTORY.toString(), this.myDirectoryComboBox);
        this.myScopeDetailsPanel.add(Scopes.Type.NAMED.toString(), ScopePanel.shrinkWrap((JComponent)((Object)this.myScopesComboBox)));
        this.myScopeDetailsPanel.setBorder((Border)JBUI.Borders.emptyBottom((int)(UIUtil.isUnderDefaultMacTheme() ? 0 : 3)));
        boolean fullVersion = !PlatformUtils.isDataGrip();
        DefaultActionGroup scopeActionGroup = fullVersion ? new DefaultActionGroup(new AnAction[]{new ScopeToggleAction(FindBundle.message("find.popup.scope.project", new Object[0]), Scopes.Type.PROJECT), new ScopeToggleAction(FindBundle.message("find.popup.scope.module", new Object[0]), Scopes.Type.MODULE), new ScopeToggleAction(FindBundle.message("find.popup.scope.directory", new Object[0]), Scopes.Type.DIRECTORY), new ScopeToggleAction(FindBundle.message("find.popup.scope.scope", new Object[0]), Scopes.Type.NAMED)}) : new DefaultActionGroup(new AnAction[]{new ScopeToggleAction(FindBundle.message("find.popup.scope.scope", new Object[0]), Scopes.Type.NAMED), new ScopeToggleAction(FindBundle.message("find.popup.scope.directory", new Object[0]), Scopes.Type.DIRECTORY)});
        this.myToolbar = (ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("ScopePanel", (ActionGroup)scopeActionGroup, true);
        this.myToolbar.setTargetComponent(null);
        this.myToolbar.setForceMinimumSize(true);
        this.myToolbar.setLayoutPolicy(0);
        this.setScope(null);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addComponent(this.myToolbar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, 25).addComponent(this.myScopeDetailsPanel));
        layout.setVerticalGroup(layout.createParallelGroup().addComponent(this.myToolbar).addComponent(this.myScopeDetailsPanel));
    }

    private static JComponent shrinkWrap(JComponent component2) {
        JPanel wrapper2 = new JPanel(new BorderLayout());
        wrapper2.add((Component)component2, "West");
        wrapper2.add(Box.createHorizontalGlue(), "Center");
        return wrapper2;
    }

    public void setRecentDirectories(@NotNull List<String> recentDirectories) {
        if (recentDirectories == null) {
            ScopePanel.$$$reportNull$$$0(1);
        }
        this.myDirectoryComboBox.setRecentDirectories(recentDirectories);
    }

    public void setScope(@Nullable SearchScope selectedScope) {
        this.myScopeType = Scopes.getType(selectedScope);
        if (selectedScope instanceof ModuleWithDependenciesScope) {
            ModuleWithDependenciesScope scope2 = (ModuleWithDependenciesScope)selectedScope;
            this.myModulesComboBox.setItem(scope2.getModule());
        } else if (selectedScope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)selectedScope;
            this.myDirectoryComboBox.setDirectory(directoryScope.getDirectory());
            this.myDirectoryComboBox.setRecursive(directoryScope.isWithSubdirectories());
        } else if (selectedScope != null && this.myScopeType == Scopes.Type.NAMED) {
            this.myScopesComboBox.selectItem(selectedScope.getDisplayName());
        }
        this.showScope(this.myScopeType);
    }

    public void setScopesFromContext(SearchScope scope2) {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context2 -> {
            VirtualFile files2;
            Editor editor;
            Scopes.Type foundScope = null;
            boolean moduleFound = false;
            boolean directoryFound = false;
            boolean namedScopeFound = false;
            Module module = (Module)LangDataKeys.MODULE.getData((DataContext)context2);
            if (module != null) {
                moduleFound = true;
                this.myModulesComboBox.setSelectedModule(module);
            }
            if ((editor = (Editor)CommonDataKeys.HOST_EDITOR.getData((DataContext)context2)) != null) {
                VirtualFile file2 = FileDocumentManager.getInstance().getFile(editor.getDocument());
                if (file2 != null) {
                    this.myDirectoryComboBox.setDirectory(file2.getParent());
                }
                this.myScopesComboBox.selectItem(PredefinedSearchScopeProviderImpl.getCurrentFileScopeName());
                this.setScope(scope2);
                return;
            }
            FindModel findModel = new FindModel();
            for (FindInProjectExtension extension2 : FindInProjectExtension.EP_NAME.getExtensionList()) {
                namedScopeFound = extension2.initModelFromContext(findModel, (DataContext)context2);
                if (!namedScopeFound) continue;
                this.myScopesComboBox.selectItem(findModel.getCustomScopeName());
                foundScope = Scopes.Type.NAMED;
                break;
            }
            if ((files2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE_ARRAY.getData((DataContext)context2)) != null && ((VirtualFile[])files2).length > 0) {
                VirtualFile directory;
                VirtualFile ancestor;
                SearchScope selectedFilesScope;
                Module fileModule;
                if (!moduleFound && (fileModule = ModuleUtilCore.findModuleForFile((VirtualFile)files2[0], (Project)this.myProject)) != null) {
                    this.myModulesComboBox.setSelectedModule(fileModule);
                }
                if (!namedScopeFound && (selectedFilesScope = PredefinedSearchScopeProviderImpl.getSelectedFilesScope(this.myProject, context2, null)) != null) {
                    this.myScopesComboBox.selectItem(selectedFilesScope.getDisplayName());
                }
                if (((VirtualFile[])files2).length == 1) {
                    directoryFound = true;
                    VirtualFile file3 = files2[0];
                    this.myDirectoryComboBox.setDirectory(file3.isDirectory() ? file3 : file3.getParent());
                    if (foundScope == null) {
                        foundScope = Scopes.Type.DIRECTORY;
                    }
                } else {
                    for (VirtualFile file4 : files2) {
                        if (!file4.isDirectory()) continue;
                        this.myDirectoryComboBox.setDirectory(file4);
                        directoryFound = true;
                        break;
                    }
                    if (foundScope == null) {
                        foundScope = Scopes.Type.NAMED;
                    }
                }
                if (!directoryFound && (ancestor = VfsUtil.getCommonAncestor(List.of(files2))) != null) {
                    this.myDirectoryComboBox.setDirectory(ancestor);
                    directoryFound = true;
                }
                if (!directoryFound && (directory = files2[0].getParent()) != null) {
                    this.myDirectoryComboBox.setDirectory(directory);
                }
            }
            this.showScope(foundScope == null ? Scopes.Type.PROJECT : foundScope);
        });
    }

    public void setScopeConsumer(@Nullable NullableConsumer<? super SearchScope> consumer) {
        this.myConsumer = consumer;
    }

    @NotNull
    public SearchScope getScope() {
        SearchScope searchScope2 = this.myScope;
        if (searchScope2 == null) {
            ScopePanel.$$$reportNull$$$0(2);
        }
        return searchScope2;
    }

    void setScopeFromUI(@NotNull Scopes.Type type, boolean requestFocus) {
        if (type == null) {
            ScopePanel.$$$reportNull$$$0(3);
        }
        switch (type) {
            case PROJECT: {
                this.myScope = GlobalSearchScope.projectScope((Project)this.myProject);
                break;
            }
            case MODULE: {
                Module module = this.myModulesComboBox.getSelectedModule();
                if (module == null) {
                    return;
                }
                this.myScope = GlobalSearchScope.moduleScope((Module)module);
                if (!requestFocus) break;
                this.myModulesComboBox.requestFocus();
                break;
            }
            case DIRECTORY: {
                VirtualFile directory = this.myDirectoryComboBox.getDirectory();
                if (directory == null) {
                    return;
                }
                this.myScope = GlobalSearchScopesCore.directoryScope((Project)this.myProject, (VirtualFile)directory, (boolean)this.myDirectoryComboBox.isRecursive());
                if (!requestFocus) break;
                this.myDirectoryComboBox.getComboBox().requestFocus();
                break;
            }
            case NAMED: {
                SearchScope scope2 = this.myScopesComboBox.getSelectedScope();
                Object object = this.myScope = scope2 == null ? GlobalSearchScope.projectScope((Project)this.myProject) : scope2;
                if (!requestFocus) break;
                this.myScopesComboBox.requestFocus();
            }
        }
        if (this.myConsumer != null) {
            this.myConsumer.consume((Object)this.myScope);
        }
    }

    private void showScope(@NotNull Scopes.Type scopeType2) {
        if (scopeType2 == null) {
            ScopePanel.$$$reportNull$$$0(4);
        }
        this.myScopeType = scopeType2;
        ((CardLayout)this.myScopeDetailsPanel.getLayout()).show(this.myScopeDetailsPanel, scopeType2.toString());
        this.setScopeFromUI(scopeType2, true);
        this.myToolbar.updateActionsImmediately();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentDirectories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/ScopePanel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ScopePanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setRecentDirectories";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setScopeFromUI";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    class ScopeToggleAction
    extends DumbAwareToggleAction {
        private final Scopes.Type myScopeType;

        ScopeToggleAction(@NotNull String text2, Scopes.Type scopeType2) {
            if (text2 == null) {
                ScopeToggleAction.$$$reportNull$$$0(0);
            }
            if (scopeType2 == null) {
                ScopeToggleAction.$$$reportNull$$$0(1);
            }
            super(text2);
            this.myScopeType = scopeType2;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ScopeToggleAction.$$$reportNull$$$0(2);
            }
            return this.myScopeType == ScopePanel.this.myScopeType;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ScopeToggleAction.$$$reportNull$$$0(3);
            }
            ScopePanel.this.showScope(this.myScopeType);
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scopeType";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/ScopePanel$ScopeToggleAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

