/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.PatternContextInfo;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplacementBuilder {
    @NotNull
    private final String replacement;
    private final MultiMap<String, ParameterInfo> parameterizations;
    private final Map<String, ScriptSupport> replacementVarsMap;
    private final ReplaceOptions options;
    private final Project myProject;

    ReplacementBuilder(@NotNull Project project, @NotNull ReplaceOptions options2) {
        if (project == null) {
            ReplacementBuilder.$$$reportNull$$$0(0);
        }
        if (options2 == null) {
            ReplacementBuilder.$$$reportNull$$$0(1);
        }
        this.parameterizations = MultiMap.createLinked();
        this.replacementVarsMap = new HashMap<String, ScriptSupport>();
        this.myProject = project;
        this.options = options2;
        Template template = TemplateManager.getInstance(project).createTemplate("", "", options2.getReplacement());
        this.replacement = template.getTemplateText();
        int prevOffset = 0;
        for (int i2 = 0; i2 < template.getSegmentsCount(); ++i2) {
            int pos;
            String name;
            int offset = template.getSegmentOffset(i2);
            ParameterInfo info2 = new ParameterInfo(name, offset, options2.getVariableDefinition(name = template.getSegmentName(i2)) != null);
            for (pos = offset - 1; pos >= prevOffset && pos < this.replacement.length() && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos)); --pos) {
            }
            if (pos >= 0) {
                if (this.replacement.charAt(pos) == ',') {
                    info2.setHasCommaBefore(true);
                }
                while (pos > prevOffset && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos - 1))) {
                    --pos;
                }
                info2.setBeforeDelimiterPos(pos);
            }
            for (pos = offset; pos < this.replacement.length() && StringUtil.isWhiteSpace((char)this.replacement.charAt(pos)); ++pos) {
            }
            if (pos < this.replacement.length()) {
                char ch = this.replacement.charAt(pos);
                if (ch == ';') {
                    info2.setStatementContext(true);
                } else if (ch == ',' || ch == ')') {
                    info2.setArgumentContext(true);
                    info2.setHasCommaAfter(ch == ',');
                }
            }
            info2.setAfterDelimiterPos(pos);
            prevOffset = offset;
            this.parameterizations.putValue((Object)name, (Object)info2);
        }
        LanguageFileType fileType = options2.getMatchOptions().getFileType();
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(fileType);
        if (profile != null) {
            try {
                Language dialect = options2.getMatchOptions().getDialect();
                assert (dialect != null);
                PatternContextInfo context2 = new PatternContextInfo(PatternTreeContext.Block, options2.getMatchOptions().getPatternContext());
                PsiElement[] elements = MatcherImplUtil.createTreeFromText(options2.getReplacement(), context2, fileType, dialect, project, false);
                if (elements.length > 0) {
                    PsiElement patternNode = elements[0].getParent();
                    patternNode.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(@NotNull PsiElement element2) {
                            String text2;
                            if (element2 == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (StructuralSearchUtil.isTypedVariable(text2 = element2.getText())) {
                                Collection<ParameterInfo> infos = ReplacementBuilder.this.findParameterization(Replacer.stripTypedVariableDecoration(text2));
                                for (ParameterInfo info2 : infos) {
                                    if (info2.getElement() != null) continue;
                                    info2.setElement(element2);
                                    return;
                                }
                            }
                            super.visitElement(element2);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/structuralsearch/plugin/replace/impl/ReplacementBuilder$1", "visitElement"));
                        }
                    });
                    profile.provideAdditionalReplaceOptions(patternNode, options2, this);
                }
            }
            catch (IncorrectOperationException e) {
                throw new MalformedPatternException(e.getMessage());
            }
        }
    }

    @NotNull
    String process(@NotNull MatchResult match, @NotNull ReplacementInfo replacementInfo, @NotNull LanguageFileType type) {
        if (match == null) {
            ReplacementBuilder.$$$reportNull$$$0(2);
        }
        if (replacementInfo == null) {
            ReplacementBuilder.$$$reportNull$$$0(3);
        }
        if (type == null) {
            ReplacementBuilder.$$$reportNull$$$0(4);
        }
        if (this.parameterizations.isEmpty()) {
            String string = this.replacement;
            if (string == null) {
                ReplacementBuilder.$$$reportNull$$$0(5);
            }
            return string;
        }
        StringBuilder result2 = new StringBuilder(this.replacement);
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByFileType(type);
        assert (profile != null);
        SmartList sorted = new SmartList(this.parameterizations.values());
        sorted.sort(Comparator.comparingInt(ParameterInfo::getStartIndex).reversed());
        for (ParameterInfo info2 : sorted) {
            MatchResult r = replacementInfo.getNamedMatchResult(info2.getName());
            if (info2.isReplacementVariable()) {
                Object replacement = this.generateReplacement(info2, match);
                if (replacement == null && r != null) {
                    profile.handleSubstitution(info2, r, result2, replacementInfo);
                    continue;
                }
                Replacer.insertSubstitution(result2, 0, info2, String.valueOf(replacement));
                continue;
            }
            if (r != null) {
                profile.handleSubstitution(info2, r, result2, replacementInfo);
                continue;
            }
            profile.handleNoSubstitution(info2, result2);
        }
        String string = result2.toString();
        if (string == null) {
            ReplacementBuilder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    private Object generateReplacement(@NotNull ParameterInfo info2, @NotNull MatchResult match) {
        ScriptSupport scriptSupport;
        if (info2 == null) {
            ReplacementBuilder.$$$reportNull$$$0(7);
        }
        if (match == null) {
            ReplacementBuilder.$$$reportNull$$$0(8);
        }
        if ((scriptSupport = this.replacementVarsMap.get(info2.getName())) == null) {
            String constraint = this.options.getVariableDefinition(info2.getName()).getScriptCodeConstraint();
            List variableNames = ContainerUtil.map(this.options.getVariableDefinitions(), o -> o.getName());
            scriptSupport = new ScriptSupport(this.myProject, StringUtil.unquoteString((String)constraint), info2.getName(), variableNames, this.options.getMatchOptions());
            this.replacementVarsMap.put(info2.getName(), scriptSupport);
        }
        return scriptSupport.evaluate(match, null);
    }

    public Collection<ParameterInfo> findParameterization(String name) {
        return this.parameterizations.get((Object)name);
    }

    public ParameterInfo findParameterization(PsiElement element2) {
        if (element2 == null) {
            return null;
        }
        String text2 = element2.getText();
        if (!StructuralSearchUtil.isTypedVariable(text2)) {
            return null;
        }
        return (ParameterInfo)((Object)ContainerUtil.find(this.findParameterization(Replacer.stripTypedVariableDecoration(text2)), info2 -> info2.getElement() == element2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/replace/impl/ReplacementBuilder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/replace/impl/ReplacementBuilder";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateReplacement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

