/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.inspection.InspectionProfileUtil;
import com.intellij.structuralsearch.inspection.SSBasedInspection;
import com.intellij.structuralsearch.inspection.StructuralSearchProfileActionProvider;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationCellRenderer;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBList;
import com.intellij.util.SmartList;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuralSearchFakeInspection
extends LocalInspectionTool {
    private Configuration myMainConfiguration;
    @NotNull
    private final List<Configuration> myConfigurations;

    public StructuralSearchFakeInspection(@NotNull @NotNull Collection<@NotNull Configuration> configurations) {
        if (configurations == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(0);
        }
        if (configurations.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.myConfigurations = new SmartList(configurations);
        this.myConfigurations.sort(Comparator.comparingInt(Configuration::getOrder));
        int size2 = this.myConfigurations.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            Configuration configuration2 = this.myConfigurations.get(i2);
            if (configuration2.getOrder() == i2) continue;
            configuration2.setOrder(i2);
        }
        this.myMainConfiguration = this.myConfigurations.get(0);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getDisplayName() {
        String string = this.myMainConfiguration.getName();
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = this.myMainConfiguration.getUuid().toString();
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getID() {
        HighlightDisplayKey key = HighlightDisplayKey.find((String)this.getShortName());
        if (key != null) {
            String string = key.getID();
            if (string == null) {
                StructuralSearchFakeInspection.$$$reportNull$$$0(3);
            }
            return string;
        }
        String suppressId = this.myMainConfiguration.getSuppressId();
        return !StringUtil.isEmpty((String)suppressId) ? suppressId : "SSBasedInspection";
    }

    @Nullable
    public String getAlternativeID() {
        return "SSBasedInspection";
    }

    @Nullable
    public String getMainToolId() {
        return "SSBasedInspection";
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getGroupDisplayName() {
        String string = SSRBundle.message("structural.search.group.name", new Object[0]);
        if (string == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getStaticDescription() {
        String description2 = this.myMainConfiguration.getDescription();
        if (StringUtil.isEmpty((String)description2)) {
            return SSRBundle.message("no.description.message", new Object[0]);
        }
        return description2;
    }

    @NotNull
    public List<Configuration> getConfigurations() {
        List<Configuration> list2 = Collections.unmodifiableList(this.myConfigurations);
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public JComponent createOptionsPanel() {
        MyListModel model2 = new MyListModel();
        JButton button4 = new JButton(SSRBundle.message("edit.metadata.button", new Object[0]));
        button4.addActionListener(__ -> this.performEditMetaData(button4));
        JBList list2 = new JBList((ListModel)model2);
        list2.setCellRenderer(new ConfigurationCellRenderer());
        JPanel listPanel = ToolbarDecorator.createDecorator((JList)list2).setAddAction(arg_0 -> this.lambda$createOptionsPanel$1((JList)list2, arg_0)).setAddActionName(SSRBundle.message("add.pattern.action", new Object[0])).setRemoveAction(arg_0 -> this.lambda$createOptionsPanel$2((JList)list2, arg_0)).setRemoveActionUpdater(arg_0 -> StructuralSearchFakeInspection.lambda$createOptionsPanel$3((JList)list2, arg_0)).setEditAction(arg_0 -> this.lambda$createOptionsPanel$4((JList)list2, arg_0)).setMoveUpAction(arg_0 -> this.lambda$createOptionsPanel$5((JList)list2, arg_0)).setMoveDownAction(arg_0 -> this.lambda$createOptionsPanel$6((JList)list2, arg_0)).createPanel();
        new DoubleClickListener((JList)list2){
            final /* synthetic */ JList val$list;
            {
                this.val$list = jList;
            }

            protected boolean onDoubleClick(@NotNull MouseEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                StructuralSearchFakeInspection.this.performEdit(this.val$list);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/structuralsearch/inspection/StructuralSearchFakeInspection$1", "onDoubleClick"));
            }
        }.installOn((Component)list2);
        JPanel panel2 = new FormBuilder().addComponent((JComponent)button4).addLabeledComponentFillVertically(SSRBundle.message("templates.title", new Object[0]), (JComponent)listPanel).getPanel();
        panel2.setBorder((Border)JBUI.Borders.emptyTop((int)10));
        JPanel jPanel2 = panel2;
        if (jPanel2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(6);
        }
        return jPanel2;
    }

    private void performEditMetaData(@NotNull Component context2) {
        if (context2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(7);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(context2));
        InspectionProfileModifiableModel profile = InspectionProfileUtil.getInspectionProfile(context2);
        if (profile == null) {
            return;
        }
        SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection(profile);
        StructuralSearchProfileActionProvider.InspectionDataDialog dialog2 = new StructuralSearchProfileActionProvider.InspectionDataDialog(project, inspection, this.myMainConfiguration, false);
        if (!dialog2.showAndGet()) {
            return;
        }
        String name = dialog2.getName();
        for (Configuration c : this.myConfigurations) {
            c.setName(name);
        }
        inspection.removeConfigurationsWithUuid(this.myMainConfiguration.getUuid());
        inspection.addConfigurations(this.myConfigurations);
        profile.setModified(true);
        InspectionProfileUtil.fireProfileChanged(profile);
    }

    private void performMove(@NotNull JList<Configuration> list2, boolean up) {
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(8);
        }
        MyListModel model2 = (MyListModel)list2.getModel();
        List<Configuration> values2 = list2.getSelectedValuesList();
        Comparator<Configuration> c = Comparator.comparingInt(Configuration::getOrder);
        values2.sort(up ? c : c.reversed());
        int[] indices = new int[values2.size()];
        int size2 = values2.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            Configuration value2 = values2.get(i2);
            int order = value2.getOrder();
            model2.swap(order, order + (up ? -1 : 1));
            indices[i2] = value2.getOrder();
        }
        this.myMainConfiguration = StructuralSearchFakeInspection.moveMetaData(this.myMainConfiguration, this.myConfigurations.get(0));
        list2.setSelectedIndices(indices);
        list2.scrollRectToVisible(list2.getCellBounds(indices[0], indices[indices.length - 1]));
        model2.fireContentsChanged(list2);
        this.saveChangesToProfile(list2);
    }

    @NotNull
    private static Configuration moveMetaData(@NotNull Configuration source, @NotNull Configuration target2) {
        if (source == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(9);
        }
        if (target2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(10);
        }
        if (source == target2) {
            Configuration configuration2 = source;
            if (configuration2 == null) {
                StructuralSearchFakeInspection.$$$reportNull$$$0(11);
            }
            return configuration2;
        }
        target2.setDescription(source.getDescription());
        target2.setSuppressId(source.getSuppressId());
        target2.setProblemDescriptor(source.getProblemDescriptor());
        source.setDescription(null);
        source.setSuppressId(null);
        source.setProblemDescriptor(null);
        Configuration configuration3 = target2;
        if (configuration3 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(12);
        }
        return configuration3;
    }

    private void performAdd(@NotNull JList<Configuration> list2, @NotNull AnActionButton b) {
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(13);
        }
        if (b == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(14);
        }
        AnAction[] children2 = new AnAction[]{new AddTemplateAction(list2, false), new AddTemplateAction(list2, true)};
        RelativePoint point = b.getPreferredPopupPoint();
        if (point == null) {
            return;
        }
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)new DefaultActionGroup(children2), DataManager.getInstance().getDataContext((Component)b.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(point);
    }

    private void performRemove(@NotNull JList<Configuration> list2) {
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(15);
        }
        boolean metaData = false;
        for (Configuration configuration2 : list2.getSelectedValuesList()) {
            if (configuration2.getOrder() == 0) {
                metaData = true;
            }
            this.myConfigurations.remove(configuration2);
        }
        if (metaData) {
            this.myMainConfiguration = StructuralSearchFakeInspection.moveMetaData(this.myMainConfiguration, this.myConfigurations.get(0));
        }
        int size2 = this.myConfigurations.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            this.myConfigurations.get(i2).setOrder(i2);
        }
        int maxIndex = list2.getMaxSelectionIndex();
        if (maxIndex != list2.getMinSelectionIndex()) {
            list2.setSelectedIndex(maxIndex);
        }
        ((MyListModel)list2.getModel()).fireContentsChanged(list2);
        if (list2.getSelectedIndex() >= size2) {
            list2.setSelectedIndex(size2 - 1);
        }
        int index2 = list2.getSelectedIndex();
        list2.scrollRectToVisible(list2.getCellBounds(index2, index2));
        this.saveChangesToProfile(list2);
    }

    private void performEdit(@NotNull JList<Configuration> list2) {
        Project project;
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(16);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(list2))) == null) {
            return;
        }
        int index2 = list2.getSelectedIndex();
        Configuration configuration2 = this.myConfigurations.get(index2);
        if (configuration2 == null) {
            return;
        }
        SearchContext searchContext = new SearchContext(project);
        StructuralSearchDialog dialog2 = new StructuralSearchDialog(searchContext, !(configuration2 instanceof SearchConfiguration), true);
        dialog2.loadConfiguration(configuration2);
        dialog2.setUseLastConfiguration(true);
        if (!dialog2.showAndGet()) {
            return;
        }
        Configuration newConfiguration = dialog2.getConfiguration();
        if (configuration2.getOrder() == 0) {
            this.myMainConfiguration = newConfiguration;
        }
        this.myConfigurations.set(index2, newConfiguration);
        ((MyListModel)list2.getModel()).fireContentsChanged(list2);
        this.saveChangesToProfile(list2);
    }

    private void saveChangesToProfile(@NotNull JList<Configuration> list2) {
        InspectionProfileModifiableModel profile;
        if (list2 == null) {
            StructuralSearchFakeInspection.$$$reportNull$$$0(17);
        }
        if ((profile = InspectionProfileUtil.getInspectionProfile(list2)) == null) {
            return;
        }
        SSBasedInspection inspection = InspectionProfileUtil.getStructuralSearchInspection(profile);
        inspection.removeConfigurationsWithUuid(this.myMainConfiguration.getUuid());
        inspection.addConfigurations(this.myConfigurations);
        profile.setModified(true);
    }

    private /* synthetic */ void lambda$createOptionsPanel$6(JList list2, AnActionButton b) {
        this.performMove(list2, false);
    }

    private /* synthetic */ void lambda$createOptionsPanel$5(JList list2, AnActionButton b) {
        this.performMove(list2, true);
    }

    private /* synthetic */ void lambda$createOptionsPanel$4(JList list2, AnActionButton b) {
        this.performEdit(list2);
    }

    private static /* synthetic */ boolean lambda$createOptionsPanel$3(JList list2, AnActionEvent e) {
        return list2.getSelectedValuesList().size() < list2.getModel().getSize();
    }

    private /* synthetic */ void lambda$createOptionsPanel$2(JList list2, AnActionButton b) {
        this.performRemove(list2);
    }

    private /* synthetic */ void lambda$createOptionsPanel$1(JList list2, AnActionButton b) {
        this.performAdd(list2, b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/StructuralSearchFakeInspection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchFakeInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsPanel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "moveMetaData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performEditMetaData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "performMove";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveMetaData";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "performAdd";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "performRemove";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "performEdit";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "saveChangesToProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyListModel
    extends AbstractListModel<Configuration> {
        private MyListModel() {
        }

        @Override
        public int getSize() {
            return StructuralSearchFakeInspection.this.myConfigurations.size();
        }

        @Override
        public Configuration getElementAt(int index2) {
            return StructuralSearchFakeInspection.this.myConfigurations.get(index2);
        }

        public void fireContentsChanged(Object source) {
            this.fireContentsChanged(source, -1, -1);
        }

        public void swap(int first, int second) {
            if (second == -1) {
                return;
            }
            Configuration one = StructuralSearchFakeInspection.this.myConfigurations.get(first);
            Configuration two = StructuralSearchFakeInspection.this.myConfigurations.get(second);
            int order = one.getOrder();
            one.setOrder(two.getOrder());
            two.setOrder(order);
            StructuralSearchFakeInspection.this.myConfigurations.set(second, one);
            StructuralSearchFakeInspection.this.myConfigurations.set(first, two);
        }
    }

    private final class AddTemplateAction
    extends DumbAwareAction {
        @NotNull
        private final JList<Configuration> myList;
        private final boolean myReplace;

        private AddTemplateAction(JList<Configuration> list2, boolean replace) {
            if (list2 == null) {
                AddTemplateAction.$$$reportNull$$$0(0);
            }
            super(replace ? SSRBundle.message("SSRInspection.add.replace.template.button", new Object[0]) : SSRBundle.message("SSRInspection.add.search.template.button", new Object[0]));
            this.myList = list2;
            this.myReplace = replace;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddTemplateAction.$$$reportNull$$$0(1);
            }
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            assert (project != null);
            SearchContext context2 = new SearchContext(project);
            StructuralSearchDialog dialog2 = new StructuralSearchDialog(context2, this.myReplace, true);
            if (!dialog2.showAndGet()) {
                return;
            }
            Configuration configuration2 = dialog2.getConfiguration();
            configuration2.setUuid(StructuralSearchFakeInspection.this.myMainConfiguration.getUuid());
            configuration2.setName(StructuralSearchFakeInspection.this.myMainConfiguration.getName());
            configuration2.setDescription(null);
            configuration2.setSuppressId(null);
            configuration2.setProblemDescriptor(null);
            MyListModel model2 = (MyListModel)this.myList.getModel();
            int size2 = model2.getSize();
            configuration2.setOrder(size2);
            InspectionProfileModifiableModel profile = InspectionProfileUtil.getInspectionProfile(this.myList);
            if (profile == null) {
                return;
            }
            if (InspectionProfileUtil.getStructuralSearchInspection(profile).addConfiguration(configuration2)) {
                StructuralSearchFakeInspection.this.myConfigurations.add(configuration2);
                model2.fireContentsChanged(this.myList);
                this.myList.setSelectedIndex(size2);
                this.myList.scrollRectToVisible(this.myList.getCellBounds(size2, size2));
                profile.setModified(true);
            } else {
                int index2 = StructuralSearchFakeInspection.this.myConfigurations.indexOf(configuration2);
                if (index2 >= 0) {
                    this.myList.setSelectedIndex(index2);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/structuralsearch/inspection/StructuralSearchFakeInspection$AddTemplateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

