/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.compiler.PatternCompiler;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SSBasedInspectionCompiledPatternsCache {
    private static final Logger LOG = Logger.getInstance(SSBasedInspectionCompiledPatternsCache.class);
    private static final Key<Map<Configuration, Matcher>> COMPILED_OPTIONS_KEY = Key.create((String)"SSR_INSPECTION_COMPILED_OPTIONS_KEY");
    private final Project myProject;

    public static SSBasedInspectionCompiledPatternsCache getInstance(@NotNull Project project) {
        if (project == null) {
            SSBasedInspectionCompiledPatternsCache.$$$reportNull$$$0(0);
        }
        return (SSBasedInspectionCompiledPatternsCache)project.getService(SSBasedInspectionCompiledPatternsCache.class);
    }

    private SSBasedInspectionCompiledPatternsCache(Project project) {
        this.myProject = project;
        StructuralSearchProfile.EP_NAME.addChangeListener(() -> project.putUserData(COMPILED_OPTIONS_KEY, null), (Disposable)project);
    }

    @NotNull
    Map<Configuration, Matcher> getCachedCompiledConfigurations(@NotNull List<? extends Configuration> configurations) {
        Map cache2;
        if (configurations == null) {
            SSBasedInspectionCompiledPatternsCache.$$$reportNull$$$0(1);
        }
        if (SSBasedInspectionCompiledPatternsCache.areConfigurationsInCache(configurations, cache2 = (Map)this.myProject.getUserData(COMPILED_OPTIONS_KEY))) {
            Map map2 = cache2;
            if (map2 == null) {
                SSBasedInspectionCompiledPatternsCache.$$$reportNull$$$0(2);
            }
            return map2;
        }
        HashMap<Configuration, Matcher> newCache = new HashMap<Configuration, Matcher>();
        if (cache2 != null && !cache2.isEmpty()) {
            newCache.putAll(cache2);
            newCache.keySet().retainAll(configurations);
        }
        if (configurations.size() != newCache.size()) {
            this.buildCompiledPatterns(configurations, newCache);
        }
        Map<Configuration, Matcher> unmodifiableCache = Collections.unmodifiableMap(newCache);
        this.myProject.putUserData(COMPILED_OPTIONS_KEY, unmodifiableCache);
        Map<Configuration, Matcher> map3 = unmodifiableCache;
        if (map3 == null) {
            SSBasedInspectionCompiledPatternsCache.$$$reportNull$$$0(3);
        }
        return map3;
    }

    void buildCompiledPatterns(List<? extends Configuration> configurations, Map<Configuration, Matcher> result2) {
        for (Configuration configuration2 : configurations) {
            if (result2.containsKey(configuration2)) continue;
            result2.put(configuration2, this.buildCompiledConfiguration(configuration2));
        }
    }

    Matcher buildCompiledConfiguration(Configuration configuration2) {
        try {
            MatchOptions matchOptions = configuration2.getMatchOptions();
            CompiledPattern compiledPattern = PatternCompiler.compilePattern(this.myProject, matchOptions, false, true);
            return compiledPattern == null ? null : new Matcher(this.myProject, matchOptions, compiledPattern);
        }
        catch (StructuralSearchException e) {
            LOG.warn("Malformed structural search inspection pattern \"" + configuration2.getName() + "\"", (Throwable)e);
            return null;
        }
    }

    @Contract(value="_, null -> false")
    private static boolean areConfigurationsInCache(@NotNull List<? extends Configuration> configurations, @Nullable Map<Configuration, Matcher> cache2) {
        if (configurations == null) {
            SSBasedInspectionCompiledPatternsCache.$$$reportNull$$$0(4);
        }
        return cache2 != null && configurations.size() == cache2.size() && configurations.stream().allMatch(key -> cache2.containsKey(key));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/inspection/SSBasedInspectionCompiledPatternsCache";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/inspection/SSBasedInspectionCompiledPatternsCache";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedCompiledConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCachedCompiledConfigurations";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "areConfigurationsInCache";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

