/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchScriptException;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptLog;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;
import org.jetbrains.annotations.NotNull;

public class ScriptSupport {
    private static final Logger LOG = Logger.getInstance(ScriptSupport.class);
    @NlsSafe
    public static final String UUID = "a3cd264774bf4efb9ab609b250c5165c";
    private final Script script;
    private final ScriptLog myScriptLog;
    private final String myName;
    private final Collection<String> myVariableNames;

    public ScriptSupport(Project project, String text2, String name, Collection<String> variableNames, MatchOptions matchOptions) {
        this.myScriptLog = new ScriptLog(project);
        this.myName = name;
        this.myVariableNames = variableNames;
        GroovyShell shell = ScriptSupport.createShell(matchOptions);
        try {
            File scriptFile = new File(text2);
            this.script = scriptFile.exists() ? shell.parse(scriptFile) : shell.parse(text2, name + "a3cd264774bf4efb9ab609b250c5165c.groovy");
        }
        catch (Exception ex) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    @NotNull
    private static GroovyShell createShell(@NotNull MatchOptions options2) {
        if (options2 == null) {
            ScriptSupport.$$$reportNull$$$0(0);
        }
        return new GroovyShell(options2.getDialect().getClass().getClassLoader());
    }

    private static Map<String, Object> buildVariableMap(@NotNull MatchResult result2, @NotNull Map<String, Object> out) {
        String name;
        if (result2 == null) {
            ScriptSupport.$$$reportNull$$$0(1);
        }
        if (out == null) {
            ScriptSupport.$$$reportNull$$$0(2);
        }
        if ((name = result2.getName()) != null && !result2.isMultipleMatch()) {
            ArrayList<PsiElement> list2;
            Object value2 = out.get(name);
            PsiElement match = StructuralSearchUtil.getPresentableElement(result2.getMatch());
            if (value2 == null) {
                out.put(name, match);
            } else if (value2 instanceof List) {
                list2 = (ArrayList<PsiElement>)value2;
                list2.add(match);
            } else if (value2 instanceof PsiElement) {
                list2 = new ArrayList<PsiElement>();
                list2.add((PsiElement)value2);
                list2.add(match);
                out.put(name, list2);
            } else {
                throw new AssertionError();
            }
        }
        for (MatchResult son : result2.getChildren()) {
            ScriptSupport.buildVariableMap(son, out);
        }
        return out;
    }

    public Object evaluate(MatchResult result2, PsiElement context2) {
        try {
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            this.myVariableNames.forEach(n -> variableMap.put((String)n, null));
            variableMap.put("__log__", this.myScriptLog);
            if (result2 != null) {
                ScriptSupport.buildVariableMap(result2.getRoot(), variableMap);
                if (context2 == null) {
                    context2 = result2.getMatch();
                }
            }
            context2 = StructuralSearchUtil.getPresentableElement(context2);
            variableMap.put(this.myName, context2);
            variableMap.put("__context__", context2);
            this.script.setBinding(new Binding(variableMap));
            Object object = this.script.run();
            return object;
        }
        catch (ProcessCanceledException | ThreadDeath t) {
            throw t;
        }
        catch (Throwable t) {
            Logger.getInstance(ScriptSupport.class).info("Exception thrown by Structural Search Groovy Script", t);
            throw new StructuralSearchScriptException(t);
        }
        finally {
            this.script.setBinding(null);
        }
    }

    public static String checkValidScript(@NotNull String scriptText, @NotNull MatchOptions matchOptions) {
        if (scriptText == null) {
            ScriptSupport.$$$reportNull$$$0(3);
        }
        if (matchOptions == null) {
            ScriptSupport.$$$reportNull$$$0(4);
        }
        try {
            File scriptFile = new File(scriptText);
            GroovyShell shell = ScriptSupport.createShell(matchOptions);
            Script script = scriptFile.exists() ? shell.parse(scriptFile) : shell.parse(scriptText);
            return null;
        }
        catch (IOException e) {
            return e.getMessage();
        }
        catch (MultipleCompilationErrorsException e) {
            ErrorCollector errorCollector = e.getErrorCollector();
            List errors = errorCollector.getErrors();
            for (Message error2 : errors) {
                if (!(error2 instanceof SyntaxErrorMessage)) continue;
                SyntaxErrorMessage errorMessage = (SyntaxErrorMessage)error2;
                SyntaxException cause = errorMessage.getCause();
                return cause.getMessage();
            }
            return e.getMessage();
        }
        catch (CompilationFailedException ex) {
            return ex.getLocalizedMessage();
        }
        catch (Throwable e) {
            LOG.warn(e);
            return SSRBundle.message("error.in.groovy.parser", new Object[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchOptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/predicates/ScriptSupport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createShell";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVariableMap";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkValidScript";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

