/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.predicates;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.predicates.MatchPredicate;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class RegExpPredicate
extends MatchPredicate {
    private Pattern pattern;
    private final String baseHandlerName;
    private boolean simpleString;
    private final boolean couldBeOptimized;
    @NotNull
    private final String regexp;
    private final boolean caseSensitive;
    private boolean multiline;
    private final boolean wholeWords;
    private final boolean target;
    private NodeTextGenerator myNodeTextGenerator;

    public RegExpPredicate(@NotNull String regexp, boolean caseSensitive, String _baseHandlerName, boolean _wholeWords, boolean _target) {
        if (regexp == null) {
            RegExpPredicate.$$$reportNull$$$0(0);
        }
        boolean bl = this.couldBeOptimized = !StructuralSearchUtil.containsRegExpMetaChar(regexp);
        if (!_wholeWords) {
            this.simpleString = this.couldBeOptimized;
        }
        this.regexp = regexp;
        this.caseSensitive = caseSensitive;
        this.wholeWords = _wholeWords;
        this.baseHandlerName = _baseHandlerName;
        if (!this.simpleString) {
            this.compilePattern();
        }
        this.target = _target;
    }

    private void compilePattern() {
        try {
            @NonNls Object realRegexp = this.regexp;
            if (this.wholeWords) {
                realRegexp = ".*?\\b(?:" + (String)realRegexp + ")\\b.*?";
            }
            this.pattern = Pattern.compile((String)realRegexp, (this.caseSensitive ? 0 : 2) | (this.multiline ? 32 : 0));
        }
        catch (PatternSyntaxException ex) {
            throw new MalformedPatternException(SSRBundle.message("error.incorrect.regexp.constraint", this.regexp, this.baseHandlerName));
        }
    }

    public boolean couldBeOptimized() {
        return this.couldBeOptimized;
    }

    @NotNull
    public String getRegExp() {
        String string = this.regexp;
        if (string == null) {
            RegExpPredicate.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public boolean match(@NotNull PsiElement matchedNode, int start2, int end, @NotNull MatchContext context2) {
        String alternativeText;
        String text2;
        boolean result2;
        if (matchedNode == null) {
            RegExpPredicate.$$$reportNull$$$0(2);
        }
        if (context2 == null) {
            RegExpPredicate.$$$reportNull$$$0(3);
        }
        if (!(result2 = this.doMatch(text2 = this.myNodeTextGenerator != null ? this.myNodeTextGenerator.getText(matchedNode) : StructuralSearchUtil.getMeaningfulText(matchedNode), start2, end, context2, matchedNode)) && (alternativeText = StructuralSearchUtil.getAlternativeText(matchedNode = StructuralSearchUtil.getParentIfIdentifier(matchedNode), text2)) != null) {
            result2 = this.doMatch(alternativeText, start2, end, context2, matchedNode);
        }
        return result2;
    }

    public boolean doMatch(@NotNull String text2, @NotNull MatchContext context2, @NotNull PsiElement matchedElement) {
        if (text2 == null) {
            RegExpPredicate.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            RegExpPredicate.$$$reportNull$$$0(5);
        }
        if (matchedElement == null) {
            RegExpPredicate.$$$reportNull$$$0(6);
        }
        return this.doMatch(text2, 0, -1, context2, matchedElement);
    }

    private boolean doMatch(@NotNull String text2, int from2, int end, @NotNull MatchContext context2, @NotNull PsiElement matchedElement) {
        Matcher matcher;
        if (text2 == null) {
            RegExpPredicate.$$$reportNull$$$0(7);
        }
        if (context2 == null) {
            RegExpPredicate.$$$reportNull$$$0(8);
        }
        if (matchedElement == null) {
            RegExpPredicate.$$$reportNull$$$0(9);
        }
        if (from2 > 0 || end != -1) {
            text2 = text2.substring(from2, end == -1 || end >= text2.length() ? text2.length() : end);
        }
        if (this.simpleString) {
            return this.caseSensitive ? text2.equals(this.regexp) : text2.equalsIgnoreCase(this.regexp);
        }
        if (!this.multiline && text2.contains("\n")) {
            this.setMultiline(true);
        }
        if (!(matcher = this.pattern.matcher(text2)).matches()) {
            return false;
        }
        for (int i2 = 1; i2 <= matcher.groupCount(); ++i2) {
            context2.getResult().addChild(new MatchResultImpl(this.baseHandlerName + "_" + i2, matcher.group(i2), new SmartPsiPointer(matchedElement), matcher.start(i2), matcher.end(i2), this.target));
        }
        return true;
    }

    public void setNodeTextGenerator(NodeTextGenerator nodeTextGenerator) {
        this.myNodeTextGenerator = nodeTextGenerator;
    }

    public void setMultiline(boolean b) {
        this.multiline = b;
        this.compilePattern();
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regexp";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/impl/matcher/predicates/RegExpPredicate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedNode";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/impl/matcher/predicates/RegExpPredicate";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegExp";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface NodeTextGenerator {
        public String getText(PsiElement var1);
    }
}

